// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/clouddms/v1/clouddms.proto

package clouddmspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// AIP-157 Partial Response view for Database Entity.
type DatabaseEntityView int32

const (
	// Unspecified view. Defaults to basic view.
	DatabaseEntityView_DATABASE_ENTITY_VIEW_UNSPECIFIED DatabaseEntityView = 0
	// Default view. Does not return DDLs or Issues.
	DatabaseEntityView_DATABASE_ENTITY_VIEW_BASIC DatabaseEntityView = 1
	// Return full entity details including mappings, ddl and issues.
	DatabaseEntityView_DATABASE_ENTITY_VIEW_FULL DatabaseEntityView = 2
	// Top-most (Database, Schema) nodes which are returned contains summary
	// details for their decendents such as the number of entities per type and
	// issues rollups. When this view is used, only a single page of result is
	// returned and the page_size property of the request is ignored. The
	// returned page will only include the top-most node types.
	DatabaseEntityView_DATABASE_ENTITY_VIEW_ROOT_SUMMARY DatabaseEntityView = 3
)

// Enum value maps for DatabaseEntityView.
var (
	DatabaseEntityView_name = map[int32]string{
		0: "DATABASE_ENTITY_VIEW_UNSPECIFIED",
		1: "DATABASE_ENTITY_VIEW_BASIC",
		2: "DATABASE_ENTITY_VIEW_FULL",
		3: "DATABASE_ENTITY_VIEW_ROOT_SUMMARY",
	}
	DatabaseEntityView_value = map[string]int32{
		"DATABASE_ENTITY_VIEW_UNSPECIFIED":  0,
		"DATABASE_ENTITY_VIEW_BASIC":        1,
		"DATABASE_ENTITY_VIEW_FULL":         2,
		"DATABASE_ENTITY_VIEW_ROOT_SUMMARY": 3,
	}
)

func (x DatabaseEntityView) Enum() *DatabaseEntityView {
	p := new(DatabaseEntityView)
	*p = x
	return p
}

func (x DatabaseEntityView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseEntityView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_clouddms_proto_enumTypes[0].Descriptor()
}

func (DatabaseEntityView) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_clouddms_proto_enumTypes[0]
}

func (x DatabaseEntityView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseEntityView.Descriptor instead.
func (DatabaseEntityView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{0}
}

// The type of a tree to return
type DescribeDatabaseEntitiesRequest_DBTreeType int32

const (
	// Unspecified tree type.
	DescribeDatabaseEntitiesRequest_DB_TREE_TYPE_UNSPECIFIED DescribeDatabaseEntitiesRequest_DBTreeType = 0
	// The source database tree.
	DescribeDatabaseEntitiesRequest_SOURCE_TREE DescribeDatabaseEntitiesRequest_DBTreeType = 1
	// The draft database tree.
	DescribeDatabaseEntitiesRequest_DRAFT_TREE DescribeDatabaseEntitiesRequest_DBTreeType = 2
	// The destination database tree.
	DescribeDatabaseEntitiesRequest_DESTINATION_TREE DescribeDatabaseEntitiesRequest_DBTreeType = 3
)

// Enum value maps for DescribeDatabaseEntitiesRequest_DBTreeType.
var (
	DescribeDatabaseEntitiesRequest_DBTreeType_name = map[int32]string{
		0: "DB_TREE_TYPE_UNSPECIFIED",
		1: "SOURCE_TREE",
		2: "DRAFT_TREE",
		3: "DESTINATION_TREE",
	}
	DescribeDatabaseEntitiesRequest_DBTreeType_value = map[string]int32{
		"DB_TREE_TYPE_UNSPECIFIED": 0,
		"SOURCE_TREE":              1,
		"DRAFT_TREE":               2,
		"DESTINATION_TREE":         3,
	}
)

func (x DescribeDatabaseEntitiesRequest_DBTreeType) Enum() *DescribeDatabaseEntitiesRequest_DBTreeType {
	p := new(DescribeDatabaseEntitiesRequest_DBTreeType)
	*p = x
	return p
}

func (x DescribeDatabaseEntitiesRequest_DBTreeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DescribeDatabaseEntitiesRequest_DBTreeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_clouddms_proto_enumTypes[1].Descriptor()
}

func (DescribeDatabaseEntitiesRequest_DBTreeType) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_clouddms_proto_enumTypes[1]
}

func (x DescribeDatabaseEntitiesRequest_DBTreeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DescribeDatabaseEntitiesRequest_DBTreeType.Descriptor instead.
func (DescribeDatabaseEntitiesRequest_DBTreeType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{45, 0}
}

// Retrieves a list of all migration jobs in a given project and location.
type ListMigrationJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent which owns this collection of migrationJobs.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of migration jobs to return. The service may return
	// fewer than this value. If unspecified, at most 50 migration jobs will be
	// returned. The maximum value is 1000; values above 1000 are coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The nextPageToken value received in the previous call to
	// migrationJobs.list, used in the subsequent request to retrieve the next
	// page of results. On first call this should be left blank. When paginating,
	// all other parameters provided to migrationJobs.list must match the call
	// that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters migration jobs listed in the response.
	// The expression must specify the field name, a comparison operator, and the
	// value that you want to use for filtering. The value must be a string,
	// a number, or a boolean. The comparison operator must be
	// either =, !=, >, or <. For example, list migration jobs created this year
	// by specifying **createTime %gt; 2020-01-01T00:00:00.000000000Z.**
	// You can also filter nested fields. For example, you could specify
	// **reverseSshConnectivity.vmIp = "1.2.3.4"** to select all migration
	// jobs connecting through the specific SSH tunnel bastion.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sort the results based on the migration job name.
	// Valid values are: "name", "name asc", and "name desc".
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListMigrationJobsRequest) Reset() {
	*x = ListMigrationJobsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMigrationJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMigrationJobsRequest) ProtoMessage() {}

func (x *ListMigrationJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMigrationJobsRequest.ProtoReflect.Descriptor instead.
func (*ListMigrationJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{0}
}

func (x *ListMigrationJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMigrationJobsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMigrationJobsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListMigrationJobsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListMigrationJobsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for 'ListMigrationJobs' request.
type ListMigrationJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of migration jobs objects.
	MigrationJobs []*MigrationJob `protobuf:"bytes,1,rep,name=migration_jobs,json=migrationJobs,proto3" json:"migration_jobs,omitempty"`
	// A token which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListMigrationJobsResponse) Reset() {
	*x = ListMigrationJobsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMigrationJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMigrationJobsResponse) ProtoMessage() {}

func (x *ListMigrationJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMigrationJobsResponse.ProtoReflect.Descriptor instead.
func (*ListMigrationJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{1}
}

func (x *ListMigrationJobsResponse) GetMigrationJobs() []*MigrationJob {
	if x != nil {
		return x.MigrationJobs
	}
	return nil
}

func (x *ListMigrationJobsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListMigrationJobsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'GetMigrationJob' request.
type GetMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the migration job resource to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetMigrationJobRequest) Reset() {
	*x = GetMigrationJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMigrationJobRequest) ProtoMessage() {}

func (x *GetMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*GetMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{2}
}

func (x *GetMigrationJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message to create a new Database Migration Service migration job
// in the specified project and region.
type CreateMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent which owns this collection of migration jobs.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the instance to create.
	MigrationJobId string `protobuf:"bytes,2,opt,name=migration_job_id,json=migrationJobId,proto3" json:"migration_job_id,omitempty"`
	// Required. Represents a [migration
	// job](https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.migrationJobs)
	// object.
	MigrationJob *MigrationJob `protobuf:"bytes,3,opt,name=migration_job,json=migrationJob,proto3" json:"migration_job,omitempty"`
	// Optional. A unique ID used to identify the request. If the server receives
	// two requests with the same ID, then the second request is ignored.
	//
	// It is recommended to always set this value to a UUID.
	//
	// The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
	// (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateMigrationJobRequest) Reset() {
	*x = CreateMigrationJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMigrationJobRequest) ProtoMessage() {}

func (x *CreateMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*CreateMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{3}
}

func (x *CreateMigrationJobRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMigrationJobRequest) GetMigrationJobId() string {
	if x != nil {
		return x.MigrationJobId
	}
	return ""
}

func (x *CreateMigrationJobRequest) GetMigrationJob() *MigrationJob {
	if x != nil {
		return x.MigrationJob
	}
	return nil
}

func (x *CreateMigrationJobRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'UpdateMigrationJob' request.
type UpdateMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten by the
	// update in the conversion workspace resource.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The migration job parameters to update.
	MigrationJob *MigrationJob `protobuf:"bytes,2,opt,name=migration_job,json=migrationJob,proto3" json:"migration_job,omitempty"`
	// A unique ID used to identify the request. If the server receives two
	// requests with the same ID, then the second request is ignored.
	//
	// It is recommended to always set this value to a UUID.
	//
	// The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
	// (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateMigrationJobRequest) Reset() {
	*x = UpdateMigrationJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateMigrationJobRequest) ProtoMessage() {}

func (x *UpdateMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*UpdateMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateMigrationJobRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateMigrationJobRequest) GetMigrationJob() *MigrationJob {
	if x != nil {
		return x.MigrationJob
	}
	return nil
}

func (x *UpdateMigrationJobRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'DeleteMigrationJob' request.
type DeleteMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the migration job resource to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A unique ID used to identify the request. If the server receives two
	// requests with the same ID, then the second request is ignored.
	//
	// It is recommended to always set this value to a UUID.
	//
	// The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
	// (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// The destination CloudSQL connection profile is always deleted with the
	// migration job. In case of force delete, the destination CloudSQL replica
	// database is also deleted.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteMigrationJobRequest) Reset() {
	*x = DeleteMigrationJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteMigrationJobRequest) ProtoMessage() {}

func (x *DeleteMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*DeleteMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteMigrationJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteMigrationJobRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteMigrationJobRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message for 'StartMigrationJob' request.
type StartMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the migration job resource to start.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Start the migration job without running prior configuration
	// verification. Defaults to `false`.
	SkipValidation bool `protobuf:"varint,2,opt,name=skip_validation,json=skipValidation,proto3" json:"skip_validation,omitempty"`
}

func (x *StartMigrationJobRequest) Reset() {
	*x = StartMigrationJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartMigrationJobRequest) ProtoMessage() {}

func (x *StartMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*StartMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{6}
}

func (x *StartMigrationJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StartMigrationJobRequest) GetSkipValidation() bool {
	if x != nil {
		return x.SkipValidation
	}
	return false
}

// Request message for 'StopMigrationJob' request.
type StopMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the migration job resource to stop.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *StopMigrationJobRequest) Reset() {
	*x = StopMigrationJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StopMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopMigrationJobRequest) ProtoMessage() {}

func (x *StopMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*StopMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{7}
}

func (x *StopMigrationJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'ResumeMigrationJob' request.
type ResumeMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the migration job resource to resume.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ResumeMigrationJobRequest) Reset() {
	*x = ResumeMigrationJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResumeMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResumeMigrationJobRequest) ProtoMessage() {}

func (x *ResumeMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResumeMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*ResumeMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{8}
}

func (x *ResumeMigrationJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'PromoteMigrationJob' request.
type PromoteMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the migration job resource to promote.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *PromoteMigrationJobRequest) Reset() {
	*x = PromoteMigrationJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PromoteMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PromoteMigrationJobRequest) ProtoMessage() {}

func (x *PromoteMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PromoteMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*PromoteMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{9}
}

func (x *PromoteMigrationJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'VerifyMigrationJob' request.
type VerifyMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the migration job resource to verify.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Field mask is used to specify the changed fields to be verified.
	// It will not update the migration job.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. The changed migration job parameters to verify.
	// It will not update the migration job.
	MigrationJob *MigrationJob `protobuf:"bytes,3,opt,name=migration_job,json=migrationJob,proto3" json:"migration_job,omitempty"`
}

func (x *VerifyMigrationJobRequest) Reset() {
	*x = VerifyMigrationJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VerifyMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyMigrationJobRequest) ProtoMessage() {}

func (x *VerifyMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*VerifyMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{10}
}

func (x *VerifyMigrationJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *VerifyMigrationJobRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *VerifyMigrationJobRequest) GetMigrationJob() *MigrationJob {
	if x != nil {
		return x.MigrationJob
	}
	return nil
}

// Request message for 'RestartMigrationJob' request.
type RestartMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the migration job resource to restart.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Restart the migration job without running prior configuration
	// verification. Defaults to `false`.
	SkipValidation bool `protobuf:"varint,2,opt,name=skip_validation,json=skipValidation,proto3" json:"skip_validation,omitempty"`
}

func (x *RestartMigrationJobRequest) Reset() {
	*x = RestartMigrationJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestartMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestartMigrationJobRequest) ProtoMessage() {}

func (x *RestartMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestartMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*RestartMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{11}
}

func (x *RestartMigrationJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RestartMigrationJobRequest) GetSkipValidation() bool {
	if x != nil {
		return x.SkipValidation
	}
	return false
}

// Request message for 'GenerateSshScript' request.
type GenerateSshScriptRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the migration job resource to generate the SSH script.
	MigrationJob string `protobuf:"bytes,1,opt,name=migration_job,json=migrationJob,proto3" json:"migration_job,omitempty"`
	// Required. Bastion VM Instance name to use or to create.
	Vm string `protobuf:"bytes,2,opt,name=vm,proto3" json:"vm,omitempty"`
	// The VM configuration
	//
	// Types that are assignable to VmConfig:
	//
	//	*GenerateSshScriptRequest_VmCreationConfig
	//	*GenerateSshScriptRequest_VmSelectionConfig
	VmConfig isGenerateSshScriptRequest_VmConfig `protobuf_oneof:"vm_config"`
	// The port that will be open on the bastion host.
	VmPort int32 `protobuf:"varint,3,opt,name=vm_port,json=vmPort,proto3" json:"vm_port,omitempty"`
}

func (x *GenerateSshScriptRequest) Reset() {
	*x = GenerateSshScriptRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateSshScriptRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateSshScriptRequest) ProtoMessage() {}

func (x *GenerateSshScriptRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateSshScriptRequest.ProtoReflect.Descriptor instead.
func (*GenerateSshScriptRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{12}
}

func (x *GenerateSshScriptRequest) GetMigrationJob() string {
	if x != nil {
		return x.MigrationJob
	}
	return ""
}

func (x *GenerateSshScriptRequest) GetVm() string {
	if x != nil {
		return x.Vm
	}
	return ""
}

func (m *GenerateSshScriptRequest) GetVmConfig() isGenerateSshScriptRequest_VmConfig {
	if m != nil {
		return m.VmConfig
	}
	return nil
}

func (x *GenerateSshScriptRequest) GetVmCreationConfig() *VmCreationConfig {
	if x, ok := x.GetVmConfig().(*GenerateSshScriptRequest_VmCreationConfig); ok {
		return x.VmCreationConfig
	}
	return nil
}

func (x *GenerateSshScriptRequest) GetVmSelectionConfig() *VmSelectionConfig {
	if x, ok := x.GetVmConfig().(*GenerateSshScriptRequest_VmSelectionConfig); ok {
		return x.VmSelectionConfig
	}
	return nil
}

func (x *GenerateSshScriptRequest) GetVmPort() int32 {
	if x != nil {
		return x.VmPort
	}
	return 0
}

type isGenerateSshScriptRequest_VmConfig interface {
	isGenerateSshScriptRequest_VmConfig()
}

type GenerateSshScriptRequest_VmCreationConfig struct {
	// The VM creation configuration
	VmCreationConfig *VmCreationConfig `protobuf:"bytes,100,opt,name=vm_creation_config,json=vmCreationConfig,proto3,oneof"`
}

type GenerateSshScriptRequest_VmSelectionConfig struct {
	// The VM selection configuration
	VmSelectionConfig *VmSelectionConfig `protobuf:"bytes,101,opt,name=vm_selection_config,json=vmSelectionConfig,proto3,oneof"`
}

func (*GenerateSshScriptRequest_VmCreationConfig) isGenerateSshScriptRequest_VmConfig() {}

func (*GenerateSshScriptRequest_VmSelectionConfig) isGenerateSshScriptRequest_VmConfig() {}

// VM creation configuration message
type VmCreationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. VM instance machine type to create.
	VmMachineType string `protobuf:"bytes,1,opt,name=vm_machine_type,json=vmMachineType,proto3" json:"vm_machine_type,omitempty"`
	// The Google Cloud Platform zone to create the VM in.
	VmZone string `protobuf:"bytes,2,opt,name=vm_zone,json=vmZone,proto3" json:"vm_zone,omitempty"`
	// The subnet name the vm needs to be created in.
	Subnet string `protobuf:"bytes,3,opt,name=subnet,proto3" json:"subnet,omitempty"`
}

func (x *VmCreationConfig) Reset() {
	*x = VmCreationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VmCreationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmCreationConfig) ProtoMessage() {}

func (x *VmCreationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmCreationConfig.ProtoReflect.Descriptor instead.
func (*VmCreationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{13}
}

func (x *VmCreationConfig) GetVmMachineType() string {
	if x != nil {
		return x.VmMachineType
	}
	return ""
}

func (x *VmCreationConfig) GetVmZone() string {
	if x != nil {
		return x.VmZone
	}
	return ""
}

func (x *VmCreationConfig) GetSubnet() string {
	if x != nil {
		return x.Subnet
	}
	return ""
}

// VM selection configuration message
type VmSelectionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Google Cloud Platform zone the VM is located.
	VmZone string `protobuf:"bytes,1,opt,name=vm_zone,json=vmZone,proto3" json:"vm_zone,omitempty"`
}

func (x *VmSelectionConfig) Reset() {
	*x = VmSelectionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VmSelectionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmSelectionConfig) ProtoMessage() {}

func (x *VmSelectionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmSelectionConfig.ProtoReflect.Descriptor instead.
func (*VmSelectionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{14}
}

func (x *VmSelectionConfig) GetVmZone() string {
	if x != nil {
		return x.VmZone
	}
	return ""
}

// Response message for 'GenerateSshScript' request.
type SshScript struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ssh configuration script.
	Script string `protobuf:"bytes,1,opt,name=script,proto3" json:"script,omitempty"`
}

func (x *SshScript) Reset() {
	*x = SshScript{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SshScript) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SshScript) ProtoMessage() {}

func (x *SshScript) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SshScript.ProtoReflect.Descriptor instead.
func (*SshScript) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{15}
}

func (x *SshScript) GetScript() string {
	if x != nil {
		return x.Script
	}
	return ""
}

// Request message for 'GenerateTcpProxyScript' request.
type GenerateTcpProxyScriptRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the migration job resource to generate the TCP Proxy script.
	MigrationJob string `protobuf:"bytes,1,opt,name=migration_job,json=migrationJob,proto3" json:"migration_job,omitempty"`
	// Required. The name of the Compute instance that will host the proxy.
	VmName string `protobuf:"bytes,2,opt,name=vm_name,json=vmName,proto3" json:"vm_name,omitempty"`
	// Required. The type of the Compute instance that will host the proxy.
	VmMachineType string `protobuf:"bytes,3,opt,name=vm_machine_type,json=vmMachineType,proto3" json:"vm_machine_type,omitempty"`
	// Optional. The Google Cloud Platform zone to create the VM in. The fully
	// qualified name of the zone must be specified, including the region name,
	// for example "us-central1-b". If not specified, uses the "-b" zone of the
	// destination Connection Profile's region.
	VmZone string `protobuf:"bytes,4,opt,name=vm_zone,json=vmZone,proto3" json:"vm_zone,omitempty"`
	// Required. The name of the subnet the Compute instance will use for private
	// connectivity. Must be supplied in the form of
	// projects/{project}/regions/{region}/subnetworks/{subnetwork}.
	// Note: the region for the subnet must match the Compute instance region.
	VmSubnet string `protobuf:"bytes,5,opt,name=vm_subnet,json=vmSubnet,proto3" json:"vm_subnet,omitempty"`
}

func (x *GenerateTcpProxyScriptRequest) Reset() {
	*x = GenerateTcpProxyScriptRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateTcpProxyScriptRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateTcpProxyScriptRequest) ProtoMessage() {}

func (x *GenerateTcpProxyScriptRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateTcpProxyScriptRequest.ProtoReflect.Descriptor instead.
func (*GenerateTcpProxyScriptRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{16}
}

func (x *GenerateTcpProxyScriptRequest) GetMigrationJob() string {
	if x != nil {
		return x.MigrationJob
	}
	return ""
}

func (x *GenerateTcpProxyScriptRequest) GetVmName() string {
	if x != nil {
		return x.VmName
	}
	return ""
}

func (x *GenerateTcpProxyScriptRequest) GetVmMachineType() string {
	if x != nil {
		return x.VmMachineType
	}
	return ""
}

func (x *GenerateTcpProxyScriptRequest) GetVmZone() string {
	if x != nil {
		return x.VmZone
	}
	return ""
}

func (x *GenerateTcpProxyScriptRequest) GetVmSubnet() string {
	if x != nil {
		return x.VmSubnet
	}
	return ""
}

// Response message for 'GenerateTcpProxyScript' request.
type TcpProxyScript struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The TCP Proxy configuration script.
	Script string `protobuf:"bytes,1,opt,name=script,proto3" json:"script,omitempty"`
}

func (x *TcpProxyScript) Reset() {
	*x = TcpProxyScript{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TcpProxyScript) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TcpProxyScript) ProtoMessage() {}

func (x *TcpProxyScript) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TcpProxyScript.ProtoReflect.Descriptor instead.
func (*TcpProxyScript) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{17}
}

func (x *TcpProxyScript) GetScript() string {
	if x != nil {
		return x.Script
	}
	return ""
}

// Request message for 'ListConnectionProfiles' request.
type ListConnectionProfilesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent which owns this collection of connection profiles.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of connection profiles to return. The service may return
	// fewer than this value. If unspecified, at most 50 connection profiles will
	// be returned. The maximum value is 1000; values above 1000 are coerced
	// to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListConnectionProfiles` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListConnectionProfiles`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters connection profiles listed in the
	// response. The expression must specify the field name, a comparison
	// operator, and the value that you want to use for filtering. The value must
	// be a string, a number, or a boolean. The comparison operator must be either
	// =, !=, >, or <. For example, list connection profiles created this year by
	// specifying **createTime %gt; 2020-01-01T00:00:00.000000000Z**. You can
	// also filter nested fields. For example, you could specify **mySql.username
	// = %lt;my_username%gt;** to list all connection profiles configured to
	// connect with a specific username.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// A comma-separated list of fields to order results according to.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListConnectionProfilesRequest) Reset() {
	*x = ListConnectionProfilesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConnectionProfilesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConnectionProfilesRequest) ProtoMessage() {}

func (x *ListConnectionProfilesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConnectionProfilesRequest.ProtoReflect.Descriptor instead.
func (*ListConnectionProfilesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{18}
}

func (x *ListConnectionProfilesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConnectionProfilesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConnectionProfilesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListConnectionProfilesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListConnectionProfilesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for 'ListConnectionProfiles' request.
type ListConnectionProfilesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The response list of connection profiles.
	ConnectionProfiles []*ConnectionProfile `protobuf:"bytes,1,rep,name=connection_profiles,json=connectionProfiles,proto3" json:"connection_profiles,omitempty"`
	// A token which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListConnectionProfilesResponse) Reset() {
	*x = ListConnectionProfilesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConnectionProfilesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConnectionProfilesResponse) ProtoMessage() {}

func (x *ListConnectionProfilesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConnectionProfilesResponse.ProtoReflect.Descriptor instead.
func (*ListConnectionProfilesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{19}
}

func (x *ListConnectionProfilesResponse) GetConnectionProfiles() []*ConnectionProfile {
	if x != nil {
		return x.ConnectionProfiles
	}
	return nil
}

func (x *ListConnectionProfilesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListConnectionProfilesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'GetConnectionProfile' request.
type GetConnectionProfileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the connection profile resource to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConnectionProfileRequest) Reset() {
	*x = GetConnectionProfileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConnectionProfileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConnectionProfileRequest) ProtoMessage() {}

func (x *GetConnectionProfileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConnectionProfileRequest.ProtoReflect.Descriptor instead.
func (*GetConnectionProfileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{20}
}

func (x *GetConnectionProfileRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'CreateConnectionProfile' request.
type CreateConnectionProfileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent which owns this collection of connection profiles.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The connection profile identifier.
	ConnectionProfileId string `protobuf:"bytes,2,opt,name=connection_profile_id,json=connectionProfileId,proto3" json:"connection_profile_id,omitempty"`
	// Required. The create request body including the connection profile data
	ConnectionProfile *ConnectionProfile `protobuf:"bytes,3,opt,name=connection_profile,json=connectionProfile,proto3" json:"connection_profile,omitempty"`
	// Optional. A unique ID used to identify the request. If the server receives
	// two requests with the same ID, then the second request is ignored.
	//
	// It is recommended to always set this value to a UUID.
	//
	// The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
	// (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. Only validate the connection profile, but don't create any
	// resources. The default is false. Only supported for Oracle connection
	// profiles.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Optional. Create the connection profile without validating it.
	// The default is false.
	// Only supported for Oracle connection profiles.
	SkipValidation bool `protobuf:"varint,6,opt,name=skip_validation,json=skipValidation,proto3" json:"skip_validation,omitempty"`
}

func (x *CreateConnectionProfileRequest) Reset() {
	*x = CreateConnectionProfileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateConnectionProfileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConnectionProfileRequest) ProtoMessage() {}

func (x *CreateConnectionProfileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConnectionProfileRequest.ProtoReflect.Descriptor instead.
func (*CreateConnectionProfileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{21}
}

func (x *CreateConnectionProfileRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateConnectionProfileRequest) GetConnectionProfileId() string {
	if x != nil {
		return x.ConnectionProfileId
	}
	return ""
}

func (x *CreateConnectionProfileRequest) GetConnectionProfile() *ConnectionProfile {
	if x != nil {
		return x.ConnectionProfile
	}
	return nil
}

func (x *CreateConnectionProfileRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateConnectionProfileRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *CreateConnectionProfileRequest) GetSkipValidation() bool {
	if x != nil {
		return x.SkipValidation
	}
	return false
}

// Request message for 'UpdateConnectionProfile' request.
type UpdateConnectionProfileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten by the
	// update in the conversion workspace resource.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The connection profile parameters to update.
	ConnectionProfile *ConnectionProfile `protobuf:"bytes,2,opt,name=connection_profile,json=connectionProfile,proto3" json:"connection_profile,omitempty"`
	// Optional. A unique ID used to identify the request. If the server receives
	// two requests with the same ID, then the second request is ignored.
	//
	// It is recommended to always set this value to a UUID.
	//
	// The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
	// (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. Only validate the connection profile, but don't update any
	// resources. The default is false. Only supported for Oracle connection
	// profiles.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Optional. Update the connection profile without validating it.
	// The default is false.
	// Only supported for Oracle connection profiles.
	SkipValidation bool `protobuf:"varint,5,opt,name=skip_validation,json=skipValidation,proto3" json:"skip_validation,omitempty"`
}

func (x *UpdateConnectionProfileRequest) Reset() {
	*x = UpdateConnectionProfileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateConnectionProfileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateConnectionProfileRequest) ProtoMessage() {}

func (x *UpdateConnectionProfileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateConnectionProfileRequest.ProtoReflect.Descriptor instead.
func (*UpdateConnectionProfileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{22}
}

func (x *UpdateConnectionProfileRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateConnectionProfileRequest) GetConnectionProfile() *ConnectionProfile {
	if x != nil {
		return x.ConnectionProfile
	}
	return nil
}

func (x *UpdateConnectionProfileRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *UpdateConnectionProfileRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *UpdateConnectionProfileRequest) GetSkipValidation() bool {
	if x != nil {
		return x.SkipValidation
	}
	return false
}

// Request message for 'DeleteConnectionProfile' request.
type DeleteConnectionProfileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the connection profile resource to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A unique ID used to identify the request. If the server receives two
	// requests with the same ID, then the second request is ignored.
	//
	// It is recommended to always set this value to a UUID.
	//
	// The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
	// (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// In case of force delete, the CloudSQL replica database is also deleted
	// (only for CloudSQL connection profile).
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteConnectionProfileRequest) Reset() {
	*x = DeleteConnectionProfileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteConnectionProfileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConnectionProfileRequest) ProtoMessage() {}

func (x *DeleteConnectionProfileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConnectionProfileRequest.ProtoReflect.Descriptor instead.
func (*DeleteConnectionProfileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{23}
}

func (x *DeleteConnectionProfileRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteConnectionProfileRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteConnectionProfileRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message to create a new private connection in the specified project
// and region.
type CreatePrivateConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent that owns the collection of PrivateConnections.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The private connection identifier.
	PrivateConnectionId string `protobuf:"bytes,2,opt,name=private_connection_id,json=privateConnectionId,proto3" json:"private_connection_id,omitempty"`
	// Required. The private connection resource to create.
	PrivateConnection *PrivateConnection `protobuf:"bytes,3,opt,name=private_connection,json=privateConnection,proto3" json:"private_connection,omitempty"`
	// Optional. A unique ID used to identify the request. If the server receives
	// two requests with the same ID, then the second request is ignored.
	//
	// It is recommended to always set this value to a UUID.
	//
	// The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
	// (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, will skip validations.
	SkipValidation bool `protobuf:"varint,5,opt,name=skip_validation,json=skipValidation,proto3" json:"skip_validation,omitempty"`
}

func (x *CreatePrivateConnectionRequest) Reset() {
	*x = CreatePrivateConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreatePrivateConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePrivateConnectionRequest) ProtoMessage() {}

func (x *CreatePrivateConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePrivateConnectionRequest.ProtoReflect.Descriptor instead.
func (*CreatePrivateConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{24}
}

func (x *CreatePrivateConnectionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreatePrivateConnectionRequest) GetPrivateConnectionId() string {
	if x != nil {
		return x.PrivateConnectionId
	}
	return ""
}

func (x *CreatePrivateConnectionRequest) GetPrivateConnection() *PrivateConnection {
	if x != nil {
		return x.PrivateConnection
	}
	return nil
}

func (x *CreatePrivateConnectionRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreatePrivateConnectionRequest) GetSkipValidation() bool {
	if x != nil {
		return x.SkipValidation
	}
	return false
}

// Request message to retrieve a list of private connections in a given project
// and location.
type ListPrivateConnectionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent that owns the collection of private connections.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of private connections to return.
	// If unspecified, at most 50 private connections that are returned.
	// The maximum value is 1000; values above 1000 are coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token received from a previous `ListPrivateConnections` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListPrivateConnections` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters private connections listed in the
	// response. The expression must specify the field name, a comparison
	// operator, and the value that you want to use for filtering. The value must
	// be a string, a number, or a boolean. The comparison operator must be either
	// =, !=, >, or <. For example, list private connections created this year by
	// specifying **createTime %gt; 2021-01-01T00:00:00.000000000Z**.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Order by fields for the result.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListPrivateConnectionsRequest) Reset() {
	*x = ListPrivateConnectionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPrivateConnectionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPrivateConnectionsRequest) ProtoMessage() {}

func (x *ListPrivateConnectionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPrivateConnectionsRequest.ProtoReflect.Descriptor instead.
func (*ListPrivateConnectionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{25}
}

func (x *ListPrivateConnectionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPrivateConnectionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPrivateConnectionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPrivateConnectionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListPrivateConnectionsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for 'ListPrivateConnections' request.
type ListPrivateConnectionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of private connections.
	PrivateConnections []*PrivateConnection `protobuf:"bytes,1,rep,name=private_connections,json=privateConnections,proto3" json:"private_connections,omitempty"`
	// A token which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListPrivateConnectionsResponse) Reset() {
	*x = ListPrivateConnectionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPrivateConnectionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPrivateConnectionsResponse) ProtoMessage() {}

func (x *ListPrivateConnectionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPrivateConnectionsResponse.ProtoReflect.Descriptor instead.
func (*ListPrivateConnectionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{26}
}

func (x *ListPrivateConnectionsResponse) GetPrivateConnections() []*PrivateConnection {
	if x != nil {
		return x.PrivateConnections
	}
	return nil
}

func (x *ListPrivateConnectionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListPrivateConnectionsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message to delete a private connection.
type DeletePrivateConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the private connection to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A unique ID used to identify the request. If the server receives
	// two requests with the same ID, then the second request is ignored.
	//
	// It is recommended to always set this value to a UUID.
	//
	// The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
	// (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeletePrivateConnectionRequest) Reset() {
	*x = DeletePrivateConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeletePrivateConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePrivateConnectionRequest) ProtoMessage() {}

func (x *DeletePrivateConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePrivateConnectionRequest.ProtoReflect.Descriptor instead.
func (*DeletePrivateConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{27}
}

func (x *DeletePrivateConnectionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeletePrivateConnectionRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message to get a private connection resource.
type GetPrivateConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the private connection to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPrivateConnectionRequest) Reset() {
	*x = GetPrivateConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPrivateConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPrivateConnectionRequest) ProtoMessage() {}

func (x *GetPrivateConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPrivateConnectionRequest.ProtoReflect.Descriptor instead.
func (*GetPrivateConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{28}
}

func (x *GetPrivateConnectionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have successfully been cancelled
	// have [Operation.error][] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{29}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Retrieve a list of all conversion workspaces in a given project and location.
type ListConversionWorkspacesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent which owns this collection of conversion workspaces.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of conversion workspaces to return. The service may
	// return fewer than this value. If unspecified, at most 50 sets are returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The nextPageToken value received in the previous call to
	// conversionWorkspaces.list, used in the subsequent request to retrieve the
	// next page of results. On first call this should be left blank. When
	// paginating, all other parameters provided to conversionWorkspaces.list must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters conversion workspaces listed in the
	// response. The expression must specify the field name, a comparison
	// operator, and the value that you want to use for filtering. The value must
	// be a string, a number, or a boolean. The comparison operator must be either
	// =, !=, >, or <. For example, list conversion workspaces created this year
	// by specifying **createTime %gt; 2020-01-01T00:00:00.000000000Z.** You can
	// also filter nested fields. For example, you could specify
	// **source.version = "12.c.1"** to select all conversion workspaces with
	// source database version equal to 12.c.1.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListConversionWorkspacesRequest) Reset() {
	*x = ListConversionWorkspacesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConversionWorkspacesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversionWorkspacesRequest) ProtoMessage() {}

func (x *ListConversionWorkspacesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversionWorkspacesRequest.ProtoReflect.Descriptor instead.
func (*ListConversionWorkspacesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{30}
}

func (x *ListConversionWorkspacesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConversionWorkspacesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConversionWorkspacesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListConversionWorkspacesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for 'ListConversionWorkspaces' request.
type ListConversionWorkspacesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of conversion workspace objects.
	ConversionWorkspaces []*ConversionWorkspace `protobuf:"bytes,1,rep,name=conversion_workspaces,json=conversionWorkspaces,proto3" json:"conversion_workspaces,omitempty"`
	// A token which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListConversionWorkspacesResponse) Reset() {
	*x = ListConversionWorkspacesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConversionWorkspacesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversionWorkspacesResponse) ProtoMessage() {}

func (x *ListConversionWorkspacesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversionWorkspacesResponse.ProtoReflect.Descriptor instead.
func (*ListConversionWorkspacesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{31}
}

func (x *ListConversionWorkspacesResponse) GetConversionWorkspaces() []*ConversionWorkspace {
	if x != nil {
		return x.ConversionWorkspaces
	}
	return nil
}

func (x *ListConversionWorkspacesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListConversionWorkspacesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'GetConversionWorkspace' request.
type GetConversionWorkspaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the conversion workspace resource to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConversionWorkspaceRequest) Reset() {
	*x = GetConversionWorkspaceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConversionWorkspaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversionWorkspaceRequest) ProtoMessage() {}

func (x *GetConversionWorkspaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversionWorkspaceRequest.ProtoReflect.Descriptor instead.
func (*GetConversionWorkspaceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{32}
}

func (x *GetConversionWorkspaceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message to create a new Conversion Workspace
// in the specified project and region.
type CreateConversionWorkspaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent which owns this collection of conversion workspaces.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the conversion workspace to create.
	ConversionWorkspaceId string `protobuf:"bytes,2,opt,name=conversion_workspace_id,json=conversionWorkspaceId,proto3" json:"conversion_workspace_id,omitempty"`
	// Required. Represents a conversion workspace object.
	ConversionWorkspace *ConversionWorkspace `protobuf:"bytes,3,opt,name=conversion_workspace,json=conversionWorkspace,proto3" json:"conversion_workspace,omitempty"`
	// A unique ID used to identify the request. If the server receives two
	// requests with the same ID, then the second request is ignored.
	//
	// It is recommended to always set this value to a UUID.
	//
	// The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
	// (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateConversionWorkspaceRequest) Reset() {
	*x = CreateConversionWorkspaceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateConversionWorkspaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConversionWorkspaceRequest) ProtoMessage() {}

func (x *CreateConversionWorkspaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConversionWorkspaceRequest.ProtoReflect.Descriptor instead.
func (*CreateConversionWorkspaceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{33}
}

func (x *CreateConversionWorkspaceRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateConversionWorkspaceRequest) GetConversionWorkspaceId() string {
	if x != nil {
		return x.ConversionWorkspaceId
	}
	return ""
}

func (x *CreateConversionWorkspaceRequest) GetConversionWorkspace() *ConversionWorkspace {
	if x != nil {
		return x.ConversionWorkspace
	}
	return nil
}

func (x *CreateConversionWorkspaceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'UpdateConversionWorkspace' request.
type UpdateConversionWorkspaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten by the
	// update in the conversion workspace resource.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The conversion workspace parameters to update.
	ConversionWorkspace *ConversionWorkspace `protobuf:"bytes,2,opt,name=conversion_workspace,json=conversionWorkspace,proto3" json:"conversion_workspace,omitempty"`
	// A unique ID used to identify the request. If the server receives two
	// requests with the same ID, then the second request is ignored.
	//
	// It is recommended to always set this value to a UUID.
	//
	// The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
	// (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateConversionWorkspaceRequest) Reset() {
	*x = UpdateConversionWorkspaceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateConversionWorkspaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateConversionWorkspaceRequest) ProtoMessage() {}

func (x *UpdateConversionWorkspaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateConversionWorkspaceRequest.ProtoReflect.Descriptor instead.
func (*UpdateConversionWorkspaceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{34}
}

func (x *UpdateConversionWorkspaceRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateConversionWorkspaceRequest) GetConversionWorkspace() *ConversionWorkspace {
	if x != nil {
		return x.ConversionWorkspace
	}
	return nil
}

func (x *UpdateConversionWorkspaceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'DeleteConversionWorkspace' request.
type DeleteConversionWorkspaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the conversion workspace resource to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A unique ID used to identify the request. If the server receives two
	// requests with the same ID, then the second request is ignored.
	//
	// It is recommended to always set this value to a UUID.
	//
	// The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
	// (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Force delete the conversion workspace, even if there's a running migration
	// that is using the workspace.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteConversionWorkspaceRequest) Reset() {
	*x = DeleteConversionWorkspaceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteConversionWorkspaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConversionWorkspaceRequest) ProtoMessage() {}

func (x *DeleteConversionWorkspaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConversionWorkspaceRequest.ProtoReflect.Descriptor instead.
func (*DeleteConversionWorkspaceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{35}
}

func (x *DeleteConversionWorkspaceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteConversionWorkspaceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteConversionWorkspaceRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message for 'CommitConversionWorkspace' request.
type CommitConversionWorkspaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the conversion workspace resource to commit.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Optional name of the commit.
	CommitName string `protobuf:"bytes,2,opt,name=commit_name,json=commitName,proto3" json:"commit_name,omitempty"`
}

func (x *CommitConversionWorkspaceRequest) Reset() {
	*x = CommitConversionWorkspaceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitConversionWorkspaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitConversionWorkspaceRequest) ProtoMessage() {}

func (x *CommitConversionWorkspaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitConversionWorkspaceRequest.ProtoReflect.Descriptor instead.
func (*CommitConversionWorkspaceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{36}
}

func (x *CommitConversionWorkspaceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CommitConversionWorkspaceRequest) GetCommitName() string {
	if x != nil {
		return x.CommitName
	}
	return ""
}

// Request message for 'RollbackConversionWorkspace' request.
type RollbackConversionWorkspaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the conversion workspace resource to roll back to.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *RollbackConversionWorkspaceRequest) Reset() {
	*x = RollbackConversionWorkspaceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RollbackConversionWorkspaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollbackConversionWorkspaceRequest) ProtoMessage() {}

func (x *RollbackConversionWorkspaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RollbackConversionWorkspaceRequest.ProtoReflect.Descriptor instead.
func (*RollbackConversionWorkspaceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{37}
}

func (x *RollbackConversionWorkspaceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'ApplyConversionWorkspace' request.
type ApplyConversionWorkspaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the conversion workspace resource for which to apply
	// the draft tree. Must be in the form of:
	//
	//	projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Filter which entities to apply. Leaving this field empty will apply all of
	// the entities. Supports Google AIP 160 based filtering.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Only validates the apply process, but doesn't change the
	// destination database. Only works for PostgreSQL destination connection
	// profile.
	DryRun bool `protobuf:"varint,3,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
	// Optional. Specifies whether the conversion workspace is to be committed
	// automatically after the apply.
	AutoCommit bool `protobuf:"varint,4,opt,name=auto_commit,json=autoCommit,proto3" json:"auto_commit,omitempty"`
	// Which destination to use when applying the conversion workspace.
	//
	// Types that are assignable to Destination:
	//
	//	*ApplyConversionWorkspaceRequest_ConnectionProfile
	Destination isApplyConversionWorkspaceRequest_Destination `protobuf_oneof:"destination"`
}

func (x *ApplyConversionWorkspaceRequest) Reset() {
	*x = ApplyConversionWorkspaceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplyConversionWorkspaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyConversionWorkspaceRequest) ProtoMessage() {}

func (x *ApplyConversionWorkspaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyConversionWorkspaceRequest.ProtoReflect.Descriptor instead.
func (*ApplyConversionWorkspaceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{38}
}

func (x *ApplyConversionWorkspaceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ApplyConversionWorkspaceRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ApplyConversionWorkspaceRequest) GetDryRun() bool {
	if x != nil {
		return x.DryRun
	}
	return false
}

func (x *ApplyConversionWorkspaceRequest) GetAutoCommit() bool {
	if x != nil {
		return x.AutoCommit
	}
	return false
}

func (m *ApplyConversionWorkspaceRequest) GetDestination() isApplyConversionWorkspaceRequest_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *ApplyConversionWorkspaceRequest) GetConnectionProfile() string {
	if x, ok := x.GetDestination().(*ApplyConversionWorkspaceRequest_ConnectionProfile); ok {
		return x.ConnectionProfile
	}
	return ""
}

type isApplyConversionWorkspaceRequest_Destination interface {
	isApplyConversionWorkspaceRequest_Destination()
}

type ApplyConversionWorkspaceRequest_ConnectionProfile struct {
	// Optional. Fully qualified (Uri) name of the destination connection
	// profile.
	ConnectionProfile string `protobuf:"bytes,100,opt,name=connection_profile,json=connectionProfile,proto3,oneof"`
}

func (*ApplyConversionWorkspaceRequest_ConnectionProfile) isApplyConversionWorkspaceRequest_Destination() {
}

// Retrieve a list of all mapping rules in a given conversion workspace.
type ListMappingRulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the conversion workspace resource whose mapping rules are
	// listed in the form of:
	// projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of rules to return. The service may return
	// fewer than this value.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The nextPageToken value received in the previous call to
	// mappingRules.list, used in the subsequent request to retrieve the next
	// page of results. On first call this should be left blank. When paginating,
	// all other parameters provided to mappingRules.list must match the call
	// that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListMappingRulesRequest) Reset() {
	*x = ListMappingRulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMappingRulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMappingRulesRequest) ProtoMessage() {}

func (x *ListMappingRulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMappingRulesRequest.ProtoReflect.Descriptor instead.
func (*ListMappingRulesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{39}
}

func (x *ListMappingRulesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMappingRulesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMappingRulesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for 'ListMappingRulesRequest' request.
type ListMappingRulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of conversion workspace mapping rules.
	MappingRules []*MappingRule `protobuf:"bytes,1,rep,name=mapping_rules,json=mappingRules,proto3" json:"mapping_rules,omitempty"`
	// A token which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListMappingRulesResponse) Reset() {
	*x = ListMappingRulesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMappingRulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMappingRulesResponse) ProtoMessage() {}

func (x *ListMappingRulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMappingRulesResponse.ProtoReflect.Descriptor instead.
func (*ListMappingRulesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{40}
}

func (x *ListMappingRulesResponse) GetMappingRules() []*MappingRule {
	if x != nil {
		return x.MappingRules
	}
	return nil
}

func (x *ListMappingRulesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for 'GetMappingRule' request.
type GetMappingRuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the mapping rule resource to get.
	// Example: conversionWorkspaces/123/mappingRules/rule123
	//
	// In order to retrieve a previous revision of the mapping rule, also provide
	// the revision ID.
	// Example:
	// conversionWorkspace/123/mappingRules/rule123@c7cfa2a8c7cfa2a8c7cfa2a8c7cfa2a8
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetMappingRuleRequest) Reset() {
	*x = GetMappingRuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMappingRuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMappingRuleRequest) ProtoMessage() {}

func (x *GetMappingRuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMappingRuleRequest.ProtoReflect.Descriptor instead.
func (*GetMappingRuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{41}
}

func (x *GetMappingRuleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'SeedConversionWorkspace' request.
type SeedConversionWorkspaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the conversion workspace resource to seed with new database
	// structure, in the form of:
	// projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Should the conversion workspace be committed automatically after the
	// seed operation.
	AutoCommit bool `protobuf:"varint,2,opt,name=auto_commit,json=autoCommit,proto3" json:"auto_commit,omitempty"`
	// The input to be used for seeding the conversion workspace. The input can
	// either be from the source or destination databases and it can be provided
	// through a connection profile or a DDL file.
	//
	// Types that are assignable to SeedFrom:
	//
	//	*SeedConversionWorkspaceRequest_SourceConnectionProfile
	//	*SeedConversionWorkspaceRequest_DestinationConnectionProfile
	SeedFrom isSeedConversionWorkspaceRequest_SeedFrom `protobuf_oneof:"seed_from"`
}

func (x *SeedConversionWorkspaceRequest) Reset() {
	*x = SeedConversionWorkspaceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SeedConversionWorkspaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SeedConversionWorkspaceRequest) ProtoMessage() {}

func (x *SeedConversionWorkspaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SeedConversionWorkspaceRequest.ProtoReflect.Descriptor instead.
func (*SeedConversionWorkspaceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{42}
}

func (x *SeedConversionWorkspaceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SeedConversionWorkspaceRequest) GetAutoCommit() bool {
	if x != nil {
		return x.AutoCommit
	}
	return false
}

func (m *SeedConversionWorkspaceRequest) GetSeedFrom() isSeedConversionWorkspaceRequest_SeedFrom {
	if m != nil {
		return m.SeedFrom
	}
	return nil
}

func (x *SeedConversionWorkspaceRequest) GetSourceConnectionProfile() string {
	if x, ok := x.GetSeedFrom().(*SeedConversionWorkspaceRequest_SourceConnectionProfile); ok {
		return x.SourceConnectionProfile
	}
	return ""
}

func (x *SeedConversionWorkspaceRequest) GetDestinationConnectionProfile() string {
	if x, ok := x.GetSeedFrom().(*SeedConversionWorkspaceRequest_DestinationConnectionProfile); ok {
		return x.DestinationConnectionProfile
	}
	return ""
}

type isSeedConversionWorkspaceRequest_SeedFrom interface {
	isSeedConversionWorkspaceRequest_SeedFrom()
}

type SeedConversionWorkspaceRequest_SourceConnectionProfile struct {
	// Optional. Fully qualified (Uri) name of the source connection profile.
	SourceConnectionProfile string `protobuf:"bytes,100,opt,name=source_connection_profile,json=sourceConnectionProfile,proto3,oneof"`
}

type SeedConversionWorkspaceRequest_DestinationConnectionProfile struct {
	// Optional. Fully qualified (Uri) name of the destination connection
	// profile.
	DestinationConnectionProfile string `protobuf:"bytes,101,opt,name=destination_connection_profile,json=destinationConnectionProfile,proto3,oneof"`
}

func (*SeedConversionWorkspaceRequest_SourceConnectionProfile) isSeedConversionWorkspaceRequest_SeedFrom() {
}

func (*SeedConversionWorkspaceRequest_DestinationConnectionProfile) isSeedConversionWorkspaceRequest_SeedFrom() {
}

// Request message for 'ConvertConversionWorkspace' request.
type ConvertConversionWorkspaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the conversion workspace resource to convert in the form of:
	// projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Specifies whether the conversion workspace is to be committed
	// automatically after the conversion.
	AutoCommit bool `protobuf:"varint,4,opt,name=auto_commit,json=autoCommit,proto3" json:"auto_commit,omitempty"`
	// Optional. Filter the entities to convert. Leaving this field empty will
	// convert all of the entities. Supports Google AIP-160 style filtering.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Automatically convert the full entity path for each entity
	// specified by the filter. For example, if the filter specifies a table, that
	// table schema (and database if there is one) will also be converted.
	ConvertFullPath bool `protobuf:"varint,6,opt,name=convert_full_path,json=convertFullPath,proto3" json:"convert_full_path,omitempty"`
}

func (x *ConvertConversionWorkspaceRequest) Reset() {
	*x = ConvertConversionWorkspaceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConvertConversionWorkspaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConvertConversionWorkspaceRequest) ProtoMessage() {}

func (x *ConvertConversionWorkspaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConvertConversionWorkspaceRequest.ProtoReflect.Descriptor instead.
func (*ConvertConversionWorkspaceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{43}
}

func (x *ConvertConversionWorkspaceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConvertConversionWorkspaceRequest) GetAutoCommit() bool {
	if x != nil {
		return x.AutoCommit
	}
	return false
}

func (x *ConvertConversionWorkspaceRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ConvertConversionWorkspaceRequest) GetConvertFullPath() bool {
	if x != nil {
		return x.ConvertFullPath
	}
	return false
}

// Request message for 'ImportMappingRules' request.
type ImportMappingRulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the conversion workspace resource to import the rules to
	// in the form of:
	// projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The format of the rules content file.
	RulesFormat ImportRulesFileFormat `protobuf:"varint,2,opt,name=rules_format,json=rulesFormat,proto3,enum=google.cloud.clouddms.v1.ImportRulesFileFormat" json:"rules_format,omitempty"`
	// Required. One or more rules files.
	RulesFiles []*ImportMappingRulesRequest_RulesFile `protobuf:"bytes,3,rep,name=rules_files,json=rulesFiles,proto3" json:"rules_files,omitempty"`
	// Required. Should the conversion workspace be committed automatically after
	// the import operation.
	AutoCommit bool `protobuf:"varint,6,opt,name=auto_commit,json=autoCommit,proto3" json:"auto_commit,omitempty"`
}

func (x *ImportMappingRulesRequest) Reset() {
	*x = ImportMappingRulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportMappingRulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportMappingRulesRequest) ProtoMessage() {}

func (x *ImportMappingRulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportMappingRulesRequest.ProtoReflect.Descriptor instead.
func (*ImportMappingRulesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{44}
}

func (x *ImportMappingRulesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ImportMappingRulesRequest) GetRulesFormat() ImportRulesFileFormat {
	if x != nil {
		return x.RulesFormat
	}
	return ImportRulesFileFormat_IMPORT_RULES_FILE_FORMAT_UNSPECIFIED
}

func (x *ImportMappingRulesRequest) GetRulesFiles() []*ImportMappingRulesRequest_RulesFile {
	if x != nil {
		return x.RulesFiles
	}
	return nil
}

func (x *ImportMappingRulesRequest) GetAutoCommit() bool {
	if x != nil {
		return x.AutoCommit
	}
	return false
}

// Request message for 'DescribeDatabaseEntities' request.
type DescribeDatabaseEntitiesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the conversion workspace resource whose database entities
	// are described. Must be in the form of:
	// projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
	ConversionWorkspace string `protobuf:"bytes,1,opt,name=conversion_workspace,json=conversionWorkspace,proto3" json:"conversion_workspace,omitempty"`
	// Optional. The maximum number of entities to return. The service may return
	// fewer entities than the value specifies.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The nextPageToken value received in the previous call to
	// conversionWorkspace.describeDatabaseEntities, used in the subsequent
	// request to retrieve the next page of results. On first call this should be
	// left blank. When paginating, all other parameters provided to
	// conversionWorkspace.describeDatabaseEntities must match the call that
	// provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Required. The tree to fetch.
	Tree DescribeDatabaseEntitiesRequest_DBTreeType `protobuf:"varint,6,opt,name=tree,proto3,enum=google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest_DBTreeType" json:"tree,omitempty"`
	// Optional. Whether to retrieve the latest committed version of the entities
	// or the latest version. This field is ignored if a specific commit_id is
	// specified.
	Uncommitted bool `protobuf:"varint,11,opt,name=uncommitted,proto3" json:"uncommitted,omitempty"`
	// Optional. Request a specific commit ID. If not specified, the entities from
	// the latest commit are returned.
	CommitId string `protobuf:"bytes,12,opt,name=commit_id,json=commitId,proto3" json:"commit_id,omitempty"`
	// Optional. Filter the returned entities based on AIP-160 standard.
	Filter string `protobuf:"bytes,13,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Results view based on AIP-157
	View DatabaseEntityView `protobuf:"varint,14,opt,name=view,proto3,enum=google.cloud.clouddms.v1.DatabaseEntityView" json:"view,omitempty"`
}

func (x *DescribeDatabaseEntitiesRequest) Reset() {
	*x = DescribeDatabaseEntitiesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DescribeDatabaseEntitiesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DescribeDatabaseEntitiesRequest) ProtoMessage() {}

func (x *DescribeDatabaseEntitiesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DescribeDatabaseEntitiesRequest.ProtoReflect.Descriptor instead.
func (*DescribeDatabaseEntitiesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{45}
}

func (x *DescribeDatabaseEntitiesRequest) GetConversionWorkspace() string {
	if x != nil {
		return x.ConversionWorkspace
	}
	return ""
}

func (x *DescribeDatabaseEntitiesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *DescribeDatabaseEntitiesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *DescribeDatabaseEntitiesRequest) GetTree() DescribeDatabaseEntitiesRequest_DBTreeType {
	if x != nil {
		return x.Tree
	}
	return DescribeDatabaseEntitiesRequest_DB_TREE_TYPE_UNSPECIFIED
}

func (x *DescribeDatabaseEntitiesRequest) GetUncommitted() bool {
	if x != nil {
		return x.Uncommitted
	}
	return false
}

func (x *DescribeDatabaseEntitiesRequest) GetCommitId() string {
	if x != nil {
		return x.CommitId
	}
	return ""
}

func (x *DescribeDatabaseEntitiesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *DescribeDatabaseEntitiesRequest) GetView() DatabaseEntityView {
	if x != nil {
		return x.View
	}
	return DatabaseEntityView_DATABASE_ENTITY_VIEW_UNSPECIFIED
}

// Response message for 'DescribeDatabaseEntities' request.
type DescribeDatabaseEntitiesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of database entities for the conversion workspace.
	DatabaseEntities []*DatabaseEntity `protobuf:"bytes,1,rep,name=database_entities,json=databaseEntities,proto3" json:"database_entities,omitempty"`
	// A token which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *DescribeDatabaseEntitiesResponse) Reset() {
	*x = DescribeDatabaseEntitiesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DescribeDatabaseEntitiesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DescribeDatabaseEntitiesResponse) ProtoMessage() {}

func (x *DescribeDatabaseEntitiesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DescribeDatabaseEntitiesResponse.ProtoReflect.Descriptor instead.
func (*DescribeDatabaseEntitiesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{46}
}

func (x *DescribeDatabaseEntitiesResponse) GetDatabaseEntities() []*DatabaseEntity {
	if x != nil {
		return x.DatabaseEntities
	}
	return nil
}

func (x *DescribeDatabaseEntitiesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for 'SearchBackgroundJobs' request.
type SearchBackgroundJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the conversion workspace resource whose jobs are listed,
	// in the form of:
	// projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
	ConversionWorkspace string `protobuf:"bytes,1,opt,name=conversion_workspace,json=conversionWorkspace,proto3" json:"conversion_workspace,omitempty"`
	// Optional. Whether or not to return just the most recent job per job type,
	ReturnMostRecentPerJobType bool `protobuf:"varint,2,opt,name=return_most_recent_per_job_type,json=returnMostRecentPerJobType,proto3" json:"return_most_recent_per_job_type,omitempty"`
	// Optional. The maximum number of jobs to return. The service may return
	// fewer than this value. If unspecified, at most 100 jobs are
	// returned. The maximum value is 100; values above 100 are coerced to
	// 100.
	MaxSize int32 `protobuf:"varint,3,opt,name=max_size,json=maxSize,proto3" json:"max_size,omitempty"`
	// Optional. If provided, only returns jobs that completed until (not
	// including) the given timestamp.
	CompletedUntilTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=completed_until_time,json=completedUntilTime,proto3" json:"completed_until_time,omitempty"`
}

func (x *SearchBackgroundJobsRequest) Reset() {
	*x = SearchBackgroundJobsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchBackgroundJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchBackgroundJobsRequest) ProtoMessage() {}

func (x *SearchBackgroundJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchBackgroundJobsRequest.ProtoReflect.Descriptor instead.
func (*SearchBackgroundJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{47}
}

func (x *SearchBackgroundJobsRequest) GetConversionWorkspace() string {
	if x != nil {
		return x.ConversionWorkspace
	}
	return ""
}

func (x *SearchBackgroundJobsRequest) GetReturnMostRecentPerJobType() bool {
	if x != nil {
		return x.ReturnMostRecentPerJobType
	}
	return false
}

func (x *SearchBackgroundJobsRequest) GetMaxSize() int32 {
	if x != nil {
		return x.MaxSize
	}
	return 0
}

func (x *SearchBackgroundJobsRequest) GetCompletedUntilTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CompletedUntilTime
	}
	return nil
}

// Response message for 'SearchBackgroundJobs' request.
type SearchBackgroundJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of conversion workspace mapping rules.
	Jobs []*BackgroundJobLogEntry `protobuf:"bytes,1,rep,name=jobs,proto3" json:"jobs,omitempty"`
}

func (x *SearchBackgroundJobsResponse) Reset() {
	*x = SearchBackgroundJobsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchBackgroundJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchBackgroundJobsResponse) ProtoMessage() {}

func (x *SearchBackgroundJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchBackgroundJobsResponse.ProtoReflect.Descriptor instead.
func (*SearchBackgroundJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{48}
}

func (x *SearchBackgroundJobsResponse) GetJobs() []*BackgroundJobLogEntry {
	if x != nil {
		return x.Jobs
	}
	return nil
}

// Request message for 'DescribeConversionWorkspaceRevisions' request.
type DescribeConversionWorkspaceRevisionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the conversion workspace resource whose revisions are
	// listed. Must be in the form of:
	// projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
	ConversionWorkspace string `protobuf:"bytes,1,opt,name=conversion_workspace,json=conversionWorkspace,proto3" json:"conversion_workspace,omitempty"`
	// Optional. Optional filter to request a specific commit ID.
	CommitId string `protobuf:"bytes,2,opt,name=commit_id,json=commitId,proto3" json:"commit_id,omitempty"`
}

func (x *DescribeConversionWorkspaceRevisionsRequest) Reset() {
	*x = DescribeConversionWorkspaceRevisionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DescribeConversionWorkspaceRevisionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DescribeConversionWorkspaceRevisionsRequest) ProtoMessage() {}

func (x *DescribeConversionWorkspaceRevisionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DescribeConversionWorkspaceRevisionsRequest.ProtoReflect.Descriptor instead.
func (*DescribeConversionWorkspaceRevisionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{49}
}

func (x *DescribeConversionWorkspaceRevisionsRequest) GetConversionWorkspace() string {
	if x != nil {
		return x.ConversionWorkspace
	}
	return ""
}

func (x *DescribeConversionWorkspaceRevisionsRequest) GetCommitId() string {
	if x != nil {
		return x.CommitId
	}
	return ""
}

// Response message for 'DescribeConversionWorkspaceRevisions' request.
type DescribeConversionWorkspaceRevisionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of conversion workspace revisions.
	Revisions []*ConversionWorkspace `protobuf:"bytes,1,rep,name=revisions,proto3" json:"revisions,omitempty"`
}

func (x *DescribeConversionWorkspaceRevisionsResponse) Reset() {
	*x = DescribeConversionWorkspaceRevisionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DescribeConversionWorkspaceRevisionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DescribeConversionWorkspaceRevisionsResponse) ProtoMessage() {}

func (x *DescribeConversionWorkspaceRevisionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DescribeConversionWorkspaceRevisionsResponse.ProtoReflect.Descriptor instead.
func (*DescribeConversionWorkspaceRevisionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{50}
}

func (x *DescribeConversionWorkspaceRevisionsResponse) GetRevisions() []*ConversionWorkspace {
	if x != nil {
		return x.Revisions
	}
	return nil
}

// Request message for 'CreateMappingRule' command.
type CreateMappingRuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent which owns this collection of mapping rules.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the rule to create.
	MappingRuleId string `protobuf:"bytes,2,opt,name=mapping_rule_id,json=mappingRuleId,proto3" json:"mapping_rule_id,omitempty"`
	// Required. Represents a [mapping rule]
	// (https://cloud.google.com/database-migration/reference/rest/v1/projects.locations.mappingRules)
	// object.
	MappingRule *MappingRule `protobuf:"bytes,3,opt,name=mapping_rule,json=mappingRule,proto3" json:"mapping_rule,omitempty"`
	// A unique ID used to identify the request. If the server receives two
	// requests with the same ID, then the second request is ignored.
	//
	// It is recommended to always set this value to a UUID.
	//
	// The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
	// (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateMappingRuleRequest) Reset() {
	*x = CreateMappingRuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateMappingRuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMappingRuleRequest) ProtoMessage() {}

func (x *CreateMappingRuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMappingRuleRequest.ProtoReflect.Descriptor instead.
func (*CreateMappingRuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{51}
}

func (x *CreateMappingRuleRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMappingRuleRequest) GetMappingRuleId() string {
	if x != nil {
		return x.MappingRuleId
	}
	return ""
}

func (x *CreateMappingRuleRequest) GetMappingRule() *MappingRule {
	if x != nil {
		return x.MappingRule
	}
	return nil
}

func (x *CreateMappingRuleRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'DeleteMappingRule' request.
type DeleteMappingRuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the mapping rule resource to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A unique ID used to identify the request. If the server receives
	// two requests with the same ID, then the second request is ignored.
	//
	// It is recommended to always set this value to a UUID.
	//
	// The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
	// (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteMappingRuleRequest) Reset() {
	*x = DeleteMappingRuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteMappingRuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteMappingRuleRequest) ProtoMessage() {}

func (x *DeleteMappingRuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteMappingRuleRequest.ProtoReflect.Descriptor instead.
func (*DeleteMappingRuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{52}
}

func (x *DeleteMappingRuleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteMappingRuleRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'FetchStaticIps' request.
type FetchStaticIpsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name for the location for which static IPs should be
	// returned. Must be in the format `projects/*/locations/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Maximum number of IPs to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `FetchStaticIps` call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *FetchStaticIpsRequest) Reset() {
	*x = FetchStaticIpsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchStaticIpsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchStaticIpsRequest) ProtoMessage() {}

func (x *FetchStaticIpsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchStaticIpsRequest.ProtoReflect.Descriptor instead.
func (*FetchStaticIpsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{53}
}

func (x *FetchStaticIpsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FetchStaticIpsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *FetchStaticIpsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for a 'FetchStaticIps' request.
type FetchStaticIpsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of static IPs.
	StaticIps []string `protobuf:"bytes,1,rep,name=static_ips,json=staticIps,proto3" json:"static_ips,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *FetchStaticIpsResponse) Reset() {
	*x = FetchStaticIpsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchStaticIpsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchStaticIpsResponse) ProtoMessage() {}

func (x *FetchStaticIpsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchStaticIpsResponse.ProtoReflect.Descriptor instead.
func (*FetchStaticIpsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{54}
}

func (x *FetchStaticIpsResponse) GetStaticIps() []string {
	if x != nil {
		return x.StaticIps
	}
	return nil
}

func (x *FetchStaticIpsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Details of a single rules file.
type ImportMappingRulesRequest_RulesFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The filename of the rules that needs to be converted. The
	// filename is used mainly so that future logs of the import rules job
	// contain it, and can therefore be searched by it.
	RulesSourceFilename string `protobuf:"bytes,1,opt,name=rules_source_filename,json=rulesSourceFilename,proto3" json:"rules_source_filename,omitempty"`
	// Required. The text content of the rules that needs to be converted.
	RulesContent string `protobuf:"bytes,2,opt,name=rules_content,json=rulesContent,proto3" json:"rules_content,omitempty"`
}

func (x *ImportMappingRulesRequest_RulesFile) Reset() {
	*x = ImportMappingRulesRequest_RulesFile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportMappingRulesRequest_RulesFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportMappingRulesRequest_RulesFile) ProtoMessage() {}

func (x *ImportMappingRulesRequest_RulesFile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportMappingRulesRequest_RulesFile.ProtoReflect.Descriptor instead.
func (*ImportMappingRulesRequest_RulesFile) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{44, 0}
}

func (x *ImportMappingRulesRequest_RulesFile) GetRulesSourceFilename() string {
	if x != nil {
		return x.RulesSourceFilename
	}
	return ""
}

func (x *ImportMappingRulesRequest_RulesFile) GetRulesContent() string {
	if x != nil {
		return x.RulesContent
	}
	return ""
}

var File_google_cloud_clouddms_v1_clouddms_proto protoreflect.FileDescriptor

var file_google_cloud_clouddms_v1_clouddms_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x6d, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73,
	0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2f, 0x76, 0x31,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73,
	0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d,
	0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd4, 0x01, 0x0a,
	0x18, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2b, 0x12, 0x29, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x42, 0x79, 0x22, 0xb4, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x4d, 0x0a, 0x0e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a,
	0x6f, 0x62, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x52, 0x0d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65,
	0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75,
	0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x5f, 0x0a, 0x16, 0x47, 0x65,
	0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x64, 0x61, 0x74, 0x61,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8b, 0x02, 0x0a, 0x19,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a,
	0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2b, 0x12, 0x29, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x2d, 0x0a, 0x10, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x49, 0x64, 0x12, 0x50, 0x0a, 0x0d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64,
	0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a,
	0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xce, 0x01, 0x0a, 0x19, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x50, 0x0a, 0x0d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x1d, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x97, 0x01, 0x0a, 0x19, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29,
	0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x14,
	0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66,
	0x6f, 0x72, 0x63, 0x65, 0x22, 0x8c, 0x01, 0x0a, 0x18, 0x53, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2e, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x6b, 0x69, 0x70, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x5d, 0x0a, 0x17, 0x53, 0x74, 0x6f, 0x70, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xfa, 0x41,
	0x2b, 0x0a, 0x29, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x5f, 0x0a, 0x19, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xfa,
	0x41, 0x2b, 0x0a, 0x29, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x60, 0x0a, 0x1a, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2e, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xf3, 0x01, 0x0a, 0x19, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2e, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x50, 0x0a, 0x0d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x22, 0x8e, 0x01, 0x0a, 0x1a,
	0x52, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x64,
	0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2c,
	0x0a, 0x0f, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x6b,
	0x69, 0x70, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xe5, 0x02, 0x0a,
	0x18, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x73, 0x68, 0x53, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x0d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2e, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62,
	0x52, 0x0c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x13,
	0x0a, 0x02, 0x76, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x02, 0x76, 0x6d, 0x12, 0x5a, 0x0a, 0x12, 0x76, 0x6d, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x10, 0x76,
	0x6d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x5d, 0x0a, 0x13, 0x76, 0x6d, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x11, 0x76, 0x6d, 0x53,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x17,
	0x0a, 0x07, 0x76, 0x6d, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x06, 0x76, 0x6d, 0x50, 0x6f, 0x72, 0x74, 0x42, 0x0b, 0x0a, 0x09, 0x76, 0x6d, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0x70, 0x0a, 0x10, 0x56, 0x6d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2b, 0x0a, 0x0f, 0x76, 0x6d, 0x5f, 0x6d,
	0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x76, 0x6d, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x76, 0x6d, 0x5f, 0x7a, 0x6f, 0x6e, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x76, 0x6d, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x16,
	0x0a, 0x06, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x22, 0x31, 0x0a, 0x11, 0x56, 0x6d, 0x53, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1c, 0x0a, 0x07, 0x76,
	0x6d, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x06, 0x76, 0x6d, 0x5a, 0x6f, 0x6e, 0x65, 0x22, 0x23, 0x0a, 0x09, 0x53, 0x73, 0x68,
	0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x22, 0xff,
	0x01, 0x0a, 0x1d, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x54, 0x63, 0x70, 0x50, 0x72,
	0x6f, 0x78, 0x79, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x53, 0x0a, 0x0d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f,
	0x62, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x64, 0x61,
	0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x0c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x1c, 0x0a, 0x07, 0x76, 0x6d, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x76, 0x6d, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x0f, 0x76, 0x6d, 0x5f, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0d, 0x76, 0x6d, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1c, 0x0a, 0x07, 0x76, 0x6d, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x76, 0x6d, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x20,
	0x0a, 0x09, 0x76, 0x6d, 0x5f, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x76, 0x6d, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74,
	0x22, 0x28, 0x0a, 0x0e, 0x54, 0x63, 0x70, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x53, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x22, 0xde, 0x01, 0x0a, 0x1d, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x30, 0x12, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xc8, 0x01, 0x0a, 0x1e,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5c,
	0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x69, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x86, 0x03, 0x0a, 0x1e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x12, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x37, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x5f, 0x0a,
	0x12, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f,
	0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x2c, 0x0a, 0x0f,
	0x73, 0x6b, 0x69, 0x70, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x6b, 0x69, 0x70,
	0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xbf, 0x02, 0x0a, 0x1e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12,
	0x5f, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x2c,
	0x0a, 0x0f, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x6b,
	0x69, 0x70, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa1, 0x01, 0x0a,
	0x1e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f,
	0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x22, 0xdc, 0x02, 0x0a, 0x1e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x12, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x37, 0x0a, 0x15, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x5f, 0x0a, 0x12,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x64, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0e, 0x73, 0x6b, 0x69, 0x70, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xde, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x12, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62,
	0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79,
	0x22, 0xc8, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x5c, 0x0a, 0x13, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72,
	0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x90, 0x01, 0x0a, 0x1e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x69,
	0x0a, 0x1b, 0x47, 0x65, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd5, 0x02, 0x0a, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a,
	0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65,
	0x72, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76,
	0x65, 0x72, 0x62, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12,
	0x3a, 0x0a, 0x16, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43,
	0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61,
	0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x22, 0xc7, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x12, 0x30, 0x64,
	0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xd0, 0x01, 0x0a, 0x20,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f,
	0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x62, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x14,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x6d,
	0x0a, 0x1d, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57,
	0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f,
	0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb7, 0x02,
	0x0a, 0x20, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x12, 0x30, 0x64, 0x61, 0x74, 0x61,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x17, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x49,
	0x64, 0x12, 0x65, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57,
	0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xea, 0x01, 0x0a, 0x20, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x65,
	0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x13, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x49, 0x64, 0x22, 0xa5, 0x01, 0x0a, 0x20, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a,
	0x30, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0x96, 0x01, 0x0a,
	0x20, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x24, 0x0a, 0x0b, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x72, 0x0a, 0x22, 0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63,
	0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x32, 0x0a, 0x30, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x90, 0x02, 0x0a, 0x1f, 0x41, 0x70,
	0x70, 0x6c, 0x79, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72,
	0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x32, 0x0a, 0x30, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x1c, 0x0a, 0x07, 0x64, 0x72, 0x79, 0x5f, 0x72, 0x75, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x64, 0x72, 0x79, 0x52, 0x75,
	0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x75, 0x74,
	0x6f, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x12, 0x34, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x64, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x42, 0x0d, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa7, 0x01, 0x0a,
	0x17, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32,
	0x0a, 0x30, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8e, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x4d,
	0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x0d, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64,
	0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c,
	0x65, 0x52, 0x0c, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5d, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x4d, 0x61,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa9, 0x02, 0x0a, 0x1e, 0x53, 0x65, 0x65, 0x64, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x64, 0x61,
	0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x63, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x6f, 0x43,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x12, 0x41, 0x0a, 0x19, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x18, 0x64, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52,
	0x17, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x4b, 0x0a, 0x1e, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x65, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x1c, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x42, 0x0b, 0x0a, 0x09, 0x73, 0x65, 0x65, 0x64, 0x5f, 0x66, 0x72,
	0x6f, 0x6d, 0x22, 0xe2, 0x01, 0x0a, 0x21, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x64, 0x61, 0x74,
	0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x63, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61,
	0x75, 0x74, 0x6f, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x2f, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x74, 0x5f, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x46,
	0x75, 0x6c, 0x6c, 0x50, 0x61, 0x74, 0x68, 0x22, 0xc1, 0x03, 0x0a, 0x19, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x64,
	0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x57, 0x0a, 0x0c, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52,
	0x75, 0x6c, 0x65, 0x73, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x12, 0x63, 0x0a, 0x0b, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75,
	0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x73,
	0x46, 0x69, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x46, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x63, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x61, 0x75, 0x74, 0x6f, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x1a, 0x6e, 0x0a, 0x09, 0x52,
	0x75, 0x6c, 0x65, 0x73, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x37, 0x0a, 0x15, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x28, 0x0a, 0x0d, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0xc3, 0x04, 0x0a, 0x1f,
	0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x6b, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f,
	0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x20, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x5d, 0x0a, 0x04, 0x74, 0x72, 0x65, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x62, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x42, 0x54, 0x72,
	0x65, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x72, 0x65,
	0x65, 0x12, 0x25, 0x0a, 0x0b, 0x75, 0x6e, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x75, 0x6e, 0x63,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x12, 0x20, 0x0a, 0x09, 0x63, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x45, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x56,
	0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0x61,
	0x0a, 0x0a, 0x44, 0x42, 0x54, 0x72, 0x65, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18,
	0x44, 0x42, 0x5f, 0x54, 0x52, 0x45, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x4f,
	0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x52, 0x45, 0x45, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x44,
	0x52, 0x41, 0x46, 0x54, 0x5f, 0x54, 0x52, 0x45, 0x45, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x44,
	0x45, 0x53, 0x54, 0x49, 0x4e, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x52, 0x45, 0x45, 0x10,
	0x03, 0x22, 0xa1, 0x01, 0x0a, 0x20, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x55, 0x0a, 0x11, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x10, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xc7, 0x02, 0x0a, 0x1b, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x42, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6b, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x64, 0x61, 0x74,
	0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x13, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x12, 0x48, 0x0a, 0x1f, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x6d, 0x6f, 0x73,
	0x74, 0x5f, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6a, 0x6f, 0x62,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x1a, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x4d, 0x6f, 0x73, 0x74, 0x52, 0x65, 0x63, 0x65,
	0x6e, 0x74, 0x50, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x08,
	0x6d, 0x61, 0x78, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x07, 0x6d, 0x61, 0x78, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x51, 0x0a, 0x14,
	0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x75, 0x6e, 0x74, 0x69, 0x6c, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x63, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x55, 0x6e, 0x74, 0x69, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x22,
	0x63, 0x0a, 0x1c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x42, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f,
	0x75, 0x6e, 0x64, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x43, 0x0a, 0x04, 0x6a, 0x6f, 0x62, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f,
	0x75, 0x6e, 0x64, 0x4a, 0x6f, 0x62, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04,
	0x6a, 0x6f, 0x62, 0x73, 0x22, 0xbc, 0x01, 0x0a, 0x2b, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62,
	0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x6b, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x64, 0x61, 0x74, 0x61,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x13, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x12, 0x20, 0x0a, 0x09, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x49, 0x64, 0x22, 0x7b, 0x0a, 0x2c, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x09, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x09, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0xff, 0x01, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x0f, 0x6d, 0x61, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75,
	0x6c, 0x65, 0x49, 0x64, 0x12, 0x4d, 0x0a, 0x0c, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f,
	0x72, 0x75, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64,
	0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52,
	0x75, 0x6c, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x22, 0x84, 0x01, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x61, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x92, 0x01, 0x0a, 0x15, 0x46, 0x65,
	0x74, 0x63, 0x68, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x49, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5f,
	0x0a, 0x16, 0x46, 0x65, 0x74, 0x63, 0x68, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x49, 0x70, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x63, 0x5f, 0x69, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x63, 0x49, 0x70, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x2a,
	0xa0, 0x01, 0x0a, 0x12, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x56, 0x69, 0x65, 0x77, 0x12, 0x24, 0x0a, 0x20, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41,
	0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1e, 0x0a, 0x1a,
	0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f,
	0x56, 0x49, 0x45, 0x57, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19,
	0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f,
	0x56, 0x49, 0x45, 0x57, 0x5f, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x02, 0x12, 0x25, 0x0a, 0x21, 0x44,
	0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x56,
	0x49, 0x45, 0x57, 0x5f, 0x52, 0x4f, 0x4f, 0x54, 0x5f, 0x53, 0x55, 0x4d, 0x4d, 0x41, 0x52, 0x59,
	0x10, 0x03, 0x32, 0x8f, 0x4b, 0x0a, 0x14, 0x44, 0x61, 0x74, 0x61, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xc0, 0x01, 0x0a, 0x11,
	0x4c, 0x69, 0x73, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62,
	0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0xad,
	0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a,
	0x6f, 0x62, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x22, 0x40, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xff,
	0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x94, 0x01, 0xca, 0x41, 0x21, 0x0a,
	0x0c, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x25, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x2c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x3a, 0x0d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x22, 0x31, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73,
	0x12, 0x81, 0x02, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x96, 0x01, 0xca, 0x41,
	0x21, 0x0a, 0x0c, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x19, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a,
	0x6f, 0x62, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x50, 0x3a, 0x0d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6a, 0x6f, 0x62, 0x32, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd7, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x6d, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x2a, 0x31, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xce,
	0x01, 0x0a, 0x11, 0x53, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x66, 0xca, 0x41, 0x21, 0x0a, 0x0c, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3c, 0x3a, 0x01, 0x2a, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12,
	0xcb, 0x01, 0x0a, 0x10, 0x53, 0x74, 0x6f, 0x70, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x74, 0x6f, 0x70, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x65, 0xca, 0x41, 0x21, 0x0a, 0x0c, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3b, 0x3a, 0x01, 0x2a, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x6f, 0x70, 0x12, 0xd1, 0x01,
	0x0a, 0x12, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a,
	0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x67, 0xca, 0x41, 0x21, 0x0a, 0x0c, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x01, 0x2a, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x73, 0x75, 0x6d,
	0x65, 0x12, 0xd4, 0x01, 0x0a, 0x13, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x68,
	0xca, 0x41, 0x21, 0x0a, 0x0c, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x3a, 0x01, 0x2a, 0x22, 0x39, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x12, 0xd1, 0x01, 0x0a, 0x12, 0x56, 0x65, 0x72,
	0x69, 0x66, 0x79, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x69, 0x66,
	0x79, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x67, 0xca, 0x41, 0x21, 0x0a, 0x0c, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a,
	0x01, 0x2a, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x12, 0xd4, 0x01, 0x0a,
	0x13, 0x52, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x68, 0xca, 0x41, 0x21, 0x0a, 0x0c,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x3a, 0x01, 0x2a, 0x22, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x12, 0xc5, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x53, 0x73, 0x68, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x73, 0x68,
	0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x73, 0x68, 0x53, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x22, 0x57, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51, 0x3a, 0x01, 0x2a, 0x22, 0x4c, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f,
	0x62, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x53, 0x73, 0x68, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0xd9, 0x01, 0x0a, 0x16,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x54, 0x63, 0x70, 0x50, 0x72, 0x6f, 0x78, 0x79,
	0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x54, 0x63, 0x70, 0x50, 0x72, 0x6f,
	0x78, 0x79, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x63, 0x70, 0x50, 0x72,
	0x6f, 0x78, 0x79, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x22, 0x5c, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x56, 0x3a, 0x01, 0x2a, 0x22, 0x51, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x54, 0x63, 0x70, 0x50, 0x72, 0x6f, 0x78,
	0x79, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0xd4, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x47, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0xc1,
	0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x22, 0x45, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xa2, 0x02, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xad, 0x01, 0xca, 0x41, 0x26, 0x0a, 0x11, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x2f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2c,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4c, 0x3a, 0x12, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x22,
	0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0xa4, 0x02, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xaf, 0x01, 0xca,
	0x41, 0x26, 0x0a, 0x11, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1e, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5f, 0x3a,
	0x12, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x32, 0x49, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe6,
	0x01, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64,
	0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x72, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x2a,
	0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa2, 0x02, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xad, 0x01, 0xca,
	0x41, 0x26, 0x0a, 0x11, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x2f, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4c,
	0x3a, 0x12, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xc1, 0x01, 0x0a,
	0x14, 0x47, 0x65, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x45, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xd4, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x47,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12,
	0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xe6, 0x01, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x72, 0xca, 0x41,
	0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x2a, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xc9, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x22, 0x47, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3a, 0x12, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57,
	0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xdc, 0x01, 0x0a,
	0x18, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57,
	0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f,
	0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x49, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3a, 0x12, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x12, 0xb0, 0x02, 0x0a, 0x19,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb7, 0x01, 0xca, 0x41, 0x28, 0x0a, 0x13, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x33, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x2c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x3a, 0x14,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x12, 0xb2,
	0x02, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb9, 0x01, 0xca, 0x41, 0x28, 0x0a, 0x13, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x20, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x2c, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x65, 0x3a, 0x14,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x32, 0x4d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xec, 0x01, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72,
	0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x74, 0xca, 0x41,
	0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x2a, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xf4, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52,
	0x75, 0x6c, 0x65, 0x22, 0x83, 0x01, 0xda, 0x41, 0x23, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x2c, 0x6d, 0x61, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x57, 0x3a, 0x0c, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x75, 0x6c, 0x65,
	0x22, 0x47, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57,
	0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x61, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0xb7, 0x01, 0x0a, 0x11, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x12,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x56, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x2a, 0x47, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xd3, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x61, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52,
	0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x61, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x58, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49,
	0x12, 0x47, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57,
	0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x61, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0xc0, 0x01, 0x0a, 0x0e, 0x47, 0x65,
	0x74, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x61, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x52, 0x75, 0x6c, 0x65, 0x22, 0x56, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x49, 0x12, 0x47, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x61, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe7, 0x01, 0x0a,
	0x17, 0x53, 0x65, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57,
	0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x73, 0xca, 0x41, 0x28, 0x0a, 0x13, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x42, 0x3a, 0x01, 0x2a, 0x22, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x73, 0x65, 0x65, 0x64, 0x12, 0xef, 0x01, 0x0a, 0x12, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4d,
	0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x84, 0x01, 0xca, 0x41, 0x28, 0x0a, 0x13, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x53, 0x3a, 0x01, 0x2a, 0x22, 0x4e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65,
	0x73, 0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x12, 0xf0, 0x01, 0x0a, 0x1a, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f,
	0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x76, 0xca, 0x41, 0x28, 0x0a, 0x13, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x3a, 0x01, 0x2a, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x12, 0xed, 0x01, 0x0a, 0x19,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x75, 0xca, 0x41, 0x28, 0x0a, 0x13, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x3a, 0x01, 0x2a, 0x22, 0x3f, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x12, 0xf3, 0x01, 0x0a, 0x1b,
	0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x77, 0xca, 0x41, 0x28, 0x0a, 0x13, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x3a, 0x01, 0x2a, 0x22, 0x41,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63,
	0x6b, 0x12, 0xea, 0x01, 0x0a, 0x18, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x74, 0xca, 0x41, 0x28, 0x0a, 0x13, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x3a, 0x01, 0x2a, 0x22, 0x3e,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x12, 0xfc,
	0x01, 0x0a, 0x18, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x69, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x63, 0x12, 0x61, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0xec, 0x01,
	0x0a, 0x14, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x42, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75,
	0x6e, 0x64, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x42, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75,
	0x6e, 0x64, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x42,
	0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5f, 0x12, 0x5d, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x42, 0x61,
	0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0xac, 0x02, 0x0a,
	0x24, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x46, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x75, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6f, 0x12, 0x6d, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xb4, 0x01, 0x0a, 0x0e,
	0x46, 0x65, 0x74, 0x63, 0x68, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x49, 0x70, 0x73, 0x12, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x53,
	0x74, 0x61, 0x74, 0x69, 0x63, 0x49, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68,
	0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x49, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x3f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32,
	0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x65, 0x74, 0x63, 0x68, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x49,
	0x70, 0x73, 0x1a, 0x50, 0xca, 0x41, 0x1c, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x42, 0xbd, 0x01, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64,
	0x6d, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x0d, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x6d, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x6d, 0x73, 0x70, 0x62, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x70, 0x62,
	0xaa, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x6d, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x18, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x44, 0x6d, 0x73, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x4d, 0x53,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_clouddms_v1_clouddms_proto_rawDescOnce sync.Once
	file_google_cloud_clouddms_v1_clouddms_proto_rawDescData = file_google_cloud_clouddms_v1_clouddms_proto_rawDesc
)

func file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP() []byte {
	file_google_cloud_clouddms_v1_clouddms_proto_rawDescOnce.Do(func() {
		file_google_cloud_clouddms_v1_clouddms_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_clouddms_v1_clouddms_proto_rawDescData)
	})
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescData
}

var file_google_cloud_clouddms_v1_clouddms_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_clouddms_v1_clouddms_proto_msgTypes = make([]protoimpl.MessageInfo, 56)
var file_google_cloud_clouddms_v1_clouddms_proto_goTypes = []interface{}{
	(DatabaseEntityView)(0),                              // 0: google.cloud.clouddms.v1.DatabaseEntityView
	(DescribeDatabaseEntitiesRequest_DBTreeType)(0),      // 1: google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.DBTreeType
	(*ListMigrationJobsRequest)(nil),                     // 2: google.cloud.clouddms.v1.ListMigrationJobsRequest
	(*ListMigrationJobsResponse)(nil),                    // 3: google.cloud.clouddms.v1.ListMigrationJobsResponse
	(*GetMigrationJobRequest)(nil),                       // 4: google.cloud.clouddms.v1.GetMigrationJobRequest
	(*CreateMigrationJobRequest)(nil),                    // 5: google.cloud.clouddms.v1.CreateMigrationJobRequest
	(*UpdateMigrationJobRequest)(nil),                    // 6: google.cloud.clouddms.v1.UpdateMigrationJobRequest
	(*DeleteMigrationJobRequest)(nil),                    // 7: google.cloud.clouddms.v1.DeleteMigrationJobRequest
	(*StartMigrationJobRequest)(nil),                     // 8: google.cloud.clouddms.v1.StartMigrationJobRequest
	(*StopMigrationJobRequest)(nil),                      // 9: google.cloud.clouddms.v1.StopMigrationJobRequest
	(*ResumeMigrationJobRequest)(nil),                    // 10: google.cloud.clouddms.v1.ResumeMigrationJobRequest
	(*PromoteMigrationJobRequest)(nil),                   // 11: google.cloud.clouddms.v1.PromoteMigrationJobRequest
	(*VerifyMigrationJobRequest)(nil),                    // 12: google.cloud.clouddms.v1.VerifyMigrationJobRequest
	(*RestartMigrationJobRequest)(nil),                   // 13: google.cloud.clouddms.v1.RestartMigrationJobRequest
	(*GenerateSshScriptRequest)(nil),                     // 14: google.cloud.clouddms.v1.GenerateSshScriptRequest
	(*VmCreationConfig)(nil),                             // 15: google.cloud.clouddms.v1.VmCreationConfig
	(*VmSelectionConfig)(nil),                            // 16: google.cloud.clouddms.v1.VmSelectionConfig
	(*SshScript)(nil),                                    // 17: google.cloud.clouddms.v1.SshScript
	(*GenerateTcpProxyScriptRequest)(nil),                // 18: google.cloud.clouddms.v1.GenerateTcpProxyScriptRequest
	(*TcpProxyScript)(nil),                               // 19: google.cloud.clouddms.v1.TcpProxyScript
	(*ListConnectionProfilesRequest)(nil),                // 20: google.cloud.clouddms.v1.ListConnectionProfilesRequest
	(*ListConnectionProfilesResponse)(nil),               // 21: google.cloud.clouddms.v1.ListConnectionProfilesResponse
	(*GetConnectionProfileRequest)(nil),                  // 22: google.cloud.clouddms.v1.GetConnectionProfileRequest
	(*CreateConnectionProfileRequest)(nil),               // 23: google.cloud.clouddms.v1.CreateConnectionProfileRequest
	(*UpdateConnectionProfileRequest)(nil),               // 24: google.cloud.clouddms.v1.UpdateConnectionProfileRequest
	(*DeleteConnectionProfileRequest)(nil),               // 25: google.cloud.clouddms.v1.DeleteConnectionProfileRequest
	(*CreatePrivateConnectionRequest)(nil),               // 26: google.cloud.clouddms.v1.CreatePrivateConnectionRequest
	(*ListPrivateConnectionsRequest)(nil),                // 27: google.cloud.clouddms.v1.ListPrivateConnectionsRequest
	(*ListPrivateConnectionsResponse)(nil),               // 28: google.cloud.clouddms.v1.ListPrivateConnectionsResponse
	(*DeletePrivateConnectionRequest)(nil),               // 29: google.cloud.clouddms.v1.DeletePrivateConnectionRequest
	(*GetPrivateConnectionRequest)(nil),                  // 30: google.cloud.clouddms.v1.GetPrivateConnectionRequest
	(*OperationMetadata)(nil),                            // 31: google.cloud.clouddms.v1.OperationMetadata
	(*ListConversionWorkspacesRequest)(nil),              // 32: google.cloud.clouddms.v1.ListConversionWorkspacesRequest
	(*ListConversionWorkspacesResponse)(nil),             // 33: google.cloud.clouddms.v1.ListConversionWorkspacesResponse
	(*GetConversionWorkspaceRequest)(nil),                // 34: google.cloud.clouddms.v1.GetConversionWorkspaceRequest
	(*CreateConversionWorkspaceRequest)(nil),             // 35: google.cloud.clouddms.v1.CreateConversionWorkspaceRequest
	(*UpdateConversionWorkspaceRequest)(nil),             // 36: google.cloud.clouddms.v1.UpdateConversionWorkspaceRequest
	(*DeleteConversionWorkspaceRequest)(nil),             // 37: google.cloud.clouddms.v1.DeleteConversionWorkspaceRequest
	(*CommitConversionWorkspaceRequest)(nil),             // 38: google.cloud.clouddms.v1.CommitConversionWorkspaceRequest
	(*RollbackConversionWorkspaceRequest)(nil),           // 39: google.cloud.clouddms.v1.RollbackConversionWorkspaceRequest
	(*ApplyConversionWorkspaceRequest)(nil),              // 40: google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest
	(*ListMappingRulesRequest)(nil),                      // 41: google.cloud.clouddms.v1.ListMappingRulesRequest
	(*ListMappingRulesResponse)(nil),                     // 42: google.cloud.clouddms.v1.ListMappingRulesResponse
	(*GetMappingRuleRequest)(nil),                        // 43: google.cloud.clouddms.v1.GetMappingRuleRequest
	(*SeedConversionWorkspaceRequest)(nil),               // 44: google.cloud.clouddms.v1.SeedConversionWorkspaceRequest
	(*ConvertConversionWorkspaceRequest)(nil),            // 45: google.cloud.clouddms.v1.ConvertConversionWorkspaceRequest
	(*ImportMappingRulesRequest)(nil),                    // 46: google.cloud.clouddms.v1.ImportMappingRulesRequest
	(*DescribeDatabaseEntitiesRequest)(nil),              // 47: google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest
	(*DescribeDatabaseEntitiesResponse)(nil),             // 48: google.cloud.clouddms.v1.DescribeDatabaseEntitiesResponse
	(*SearchBackgroundJobsRequest)(nil),                  // 49: google.cloud.clouddms.v1.SearchBackgroundJobsRequest
	(*SearchBackgroundJobsResponse)(nil),                 // 50: google.cloud.clouddms.v1.SearchBackgroundJobsResponse
	(*DescribeConversionWorkspaceRevisionsRequest)(nil),  // 51: google.cloud.clouddms.v1.DescribeConversionWorkspaceRevisionsRequest
	(*DescribeConversionWorkspaceRevisionsResponse)(nil), // 52: google.cloud.clouddms.v1.DescribeConversionWorkspaceRevisionsResponse
	(*CreateMappingRuleRequest)(nil),                     // 53: google.cloud.clouddms.v1.CreateMappingRuleRequest
	(*DeleteMappingRuleRequest)(nil),                     // 54: google.cloud.clouddms.v1.DeleteMappingRuleRequest
	(*FetchStaticIpsRequest)(nil),                        // 55: google.cloud.clouddms.v1.FetchStaticIpsRequest
	(*FetchStaticIpsResponse)(nil),                       // 56: google.cloud.clouddms.v1.FetchStaticIpsResponse
	(*ImportMappingRulesRequest_RulesFile)(nil),          // 57: google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile
	(*MigrationJob)(nil),                                 // 58: google.cloud.clouddms.v1.MigrationJob
	(*fieldmaskpb.FieldMask)(nil),                        // 59: google.protobuf.FieldMask
	(*ConnectionProfile)(nil),                            // 60: google.cloud.clouddms.v1.ConnectionProfile
	(*PrivateConnection)(nil),                            // 61: google.cloud.clouddms.v1.PrivateConnection
	(*timestamppb.Timestamp)(nil),                        // 62: google.protobuf.Timestamp
	(*ConversionWorkspace)(nil),                          // 63: google.cloud.clouddms.v1.ConversionWorkspace
	(*MappingRule)(nil),                                  // 64: google.cloud.clouddms.v1.MappingRule
	(ImportRulesFileFormat)(0),                           // 65: google.cloud.clouddms.v1.ImportRulesFileFormat
	(*DatabaseEntity)(nil),                               // 66: google.cloud.clouddms.v1.DatabaseEntity
	(*BackgroundJobLogEntry)(nil),                        // 67: google.cloud.clouddms.v1.BackgroundJobLogEntry
	(*longrunningpb.Operation)(nil),                      // 68: google.longrunning.Operation
	(*emptypb.Empty)(nil),                                // 69: google.protobuf.Empty
}
var file_google_cloud_clouddms_v1_clouddms_proto_depIdxs = []int32{
	58, // 0: google.cloud.clouddms.v1.ListMigrationJobsResponse.migration_jobs:type_name -> google.cloud.clouddms.v1.MigrationJob
	58, // 1: google.cloud.clouddms.v1.CreateMigrationJobRequest.migration_job:type_name -> google.cloud.clouddms.v1.MigrationJob
	59, // 2: google.cloud.clouddms.v1.UpdateMigrationJobRequest.update_mask:type_name -> google.protobuf.FieldMask
	58, // 3: google.cloud.clouddms.v1.UpdateMigrationJobRequest.migration_job:type_name -> google.cloud.clouddms.v1.MigrationJob
	59, // 4: google.cloud.clouddms.v1.VerifyMigrationJobRequest.update_mask:type_name -> google.protobuf.FieldMask
	58, // 5: google.cloud.clouddms.v1.VerifyMigrationJobRequest.migration_job:type_name -> google.cloud.clouddms.v1.MigrationJob
	15, // 6: google.cloud.clouddms.v1.GenerateSshScriptRequest.vm_creation_config:type_name -> google.cloud.clouddms.v1.VmCreationConfig
	16, // 7: google.cloud.clouddms.v1.GenerateSshScriptRequest.vm_selection_config:type_name -> google.cloud.clouddms.v1.VmSelectionConfig
	60, // 8: google.cloud.clouddms.v1.ListConnectionProfilesResponse.connection_profiles:type_name -> google.cloud.clouddms.v1.ConnectionProfile
	60, // 9: google.cloud.clouddms.v1.CreateConnectionProfileRequest.connection_profile:type_name -> google.cloud.clouddms.v1.ConnectionProfile
	59, // 10: google.cloud.clouddms.v1.UpdateConnectionProfileRequest.update_mask:type_name -> google.protobuf.FieldMask
	60, // 11: google.cloud.clouddms.v1.UpdateConnectionProfileRequest.connection_profile:type_name -> google.cloud.clouddms.v1.ConnectionProfile
	61, // 12: google.cloud.clouddms.v1.CreatePrivateConnectionRequest.private_connection:type_name -> google.cloud.clouddms.v1.PrivateConnection
	61, // 13: google.cloud.clouddms.v1.ListPrivateConnectionsResponse.private_connections:type_name -> google.cloud.clouddms.v1.PrivateConnection
	62, // 14: google.cloud.clouddms.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	62, // 15: google.cloud.clouddms.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	63, // 16: google.cloud.clouddms.v1.ListConversionWorkspacesResponse.conversion_workspaces:type_name -> google.cloud.clouddms.v1.ConversionWorkspace
	63, // 17: google.cloud.clouddms.v1.CreateConversionWorkspaceRequest.conversion_workspace:type_name -> google.cloud.clouddms.v1.ConversionWorkspace
	59, // 18: google.cloud.clouddms.v1.UpdateConversionWorkspaceRequest.update_mask:type_name -> google.protobuf.FieldMask
	63, // 19: google.cloud.clouddms.v1.UpdateConversionWorkspaceRequest.conversion_workspace:type_name -> google.cloud.clouddms.v1.ConversionWorkspace
	64, // 20: google.cloud.clouddms.v1.ListMappingRulesResponse.mapping_rules:type_name -> google.cloud.clouddms.v1.MappingRule
	65, // 21: google.cloud.clouddms.v1.ImportMappingRulesRequest.rules_format:type_name -> google.cloud.clouddms.v1.ImportRulesFileFormat
	57, // 22: google.cloud.clouddms.v1.ImportMappingRulesRequest.rules_files:type_name -> google.cloud.clouddms.v1.ImportMappingRulesRequest.RulesFile
	1,  // 23: google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.tree:type_name -> google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.DBTreeType
	0,  // 24: google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest.view:type_name -> google.cloud.clouddms.v1.DatabaseEntityView
	66, // 25: google.cloud.clouddms.v1.DescribeDatabaseEntitiesResponse.database_entities:type_name -> google.cloud.clouddms.v1.DatabaseEntity
	62, // 26: google.cloud.clouddms.v1.SearchBackgroundJobsRequest.completed_until_time:type_name -> google.protobuf.Timestamp
	67, // 27: google.cloud.clouddms.v1.SearchBackgroundJobsResponse.jobs:type_name -> google.cloud.clouddms.v1.BackgroundJobLogEntry
	63, // 28: google.cloud.clouddms.v1.DescribeConversionWorkspaceRevisionsResponse.revisions:type_name -> google.cloud.clouddms.v1.ConversionWorkspace
	64, // 29: google.cloud.clouddms.v1.CreateMappingRuleRequest.mapping_rule:type_name -> google.cloud.clouddms.v1.MappingRule
	2,  // 30: google.cloud.clouddms.v1.DataMigrationService.ListMigrationJobs:input_type -> google.cloud.clouddms.v1.ListMigrationJobsRequest
	4,  // 31: google.cloud.clouddms.v1.DataMigrationService.GetMigrationJob:input_type -> google.cloud.clouddms.v1.GetMigrationJobRequest
	5,  // 32: google.cloud.clouddms.v1.DataMigrationService.CreateMigrationJob:input_type -> google.cloud.clouddms.v1.CreateMigrationJobRequest
	6,  // 33: google.cloud.clouddms.v1.DataMigrationService.UpdateMigrationJob:input_type -> google.cloud.clouddms.v1.UpdateMigrationJobRequest
	7,  // 34: google.cloud.clouddms.v1.DataMigrationService.DeleteMigrationJob:input_type -> google.cloud.clouddms.v1.DeleteMigrationJobRequest
	8,  // 35: google.cloud.clouddms.v1.DataMigrationService.StartMigrationJob:input_type -> google.cloud.clouddms.v1.StartMigrationJobRequest
	9,  // 36: google.cloud.clouddms.v1.DataMigrationService.StopMigrationJob:input_type -> google.cloud.clouddms.v1.StopMigrationJobRequest
	10, // 37: google.cloud.clouddms.v1.DataMigrationService.ResumeMigrationJob:input_type -> google.cloud.clouddms.v1.ResumeMigrationJobRequest
	11, // 38: google.cloud.clouddms.v1.DataMigrationService.PromoteMigrationJob:input_type -> google.cloud.clouddms.v1.PromoteMigrationJobRequest
	12, // 39: google.cloud.clouddms.v1.DataMigrationService.VerifyMigrationJob:input_type -> google.cloud.clouddms.v1.VerifyMigrationJobRequest
	13, // 40: google.cloud.clouddms.v1.DataMigrationService.RestartMigrationJob:input_type -> google.cloud.clouddms.v1.RestartMigrationJobRequest
	14, // 41: google.cloud.clouddms.v1.DataMigrationService.GenerateSshScript:input_type -> google.cloud.clouddms.v1.GenerateSshScriptRequest
	18, // 42: google.cloud.clouddms.v1.DataMigrationService.GenerateTcpProxyScript:input_type -> google.cloud.clouddms.v1.GenerateTcpProxyScriptRequest
	20, // 43: google.cloud.clouddms.v1.DataMigrationService.ListConnectionProfiles:input_type -> google.cloud.clouddms.v1.ListConnectionProfilesRequest
	22, // 44: google.cloud.clouddms.v1.DataMigrationService.GetConnectionProfile:input_type -> google.cloud.clouddms.v1.GetConnectionProfileRequest
	23, // 45: google.cloud.clouddms.v1.DataMigrationService.CreateConnectionProfile:input_type -> google.cloud.clouddms.v1.CreateConnectionProfileRequest
	24, // 46: google.cloud.clouddms.v1.DataMigrationService.UpdateConnectionProfile:input_type -> google.cloud.clouddms.v1.UpdateConnectionProfileRequest
	25, // 47: google.cloud.clouddms.v1.DataMigrationService.DeleteConnectionProfile:input_type -> google.cloud.clouddms.v1.DeleteConnectionProfileRequest
	26, // 48: google.cloud.clouddms.v1.DataMigrationService.CreatePrivateConnection:input_type -> google.cloud.clouddms.v1.CreatePrivateConnectionRequest
	30, // 49: google.cloud.clouddms.v1.DataMigrationService.GetPrivateConnection:input_type -> google.cloud.clouddms.v1.GetPrivateConnectionRequest
	27, // 50: google.cloud.clouddms.v1.DataMigrationService.ListPrivateConnections:input_type -> google.cloud.clouddms.v1.ListPrivateConnectionsRequest
	29, // 51: google.cloud.clouddms.v1.DataMigrationService.DeletePrivateConnection:input_type -> google.cloud.clouddms.v1.DeletePrivateConnectionRequest
	34, // 52: google.cloud.clouddms.v1.DataMigrationService.GetConversionWorkspace:input_type -> google.cloud.clouddms.v1.GetConversionWorkspaceRequest
	32, // 53: google.cloud.clouddms.v1.DataMigrationService.ListConversionWorkspaces:input_type -> google.cloud.clouddms.v1.ListConversionWorkspacesRequest
	35, // 54: google.cloud.clouddms.v1.DataMigrationService.CreateConversionWorkspace:input_type -> google.cloud.clouddms.v1.CreateConversionWorkspaceRequest
	36, // 55: google.cloud.clouddms.v1.DataMigrationService.UpdateConversionWorkspace:input_type -> google.cloud.clouddms.v1.UpdateConversionWorkspaceRequest
	37, // 56: google.cloud.clouddms.v1.DataMigrationService.DeleteConversionWorkspace:input_type -> google.cloud.clouddms.v1.DeleteConversionWorkspaceRequest
	53, // 57: google.cloud.clouddms.v1.DataMigrationService.CreateMappingRule:input_type -> google.cloud.clouddms.v1.CreateMappingRuleRequest
	54, // 58: google.cloud.clouddms.v1.DataMigrationService.DeleteMappingRule:input_type -> google.cloud.clouddms.v1.DeleteMappingRuleRequest
	41, // 59: google.cloud.clouddms.v1.DataMigrationService.ListMappingRules:input_type -> google.cloud.clouddms.v1.ListMappingRulesRequest
	43, // 60: google.cloud.clouddms.v1.DataMigrationService.GetMappingRule:input_type -> google.cloud.clouddms.v1.GetMappingRuleRequest
	44, // 61: google.cloud.clouddms.v1.DataMigrationService.SeedConversionWorkspace:input_type -> google.cloud.clouddms.v1.SeedConversionWorkspaceRequest
	46, // 62: google.cloud.clouddms.v1.DataMigrationService.ImportMappingRules:input_type -> google.cloud.clouddms.v1.ImportMappingRulesRequest
	45, // 63: google.cloud.clouddms.v1.DataMigrationService.ConvertConversionWorkspace:input_type -> google.cloud.clouddms.v1.ConvertConversionWorkspaceRequest
	38, // 64: google.cloud.clouddms.v1.DataMigrationService.CommitConversionWorkspace:input_type -> google.cloud.clouddms.v1.CommitConversionWorkspaceRequest
	39, // 65: google.cloud.clouddms.v1.DataMigrationService.RollbackConversionWorkspace:input_type -> google.cloud.clouddms.v1.RollbackConversionWorkspaceRequest
	40, // 66: google.cloud.clouddms.v1.DataMigrationService.ApplyConversionWorkspace:input_type -> google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest
	47, // 67: google.cloud.clouddms.v1.DataMigrationService.DescribeDatabaseEntities:input_type -> google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest
	49, // 68: google.cloud.clouddms.v1.DataMigrationService.SearchBackgroundJobs:input_type -> google.cloud.clouddms.v1.SearchBackgroundJobsRequest
	51, // 69: google.cloud.clouddms.v1.DataMigrationService.DescribeConversionWorkspaceRevisions:input_type -> google.cloud.clouddms.v1.DescribeConversionWorkspaceRevisionsRequest
	55, // 70: google.cloud.clouddms.v1.DataMigrationService.FetchStaticIps:input_type -> google.cloud.clouddms.v1.FetchStaticIpsRequest
	3,  // 71: google.cloud.clouddms.v1.DataMigrationService.ListMigrationJobs:output_type -> google.cloud.clouddms.v1.ListMigrationJobsResponse
	58, // 72: google.cloud.clouddms.v1.DataMigrationService.GetMigrationJob:output_type -> google.cloud.clouddms.v1.MigrationJob
	68, // 73: google.cloud.clouddms.v1.DataMigrationService.CreateMigrationJob:output_type -> google.longrunning.Operation
	68, // 74: google.cloud.clouddms.v1.DataMigrationService.UpdateMigrationJob:output_type -> google.longrunning.Operation
	68, // 75: google.cloud.clouddms.v1.DataMigrationService.DeleteMigrationJob:output_type -> google.longrunning.Operation
	68, // 76: google.cloud.clouddms.v1.DataMigrationService.StartMigrationJob:output_type -> google.longrunning.Operation
	68, // 77: google.cloud.clouddms.v1.DataMigrationService.StopMigrationJob:output_type -> google.longrunning.Operation
	68, // 78: google.cloud.clouddms.v1.DataMigrationService.ResumeMigrationJob:output_type -> google.longrunning.Operation
	68, // 79: google.cloud.clouddms.v1.DataMigrationService.PromoteMigrationJob:output_type -> google.longrunning.Operation
	68, // 80: google.cloud.clouddms.v1.DataMigrationService.VerifyMigrationJob:output_type -> google.longrunning.Operation
	68, // 81: google.cloud.clouddms.v1.DataMigrationService.RestartMigrationJob:output_type -> google.longrunning.Operation
	17, // 82: google.cloud.clouddms.v1.DataMigrationService.GenerateSshScript:output_type -> google.cloud.clouddms.v1.SshScript
	19, // 83: google.cloud.clouddms.v1.DataMigrationService.GenerateTcpProxyScript:output_type -> google.cloud.clouddms.v1.TcpProxyScript
	21, // 84: google.cloud.clouddms.v1.DataMigrationService.ListConnectionProfiles:output_type -> google.cloud.clouddms.v1.ListConnectionProfilesResponse
	60, // 85: google.cloud.clouddms.v1.DataMigrationService.GetConnectionProfile:output_type -> google.cloud.clouddms.v1.ConnectionProfile
	68, // 86: google.cloud.clouddms.v1.DataMigrationService.CreateConnectionProfile:output_type -> google.longrunning.Operation
	68, // 87: google.cloud.clouddms.v1.DataMigrationService.UpdateConnectionProfile:output_type -> google.longrunning.Operation
	68, // 88: google.cloud.clouddms.v1.DataMigrationService.DeleteConnectionProfile:output_type -> google.longrunning.Operation
	68, // 89: google.cloud.clouddms.v1.DataMigrationService.CreatePrivateConnection:output_type -> google.longrunning.Operation
	61, // 90: google.cloud.clouddms.v1.DataMigrationService.GetPrivateConnection:output_type -> google.cloud.clouddms.v1.PrivateConnection
	28, // 91: google.cloud.clouddms.v1.DataMigrationService.ListPrivateConnections:output_type -> google.cloud.clouddms.v1.ListPrivateConnectionsResponse
	68, // 92: google.cloud.clouddms.v1.DataMigrationService.DeletePrivateConnection:output_type -> google.longrunning.Operation
	63, // 93: google.cloud.clouddms.v1.DataMigrationService.GetConversionWorkspace:output_type -> google.cloud.clouddms.v1.ConversionWorkspace
	33, // 94: google.cloud.clouddms.v1.DataMigrationService.ListConversionWorkspaces:output_type -> google.cloud.clouddms.v1.ListConversionWorkspacesResponse
	68, // 95: google.cloud.clouddms.v1.DataMigrationService.CreateConversionWorkspace:output_type -> google.longrunning.Operation
	68, // 96: google.cloud.clouddms.v1.DataMigrationService.UpdateConversionWorkspace:output_type -> google.longrunning.Operation
	68, // 97: google.cloud.clouddms.v1.DataMigrationService.DeleteConversionWorkspace:output_type -> google.longrunning.Operation
	64, // 98: google.cloud.clouddms.v1.DataMigrationService.CreateMappingRule:output_type -> google.cloud.clouddms.v1.MappingRule
	69, // 99: google.cloud.clouddms.v1.DataMigrationService.DeleteMappingRule:output_type -> google.protobuf.Empty
	42, // 100: google.cloud.clouddms.v1.DataMigrationService.ListMappingRules:output_type -> google.cloud.clouddms.v1.ListMappingRulesResponse
	64, // 101: google.cloud.clouddms.v1.DataMigrationService.GetMappingRule:output_type -> google.cloud.clouddms.v1.MappingRule
	68, // 102: google.cloud.clouddms.v1.DataMigrationService.SeedConversionWorkspace:output_type -> google.longrunning.Operation
	68, // 103: google.cloud.clouddms.v1.DataMigrationService.ImportMappingRules:output_type -> google.longrunning.Operation
	68, // 104: google.cloud.clouddms.v1.DataMigrationService.ConvertConversionWorkspace:output_type -> google.longrunning.Operation
	68, // 105: google.cloud.clouddms.v1.DataMigrationService.CommitConversionWorkspace:output_type -> google.longrunning.Operation
	68, // 106: google.cloud.clouddms.v1.DataMigrationService.RollbackConversionWorkspace:output_type -> google.longrunning.Operation
	68, // 107: google.cloud.clouddms.v1.DataMigrationService.ApplyConversionWorkspace:output_type -> google.longrunning.Operation
	48, // 108: google.cloud.clouddms.v1.DataMigrationService.DescribeDatabaseEntities:output_type -> google.cloud.clouddms.v1.DescribeDatabaseEntitiesResponse
	50, // 109: google.cloud.clouddms.v1.DataMigrationService.SearchBackgroundJobs:output_type -> google.cloud.clouddms.v1.SearchBackgroundJobsResponse
	52, // 110: google.cloud.clouddms.v1.DataMigrationService.DescribeConversionWorkspaceRevisions:output_type -> google.cloud.clouddms.v1.DescribeConversionWorkspaceRevisionsResponse
	56, // 111: google.cloud.clouddms.v1.DataMigrationService.FetchStaticIps:output_type -> google.cloud.clouddms.v1.FetchStaticIpsResponse
	71, // [71:112] is the sub-list for method output_type
	30, // [30:71] is the sub-list for method input_type
	30, // [30:30] is the sub-list for extension type_name
	30, // [30:30] is the sub-list for extension extendee
	0,  // [0:30] is the sub-list for field type_name
}

func init() { file_google_cloud_clouddms_v1_clouddms_proto_init() }
func file_google_cloud_clouddms_v1_clouddms_proto_init() {
	if File_google_cloud_clouddms_v1_clouddms_proto != nil {
		return
	}
	file_google_cloud_clouddms_v1_clouddms_resources_proto_init()
	file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMigrationJobsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMigrationJobsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMigrationJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateMigrationJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateMigrationJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteMigrationJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartMigrationJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StopMigrationJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResumeMigrationJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PromoteMigrationJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VerifyMigrationJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RestartMigrationJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateSshScriptRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VmCreationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VmSelectionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SshScript); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateTcpProxyScriptRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TcpProxyScript); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConnectionProfilesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConnectionProfilesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConnectionProfileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateConnectionProfileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateConnectionProfileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteConnectionProfileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreatePrivateConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPrivateConnectionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPrivateConnectionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeletePrivateConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPrivateConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConversionWorkspacesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConversionWorkspacesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConversionWorkspaceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateConversionWorkspaceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateConversionWorkspaceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteConversionWorkspaceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitConversionWorkspaceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RollbackConversionWorkspaceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplyConversionWorkspaceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMappingRulesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMappingRulesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMappingRuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SeedConversionWorkspaceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConvertConversionWorkspaceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportMappingRulesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DescribeDatabaseEntitiesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DescribeDatabaseEntitiesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchBackgroundJobsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchBackgroundJobsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DescribeConversionWorkspaceRevisionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DescribeConversionWorkspaceRevisionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateMappingRuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteMappingRuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchStaticIpsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchStaticIpsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportMappingRulesRequest_RulesFile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*GenerateSshScriptRequest_VmCreationConfig)(nil),
		(*GenerateSshScriptRequest_VmSelectionConfig)(nil),
	}
	file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[38].OneofWrappers = []interface{}{
		(*ApplyConversionWorkspaceRequest_ConnectionProfile)(nil),
	}
	file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[42].OneofWrappers = []interface{}{
		(*SeedConversionWorkspaceRequest_SourceConnectionProfile)(nil),
		(*SeedConversionWorkspaceRequest_DestinationConnectionProfile)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_clouddms_v1_clouddms_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   56,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_clouddms_v1_clouddms_proto_goTypes,
		DependencyIndexes: file_google_cloud_clouddms_v1_clouddms_proto_depIdxs,
		EnumInfos:         file_google_cloud_clouddms_v1_clouddms_proto_enumTypes,
		MessageInfos:      file_google_cloud_clouddms_v1_clouddms_proto_msgTypes,
	}.Build()
	File_google_cloud_clouddms_v1_clouddms_proto = out.File
	file_google_cloud_clouddms_v1_clouddms_proto_rawDesc = nil
	file_google_cloud_clouddms_v1_clouddms_proto_goTypes = nil
	file_google_cloud_clouddms_v1_clouddms_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DataMigrationServiceClient is the client API for DataMigrationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DataMigrationServiceClient interface {
	// Lists migration jobs in a given project and location.
	ListMigrationJobs(ctx context.Context, in *ListMigrationJobsRequest, opts ...grpc.CallOption) (*ListMigrationJobsResponse, error)
	// Gets details of a single migration job.
	GetMigrationJob(ctx context.Context, in *GetMigrationJobRequest, opts ...grpc.CallOption) (*MigrationJob, error)
	// Creates a new migration job in a given project and location.
	CreateMigrationJob(ctx context.Context, in *CreateMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single migration job.
	UpdateMigrationJob(ctx context.Context, in *UpdateMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single migration job.
	DeleteMigrationJob(ctx context.Context, in *DeleteMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Start an already created migration job.
	StartMigrationJob(ctx context.Context, in *StartMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Stops a running migration job.
	StopMigrationJob(ctx context.Context, in *StopMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Resume a migration job that is currently stopped and is resumable (was
	// stopped during CDC phase).
	ResumeMigrationJob(ctx context.Context, in *ResumeMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Promote a migration job, stopping replication to the destination and
	// promoting the destination to be a standalone database.
	PromoteMigrationJob(ctx context.Context, in *PromoteMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Verify a migration job, making sure the destination can reach the source
	// and that all configuration and prerequisites are met.
	VerifyMigrationJob(ctx context.Context, in *VerifyMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Restart a stopped or failed migration job, resetting the destination
	// instance to its original state and starting the migration process from
	// scratch.
	RestartMigrationJob(ctx context.Context, in *RestartMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Generate a SSH configuration script to configure the reverse SSH
	// connectivity.
	GenerateSshScript(ctx context.Context, in *GenerateSshScriptRequest, opts ...grpc.CallOption) (*SshScript, error)
	// Generate a TCP Proxy configuration script to configure a cloud-hosted VM
	// running a TCP Proxy.
	GenerateTcpProxyScript(ctx context.Context, in *GenerateTcpProxyScriptRequest, opts ...grpc.CallOption) (*TcpProxyScript, error)
	// Retrieves a list of all connection profiles in a given project and
	// location.
	ListConnectionProfiles(ctx context.Context, in *ListConnectionProfilesRequest, opts ...grpc.CallOption) (*ListConnectionProfilesResponse, error)
	// Gets details of a single connection profile.
	GetConnectionProfile(ctx context.Context, in *GetConnectionProfileRequest, opts ...grpc.CallOption) (*ConnectionProfile, error)
	// Creates a new connection profile in a given project and location.
	CreateConnectionProfile(ctx context.Context, in *CreateConnectionProfileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Update the configuration of a single connection profile.
	UpdateConnectionProfile(ctx context.Context, in *UpdateConnectionProfileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Database Migration Service connection profile.
	// A connection profile can only be deleted if it is not in use by any
	// active migration jobs.
	DeleteConnectionProfile(ctx context.Context, in *DeleteConnectionProfileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new private connection in a given project and location.
	CreatePrivateConnection(ctx context.Context, in *CreatePrivateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of a single private connection.
	GetPrivateConnection(ctx context.Context, in *GetPrivateConnectionRequest, opts ...grpc.CallOption) (*PrivateConnection, error)
	// Retrieves a list of private connections in a given project and location.
	ListPrivateConnections(ctx context.Context, in *ListPrivateConnectionsRequest, opts ...grpc.CallOption) (*ListPrivateConnectionsResponse, error)
	// Deletes a single Database Migration Service private connection.
	DeletePrivateConnection(ctx context.Context, in *DeletePrivateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of a single conversion workspace.
	GetConversionWorkspace(ctx context.Context, in *GetConversionWorkspaceRequest, opts ...grpc.CallOption) (*ConversionWorkspace, error)
	// Lists conversion workspaces in a given project and location.
	ListConversionWorkspaces(ctx context.Context, in *ListConversionWorkspacesRequest, opts ...grpc.CallOption) (*ListConversionWorkspacesResponse, error)
	// Creates a new conversion workspace in a given project and location.
	CreateConversionWorkspace(ctx context.Context, in *CreateConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single conversion workspace.
	UpdateConversionWorkspace(ctx context.Context, in *UpdateConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single conversion workspace.
	DeleteConversionWorkspace(ctx context.Context, in *DeleteConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new mapping rule for a given conversion workspace.
	CreateMappingRule(ctx context.Context, in *CreateMappingRuleRequest, opts ...grpc.CallOption) (*MappingRule, error)
	// Deletes a single mapping rule.
	DeleteMappingRule(ctx context.Context, in *DeleteMappingRuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists the mapping rules for a specific conversion workspace.
	ListMappingRules(ctx context.Context, in *ListMappingRulesRequest, opts ...grpc.CallOption) (*ListMappingRulesResponse, error)
	// Gets the details of a mapping rule.
	GetMappingRule(ctx context.Context, in *GetMappingRuleRequest, opts ...grpc.CallOption) (*MappingRule, error)
	// Imports a snapshot of the source database into the
	// conversion workspace.
	SeedConversionWorkspace(ctx context.Context, in *SeedConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Imports the mapping rules for a given conversion workspace.
	// Supports various formats of external rules files.
	ImportMappingRules(ctx context.Context, in *ImportMappingRulesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a draft tree schema for the destination database.
	ConvertConversionWorkspace(ctx context.Context, in *ConvertConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Marks all the data in the conversion workspace as committed.
	CommitConversionWorkspace(ctx context.Context, in *CommitConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Rolls back a conversion workspace to the last committed snapshot.
	RollbackConversionWorkspace(ctx context.Context, in *RollbackConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Applies draft tree onto a specific destination database.
	ApplyConversionWorkspace(ctx context.Context, in *ApplyConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Describes the database entities tree for a specific conversion workspace
	// and a specific tree type.
	//
	// Database entities are not resources like conversion workspaces or mapping
	// rules, and they can't be created, updated or deleted. Instead, they are
	// simple data objects describing the structure of the client database.
	DescribeDatabaseEntities(ctx context.Context, in *DescribeDatabaseEntitiesRequest, opts ...grpc.CallOption) (*DescribeDatabaseEntitiesResponse, error)
	// Searches/lists the background jobs for a specific
	// conversion workspace.
	//
	// The background jobs are not resources like conversion workspaces or
	// mapping rules, and they can't be created, updated or deleted.
	// Instead, they are a way to expose the data plane jobs log.
	SearchBackgroundJobs(ctx context.Context, in *SearchBackgroundJobsRequest, opts ...grpc.CallOption) (*SearchBackgroundJobsResponse, error)
	// Retrieves a list of committed revisions of a specific conversion
	// workspace.
	DescribeConversionWorkspaceRevisions(ctx context.Context, in *DescribeConversionWorkspaceRevisionsRequest, opts ...grpc.CallOption) (*DescribeConversionWorkspaceRevisionsResponse, error)
	// Fetches a set of static IP addresses that need to be allowlisted by the
	// customer when using the static-IP connectivity method.
	FetchStaticIps(ctx context.Context, in *FetchStaticIpsRequest, opts ...grpc.CallOption) (*FetchStaticIpsResponse, error)
}

type dataMigrationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDataMigrationServiceClient(cc grpc.ClientConnInterface) DataMigrationServiceClient {
	return &dataMigrationServiceClient{cc}
}

func (c *dataMigrationServiceClient) ListMigrationJobs(ctx context.Context, in *ListMigrationJobsRequest, opts ...grpc.CallOption) (*ListMigrationJobsResponse, error) {
	out := new(ListMigrationJobsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/ListMigrationJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) GetMigrationJob(ctx context.Context, in *GetMigrationJobRequest, opts ...grpc.CallOption) (*MigrationJob, error) {
	out := new(MigrationJob)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/GetMigrationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) CreateMigrationJob(ctx context.Context, in *CreateMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/CreateMigrationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) UpdateMigrationJob(ctx context.Context, in *UpdateMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/UpdateMigrationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) DeleteMigrationJob(ctx context.Context, in *DeleteMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/DeleteMigrationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) StartMigrationJob(ctx context.Context, in *StartMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/StartMigrationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) StopMigrationJob(ctx context.Context, in *StopMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/StopMigrationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) ResumeMigrationJob(ctx context.Context, in *ResumeMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/ResumeMigrationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) PromoteMigrationJob(ctx context.Context, in *PromoteMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/PromoteMigrationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) VerifyMigrationJob(ctx context.Context, in *VerifyMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/VerifyMigrationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) RestartMigrationJob(ctx context.Context, in *RestartMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/RestartMigrationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) GenerateSshScript(ctx context.Context, in *GenerateSshScriptRequest, opts ...grpc.CallOption) (*SshScript, error) {
	out := new(SshScript)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/GenerateSshScript", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) GenerateTcpProxyScript(ctx context.Context, in *GenerateTcpProxyScriptRequest, opts ...grpc.CallOption) (*TcpProxyScript, error) {
	out := new(TcpProxyScript)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/GenerateTcpProxyScript", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) ListConnectionProfiles(ctx context.Context, in *ListConnectionProfilesRequest, opts ...grpc.CallOption) (*ListConnectionProfilesResponse, error) {
	out := new(ListConnectionProfilesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/ListConnectionProfiles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) GetConnectionProfile(ctx context.Context, in *GetConnectionProfileRequest, opts ...grpc.CallOption) (*ConnectionProfile, error) {
	out := new(ConnectionProfile)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/GetConnectionProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) CreateConnectionProfile(ctx context.Context, in *CreateConnectionProfileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/CreateConnectionProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) UpdateConnectionProfile(ctx context.Context, in *UpdateConnectionProfileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/UpdateConnectionProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) DeleteConnectionProfile(ctx context.Context, in *DeleteConnectionProfileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/DeleteConnectionProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) CreatePrivateConnection(ctx context.Context, in *CreatePrivateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/CreatePrivateConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) GetPrivateConnection(ctx context.Context, in *GetPrivateConnectionRequest, opts ...grpc.CallOption) (*PrivateConnection, error) {
	out := new(PrivateConnection)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/GetPrivateConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) ListPrivateConnections(ctx context.Context, in *ListPrivateConnectionsRequest, opts ...grpc.CallOption) (*ListPrivateConnectionsResponse, error) {
	out := new(ListPrivateConnectionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/ListPrivateConnections", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) DeletePrivateConnection(ctx context.Context, in *DeletePrivateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/DeletePrivateConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) GetConversionWorkspace(ctx context.Context, in *GetConversionWorkspaceRequest, opts ...grpc.CallOption) (*ConversionWorkspace, error) {
	out := new(ConversionWorkspace)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/GetConversionWorkspace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) ListConversionWorkspaces(ctx context.Context, in *ListConversionWorkspacesRequest, opts ...grpc.CallOption) (*ListConversionWorkspacesResponse, error) {
	out := new(ListConversionWorkspacesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/ListConversionWorkspaces", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) CreateConversionWorkspace(ctx context.Context, in *CreateConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/CreateConversionWorkspace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) UpdateConversionWorkspace(ctx context.Context, in *UpdateConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/UpdateConversionWorkspace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) DeleteConversionWorkspace(ctx context.Context, in *DeleteConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/DeleteConversionWorkspace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) CreateMappingRule(ctx context.Context, in *CreateMappingRuleRequest, opts ...grpc.CallOption) (*MappingRule, error) {
	out := new(MappingRule)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/CreateMappingRule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) DeleteMappingRule(ctx context.Context, in *DeleteMappingRuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/DeleteMappingRule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) ListMappingRules(ctx context.Context, in *ListMappingRulesRequest, opts ...grpc.CallOption) (*ListMappingRulesResponse, error) {
	out := new(ListMappingRulesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/ListMappingRules", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) GetMappingRule(ctx context.Context, in *GetMappingRuleRequest, opts ...grpc.CallOption) (*MappingRule, error) {
	out := new(MappingRule)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/GetMappingRule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) SeedConversionWorkspace(ctx context.Context, in *SeedConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/SeedConversionWorkspace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) ImportMappingRules(ctx context.Context, in *ImportMappingRulesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/ImportMappingRules", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) ConvertConversionWorkspace(ctx context.Context, in *ConvertConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/ConvertConversionWorkspace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) CommitConversionWorkspace(ctx context.Context, in *CommitConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/CommitConversionWorkspace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) RollbackConversionWorkspace(ctx context.Context, in *RollbackConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/RollbackConversionWorkspace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) ApplyConversionWorkspace(ctx context.Context, in *ApplyConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/ApplyConversionWorkspace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) DescribeDatabaseEntities(ctx context.Context, in *DescribeDatabaseEntitiesRequest, opts ...grpc.CallOption) (*DescribeDatabaseEntitiesResponse, error) {
	out := new(DescribeDatabaseEntitiesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/DescribeDatabaseEntities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) SearchBackgroundJobs(ctx context.Context, in *SearchBackgroundJobsRequest, opts ...grpc.CallOption) (*SearchBackgroundJobsResponse, error) {
	out := new(SearchBackgroundJobsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/SearchBackgroundJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) DescribeConversionWorkspaceRevisions(ctx context.Context, in *DescribeConversionWorkspaceRevisionsRequest, opts ...grpc.CallOption) (*DescribeConversionWorkspaceRevisionsResponse, error) {
	out := new(DescribeConversionWorkspaceRevisionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/DescribeConversionWorkspaceRevisions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) FetchStaticIps(ctx context.Context, in *FetchStaticIpsRequest, opts ...grpc.CallOption) (*FetchStaticIpsResponse, error) {
	out := new(FetchStaticIpsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/FetchStaticIps", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataMigrationServiceServer is the server API for DataMigrationService service.
type DataMigrationServiceServer interface {
	// Lists migration jobs in a given project and location.
	ListMigrationJobs(context.Context, *ListMigrationJobsRequest) (*ListMigrationJobsResponse, error)
	// Gets details of a single migration job.
	GetMigrationJob(context.Context, *GetMigrationJobRequest) (*MigrationJob, error)
	// Creates a new migration job in a given project and location.
	CreateMigrationJob(context.Context, *CreateMigrationJobRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single migration job.
	UpdateMigrationJob(context.Context, *UpdateMigrationJobRequest) (*longrunningpb.Operation, error)
	// Deletes a single migration job.
	DeleteMigrationJob(context.Context, *DeleteMigrationJobRequest) (*longrunningpb.Operation, error)
	// Start an already created migration job.
	StartMigrationJob(context.Context, *StartMigrationJobRequest) (*longrunningpb.Operation, error)
	// Stops a running migration job.
	StopMigrationJob(context.Context, *StopMigrationJobRequest) (*longrunningpb.Operation, error)
	// Resume a migration job that is currently stopped and is resumable (was
	// stopped during CDC phase).
	ResumeMigrationJob(context.Context, *ResumeMigrationJobRequest) (*longrunningpb.Operation, error)
	// Promote a migration job, stopping replication to the destination and
	// promoting the destination to be a standalone database.
	PromoteMigrationJob(context.Context, *PromoteMigrationJobRequest) (*longrunningpb.Operation, error)
	// Verify a migration job, making sure the destination can reach the source
	// and that all configuration and prerequisites are met.
	VerifyMigrationJob(context.Context, *VerifyMigrationJobRequest) (*longrunningpb.Operation, error)
	// Restart a stopped or failed migration job, resetting the destination
	// instance to its original state and starting the migration process from
	// scratch.
	RestartMigrationJob(context.Context, *RestartMigrationJobRequest) (*longrunningpb.Operation, error)
	// Generate a SSH configuration script to configure the reverse SSH
	// connectivity.
	GenerateSshScript(context.Context, *GenerateSshScriptRequest) (*SshScript, error)
	// Generate a TCP Proxy configuration script to configure a cloud-hosted VM
	// running a TCP Proxy.
	GenerateTcpProxyScript(context.Context, *GenerateTcpProxyScriptRequest) (*TcpProxyScript, error)
	// Retrieves a list of all connection profiles in a given project and
	// location.
	ListConnectionProfiles(context.Context, *ListConnectionProfilesRequest) (*ListConnectionProfilesResponse, error)
	// Gets details of a single connection profile.
	GetConnectionProfile(context.Context, *GetConnectionProfileRequest) (*ConnectionProfile, error)
	// Creates a new connection profile in a given project and location.
	CreateConnectionProfile(context.Context, *CreateConnectionProfileRequest) (*longrunningpb.Operation, error)
	// Update the configuration of a single connection profile.
	UpdateConnectionProfile(context.Context, *UpdateConnectionProfileRequest) (*longrunningpb.Operation, error)
	// Deletes a single Database Migration Service connection profile.
	// A connection profile can only be deleted if it is not in use by any
	// active migration jobs.
	DeleteConnectionProfile(context.Context, *DeleteConnectionProfileRequest) (*longrunningpb.Operation, error)
	// Creates a new private connection in a given project and location.
	CreatePrivateConnection(context.Context, *CreatePrivateConnectionRequest) (*longrunningpb.Operation, error)
	// Gets details of a single private connection.
	GetPrivateConnection(context.Context, *GetPrivateConnectionRequest) (*PrivateConnection, error)
	// Retrieves a list of private connections in a given project and location.
	ListPrivateConnections(context.Context, *ListPrivateConnectionsRequest) (*ListPrivateConnectionsResponse, error)
	// Deletes a single Database Migration Service private connection.
	DeletePrivateConnection(context.Context, *DeletePrivateConnectionRequest) (*longrunningpb.Operation, error)
	// Gets details of a single conversion workspace.
	GetConversionWorkspace(context.Context, *GetConversionWorkspaceRequest) (*ConversionWorkspace, error)
	// Lists conversion workspaces in a given project and location.
	ListConversionWorkspaces(context.Context, *ListConversionWorkspacesRequest) (*ListConversionWorkspacesResponse, error)
	// Creates a new conversion workspace in a given project and location.
	CreateConversionWorkspace(context.Context, *CreateConversionWorkspaceRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single conversion workspace.
	UpdateConversionWorkspace(context.Context, *UpdateConversionWorkspaceRequest) (*longrunningpb.Operation, error)
	// Deletes a single conversion workspace.
	DeleteConversionWorkspace(context.Context, *DeleteConversionWorkspaceRequest) (*longrunningpb.Operation, error)
	// Creates a new mapping rule for a given conversion workspace.
	CreateMappingRule(context.Context, *CreateMappingRuleRequest) (*MappingRule, error)
	// Deletes a single mapping rule.
	DeleteMappingRule(context.Context, *DeleteMappingRuleRequest) (*emptypb.Empty, error)
	// Lists the mapping rules for a specific conversion workspace.
	ListMappingRules(context.Context, *ListMappingRulesRequest) (*ListMappingRulesResponse, error)
	// Gets the details of a mapping rule.
	GetMappingRule(context.Context, *GetMappingRuleRequest) (*MappingRule, error)
	// Imports a snapshot of the source database into the
	// conversion workspace.
	SeedConversionWorkspace(context.Context, *SeedConversionWorkspaceRequest) (*longrunningpb.Operation, error)
	// Imports the mapping rules for a given conversion workspace.
	// Supports various formats of external rules files.
	ImportMappingRules(context.Context, *ImportMappingRulesRequest) (*longrunningpb.Operation, error)
	// Creates a draft tree schema for the destination database.
	ConvertConversionWorkspace(context.Context, *ConvertConversionWorkspaceRequest) (*longrunningpb.Operation, error)
	// Marks all the data in the conversion workspace as committed.
	CommitConversionWorkspace(context.Context, *CommitConversionWorkspaceRequest) (*longrunningpb.Operation, error)
	// Rolls back a conversion workspace to the last committed snapshot.
	RollbackConversionWorkspace(context.Context, *RollbackConversionWorkspaceRequest) (*longrunningpb.Operation, error)
	// Applies draft tree onto a specific destination database.
	ApplyConversionWorkspace(context.Context, *ApplyConversionWorkspaceRequest) (*longrunningpb.Operation, error)
	// Describes the database entities tree for a specific conversion workspace
	// and a specific tree type.
	//
	// Database entities are not resources like conversion workspaces or mapping
	// rules, and they can't be created, updated or deleted. Instead, they are
	// simple data objects describing the structure of the client database.
	DescribeDatabaseEntities(context.Context, *DescribeDatabaseEntitiesRequest) (*DescribeDatabaseEntitiesResponse, error)
	// Searches/lists the background jobs for a specific
	// conversion workspace.
	//
	// The background jobs are not resources like conversion workspaces or
	// mapping rules, and they can't be created, updated or deleted.
	// Instead, they are a way to expose the data plane jobs log.
	SearchBackgroundJobs(context.Context, *SearchBackgroundJobsRequest) (*SearchBackgroundJobsResponse, error)
	// Retrieves a list of committed revisions of a specific conversion
	// workspace.
	DescribeConversionWorkspaceRevisions(context.Context, *DescribeConversionWorkspaceRevisionsRequest) (*DescribeConversionWorkspaceRevisionsResponse, error)
	// Fetches a set of static IP addresses that need to be allowlisted by the
	// customer when using the static-IP connectivity method.
	FetchStaticIps(context.Context, *FetchStaticIpsRequest) (*FetchStaticIpsResponse, error)
}

// UnimplementedDataMigrationServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDataMigrationServiceServer struct {
}

func (*UnimplementedDataMigrationServiceServer) ListMigrationJobs(context.Context, *ListMigrationJobsRequest) (*ListMigrationJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMigrationJobs not implemented")
}
func (*UnimplementedDataMigrationServiceServer) GetMigrationJob(context.Context, *GetMigrationJobRequest) (*MigrationJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMigrationJob not implemented")
}
func (*UnimplementedDataMigrationServiceServer) CreateMigrationJob(context.Context, *CreateMigrationJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMigrationJob not implemented")
}
func (*UnimplementedDataMigrationServiceServer) UpdateMigrationJob(context.Context, *UpdateMigrationJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateMigrationJob not implemented")
}
func (*UnimplementedDataMigrationServiceServer) DeleteMigrationJob(context.Context, *DeleteMigrationJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMigrationJob not implemented")
}
func (*UnimplementedDataMigrationServiceServer) StartMigrationJob(context.Context, *StartMigrationJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartMigrationJob not implemented")
}
func (*UnimplementedDataMigrationServiceServer) StopMigrationJob(context.Context, *StopMigrationJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopMigrationJob not implemented")
}
func (*UnimplementedDataMigrationServiceServer) ResumeMigrationJob(context.Context, *ResumeMigrationJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResumeMigrationJob not implemented")
}
func (*UnimplementedDataMigrationServiceServer) PromoteMigrationJob(context.Context, *PromoteMigrationJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PromoteMigrationJob not implemented")
}
func (*UnimplementedDataMigrationServiceServer) VerifyMigrationJob(context.Context, *VerifyMigrationJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method VerifyMigrationJob not implemented")
}
func (*UnimplementedDataMigrationServiceServer) RestartMigrationJob(context.Context, *RestartMigrationJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestartMigrationJob not implemented")
}
func (*UnimplementedDataMigrationServiceServer) GenerateSshScript(context.Context, *GenerateSshScriptRequest) (*SshScript, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateSshScript not implemented")
}
func (*UnimplementedDataMigrationServiceServer) GenerateTcpProxyScript(context.Context, *GenerateTcpProxyScriptRequest) (*TcpProxyScript, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateTcpProxyScript not implemented")
}
func (*UnimplementedDataMigrationServiceServer) ListConnectionProfiles(context.Context, *ListConnectionProfilesRequest) (*ListConnectionProfilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConnectionProfiles not implemented")
}
func (*UnimplementedDataMigrationServiceServer) GetConnectionProfile(context.Context, *GetConnectionProfileRequest) (*ConnectionProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConnectionProfile not implemented")
}
func (*UnimplementedDataMigrationServiceServer) CreateConnectionProfile(context.Context, *CreateConnectionProfileRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConnectionProfile not implemented")
}
func (*UnimplementedDataMigrationServiceServer) UpdateConnectionProfile(context.Context, *UpdateConnectionProfileRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConnectionProfile not implemented")
}
func (*UnimplementedDataMigrationServiceServer) DeleteConnectionProfile(context.Context, *DeleteConnectionProfileRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConnectionProfile not implemented")
}
func (*UnimplementedDataMigrationServiceServer) CreatePrivateConnection(context.Context, *CreatePrivateConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePrivateConnection not implemented")
}
func (*UnimplementedDataMigrationServiceServer) GetPrivateConnection(context.Context, *GetPrivateConnectionRequest) (*PrivateConnection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPrivateConnection not implemented")
}
func (*UnimplementedDataMigrationServiceServer) ListPrivateConnections(context.Context, *ListPrivateConnectionsRequest) (*ListPrivateConnectionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPrivateConnections not implemented")
}
func (*UnimplementedDataMigrationServiceServer) DeletePrivateConnection(context.Context, *DeletePrivateConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePrivateConnection not implemented")
}
func (*UnimplementedDataMigrationServiceServer) GetConversionWorkspace(context.Context, *GetConversionWorkspaceRequest) (*ConversionWorkspace, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversionWorkspace not implemented")
}
func (*UnimplementedDataMigrationServiceServer) ListConversionWorkspaces(context.Context, *ListConversionWorkspacesRequest) (*ListConversionWorkspacesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConversionWorkspaces not implemented")
}
func (*UnimplementedDataMigrationServiceServer) CreateConversionWorkspace(context.Context, *CreateConversionWorkspaceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConversionWorkspace not implemented")
}
func (*UnimplementedDataMigrationServiceServer) UpdateConversionWorkspace(context.Context, *UpdateConversionWorkspaceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConversionWorkspace not implemented")
}
func (*UnimplementedDataMigrationServiceServer) DeleteConversionWorkspace(context.Context, *DeleteConversionWorkspaceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConversionWorkspace not implemented")
}
func (*UnimplementedDataMigrationServiceServer) CreateMappingRule(context.Context, *CreateMappingRuleRequest) (*MappingRule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMappingRule not implemented")
}
func (*UnimplementedDataMigrationServiceServer) DeleteMappingRule(context.Context, *DeleteMappingRuleRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMappingRule not implemented")
}
func (*UnimplementedDataMigrationServiceServer) ListMappingRules(context.Context, *ListMappingRulesRequest) (*ListMappingRulesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMappingRules not implemented")
}
func (*UnimplementedDataMigrationServiceServer) GetMappingRule(context.Context, *GetMappingRuleRequest) (*MappingRule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMappingRule not implemented")
}
func (*UnimplementedDataMigrationServiceServer) SeedConversionWorkspace(context.Context, *SeedConversionWorkspaceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SeedConversionWorkspace not implemented")
}
func (*UnimplementedDataMigrationServiceServer) ImportMappingRules(context.Context, *ImportMappingRulesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportMappingRules not implemented")
}
func (*UnimplementedDataMigrationServiceServer) ConvertConversionWorkspace(context.Context, *ConvertConversionWorkspaceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConvertConversionWorkspace not implemented")
}
func (*UnimplementedDataMigrationServiceServer) CommitConversionWorkspace(context.Context, *CommitConversionWorkspaceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CommitConversionWorkspace not implemented")
}
func (*UnimplementedDataMigrationServiceServer) RollbackConversionWorkspace(context.Context, *RollbackConversionWorkspaceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RollbackConversionWorkspace not implemented")
}
func (*UnimplementedDataMigrationServiceServer) ApplyConversionWorkspace(context.Context, *ApplyConversionWorkspaceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApplyConversionWorkspace not implemented")
}
func (*UnimplementedDataMigrationServiceServer) DescribeDatabaseEntities(context.Context, *DescribeDatabaseEntitiesRequest) (*DescribeDatabaseEntitiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DescribeDatabaseEntities not implemented")
}
func (*UnimplementedDataMigrationServiceServer) SearchBackgroundJobs(context.Context, *SearchBackgroundJobsRequest) (*SearchBackgroundJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchBackgroundJobs not implemented")
}
func (*UnimplementedDataMigrationServiceServer) DescribeConversionWorkspaceRevisions(context.Context, *DescribeConversionWorkspaceRevisionsRequest) (*DescribeConversionWorkspaceRevisionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DescribeConversionWorkspaceRevisions not implemented")
}
func (*UnimplementedDataMigrationServiceServer) FetchStaticIps(context.Context, *FetchStaticIpsRequest) (*FetchStaticIpsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchStaticIps not implemented")
}

func RegisterDataMigrationServiceServer(s *grpc.Server, srv DataMigrationServiceServer) {
	s.RegisterService(&_DataMigrationService_serviceDesc, srv)
}

func _DataMigrationService_ListMigrationJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMigrationJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).ListMigrationJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/ListMigrationJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).ListMigrationJobs(ctx, req.(*ListMigrationJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_GetMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).GetMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/GetMigrationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).GetMigrationJob(ctx, req.(*GetMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_CreateMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).CreateMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/CreateMigrationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).CreateMigrationJob(ctx, req.(*CreateMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_UpdateMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).UpdateMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/UpdateMigrationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).UpdateMigrationJob(ctx, req.(*UpdateMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_DeleteMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).DeleteMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/DeleteMigrationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).DeleteMigrationJob(ctx, req.(*DeleteMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_StartMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).StartMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/StartMigrationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).StartMigrationJob(ctx, req.(*StartMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_StopMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).StopMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/StopMigrationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).StopMigrationJob(ctx, req.(*StopMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_ResumeMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumeMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).ResumeMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/ResumeMigrationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).ResumeMigrationJob(ctx, req.(*ResumeMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_PromoteMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PromoteMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).PromoteMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/PromoteMigrationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).PromoteMigrationJob(ctx, req.(*PromoteMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_VerifyMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VerifyMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).VerifyMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/VerifyMigrationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).VerifyMigrationJob(ctx, req.(*VerifyMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_RestartMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestartMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).RestartMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/RestartMigrationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).RestartMigrationJob(ctx, req.(*RestartMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_GenerateSshScript_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateSshScriptRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).GenerateSshScript(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/GenerateSshScript",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).GenerateSshScript(ctx, req.(*GenerateSshScriptRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_GenerateTcpProxyScript_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateTcpProxyScriptRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).GenerateTcpProxyScript(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/GenerateTcpProxyScript",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).GenerateTcpProxyScript(ctx, req.(*GenerateTcpProxyScriptRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_ListConnectionProfiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConnectionProfilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).ListConnectionProfiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/ListConnectionProfiles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).ListConnectionProfiles(ctx, req.(*ListConnectionProfilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_GetConnectionProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConnectionProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).GetConnectionProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/GetConnectionProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).GetConnectionProfile(ctx, req.(*GetConnectionProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_CreateConnectionProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConnectionProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).CreateConnectionProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/CreateConnectionProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).CreateConnectionProfile(ctx, req.(*CreateConnectionProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_UpdateConnectionProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConnectionProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).UpdateConnectionProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/UpdateConnectionProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).UpdateConnectionProfile(ctx, req.(*UpdateConnectionProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_DeleteConnectionProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConnectionProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).DeleteConnectionProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/DeleteConnectionProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).DeleteConnectionProfile(ctx, req.(*DeleteConnectionProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_CreatePrivateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePrivateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).CreatePrivateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/CreatePrivateConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).CreatePrivateConnection(ctx, req.(*CreatePrivateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_GetPrivateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPrivateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).GetPrivateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/GetPrivateConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).GetPrivateConnection(ctx, req.(*GetPrivateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_ListPrivateConnections_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPrivateConnectionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).ListPrivateConnections(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/ListPrivateConnections",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).ListPrivateConnections(ctx, req.(*ListPrivateConnectionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_DeletePrivateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePrivateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).DeletePrivateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/DeletePrivateConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).DeletePrivateConnection(ctx, req.(*DeletePrivateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_GetConversionWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversionWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).GetConversionWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/GetConversionWorkspace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).GetConversionWorkspace(ctx, req.(*GetConversionWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_ListConversionWorkspaces_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConversionWorkspacesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).ListConversionWorkspaces(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/ListConversionWorkspaces",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).ListConversionWorkspaces(ctx, req.(*ListConversionWorkspacesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_CreateConversionWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConversionWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).CreateConversionWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/CreateConversionWorkspace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).CreateConversionWorkspace(ctx, req.(*CreateConversionWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_UpdateConversionWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConversionWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).UpdateConversionWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/UpdateConversionWorkspace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).UpdateConversionWorkspace(ctx, req.(*UpdateConversionWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_DeleteConversionWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConversionWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).DeleteConversionWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/DeleteConversionWorkspace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).DeleteConversionWorkspace(ctx, req.(*DeleteConversionWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_CreateMappingRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMappingRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).CreateMappingRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/CreateMappingRule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).CreateMappingRule(ctx, req.(*CreateMappingRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_DeleteMappingRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMappingRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).DeleteMappingRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/DeleteMappingRule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).DeleteMappingRule(ctx, req.(*DeleteMappingRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_ListMappingRules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMappingRulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).ListMappingRules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/ListMappingRules",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).ListMappingRules(ctx, req.(*ListMappingRulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_GetMappingRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMappingRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).GetMappingRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/GetMappingRule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).GetMappingRule(ctx, req.(*GetMappingRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_SeedConversionWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SeedConversionWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).SeedConversionWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/SeedConversionWorkspace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).SeedConversionWorkspace(ctx, req.(*SeedConversionWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_ImportMappingRules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportMappingRulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).ImportMappingRules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/ImportMappingRules",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).ImportMappingRules(ctx, req.(*ImportMappingRulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_ConvertConversionWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConvertConversionWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).ConvertConversionWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/ConvertConversionWorkspace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).ConvertConversionWorkspace(ctx, req.(*ConvertConversionWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_CommitConversionWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitConversionWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).CommitConversionWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/CommitConversionWorkspace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).CommitConversionWorkspace(ctx, req.(*CommitConversionWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_RollbackConversionWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackConversionWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).RollbackConversionWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/RollbackConversionWorkspace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).RollbackConversionWorkspace(ctx, req.(*RollbackConversionWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_ApplyConversionWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplyConversionWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).ApplyConversionWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/ApplyConversionWorkspace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).ApplyConversionWorkspace(ctx, req.(*ApplyConversionWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_DescribeDatabaseEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DescribeDatabaseEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).DescribeDatabaseEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/DescribeDatabaseEntities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).DescribeDatabaseEntities(ctx, req.(*DescribeDatabaseEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_SearchBackgroundJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchBackgroundJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).SearchBackgroundJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/SearchBackgroundJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).SearchBackgroundJobs(ctx, req.(*SearchBackgroundJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_DescribeConversionWorkspaceRevisions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DescribeConversionWorkspaceRevisionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).DescribeConversionWorkspaceRevisions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/DescribeConversionWorkspaceRevisions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).DescribeConversionWorkspaceRevisions(ctx, req.(*DescribeConversionWorkspaceRevisionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_FetchStaticIps_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchStaticIpsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).FetchStaticIps(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/FetchStaticIps",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).FetchStaticIps(ctx, req.(*FetchStaticIpsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DataMigrationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.clouddms.v1.DataMigrationService",
	HandlerType: (*DataMigrationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListMigrationJobs",
			Handler:    _DataMigrationService_ListMigrationJobs_Handler,
		},
		{
			MethodName: "GetMigrationJob",
			Handler:    _DataMigrationService_GetMigrationJob_Handler,
		},
		{
			MethodName: "CreateMigrationJob",
			Handler:    _DataMigrationService_CreateMigrationJob_Handler,
		},
		{
			MethodName: "UpdateMigrationJob",
			Handler:    _DataMigrationService_UpdateMigrationJob_Handler,
		},
		{
			MethodName: "DeleteMigrationJob",
			Handler:    _DataMigrationService_DeleteMigrationJob_Handler,
		},
		{
			MethodName: "StartMigrationJob",
			Handler:    _DataMigrationService_StartMigrationJob_Handler,
		},
		{
			MethodName: "StopMigrationJob",
			Handler:    _DataMigrationService_StopMigrationJob_Handler,
		},
		{
			MethodName: "ResumeMigrationJob",
			Handler:    _DataMigrationService_ResumeMigrationJob_Handler,
		},
		{
			MethodName: "PromoteMigrationJob",
			Handler:    _DataMigrationService_PromoteMigrationJob_Handler,
		},
		{
			MethodName: "VerifyMigrationJob",
			Handler:    _DataMigrationService_VerifyMigrationJob_Handler,
		},
		{
			MethodName: "RestartMigrationJob",
			Handler:    _DataMigrationService_RestartMigrationJob_Handler,
		},
		{
			MethodName: "GenerateSshScript",
			Handler:    _DataMigrationService_GenerateSshScript_Handler,
		},
		{
			MethodName: "GenerateTcpProxyScript",
			Handler:    _DataMigrationService_GenerateTcpProxyScript_Handler,
		},
		{
			MethodName: "ListConnectionProfiles",
			Handler:    _DataMigrationService_ListConnectionProfiles_Handler,
		},
		{
			MethodName: "GetConnectionProfile",
			Handler:    _DataMigrationService_GetConnectionProfile_Handler,
		},
		{
			MethodName: "CreateConnectionProfile",
			Handler:    _DataMigrationService_CreateConnectionProfile_Handler,
		},
		{
			MethodName: "UpdateConnectionProfile",
			Handler:    _DataMigrationService_UpdateConnectionProfile_Handler,
		},
		{
			MethodName: "DeleteConnectionProfile",
			Handler:    _DataMigrationService_DeleteConnectionProfile_Handler,
		},
		{
			MethodName: "CreatePrivateConnection",
			Handler:    _DataMigrationService_CreatePrivateConnection_Handler,
		},
		{
			MethodName: "GetPrivateConnection",
			Handler:    _DataMigrationService_GetPrivateConnection_Handler,
		},
		{
			MethodName: "ListPrivateConnections",
			Handler:    _DataMigrationService_ListPrivateConnections_Handler,
		},
		{
			MethodName: "DeletePrivateConnection",
			Handler:    _DataMigrationService_DeletePrivateConnection_Handler,
		},
		{
			MethodName: "GetConversionWorkspace",
			Handler:    _DataMigrationService_GetConversionWorkspace_Handler,
		},
		{
			MethodName: "ListConversionWorkspaces",
			Handler:    _DataMigrationService_ListConversionWorkspaces_Handler,
		},
		{
			MethodName: "CreateConversionWorkspace",
			Handler:    _DataMigrationService_CreateConversionWorkspace_Handler,
		},
		{
			MethodName: "UpdateConversionWorkspace",
			Handler:    _DataMigrationService_UpdateConversionWorkspace_Handler,
		},
		{
			MethodName: "DeleteConversionWorkspace",
			Handler:    _DataMigrationService_DeleteConversionWorkspace_Handler,
		},
		{
			MethodName: "CreateMappingRule",
			Handler:    _DataMigrationService_CreateMappingRule_Handler,
		},
		{
			MethodName: "DeleteMappingRule",
			Handler:    _DataMigrationService_DeleteMappingRule_Handler,
		},
		{
			MethodName: "ListMappingRules",
			Handler:    _DataMigrationService_ListMappingRules_Handler,
		},
		{
			MethodName: "GetMappingRule",
			Handler:    _DataMigrationService_GetMappingRule_Handler,
		},
		{
			MethodName: "SeedConversionWorkspace",
			Handler:    _DataMigrationService_SeedConversionWorkspace_Handler,
		},
		{
			MethodName: "ImportMappingRules",
			Handler:    _DataMigrationService_ImportMappingRules_Handler,
		},
		{
			MethodName: "ConvertConversionWorkspace",
			Handler:    _DataMigrationService_ConvertConversionWorkspace_Handler,
		},
		{
			MethodName: "CommitConversionWorkspace",
			Handler:    _DataMigrationService_CommitConversionWorkspace_Handler,
		},
		{
			MethodName: "RollbackConversionWorkspace",
			Handler:    _DataMigrationService_RollbackConversionWorkspace_Handler,
		},
		{
			MethodName: "ApplyConversionWorkspace",
			Handler:    _DataMigrationService_ApplyConversionWorkspace_Handler,
		},
		{
			MethodName: "DescribeDatabaseEntities",
			Handler:    _DataMigrationService_DescribeDatabaseEntities_Handler,
		},
		{
			MethodName: "SearchBackgroundJobs",
			Handler:    _DataMigrationService_SearchBackgroundJobs_Handler,
		},
		{
			MethodName: "DescribeConversionWorkspaceRevisions",
			Handler:    _DataMigrationService_DescribeConversionWorkspaceRevisions_Handler,
		},
		{
			MethodName: "FetchStaticIps",
			Handler:    _DataMigrationService_FetchStaticIps_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/clouddms/v1/clouddms.proto",
}
