package CExpr::Conditional;

use 5.6.0;
use strict;
use warnings;

use CExpr;

our @ISA = qw/CExpr/;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;

    my $cond = shift;
    my $true = shift;
    my $false = shift;

    my $self = {cond => $cond,
                true => $true,
                false => $false,
               };
    bless $self, $class;
    return $self;
  }

sub dump_c
  {
    my $self = shift;

    my $cond = $self->{cond}->dump_c;
    my $true = $self->{true}->dump_c;
    my $false = $self->{false}->dump_c;

    return "($cond) ? $true : $false";
  }

sub compute
  {
    my $self = shift;

    my $cond = $self->{cond}->compute;

    return $cond ? $self->{true}->compute : $self->{false}->compute;
  }

sub get_refs
  {
    my $self = shift;
    return ($self->{cond}->get_refs, $self->{true}->get_refs, $self->{false}->get_refs);
  }

sub layout
  {
    my $self = shift;
    my $accept_incomplete = shift;
    my $namespace = shift;
    $self->{cond}->layout($accept_incomplete, $namespace);
    $self->{true}->layout($accept_incomplete, $namespace);
    $self->{false}->layout($accept_incomplete, $namespace);
  }

1;
