/*
* Copyright 2000-2010 JetBrains s.r.o.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
package com.intellij.jarRepository.services.nexus;

import com.intellij.jarRepository.RemoteRepositoryDescription;

import javax.xml.bind.annotation.XmlRegistry;


/**
 * This object contains factory methods for each
 * Java content interface and Java element interface
 * generated in the nexus package.
 * <p>An ObjectFactory allows you to programatically
 * construct new instances of the Java representation
 * for XML content. The Java representation of XML
 * content can consist of schema derived interfaces
 * and classes representing the binding of schema
 * type definitions, element declarations and model
 * groups.  Factory methods for each of these are
 * provided in this class.
 */
@XmlRegistry
public class ObjectFactory {


  /**
   * Create a new ObjectFactory that can be used to create new instances of schema derived classes for package: nexus
   */
  public ObjectFactory() {
  }

  /**
   * Create an instance of {@link Repositories }
   */
  public Repositories createRepositories() {
    return new Repositories();
  }

  /**
   * Create an instance of {@link RepositoryMetaData }
   */
  public RepositoryMetaData createRepositoryMetaData() {
    return new RepositoryMetaData();
  }

  /**
   * Create an instance of {@link SearchResults }
   */
  public SearchResults createSearchResults() {
    return new SearchResults();
  }

  /**
   * Create an instance of {@link RemoteRepositoryDescription }
   */
  public RepositoryType createRepositoryType() {
    return new RepositoryType();
  }

  /**
   * Create an instance of {@link org.jetbrains.idea.maven.model.MavenArtifactInfo }
   */
  public ArtifactType createArtifactType() {
    return new ArtifactType();
  }

  /**
   * Create an instance of {@link Repositories.Data }
   */
  public Repositories.Data createRepositoriesData() {
    return new Repositories.Data();
  }

  /**
   * Create an instance of {@link SearchResults.Data }
   */
  public SearchResults.Data createSearchResultsData() {
    return new SearchResults.Data();
  }
}
