/*
 * Copyright 2000-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.formatting.blocks

import com.intellij.lang.ASTNode
import com.intellij.psi.TokenType

fun ASTNode.prev(): ASTNode? {
  var prev = treePrev
  while (prev != null && prev.elementType == TokenType.WHITE_SPACE) {
    prev = prev.treePrev
  }
  if (prev != null) return prev
  return if (treeParent != null) treeParent.prev() else null
}
