/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogRootFilter;
import org.jetbrains.annotations.NotNull;

import java.util.Collection;

public class VcsLogRootFilterImpl implements VcsLogRootFilter {
  @NotNull private final Collection<VirtualFile> myRoots;

  public VcsLogRootFilterImpl(@NotNull Collection<VirtualFile> roots) {
    myRoots = roots;
  }

  @NotNull
  @Override
  public Collection<VirtualFile> getRoots() {
    return myRoots;
  }

  @Override
  public String toString() {
    return "roots:" + myRoots;
  }
}
