// Copyright 2020 The Bazel Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Log Stream API

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v5.28.1
// source: build/bazel/remote/logstream/v1/remote_logstream.proto

package remotelogstream

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	LogStreamService_CreateLogStream_FullMethodName = "/build.bazel.remote.logstream.v1.LogStreamService/CreateLogStream"
)

// LogStreamServiceClient is the client API for LogStreamService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type LogStreamServiceClient interface {
	// Create a LogStream which may be written to.
	//
	// The returned LogStream resource name will include a `write_resource_name`
	// which is the resource to use when writing to the LogStream.
	// Callers of CreateLogStream are expected to NOT publish the
	// `write_resource_name`.
	CreateLogStream(ctx context.Context, in *CreateLogStreamRequest, opts ...grpc.CallOption) (*LogStream, error)
}

type logStreamServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewLogStreamServiceClient(cc grpc.ClientConnInterface) LogStreamServiceClient {
	return &logStreamServiceClient{cc}
}

func (c *logStreamServiceClient) CreateLogStream(ctx context.Context, in *CreateLogStreamRequest, opts ...grpc.CallOption) (*LogStream, error) {
	out := new(LogStream)
	err := c.cc.Invoke(ctx, LogStreamService_CreateLogStream_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LogStreamServiceServer is the server API for LogStreamService service.
// All implementations should embed UnimplementedLogStreamServiceServer
// for forward compatibility
type LogStreamServiceServer interface {
	// Create a LogStream which may be written to.
	//
	// The returned LogStream resource name will include a `write_resource_name`
	// which is the resource to use when writing to the LogStream.
	// Callers of CreateLogStream are expected to NOT publish the
	// `write_resource_name`.
	CreateLogStream(context.Context, *CreateLogStreamRequest) (*LogStream, error)
}

// UnimplementedLogStreamServiceServer should be embedded to have forward compatible implementations.
type UnimplementedLogStreamServiceServer struct {
}

func (UnimplementedLogStreamServiceServer) CreateLogStream(context.Context, *CreateLogStreamRequest) (*LogStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateLogStream not implemented")
}

// UnsafeLogStreamServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to LogStreamServiceServer will
// result in compilation errors.
type UnsafeLogStreamServiceServer interface {
	mustEmbedUnimplementedLogStreamServiceServer()
}

func RegisterLogStreamServiceServer(s grpc.ServiceRegistrar, srv LogStreamServiceServer) {
	s.RegisterService(&LogStreamService_ServiceDesc, srv)
}

func _LogStreamService_CreateLogStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateLogStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LogStreamServiceServer).CreateLogStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LogStreamService_CreateLogStream_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LogStreamServiceServer).CreateLogStream(ctx, req.(*CreateLogStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// LogStreamService_ServiceDesc is the grpc.ServiceDesc for LogStreamService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var LogStreamService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "build.bazel.remote.logstream.v1.LogStreamService",
	HandlerType: (*LogStreamServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateLogStream",
			Handler:    _LogStreamService_CreateLogStream_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "build/bazel/remote/logstream/v1/remote_logstream.proto",
}
