# NAME

Test::Snapshot - test against data stored in automatically-named file

# PROJECT STATUS

| OS      |  Build status |
|:-------:|--------------:|
| Linux   | [![Build Status](https://travis-ci.org/mohawk2/Test-Snapshot.svg?branch=master)](https://travis-ci.org/mohawk2/Test-Snapshot) |

[![CPAN version](https://badge.fury.io/pl/Test-Snapshot.svg)](https://metacpan.org/pod/Test::Snapshot)

# SYNOPSIS

    use Test::Snapshot;
    my $got = function_generating_data();
    is_deeply_snapshot $got, 'test description'; # could also be in a subtest

    # command line:
    TEST_SNAPSHOT_UPDATE=1 prove -lr t
    # or
    TEST_SNAPSHOT_UPDATE=1 make test
    # if your code means the expected data should change, then inspect with
    git diff -w

# DESCRIPTION

Not connected with [Test::Snapshots](https://metacpan.org/pod/Test::Snapshots), which is based on a similar
concept but for running executables.

Implements a function to automate the storing and updating of expected
test outputs. This is based on the idea known in frontend development
circles as "snapshot testing", hence the module name.

These snapshots will be stored in files whose names are automatically
generated from:

- the test filename (`$0`)
- any subtests' names surrounding and including this one
- the test description if any

If that file is not present, it will be treated as though it contains
an `undef`.

# FUNCTIONS

## is\_deeply\_snapshot

Exported by default. Takes two mandatory arguments:

- The "got" data (mandatory), a scalar which might be a reference. It will
be passed to ["is\_deeply" in Test::More](https://metacpan.org/pod/Test::More#is_deeply) to be compared to the snapshotted
data.
- A text description of this test (mandatory). It will be used for reporting
results, but also to derive the filename in which the "expected" data
is stored.

Will return the truth value of whether the test passed this time -
see below for automatic updating of "expected" data.

# ENVIRONMENT

To have this module automatically update its "expected" data, set
environment variable `TEST_SNAPSHOT_UPDATE` to a true value. If the
got and expected data do not match, a test failure will be reported,
but the "expected" data will be updated anyway.

This means it is safe to always have the variable set to a true value,
so long as you are using source control (you _are_ using source control,
right?) and check your diffs before committing.

# FILE FORMAT

The "expected" data will be stored in a format generated by
["Dumper" in Data::Dumper](https://metacpan.org/pod/Data::Dumper#Dumper), with these values set to true, to maximise
readability (and to minimise diffs) of the stored data:

- Sortkeys
- Indent
- Terse

# AUTHOR

Ed J, `<etj at cpan.org>`

# LICENSE

Copyright (C) Ed J

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.
