/* Hey EMACS -*- linux-c -*- */
/* $Id: keys83p.c 2385 2006-05-26 07:44:30Z roms $ */

/*  libticalcs - Ti Calculator library, a part of the TiLP project
 *  Copyright (C) 1999-2007  Romain Livin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "ticalcs.h"
#include "keys83.h"

/*
  Conversion of an ASCII code into a TI key
  This table is very incomplete. It contains most of ASCII chars only.
  Same for TI73/TI83.
*/
extern const CalcKey TI83_KEYS[] =
{
/* 0x00 */
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"Enter", {"Enter", KEY83_Enter}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
/* 0x10 */
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"ESC", {"Quit", KEY83_Quit}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
/* 0x20 */
  {" ", {"Space", KEY83_Space}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"!", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"\"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"#", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"$", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"%", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"&", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"'", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"(", {"LParen", KEY83_LParen}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {")", {"RParen", KEY83_RParen}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"*", {"Mul", KEY83_Mul}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"+", {"Add", KEY83_Add}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {",", {"Comma", KEY83_Comma}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"-", {"Sub", KEY83_Sub}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {".", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"/", {"Div", KEY83_Div}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
/* 0x30 */
  {"0", {"0", KEY83_0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"1", {"1", KEY83_1}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"2", {"2", KEY83_2}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"3", {"3", KEY83_3}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"4", {"4", KEY83_4}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"5", {"5", KEY83_5}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"6", {"6", KEY83_6}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"7", {"7", KEY83_7}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"8", {"8", KEY83_8}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"9", {"9", KEY83_9}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {":", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {";", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"<", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"=", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {">", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"?", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
/* 0x40 */
  {"@", {"@", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"A", {"A", KEY83_CapA}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"B", {"B", KEY83_CapB}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"C", {"C", KEY83_CapC}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"D", {"D", KEY83_CapD}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"E", {"E", KEY83_CapE}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"F", {"F", KEY83_CapF}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"G", {"G", KEY83_CapG}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"H", {"H", KEY83_CapH}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"I", {"I", KEY83_CapI}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"J", {"J", KEY83_CapJ}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"K", {"K", KEY83_CapK}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"L", {"L", KEY83_CapL}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"M", {"M", KEY83_CapM}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"N", {"N", KEY83_CapN}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"O", {"O", KEY83_CapO}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
/* 0x50 */
  {"P", {"P", KEY83_CapP}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"Q", {"Q", KEY83_CapQ}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"R", {"R", KEY83_CapR}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"S", {"S", KEY83_CapS}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"T", {"T", KEY83_CapT}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"U", {"U", KEY83_CapU}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"V", {"V", KEY83_CapV}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"W", {"W", KEY83_CapW}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"X", {"X", KEY83_CapX}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"Y", {"Y", KEY83_CapY}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"Z", {"Z", KEY83_CapZ}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"[", {"LBrack", KEY83_LBrack}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"\\", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"]", {"RBrack", KEY83_RBrack}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"^", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"_", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
/* 0x60 */
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"a", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"b", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"c", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"d", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"e", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"f", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"g", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"h", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"i", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"j", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"k", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"l", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"m", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"n", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"o", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
/* 0x70 */
  {"p", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"q", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"r", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"s", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"t", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"u", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"v", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"w", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"x", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"y", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"z", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"{", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"|", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"}", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"~", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
/* 0x80 */
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"\173", {"Ans", KEY83_Ans}, {"\173", 173}, {"ANS", 4372}, {"", 8365}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
  {"", {"", 0}, {"", 0}, {"", 0}, {"", 0}, {"", 0}},
/* 0x90 */
};
