/*
 * Program name:  equake
 * Version:	  1.3.8.2
 * Source file:	  equake_func.h  
 * Description:	  Equake pulls data about earthquakes and displays it in interesting ways
 *
 * Copyright (C) 2016-2018 Jeroen van Aart
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */


static gboolean button_press_callback
(
  GtkWidget *event_box,
  GdkEventButton *event,
  gpointer data
);

void equake_setprefs
(
  struct Equake_Data *equakedata
);

void equake_getprefs
(
  struct Equake_Data *equakedata
);

void equake_saveprefs
(
  struct Equake_Data *equakedata,
  FILE *fp
);

static void equake_applet_change_background
(
  MatePanelApplet *applet,
  MatePanelAppletBackgroundType type,
  GdkColor  *colour,
#if GTK_CHECK_VERSION (3, 0, 0)
  cairo_pattern_t *pattern
#else
  GdkPixmap *pixmap
#endif
);

static gboolean equake_applet_fill
(
  MatePanelApplet *applet,
  const gchar *iid,
  gpointer data
);

void setdefaults
(
  struct Equake_Data *equakedata
);

/* process the arguments given at program startup, if any */
void process_arguments
(
  int arg,
  char **argv,
  struct Equake_Data *equakedata
);

int processdata_daily
(
  struct Equake_Data *equakedata
);

int processdata_weekly
(
  struct Equake_Data *equakedata
);

int render_equake_label
(
  struct Equake_Data *equakedata
);

static void set_label_tooltip_text
(
  GtkLabel *label,
  char *lbltxt,
  char *tooltiptxt
);

int count_characters
(
  const char *str,
  char *character
);

int processdata
(
  struct Equake_Data *equakedata,
  int period
);

void set_signature_file
(
  struct Equake_Data *equakedata
);

void alert_heavy_quake
(
  struct Equake_Data *equakedata,
  int pos
);

void set_magnitude_icon
(
  struct Equake_Data *equakedata,
  int pos
);

int convert_localtime
(
  struct Equake_Format *equakeformat
);

long long diff_tm
(
  struct tm *a, 
  struct tm *b
);

int eventloop
(
  struct Equake_Data *equakedata
);

/* callback used to store data we get from server */
size_t wdata
(
  char *curlbuf,
  size_t size,
  size_t mb,
  char *buf
); 

/* get the earthquake data using libcurl to allow https support */
int getdata
(
  char *url,
  char *buf,
  int period
);

/*
 * pull earthquake data from website
 * the data is in CSV format (Comma separated ASCII text)
 */
int getquakedata
(
  struct Equake_Data *equakedata,
  int period
);

int startequake
(
  MatePanelApplet *applet,
  GtkWidget *label,
  GtkWidget *logo,
  struct Equake_Data *equakedata
);

/* menu functions */
static void do_update
(
  GtkAction *action,
  struct Equake_Data *equakedata
);

static void load_details
(
  GtkAction *action,
  struct Equake_Data *equakedata
);

static void load_map
(
  GtkAction *action,
  struct Equake_Data *equakedata
);

static void load_didyoufeelit
(
  GtkAction *action,
  struct Equake_Data *equakedata
);

static void display_properties_dialog 
(
  GtkAction *action,
  struct Equake_Data *equakedata
);

static void set_properties_from_dialog
(
  int polltime,
  int willalert,
  int alertheavy,
  int sigfilemag,
  int monitormag,
  struct Equake_Data *equakedata
);

static void display_about_dialog
(
  GtkAction *action,
  struct Equake_Data *equakedata
);

static void display_dialog
(
  char *t
);

static void display_nonmodaldialog
(
  GtkWidget *dialog,
  char *t
);

static void display_url
(
  char *url
);

static void display_lastweek
(
  GtkAction *action,
  struct Equake_Data *equakedata
);

static void display_lastday
(
  GtkAction *action, 
  struct Equake_Data *equakedata
);

static void display_lasthour
(
  GtkAction *action, 
  struct Equake_Data *equakedata
);

static void fill_text_period
(
  struct Equake_Data *equakedata,
  char *running,
  char *periodtext,
  int period
);

static void display_period_window
(
  char *text,
  int period
);

static void display_lastperiod
(
  GtkAction *action,
  struct Equake_Data *equakedata,
  int period
);
