/***************************** LICENSE START ***********************************

 Copyright 2013 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/


#pragma once

#include "MvQRequestPanelHelp.h"
#include "MvIconParameter.h"
#include "ReplyObserver.h"

#include <QMap>
#include <QString>

class MvQExternalHelp : public MvQRequestPanelHelp,
                        public ReplyObserver
{
public:
    MvQExternalHelp(RequestPanel& owner, const MvIconParameter& param);
    ~MvQExternalHelp() = default;

    void start();
    bool dialog() { return true; }
    QWidget* widget() { return 0; }

protected:
    virtual void refresh(const std::vector<std::string>&);
    virtual long flags() { return 9; }
    virtual void set(Request&);

    void reply(const Request&, int);
    void progress(const Request&);
    void message(const std::string&);

    Request request_;
};
