#include <assert.h>
#include <stdlib.h>
#include "lib/util.h"
#include "semantic_actions.h"

struct rc_setting* parsed_rc_setting;

void emit(struct rc_setting* rc)
{
	parsed_rc_setting = rc;
}


struct rc_setting* append_rc(struct rc_setting* prev, struct rc_setting* cur)
{
	assert(!cur->prev);
	cur->prev = prev;
	return cur;
}

struct rc_setting* create_base_delay(int delay)
{
	struct rc_setting* rc_setting = malloc(sizeof(*rc_setting));
	die_if(!rc_setting, "malloc");
	rc_setting->base_delay = delay;
	rc_setting->type = RCS_BASEDELAY;
	rc_setting->prev = NULL;
	return rc_setting;
}

struct rc_setting* create_inter_delay(int delay)
{
	struct rc_setting* rc_setting = malloc(sizeof(*rc_setting));
	die_if(!rc_setting, "malloc");
	rc_setting->inter_delay = delay;
	rc_setting->type = RCS_INTERDELAY;
	rc_setting->prev = NULL;
	return rc_setting;
}

struct rc_setting* create_inter_delay_list(int delay, struct str_list* str)
{
	struct rc_setting* rc_setting = malloc(sizeof(*rc_setting));
	die_if(!rc_setting, "malloc");
	rc_setting->inter_delay_list.delay = delay;
	rc_setting->inter_delay_list.mailboxes = str;
	rc_setting->type = RCS_INTERDELAY_LIST;
	rc_setting->prev = NULL;
	return rc_setting;
}

struct rc_setting* create_ignore(struct str_list* str)
{
	struct rc_setting* rc_setting = malloc(sizeof(*rc_setting));
	die_if(!rc_setting, "malloc");
	rc_setting->ignores = str;
	rc_setting->type = RCS_IGNORE;
	rc_setting->prev = NULL;
	return rc_setting;
}

struct rc_setting* create_max_delay(int delay)
{
	struct rc_setting* rc_setting = malloc(sizeof(*rc_setting));
	die_if(!rc_setting, "malloc");
	rc_setting->max_delay = delay;
	rc_setting->type = RCS_MAXDELAY;
	rc_setting->prev = NULL;
	return rc_setting;
}

struct rc_setting* create_poll_period(int period)
{
	struct rc_setting* rc_setting = malloc(sizeof(*rc_setting));
	die_if(!rc_setting, "malloc");
	rc_setting->poll_period = period;
	rc_setting->type = RCS_POLLPERIOD;
	rc_setting->prev = NULL;
	return rc_setting;
}

struct rc_setting* create_sync(struct str_list* str)
{
	struct rc_setting* rc_setting = malloc(sizeof(*rc_setting));
	die_if(!rc_setting, "malloc");
	rc_setting->sync = str;
	rc_setting->type = RCS_SYNC;
	rc_setting->prev = NULL;
	return rc_setting;
}

struct rc_setting* create_mailbox_prefix(char* prefix, char* sep)
{
	struct rc_setting* rc_setting = malloc(sizeof(*rc_setting));
	die_if(!rc_setting, "malloc");
	rc_setting->mailbox_prefix[0] = prefix;
	rc_setting->mailbox_prefix[1] = sep;
	rc_setting->type = RCS_MAILBOXPREFIX;
	rc_setting->prev = NULL;
	return rc_setting;
}

struct rc_setting* create_store(struct rc_store_setting* store_setting)
{
	struct rc_setting* rc_setting = malloc(sizeof(*rc_setting));
	die_if(!rc_setting, "malloc");
	rc_setting->store_setting = store_setting;
	rc_setting->type = RCS_SS;
	rc_setting->prev = NULL;
	return rc_setting;
}


struct rc_store_setting* append_rc_store(struct rc_store_setting* prev, struct rc_store_setting* cur)
{
	assert(!cur->prev);
	cur->prev = prev;
	return cur;
}

struct rc_store_setting* create_store_name(char* str)
{
	struct rc_store_setting* rc_store_setting = malloc(sizeof(*rc_store_setting));
	die_if(!rc_store_setting, "malloc");
	rc_store_setting->name = str;
	rc_store_setting->type = RCSS_NAME;
	rc_store_setting->prev = NULL;
	return rc_store_setting;
}

struct rc_store_setting* create_store_watch(struct str_list* str)
{
	struct rc_store_setting* rc_store_setting = malloc(sizeof(*rc_store_setting));
	die_if(!rc_store_setting, "malloc");
	rc_store_setting->watch = str;
	rc_store_setting->type = RCSS_WATCH;
	rc_store_setting->prev = NULL;
	return rc_store_setting;
}


struct str_list* append_str(struct str_list* prev, struct str_list* cur)
{
	assert(!cur->prev);
	cur->prev = prev;
	return cur;
}

struct str_list* create_str(char* str)
{
	struct str_list* str_list = malloc(sizeof(*str_list));
	die_if(!str_list, "malloc");
	str_list->str = str;
	str_list->prev = NULL;
	return str_list;
}
