/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.core;

import net.sourceforge.plantuml.project.OpenClose;
import net.sourceforge.plantuml.project.draw.ResourceDraw;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.DayOfWeek;

public class Resource {
    private final String name;
    private ResourceDraw draw;
    private final OpenClose openClose = new OpenClose();

    public Resource(String name) {
        this.name = name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        Resource other = (Resource)obj;
        return this.name.equals(other.name);
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public ResourceDraw getResourceDraw() {
        return this.draw;
    }

    public void setTaskDraw(ResourceDraw draw) {
        this.draw = draw;
    }

    public boolean isClosedAt(Day day) {
        return this.openClose.isClosed(day);
    }

    public void addCloseDay(Day day) {
        this.openClose.close(day);
    }

    public void addForceOnDay(Day day) {
        this.openClose.open(day);
    }

    public void addCloseDay(DayOfWeek day) {
        this.openClose.close(day);
    }
}

