/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.ThemeStyle;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.project.draw.TimeHeader;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.project.timescale.TimeScaleWink;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class TimeHeaderSimple
extends TimeHeader {
    @Override
    public double getFullHeaderHeight() {
        return this.getTimeHeaderHeight() + this.getHeaderNameDayHeight();
    }

    @Override
    public double getTimeHeaderHeight() {
        return 16.0;
    }

    @Override
    public double getTimeFooterHeight() {
        return 16.0;
    }

    private double getHeaderNameDayHeight() {
        return 0.0;
    }

    public TimeHeaderSimple(Style timelineStyle, Style closedStyle, double scale, Day min, Day max, HColorSet colorSet, ThemeStyle themeStyle) {
        super(timelineStyle, closedStyle, min, max, new TimeScaleWink(scale), colorSet, themeStyle);
    }

    private void drawSmallVlinesDay(UGraphic ug, TimeScale timeScale, double totalHeightWithoutFooter) {
        ULine vbar = ULine.vline(totalHeightWithoutFooter);
        Day i = this.min;
        while (i.compareTo(this.max.increment()) <= 0) {
            double x1 = timeScale.getStartingPosition(i);
            ug.apply(this.getBarColor()).apply(UTranslate.dx(x1)).draw(vbar);
            i = i.increment();
        }
    }

    private void drawSimpleDayCounter(UGraphic ug, TimeScale timeScale) {
        Day i = this.min;
        while (i.compareTo(this.max.increment()) <= 0) {
            String number = "" + (i.getAbsoluteDayNum() + 1);
            TextBlock num = Display.getWithNewlines(number).create(this.getFontConfiguration(10, false, this.openFontColor()), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            double x1 = timeScale.getStartingPosition(i);
            double x2 = timeScale.getEndingPosition(i);
            double width = num.calculateDimension(ug.getStringBounder()).getWidth();
            double delta = x2 - x1 - width;
            if (i.compareTo(this.max.increment()) < 0) {
                num.drawU(ug.apply(UTranslate.dx(x1 + delta / 2.0)));
            }
            i = i.increment();
        }
    }

    @Override
    public void drawTimeHeader(UGraphic ug, double totalHeightWithoutFooter) {
        double xmin = this.getTimeScale().getStartingPosition(this.min);
        double xmax = this.getTimeScale().getEndingPosition(this.max);
        this.drawSmallVlinesDay(ug, this.getTimeScale(), totalHeightWithoutFooter);
        this.drawSimpleDayCounter(ug, this.getTimeScale());
        ug.apply(this.getBarColor()).draw(ULine.hline(xmax - xmin));
        ug.apply(this.getBarColor()).apply(UTranslate.dy(this.getFullHeaderHeight() - 3.0)).draw(ULine.hline(xmax - xmin));
    }

    @Override
    public void drawTimeFooter(UGraphic ug) {
        double xmin = this.getTimeScale().getStartingPosition(this.min);
        double xmax = this.getTimeScale().getEndingPosition(this.max);
        this.drawSmallVlinesDay(ug, this.getTimeScale(), this.getTimeFooterHeight());
        ug = ug.apply(UTranslate.dy(3.0));
        this.drawSimpleDayCounter(ug, this.getTimeScale());
        ug.apply(this.getBarColor()).draw(ULine.hline(xmax - xmin));
    }
}

