	SUBROUTINE TM_Parse_String ( instr, ndim, outary, nvals )
*
*
*  This software was developed by the Thermal Modeling and Analysis
*  Project(TMAP) of the National Oceanographic and Atmospheric
*  Administration's (NOAA) Pacific Marine Environmental Lab(PMEL),
*  hereafter referred to as NOAA/PMEL/TMAP.
*
*  Access and use of this software shall impose the following
*  obligations and understandings on the user. The user is granted the
*  right, without any fee or cost, to use, copy, modify, alter, enhance
*  and distribute this software, and any derivative works thereof, and
*  its supporting documentation for any purpose whatsoever, provided
*  that this entire notice appears in all copies of the software,
*  derivative works and supporting documentation.  Further, the user
*  agrees to credit NOAA/PMEL/TMAP in any publications that result from
*  the use of this software or in any product that includes this
*  software. The names TMAP, NOAA and/or PMEL, however, may not be used
*  in any advertising or publicity to endorse or promote any products
*  or commercial entity unless specific written permission is obtained
*  from NOAA/PMEL/TMAP. The user also understands that NOAA/PMEL/TMAP
*  is not obligated to provide the user with any support, consulting,
*  training or assistance of any kind with regard to the use, operation
*  and performance of this software nor to provide the user with any
*  updates, revisions, new versions or "bug fixes".
*
*  THIS SOFTWARE IS PROVIDED BY NOAA/PMEL/TMAP "AS IS" AND ANY EXPRESS
*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
*  ARE DISCLAIMED. IN NO EVENT SHALL NOAA/PMEL/TMAP BE LIABLE FOR ANY SPECIAL,
*  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
*  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
*  CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
*  CONNECTION WITH THE ACCESS, USE OR PERFORMANCE OF THIS SOFTWARE. 
*
*
*
* Will take the input string "instr" and separate the individual items at space,
* tab, or commas. It will place the items in array outary, which is dimensioned
* ndim, and then return number of items found in nvals. If more than ndim items
* are found, then only ndim items will be saved, although total number of items
* found will be reported in nvals.
*
* revision 0.00 - 08/14/89
*
* 10/96 *kob* - Linux port - had to move variable assignments off of
*		declaration line.

* Arguments:
*	instr	- input string containing items to be parsed
*	ndim	- dimension of outary
*	outary	- array where individual items are stored
*	nvals	- number of items found in instr
*
	INTEGER*4	ndim, nvals
	CHARACTER*(*)	instr, outary(ndim)
*
* Local definitions
* *kob* explicit definitions not allowed on decl line in linux...
*       moved it to parameter line 10/96
	CHARACTER*1	blank, comma, tab
	PARAMETER      (blank = ' ',
     .                  comma = ',',
     .                	tab = 	'	')
	INTEGER*4	ilen, pos, start
*
* Initialize
	nvals = 0
	ilen = LEN(instr)
	pos = 1
*
* Locate non-blank, non-comma, non-tab
  100	IF (pos .GT. ilen) GOTO 900
	IF ( instr(pos:pos) .NE. blank .AND.
     .	     instr(pos:pos) .NE. comma .AND.
     .	     instr(pos:pos) .NE. tab         ) THEN
	  start = pos
	  GOTO 200
	ENDIF
	pos = pos + 1
	GOTO 100
*
* Found start of item, find blank, comma, or tab to locate end of item
  200	IF ( instr(pos:pos) .EQ. blank .OR.
     .	     instr(pos:pos) .EQ. comma .OR.
     .	     instr(pos:pos) .EQ. tab         ) GOTO 300
	pos = pos + 1
	IF (pos .GT. ilen) GOTO 300
	GOTO 200
*
* Found end of item, store it.
  300	nvals = nvals + 1
	IF (nvals .LE. ndim) outary(nvals) = instr(start:pos-1)
	GOTO 100
*
* End of string
  900	RETURN
	END
