# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.eventgrid.aio import EventGridManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestEventGridManagementPartnerConfigurationsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(EventGridManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_partner_configurations_get(self, resource_group):
        response = await self.client.partner_configurations.get(
            resource_group_name=resource_group.name,
            api_version="2025-04-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_partner_configurations_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.partner_configurations.begin_create_or_update(
                resource_group_name=resource_group.name,
                partner_configuration_info={
                    "id": "str",
                    "location": "str",
                    "name": "str",
                    "partnerAuthorization": {
                        "authorizedPartnersList": [
                            {
                                "authorizationExpirationTimeInUtc": "2020-02-20 00:00:00",
                                "partnerName": "str",
                                "partnerRegistrationImmutableId": "str",
                            }
                        ],
                        "defaultMaximumExpirationTimeInDays": 0,
                    },
                    "provisioningState": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2025-04-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_partner_configurations_begin_delete(self, resource_group):
        response = await (
            await self.client.partner_configurations.begin_delete(
                resource_group_name=resource_group.name,
                api_version="2025-04-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_partner_configurations_begin_update(self, resource_group):
        response = await (
            await self.client.partner_configurations.begin_update(
                resource_group_name=resource_group.name,
                partner_configuration_update_parameters={
                    "defaultMaximumExpirationTimeInDays": 0,
                    "tags": {"str": "str"},
                },
                api_version="2025-04-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_partner_configurations_list_by_resource_group(self, resource_group):
        response = self.client.partner_configurations.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-04-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_partner_configurations_list_by_subscription(self, resource_group):
        response = self.client.partner_configurations.list_by_subscription(
            api_version="2025-04-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_partner_configurations_authorize_partner(self, resource_group):
        response = await self.client.partner_configurations.authorize_partner(
            resource_group_name=resource_group.name,
            partner_info={
                "authorizationExpirationTimeInUtc": "2020-02-20 00:00:00",
                "partnerName": "str",
                "partnerRegistrationImmutableId": "str",
            },
            api_version="2025-04-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_partner_configurations_unauthorize_partner(self, resource_group):
        response = await self.client.partner_configurations.unauthorize_partner(
            resource_group_name=resource_group.name,
            partner_info={
                "authorizationExpirationTimeInUtc": "2020-02-20 00:00:00",
                "partnerName": "str",
                "partnerRegistrationImmutableId": "str",
            },
            api_version="2025-04-01-preview",
        )

        # please add some check logic here by yourself
        # ...
