/////////////////////////////////////////////////////////////////////////////////////////////
// Copyright 2024 Garmin International, Inc.
// Licensed under the Flexible and Interoperable Data Transfer (FIT) Protocol License; you
// may not use this file except in compliance with the Flexible and Interoperable Data
// Transfer (FIT) Protocol License.
/////////////////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 21.158.0Release
// Tag = production/release/21.158.0-0-gc9428aa
/////////////////////////////////////////////////////////////////////////////////////////////


#if !defined(FIT_WORKOUT_STEP_MESG_HPP)
#define FIT_WORKOUT_STEP_MESG_HPP

#include "fit_mesg.hpp"

namespace fit
{

class WorkoutStepMesg : public Mesg
{
public:
    class FieldDefNum final
    {
    public:
       static const FIT_UINT8 MessageIndex = 254;
       static const FIT_UINT8 WktStepName = 0;
       static const FIT_UINT8 DurationType = 1;
       static const FIT_UINT8 DurationValue = 2;
       static const FIT_UINT8 TargetType = 3;
       static const FIT_UINT8 TargetValue = 4;
       static const FIT_UINT8 CustomTargetValueLow = 5;
       static const FIT_UINT8 CustomTargetValueHigh = 6;
       static const FIT_UINT8 Intensity = 7;
       static const FIT_UINT8 Notes = 8;
       static const FIT_UINT8 Equipment = 9;
       static const FIT_UINT8 ExerciseCategory = 10;
       static const FIT_UINT8 ExerciseName = 11;
       static const FIT_UINT8 ExerciseWeight = 12;
       static const FIT_UINT8 WeightDisplayUnit = 13;
       static const FIT_UINT8 SecondaryTargetType = 19;
       static const FIT_UINT8 SecondaryTargetValue = 20;
       static const FIT_UINT8 SecondaryCustomTargetValueLow = 21;
       static const FIT_UINT8 SecondaryCustomTargetValueHigh = 22;
       static const FIT_UINT8 Invalid = FIT_FIELD_NUM_INVALID;
    };

    WorkoutStepMesg(void) : Mesg(Profile::MESG_WORKOUT_STEP)
    {
    }

    WorkoutStepMesg(const Mesg &mesg) : Mesg(mesg)
    {
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of message_index field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMessageIndexValid() const
    {
        const Field* field = GetField(254);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns message_index field
    ///////////////////////////////////////////////////////////////////////
    FIT_MESSAGE_INDEX GetMessageIndex(void) const
    {
        return GetFieldUINT16Value(254, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set message_index field
    ///////////////////////////////////////////////////////////////////////
    void SetMessageIndex(FIT_MESSAGE_INDEX messageIndex)
    {
        SetFieldUINT16Value(254, messageIndex, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of wkt_step_name field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsWktStepNameValid() const
    {
        const Field* field = GetField(0);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns wkt_step_name field
    ///////////////////////////////////////////////////////////////////////
    FIT_WSTRING GetWktStepName(void) const
    {
        return GetFieldSTRINGValue(0, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set wkt_step_name field
    ///////////////////////////////////////////////////////////////////////
    void SetWktStepName(FIT_WSTRING wktStepName)
    {
        SetFieldSTRINGValue(0, wktStepName, 0);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of duration_type field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsDurationTypeValid() const
    {
        const Field* field = GetField(1);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns duration_type field
    ///////////////////////////////////////////////////////////////////////
    FIT_WKT_STEP_DURATION GetDurationType(void) const
    {
        return GetFieldENUMValue(1, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set duration_type field
    ///////////////////////////////////////////////////////////////////////
    void SetDurationType(FIT_WKT_STEP_DURATION durationType)
    {
        SetFieldENUMValue(1, durationType, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of duration_value field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsDurationValueValid() const
    {
        const Field* field = GetField(2);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns duration_value field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetDurationValue(void) const
    {
        return GetFieldUINT32Value(2, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set duration_value field
    ///////////////////////////////////////////////////////////////////////
    void SetDurationValue(FIT_UINT32 durationValue)
    {
        SetFieldUINT32Value(2, durationValue, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of duration_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsDurationTimeValid() const
    {
        const Field* field = GetField(2);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_TIME ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_TIME);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns duration_time field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetDurationTime(void) const
    {
        return GetFieldFLOAT32Value(2, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_TIME);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set duration_time field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetDurationTime(FIT_FLOAT32 durationTime)
    {
        SetFieldFLOAT32Value(2, durationTime, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_TIME);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of duration_distance field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsDurationDistanceValid() const
    {
        const Field* field = GetField(2);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_DISTANCE ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_DISTANCE);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns duration_distance field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetDurationDistance(void) const
    {
        return GetFieldFLOAT32Value(2, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_DISTANCE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set duration_distance field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetDurationDistance(FIT_FLOAT32 durationDistance)
    {
        SetFieldFLOAT32Value(2, durationDistance, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_DISTANCE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of duration_hr field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsDurationHrValid() const
    {
        const Field* field = GetField(2);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_HR ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_HR);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns duration_hr field
    // Units: % or bpm
    ///////////////////////////////////////////////////////////////////////
    FIT_WORKOUT_HR GetDurationHr(void) const
    {
        return GetFieldUINT32Value(2, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_HR);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set duration_hr field
    // Units: % or bpm
    ///////////////////////////////////////////////////////////////////////
    void SetDurationHr(FIT_WORKOUT_HR durationHr)
    {
        SetFieldUINT32Value(2, durationHr, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_HR);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of duration_calories field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsDurationCaloriesValid() const
    {
        const Field* field = GetField(2);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_CALORIES ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_CALORIES);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns duration_calories field
    // Units: calories
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetDurationCalories(void) const
    {
        return GetFieldUINT32Value(2, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_CALORIES);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set duration_calories field
    // Units: calories
    ///////////////////////////////////////////////////////////////////////
    void SetDurationCalories(FIT_UINT32 durationCalories)
    {
        SetFieldUINT32Value(2, durationCalories, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_CALORIES);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of duration_step field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsDurationStepValid() const
    {
        const Field* field = GetField(2);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_STEP ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_STEP);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns duration_step field
    // Comment: message_index of step to loop back to. Steps are assumed to be in the order by message_index. custom_name and intensity members are undefined for this duration type.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetDurationStep(void) const
    {
        return GetFieldUINT32Value(2, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_STEP);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set duration_step field
    // Comment: message_index of step to loop back to. Steps are assumed to be in the order by message_index. custom_name and intensity members are undefined for this duration type.
    ///////////////////////////////////////////////////////////////////////
    void SetDurationStep(FIT_UINT32 durationStep)
    {
        SetFieldUINT32Value(2, durationStep, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_STEP);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of duration_power field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsDurationPowerValid() const
    {
        const Field* field = GetField(2);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_POWER ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_POWER);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns duration_power field
    // Units: % or watts
    ///////////////////////////////////////////////////////////////////////
    FIT_WORKOUT_POWER GetDurationPower(void) const
    {
        return GetFieldUINT32Value(2, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_POWER);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set duration_power field
    // Units: % or watts
    ///////////////////////////////////////////////////////////////////////
    void SetDurationPower(FIT_WORKOUT_POWER durationPower)
    {
        SetFieldUINT32Value(2, durationPower, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_POWER);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of duration_reps field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsDurationRepsValid() const
    {
        const Field* field = GetField(2);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_REPS ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_REPS);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns duration_reps field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetDurationReps(void) const
    {
        return GetFieldUINT32Value(2, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_REPS);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set duration_reps field
    ///////////////////////////////////////////////////////////////////////
    void SetDurationReps(FIT_UINT32 durationReps)
    {
        SetFieldUINT32Value(2, durationReps, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_REPS);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of target_type field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTargetTypeValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns target_type field
    ///////////////////////////////////////////////////////////////////////
    FIT_WKT_STEP_TARGET GetTargetType(void) const
    {
        return GetFieldENUMValue(3, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set target_type field
    ///////////////////////////////////////////////////////////////////////
    void SetTargetType(FIT_WKT_STEP_TARGET targetType)
    {
        SetFieldENUMValue(3, targetType, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of target_value field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTargetValueValid() const
    {
        const Field* field = GetField(4);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns target_value field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetTargetValue(void) const
    {
        return GetFieldUINT32Value(4, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set target_value field
    ///////////////////////////////////////////////////////////////////////
    void SetTargetValue(FIT_UINT32 targetValue)
    {
        SetFieldUINT32Value(4, targetValue, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of target_speed_zone field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTargetSpeedZoneValid() const
    {
        const Field* field = GetField(4);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_SPEED_ZONE ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_SPEED_ZONE);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns target_speed_zone field
    // Comment: speed zone (1-10);Custom =0;
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetTargetSpeedZone(void) const
    {
        return GetFieldUINT32Value(4, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_SPEED_ZONE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set target_speed_zone field
    // Comment: speed zone (1-10);Custom =0;
    ///////////////////////////////////////////////////////////////////////
    void SetTargetSpeedZone(FIT_UINT32 targetSpeedZone)
    {
        SetFieldUINT32Value(4, targetSpeedZone, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_SPEED_ZONE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of target_hr_zone field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTargetHrZoneValid() const
    {
        const Field* field = GetField(4);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_HR_ZONE ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_HR_ZONE);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns target_hr_zone field
    // Comment: hr zone (1-5);Custom =0;
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetTargetHrZone(void) const
    {
        return GetFieldUINT32Value(4, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_HR_ZONE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set target_hr_zone field
    // Comment: hr zone (1-5);Custom =0;
    ///////////////////////////////////////////////////////////////////////
    void SetTargetHrZone(FIT_UINT32 targetHrZone)
    {
        SetFieldUINT32Value(4, targetHrZone, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_HR_ZONE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of target_cadence_zone field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTargetCadenceZoneValid() const
    {
        const Field* field = GetField(4);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_CADENCE_ZONE ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_CADENCE_ZONE);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns target_cadence_zone field
    // Comment: Zone (1-?); Custom = 0;
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetTargetCadenceZone(void) const
    {
        return GetFieldUINT32Value(4, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_CADENCE_ZONE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set target_cadence_zone field
    // Comment: Zone (1-?); Custom = 0;
    ///////////////////////////////////////////////////////////////////////
    void SetTargetCadenceZone(FIT_UINT32 targetCadenceZone)
    {
        SetFieldUINT32Value(4, targetCadenceZone, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_CADENCE_ZONE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of target_power_zone field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTargetPowerZoneValid() const
    {
        const Field* field = GetField(4);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_POWER_ZONE ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_POWER_ZONE);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns target_power_zone field
    // Comment: Power Zone ( 1-7); Custom = 0;
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetTargetPowerZone(void) const
    {
        return GetFieldUINT32Value(4, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_POWER_ZONE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set target_power_zone field
    // Comment: Power Zone ( 1-7); Custom = 0;
    ///////////////////////////////////////////////////////////////////////
    void SetTargetPowerZone(FIT_UINT32 targetPowerZone)
    {
        SetFieldUINT32Value(4, targetPowerZone, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_POWER_ZONE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of repeat_steps field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsRepeatStepsValid() const
    {
        const Field* field = GetField(4);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_STEPS ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_STEPS);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns repeat_steps field
    // Comment: # of repetitions
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetRepeatSteps(void) const
    {
        return GetFieldUINT32Value(4, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_STEPS);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set repeat_steps field
    // Comment: # of repetitions
    ///////////////////////////////////////////////////////////////////////
    void SetRepeatSteps(FIT_UINT32 repeatSteps)
    {
        SetFieldUINT32Value(4, repeatSteps, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_STEPS);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of repeat_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsRepeatTimeValid() const
    {
        const Field* field = GetField(4);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_TIME ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_TIME);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns repeat_time field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetRepeatTime(void) const
    {
        return GetFieldFLOAT32Value(4, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_TIME);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set repeat_time field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetRepeatTime(FIT_FLOAT32 repeatTime)
    {
        SetFieldFLOAT32Value(4, repeatTime, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_TIME);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of repeat_distance field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsRepeatDistanceValid() const
    {
        const Field* field = GetField(4);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_DISTANCE ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_DISTANCE);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns repeat_distance field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetRepeatDistance(void) const
    {
        return GetFieldFLOAT32Value(4, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_DISTANCE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set repeat_distance field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetRepeatDistance(FIT_FLOAT32 repeatDistance)
    {
        SetFieldFLOAT32Value(4, repeatDistance, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_DISTANCE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of repeat_calories field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsRepeatCaloriesValid() const
    {
        const Field* field = GetField(4);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_CALORIES ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_CALORIES);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns repeat_calories field
    // Units: calories
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetRepeatCalories(void) const
    {
        return GetFieldUINT32Value(4, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_CALORIES);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set repeat_calories field
    // Units: calories
    ///////////////////////////////////////////////////////////////////////
    void SetRepeatCalories(FIT_UINT32 repeatCalories)
    {
        SetFieldUINT32Value(4, repeatCalories, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_CALORIES);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of repeat_hr field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsRepeatHrValid() const
    {
        const Field* field = GetField(4);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_HR ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_HR);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns repeat_hr field
    // Units: % or bpm
    ///////////////////////////////////////////////////////////////////////
    FIT_WORKOUT_HR GetRepeatHr(void) const
    {
        return GetFieldUINT32Value(4, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_HR);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set repeat_hr field
    // Units: % or bpm
    ///////////////////////////////////////////////////////////////////////
    void SetRepeatHr(FIT_WORKOUT_HR repeatHr)
    {
        SetFieldUINT32Value(4, repeatHr, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_HR);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of repeat_power field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsRepeatPowerValid() const
    {
        const Field* field = GetField(4);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_POWER ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_POWER);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns repeat_power field
    // Units: % or watts
    ///////////////////////////////////////////////////////////////////////
    FIT_WORKOUT_POWER GetRepeatPower(void) const
    {
        return GetFieldUINT32Value(4, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_POWER);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set repeat_power field
    // Units: % or watts
    ///////////////////////////////////////////////////////////////////////
    void SetRepeatPower(FIT_WORKOUT_POWER repeatPower)
    {
        SetFieldUINT32Value(4, repeatPower, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_POWER);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of target_stroke_type field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTargetStrokeTypeValid() const
    {
        const Field* field = GetField(4);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_STROKE_TYPE ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_STROKE_TYPE);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns target_stroke_type field
    ///////////////////////////////////////////////////////////////////////
    FIT_SWIM_STROKE GetTargetStrokeType(void) const
    {
        return GetFieldENUMValue(4, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_STROKE_TYPE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set target_stroke_type field
    ///////////////////////////////////////////////////////////////////////
    void SetTargetStrokeType(FIT_SWIM_STROKE targetStrokeType)
    {
        SetFieldENUMValue(4, targetStrokeType, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_STROKE_TYPE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of custom_target_value_low field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCustomTargetValueLowValid() const
    {
        const Field* field = GetField(5);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns custom_target_value_low field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetCustomTargetValueLow(void) const
    {
        return GetFieldUINT32Value(5, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set custom_target_value_low field
    ///////////////////////////////////////////////////////////////////////
    void SetCustomTargetValueLow(FIT_UINT32 customTargetValueLow)
    {
        SetFieldUINT32Value(5, customTargetValueLow, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of custom_target_speed_low field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCustomTargetSpeedLowValid() const
    {
        const Field* field = GetField(5);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_CUSTOM_TARGET_SPEED_LOW ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_CUSTOM_TARGET_SPEED_LOW);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns custom_target_speed_low field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetCustomTargetSpeedLow(void) const
    {
        return GetFieldFLOAT32Value(5, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_CUSTOM_TARGET_SPEED_LOW);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set custom_target_speed_low field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetCustomTargetSpeedLow(FIT_FLOAT32 customTargetSpeedLow)
    {
        SetFieldFLOAT32Value(5, customTargetSpeedLow, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_CUSTOM_TARGET_SPEED_LOW);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of custom_target_heart_rate_low field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCustomTargetHeartRateLowValid() const
    {
        const Field* field = GetField(5);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_CUSTOM_TARGET_HEART_RATE_LOW ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_CUSTOM_TARGET_HEART_RATE_LOW);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns custom_target_heart_rate_low field
    // Units: % or bpm
    ///////////////////////////////////////////////////////////////////////
    FIT_WORKOUT_HR GetCustomTargetHeartRateLow(void) const
    {
        return GetFieldUINT32Value(5, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_CUSTOM_TARGET_HEART_RATE_LOW);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set custom_target_heart_rate_low field
    // Units: % or bpm
    ///////////////////////////////////////////////////////////////////////
    void SetCustomTargetHeartRateLow(FIT_WORKOUT_HR customTargetHeartRateLow)
    {
        SetFieldUINT32Value(5, customTargetHeartRateLow, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_CUSTOM_TARGET_HEART_RATE_LOW);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of custom_target_cadence_low field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCustomTargetCadenceLowValid() const
    {
        const Field* field = GetField(5);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_CUSTOM_TARGET_CADENCE_LOW ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_CUSTOM_TARGET_CADENCE_LOW);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns custom_target_cadence_low field
    // Units: rpm
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetCustomTargetCadenceLow(void) const
    {
        return GetFieldUINT32Value(5, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_CUSTOM_TARGET_CADENCE_LOW);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set custom_target_cadence_low field
    // Units: rpm
    ///////////////////////////////////////////////////////////////////////
    void SetCustomTargetCadenceLow(FIT_UINT32 customTargetCadenceLow)
    {
        SetFieldUINT32Value(5, customTargetCadenceLow, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_CUSTOM_TARGET_CADENCE_LOW);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of custom_target_power_low field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCustomTargetPowerLowValid() const
    {
        const Field* field = GetField(5);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_CUSTOM_TARGET_POWER_LOW ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_CUSTOM_TARGET_POWER_LOW);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns custom_target_power_low field
    // Units: % or watts
    ///////////////////////////////////////////////////////////////////////
    FIT_WORKOUT_POWER GetCustomTargetPowerLow(void) const
    {
        return GetFieldUINT32Value(5, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_CUSTOM_TARGET_POWER_LOW);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set custom_target_power_low field
    // Units: % or watts
    ///////////////////////////////////////////////////////////////////////
    void SetCustomTargetPowerLow(FIT_WORKOUT_POWER customTargetPowerLow)
    {
        SetFieldUINT32Value(5, customTargetPowerLow, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_CUSTOM_TARGET_POWER_LOW);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of custom_target_value_high field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCustomTargetValueHighValid() const
    {
        const Field* field = GetField(6);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns custom_target_value_high field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetCustomTargetValueHigh(void) const
    {
        return GetFieldUINT32Value(6, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set custom_target_value_high field
    ///////////////////////////////////////////////////////////////////////
    void SetCustomTargetValueHigh(FIT_UINT32 customTargetValueHigh)
    {
        SetFieldUINT32Value(6, customTargetValueHigh, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of custom_target_speed_high field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCustomTargetSpeedHighValid() const
    {
        const Field* field = GetField(6);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_CUSTOM_TARGET_SPEED_HIGH ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_CUSTOM_TARGET_SPEED_HIGH);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns custom_target_speed_high field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetCustomTargetSpeedHigh(void) const
    {
        return GetFieldFLOAT32Value(6, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_CUSTOM_TARGET_SPEED_HIGH);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set custom_target_speed_high field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetCustomTargetSpeedHigh(FIT_FLOAT32 customTargetSpeedHigh)
    {
        SetFieldFLOAT32Value(6, customTargetSpeedHigh, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_CUSTOM_TARGET_SPEED_HIGH);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of custom_target_heart_rate_high field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCustomTargetHeartRateHighValid() const
    {
        const Field* field = GetField(6);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_CUSTOM_TARGET_HEART_RATE_HIGH ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_CUSTOM_TARGET_HEART_RATE_HIGH);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns custom_target_heart_rate_high field
    // Units: % or bpm
    ///////////////////////////////////////////////////////////////////////
    FIT_WORKOUT_HR GetCustomTargetHeartRateHigh(void) const
    {
        return GetFieldUINT32Value(6, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_CUSTOM_TARGET_HEART_RATE_HIGH);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set custom_target_heart_rate_high field
    // Units: % or bpm
    ///////////////////////////////////////////////////////////////////////
    void SetCustomTargetHeartRateHigh(FIT_WORKOUT_HR customTargetHeartRateHigh)
    {
        SetFieldUINT32Value(6, customTargetHeartRateHigh, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_CUSTOM_TARGET_HEART_RATE_HIGH);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of custom_target_cadence_high field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCustomTargetCadenceHighValid() const
    {
        const Field* field = GetField(6);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_CUSTOM_TARGET_CADENCE_HIGH ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_CUSTOM_TARGET_CADENCE_HIGH);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns custom_target_cadence_high field
    // Units: rpm
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetCustomTargetCadenceHigh(void) const
    {
        return GetFieldUINT32Value(6, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_CUSTOM_TARGET_CADENCE_HIGH);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set custom_target_cadence_high field
    // Units: rpm
    ///////////////////////////////////////////////////////////////////////
    void SetCustomTargetCadenceHigh(FIT_UINT32 customTargetCadenceHigh)
    {
        SetFieldUINT32Value(6, customTargetCadenceHigh, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_CUSTOM_TARGET_CADENCE_HIGH);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of custom_target_power_high field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCustomTargetPowerHighValid() const
    {
        const Field* field = GetField(6);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_CUSTOM_TARGET_POWER_HIGH ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_CUSTOM_TARGET_POWER_HIGH);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns custom_target_power_high field
    // Units: % or watts
    ///////////////////////////////////////////////////////////////////////
    FIT_WORKOUT_POWER GetCustomTargetPowerHigh(void) const
    {
        return GetFieldUINT32Value(6, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_CUSTOM_TARGET_POWER_HIGH);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set custom_target_power_high field
    // Units: % or watts
    ///////////////////////////////////////////////////////////////////////
    void SetCustomTargetPowerHigh(FIT_WORKOUT_POWER customTargetPowerHigh)
    {
        SetFieldUINT32Value(6, customTargetPowerHigh, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_CUSTOM_TARGET_POWER_HIGH);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of intensity field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsIntensityValid() const
    {
        const Field* field = GetField(7);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns intensity field
    ///////////////////////////////////////////////////////////////////////
    FIT_INTENSITY GetIntensity(void) const
    {
        return GetFieldENUMValue(7, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set intensity field
    ///////////////////////////////////////////////////////////////////////
    void SetIntensity(FIT_INTENSITY intensity)
    {
        SetFieldENUMValue(7, intensity, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of notes field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsNotesValid() const
    {
        const Field* field = GetField(8);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns notes field
    ///////////////////////////////////////////////////////////////////////
    FIT_WSTRING GetNotes(void) const
    {
        return GetFieldSTRINGValue(8, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set notes field
    ///////////////////////////////////////////////////////////////////////
    void SetNotes(FIT_WSTRING notes)
    {
        SetFieldSTRINGValue(8, notes, 0);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of equipment field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEquipmentValid() const
    {
        const Field* field = GetField(9);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns equipment field
    ///////////////////////////////////////////////////////////////////////
    FIT_WORKOUT_EQUIPMENT GetEquipment(void) const
    {
        return GetFieldENUMValue(9, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set equipment field
    ///////////////////////////////////////////////////////////////////////
    void SetEquipment(FIT_WORKOUT_EQUIPMENT equipment)
    {
        SetFieldENUMValue(9, equipment, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of exercise_category field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsExerciseCategoryValid() const
    {
        const Field* field = GetField(10);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns exercise_category field
    ///////////////////////////////////////////////////////////////////////
    FIT_EXERCISE_CATEGORY GetExerciseCategory(void) const
    {
        return GetFieldUINT16Value(10, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set exercise_category field
    ///////////////////////////////////////////////////////////////////////
    void SetExerciseCategory(FIT_EXERCISE_CATEGORY exerciseCategory)
    {
        SetFieldUINT16Value(10, exerciseCategory, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of exercise_name field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsExerciseNameValid() const
    {
        const Field* field = GetField(11);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns exercise_name field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetExerciseName(void) const
    {
        return GetFieldUINT16Value(11, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set exercise_name field
    ///////////////////////////////////////////////////////////////////////
    void SetExerciseName(FIT_UINT16 exerciseName)
    {
        SetFieldUINT16Value(11, exerciseName, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of exercise_weight field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsExerciseWeightValid() const
    {
        const Field* field = GetField(12);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns exercise_weight field
    // Units: kg
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetExerciseWeight(void) const
    {
        return GetFieldFLOAT32Value(12, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set exercise_weight field
    // Units: kg
    ///////////////////////////////////////////////////////////////////////
    void SetExerciseWeight(FIT_FLOAT32 exerciseWeight)
    {
        SetFieldFLOAT32Value(12, exerciseWeight, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of weight_display_unit field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsWeightDisplayUnitValid() const
    {
        const Field* field = GetField(13);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns weight_display_unit field
    ///////////////////////////////////////////////////////////////////////
    FIT_FIT_BASE_UNIT GetWeightDisplayUnit(void) const
    {
        return GetFieldUINT16Value(13, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set weight_display_unit field
    ///////////////////////////////////////////////////////////////////////
    void SetWeightDisplayUnit(FIT_FIT_BASE_UNIT weightDisplayUnit)
    {
        SetFieldUINT16Value(13, weightDisplayUnit, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of secondary_target_type field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSecondaryTargetTypeValid() const
    {
        const Field* field = GetField(19);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns secondary_target_type field
    ///////////////////////////////////////////////////////////////////////
    FIT_WKT_STEP_TARGET GetSecondaryTargetType(void) const
    {
        return GetFieldENUMValue(19, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set secondary_target_type field
    ///////////////////////////////////////////////////////////////////////
    void SetSecondaryTargetType(FIT_WKT_STEP_TARGET secondaryTargetType)
    {
        SetFieldENUMValue(19, secondaryTargetType, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of secondary_target_value field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSecondaryTargetValueValid() const
    {
        const Field* field = GetField(20);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns secondary_target_value field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetSecondaryTargetValue(void) const
    {
        return GetFieldUINT32Value(20, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set secondary_target_value field
    ///////////////////////////////////////////////////////////////////////
    void SetSecondaryTargetValue(FIT_UINT32 secondaryTargetValue)
    {
        SetFieldUINT32Value(20, secondaryTargetValue, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of secondary_target_speed_zone field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSecondaryTargetSpeedZoneValid() const
    {
        const Field* field = GetField(20);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SECONDARY_TARGET_SPEED_ZONE ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SECONDARY_TARGET_SPEED_ZONE);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns secondary_target_speed_zone field
    // Comment: speed zone (1-10);Custom =0;
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetSecondaryTargetSpeedZone(void) const
    {
        return GetFieldUINT32Value(20, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SECONDARY_TARGET_SPEED_ZONE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set secondary_target_speed_zone field
    // Comment: speed zone (1-10);Custom =0;
    ///////////////////////////////////////////////////////////////////////
    void SetSecondaryTargetSpeedZone(FIT_UINT32 secondaryTargetSpeedZone)
    {
        SetFieldUINT32Value(20, secondaryTargetSpeedZone, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SECONDARY_TARGET_SPEED_ZONE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of secondary_target_hr_zone field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSecondaryTargetHrZoneValid() const
    {
        const Field* field = GetField(20);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SECONDARY_TARGET_HR_ZONE ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SECONDARY_TARGET_HR_ZONE);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns secondary_target_hr_zone field
    // Comment: hr zone (1-5);Custom =0;
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetSecondaryTargetHrZone(void) const
    {
        return GetFieldUINT32Value(20, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SECONDARY_TARGET_HR_ZONE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set secondary_target_hr_zone field
    // Comment: hr zone (1-5);Custom =0;
    ///////////////////////////////////////////////////////////////////////
    void SetSecondaryTargetHrZone(FIT_UINT32 secondaryTargetHrZone)
    {
        SetFieldUINT32Value(20, secondaryTargetHrZone, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SECONDARY_TARGET_HR_ZONE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of secondary_target_cadence_zone field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSecondaryTargetCadenceZoneValid() const
    {
        const Field* field = GetField(20);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SECONDARY_TARGET_CADENCE_ZONE ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SECONDARY_TARGET_CADENCE_ZONE);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns secondary_target_cadence_zone field
    // Comment: Zone (1-?); Custom = 0;
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetSecondaryTargetCadenceZone(void) const
    {
        return GetFieldUINT32Value(20, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SECONDARY_TARGET_CADENCE_ZONE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set secondary_target_cadence_zone field
    // Comment: Zone (1-?); Custom = 0;
    ///////////////////////////////////////////////////////////////////////
    void SetSecondaryTargetCadenceZone(FIT_UINT32 secondaryTargetCadenceZone)
    {
        SetFieldUINT32Value(20, secondaryTargetCadenceZone, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SECONDARY_TARGET_CADENCE_ZONE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of secondary_target_power_zone field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSecondaryTargetPowerZoneValid() const
    {
        const Field* field = GetField(20);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SECONDARY_TARGET_POWER_ZONE ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SECONDARY_TARGET_POWER_ZONE);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns secondary_target_power_zone field
    // Comment: Power Zone ( 1-7); Custom = 0;
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetSecondaryTargetPowerZone(void) const
    {
        return GetFieldUINT32Value(20, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SECONDARY_TARGET_POWER_ZONE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set secondary_target_power_zone field
    // Comment: Power Zone ( 1-7); Custom = 0;
    ///////////////////////////////////////////////////////////////////////
    void SetSecondaryTargetPowerZone(FIT_UINT32 secondaryTargetPowerZone)
    {
        SetFieldUINT32Value(20, secondaryTargetPowerZone, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SECONDARY_TARGET_POWER_ZONE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of secondary_target_stroke_type field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSecondaryTargetStrokeTypeValid() const
    {
        const Field* field = GetField(20);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SECONDARY_TARGET_STROKE_TYPE ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SECONDARY_TARGET_STROKE_TYPE);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns secondary_target_stroke_type field
    ///////////////////////////////////////////////////////////////////////
    FIT_SWIM_STROKE GetSecondaryTargetStrokeType(void) const
    {
        return GetFieldENUMValue(20, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SECONDARY_TARGET_STROKE_TYPE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set secondary_target_stroke_type field
    ///////////////////////////////////////////////////////////////////////
    void SetSecondaryTargetStrokeType(FIT_SWIM_STROKE secondaryTargetStrokeType)
    {
        SetFieldENUMValue(20, secondaryTargetStrokeType, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SECONDARY_TARGET_STROKE_TYPE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of secondary_custom_target_value_low field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSecondaryCustomTargetValueLowValid() const
    {
        const Field* field = GetField(21);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns secondary_custom_target_value_low field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetSecondaryCustomTargetValueLow(void) const
    {
        return GetFieldUINT32Value(21, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set secondary_custom_target_value_low field
    ///////////////////////////////////////////////////////////////////////
    void SetSecondaryCustomTargetValueLow(FIT_UINT32 secondaryCustomTargetValueLow)
    {
        SetFieldUINT32Value(21, secondaryCustomTargetValueLow, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of secondary_custom_target_speed_low field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSecondaryCustomTargetSpeedLowValid() const
    {
        const Field* field = GetField(21);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_LOW_FIELD_SECONDARY_CUSTOM_TARGET_SPEED_LOW ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_LOW_FIELD_SECONDARY_CUSTOM_TARGET_SPEED_LOW);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns secondary_custom_target_speed_low field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetSecondaryCustomTargetSpeedLow(void) const
    {
        return GetFieldFLOAT32Value(21, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_LOW_FIELD_SECONDARY_CUSTOM_TARGET_SPEED_LOW);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set secondary_custom_target_speed_low field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetSecondaryCustomTargetSpeedLow(FIT_FLOAT32 secondaryCustomTargetSpeedLow)
    {
        SetFieldFLOAT32Value(21, secondaryCustomTargetSpeedLow, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_LOW_FIELD_SECONDARY_CUSTOM_TARGET_SPEED_LOW);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of secondary_custom_target_heart_rate_low field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSecondaryCustomTargetHeartRateLowValid() const
    {
        const Field* field = GetField(21);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_LOW_FIELD_SECONDARY_CUSTOM_TARGET_HEART_RATE_LOW ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_LOW_FIELD_SECONDARY_CUSTOM_TARGET_HEART_RATE_LOW);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns secondary_custom_target_heart_rate_low field
    // Units: % or bpm
    ///////////////////////////////////////////////////////////////////////
    FIT_WORKOUT_HR GetSecondaryCustomTargetHeartRateLow(void) const
    {
        return GetFieldUINT32Value(21, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_LOW_FIELD_SECONDARY_CUSTOM_TARGET_HEART_RATE_LOW);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set secondary_custom_target_heart_rate_low field
    // Units: % or bpm
    ///////////////////////////////////////////////////////////////////////
    void SetSecondaryCustomTargetHeartRateLow(FIT_WORKOUT_HR secondaryCustomTargetHeartRateLow)
    {
        SetFieldUINT32Value(21, secondaryCustomTargetHeartRateLow, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_LOW_FIELD_SECONDARY_CUSTOM_TARGET_HEART_RATE_LOW);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of secondary_custom_target_cadence_low field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSecondaryCustomTargetCadenceLowValid() const
    {
        const Field* field = GetField(21);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_LOW_FIELD_SECONDARY_CUSTOM_TARGET_CADENCE_LOW ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_LOW_FIELD_SECONDARY_CUSTOM_TARGET_CADENCE_LOW);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns secondary_custom_target_cadence_low field
    // Units: rpm
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetSecondaryCustomTargetCadenceLow(void) const
    {
        return GetFieldUINT32Value(21, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_LOW_FIELD_SECONDARY_CUSTOM_TARGET_CADENCE_LOW);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set secondary_custom_target_cadence_low field
    // Units: rpm
    ///////////////////////////////////////////////////////////////////////
    void SetSecondaryCustomTargetCadenceLow(FIT_UINT32 secondaryCustomTargetCadenceLow)
    {
        SetFieldUINT32Value(21, secondaryCustomTargetCadenceLow, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_LOW_FIELD_SECONDARY_CUSTOM_TARGET_CADENCE_LOW);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of secondary_custom_target_power_low field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSecondaryCustomTargetPowerLowValid() const
    {
        const Field* field = GetField(21);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_LOW_FIELD_SECONDARY_CUSTOM_TARGET_POWER_LOW ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_LOW_FIELD_SECONDARY_CUSTOM_TARGET_POWER_LOW);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns secondary_custom_target_power_low field
    // Units: % or watts
    ///////////////////////////////////////////////////////////////////////
    FIT_WORKOUT_POWER GetSecondaryCustomTargetPowerLow(void) const
    {
        return GetFieldUINT32Value(21, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_LOW_FIELD_SECONDARY_CUSTOM_TARGET_POWER_LOW);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set secondary_custom_target_power_low field
    // Units: % or watts
    ///////////////////////////////////////////////////////////////////////
    void SetSecondaryCustomTargetPowerLow(FIT_WORKOUT_POWER secondaryCustomTargetPowerLow)
    {
        SetFieldUINT32Value(21, secondaryCustomTargetPowerLow, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_LOW_FIELD_SECONDARY_CUSTOM_TARGET_POWER_LOW);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of secondary_custom_target_value_high field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSecondaryCustomTargetValueHighValid() const
    {
        const Field* field = GetField(22);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns secondary_custom_target_value_high field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetSecondaryCustomTargetValueHigh(void) const
    {
        return GetFieldUINT32Value(22, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set secondary_custom_target_value_high field
    ///////////////////////////////////////////////////////////////////////
    void SetSecondaryCustomTargetValueHigh(FIT_UINT32 secondaryCustomTargetValueHigh)
    {
        SetFieldUINT32Value(22, secondaryCustomTargetValueHigh, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of secondary_custom_target_speed_high field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSecondaryCustomTargetSpeedHighValid() const
    {
        const Field* field = GetField(22);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_HIGH_FIELD_SECONDARY_CUSTOM_TARGET_SPEED_HIGH ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_HIGH_FIELD_SECONDARY_CUSTOM_TARGET_SPEED_HIGH);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns secondary_custom_target_speed_high field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetSecondaryCustomTargetSpeedHigh(void) const
    {
        return GetFieldFLOAT32Value(22, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_HIGH_FIELD_SECONDARY_CUSTOM_TARGET_SPEED_HIGH);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set secondary_custom_target_speed_high field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetSecondaryCustomTargetSpeedHigh(FIT_FLOAT32 secondaryCustomTargetSpeedHigh)
    {
        SetFieldFLOAT32Value(22, secondaryCustomTargetSpeedHigh, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_HIGH_FIELD_SECONDARY_CUSTOM_TARGET_SPEED_HIGH);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of secondary_custom_target_heart_rate_high field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSecondaryCustomTargetHeartRateHighValid() const
    {
        const Field* field = GetField(22);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_HIGH_FIELD_SECONDARY_CUSTOM_TARGET_HEART_RATE_HIGH ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_HIGH_FIELD_SECONDARY_CUSTOM_TARGET_HEART_RATE_HIGH);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns secondary_custom_target_heart_rate_high field
    // Units: % or bpm
    ///////////////////////////////////////////////////////////////////////
    FIT_WORKOUT_HR GetSecondaryCustomTargetHeartRateHigh(void) const
    {
        return GetFieldUINT32Value(22, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_HIGH_FIELD_SECONDARY_CUSTOM_TARGET_HEART_RATE_HIGH);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set secondary_custom_target_heart_rate_high field
    // Units: % or bpm
    ///////////////////////////////////////////////////////////////////////
    void SetSecondaryCustomTargetHeartRateHigh(FIT_WORKOUT_HR secondaryCustomTargetHeartRateHigh)
    {
        SetFieldUINT32Value(22, secondaryCustomTargetHeartRateHigh, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_HIGH_FIELD_SECONDARY_CUSTOM_TARGET_HEART_RATE_HIGH);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of secondary_custom_target_cadence_high field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSecondaryCustomTargetCadenceHighValid() const
    {
        const Field* field = GetField(22);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_HIGH_FIELD_SECONDARY_CUSTOM_TARGET_CADENCE_HIGH ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_HIGH_FIELD_SECONDARY_CUSTOM_TARGET_CADENCE_HIGH);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns secondary_custom_target_cadence_high field
    // Units: rpm
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetSecondaryCustomTargetCadenceHigh(void) const
    {
        return GetFieldUINT32Value(22, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_HIGH_FIELD_SECONDARY_CUSTOM_TARGET_CADENCE_HIGH);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set secondary_custom_target_cadence_high field
    // Units: rpm
    ///////////////////////////////////////////////////////////////////////
    void SetSecondaryCustomTargetCadenceHigh(FIT_UINT32 secondaryCustomTargetCadenceHigh)
    {
        SetFieldUINT32Value(22, secondaryCustomTargetCadenceHigh, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_HIGH_FIELD_SECONDARY_CUSTOM_TARGET_CADENCE_HIGH);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of secondary_custom_target_power_high field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSecondaryCustomTargetPowerHighValid() const
    {
        const Field* field = GetField(22);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_HIGH_FIELD_SECONDARY_CUSTOM_TARGET_POWER_HIGH ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_HIGH_FIELD_SECONDARY_CUSTOM_TARGET_POWER_HIGH);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns secondary_custom_target_power_high field
    // Units: % or watts
    ///////////////////////////////////////////////////////////////////////
    FIT_WORKOUT_POWER GetSecondaryCustomTargetPowerHigh(void) const
    {
        return GetFieldUINT32Value(22, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_HIGH_FIELD_SECONDARY_CUSTOM_TARGET_POWER_HIGH);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set secondary_custom_target_power_high field
    // Units: % or watts
    ///////////////////////////////////////////////////////////////////////
    void SetSecondaryCustomTargetPowerHigh(FIT_WORKOUT_POWER secondaryCustomTargetPowerHigh)
    {
        SetFieldUINT32Value(22, secondaryCustomTargetPowerHigh, 0, (FIT_UINT16) Profile::WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_HIGH_FIELD_SECONDARY_CUSTOM_TARGET_POWER_HIGH);
    }

};

} // namespace fit

#endif // !defined(FIT_WORKOUT_STEP_MESG_HPP)
