% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logNormCounts.R
\name{logNormCounts}
\alias{logNormCounts}
\alias{logNormCounts,SummarizedExperiment-method}
\alias{logNormCounts,SingleCellExperiment-method}
\title{Compute log-normalized expression values}
\usage{
logNormCounts(x, ...)

\S4method{logNormCounts}{SummarizedExperiment}(
  x,
  size.factors = NULL,
  log = TRUE,
  pseudo.count = 1,
  center.size.factors = TRUE,
  ...,
  assay.type = "counts",
  name = NULL,
  BPPARAM = SerialParam(),
  size_factors = NULL,
  pseudo_count = NULL,
  center_size_factors = NULL,
  exprs_values = NULL
)

\S4method{logNormCounts}{SingleCellExperiment}(
  x,
  size.factors = NULL,
  log = TRUE,
  pseudo.count = 1,
  center.size.factors = TRUE,
  ...,
  assay.type = "counts",
  use.altexps = FALSE,
  name = NULL,
  BPPARAM = SerialParam(),
  size_factors = NULL,
  pseudo_count = NULL,
  center_size_factors = NULL,
  exprs_values = NULL,
  use_altexps = NULL
)
}
\arguments{
\item{x}{A \linkS4class{SingleCellExperiment} or \linkS4class{SummarizedExperiment} object containing a count matrix.}

\item{...}{For the generic, additional arguments passed to specific methods. 

For the methods, additional arguments passed to \code{\link{normalizeCounts}}.}

\item{size.factors}{A numeric vector of cell-specific size factors.
Alternatively \code{NULL}, in which case the size factors are extracted or computed from \code{x}.}

\item{log}{Logical scalar indicating whether normalized values should be log2-transformed.}

\item{pseudo.count}{Numeric scalar specifying the pseudo-count to add when log-transforming expression values.}

\item{center.size.factors}{Logical scalar indicating whether size factors should be centered at unity before being used.}

\item{assay.type}{A string or integer scalar specifying the assay of \code{x} containing the count matrix.}

\item{name}{String containing an assay name for storing the output normalized values.
Defaults to \code{"logcounts"} when \code{log=TRUE} and \code{"normcounts"} otherwise.}

\item{BPPARAM}{A \linkS4class{BiocParallelParam} object specifying how library size factor calculations should be parallelized.
Only used if \code{size.factors} is not specified.}

\item{size_factors}{Soft-deprecated equivalents to the arguments described previously.}

\item{pseudo_count}{Soft-deprecated equivalents to the arguments described previously.}

\item{center_size_factors}{Soft-deprecated equivalents to the arguments described previously.}

\item{exprs_values}{Soft-deprecated equivalents to the arguments described previously.}

\item{use.altexps}{Logical scalar indicating whether normalization should be performed for alternative experiments in \code{x}.

Alternatively, a character vector specifying the names of the alternative experiments to be normalized.

Alternatively \code{NULL}, in which case no calculations are performed on the alternative experiments.}

\item{use_altexps}{Soft-deprecated equivalent to the argument above.}
}
\value{
\code{x} is returned containing the (log-)normalized expression values in an additional assay named as \code{name}.

If \code{x} is a \linkS4class{SingleCellExperiment}, the size factors used for normalization are stored in \code{\link{sizeFactors}}.
These are centered if \code{center.size.factors=TRUE}.

If \code{x} contains alternative experiments and \code{use.altexps=TRUE},  each of the alternative experiments in \code{x} will also contain an additional assay.
This can be limited to particular \code{\link{altExps}} entries by specifying them in \code{use.altexps}.
}
\description{
Compute log-transformed normalized expression values from a count matrix in a \linkS4class{SingleCellExperiment} object.
}
\details{
This function is a convenience wrapper around \code{\link{normalizeCounts}}.
It returns a \linkS4class{SingleCellExperiment} or \linkS4class{SummarizedExperiment} containing the normalized values in a separate assay.
This makes it easier to perform normalization by avoiding book-keeping errors during a long analysis workflow.

If \code{x} is a \linkS4class{SingleCellExperiment} that contains alternative Experiments, normalized values can be computed and stored within each alternative experiment by setting \code{use.altexps} appropriately.
By default, \code{use.altexps=FALSE} to avoid problems from attempting to library size-normalize alternative experiments that have zero total counts for some cells.

If \code{size.factors=NULL}, size factors are obtained following the rules in \code{\link{normalizeCounts}}.
This is done independently for the main and alternative Experiments when \code{use.altexps} is specified,
i.e. no information is shared between Experiments by default.
However, if \code{size.factors} is supplied, it will override any size factors available in any Experiment.
}
\examples{
example_sce <- mockSCE()

# Standard library size normalization:
example_sce2 <- logNormCounts(example_sce)
assayNames(example_sce2)
logcounts(example_sce2)[1:5,1:5]

# Without logging, the assay is 'normcounts':
example_sce2 <- logNormCounts(example_sce, log=FALSE)
assayNames(example_sce2)
normcounts(example_sce2)[1:5,1:5]

# Pre-loading with size factors:
example_sce2 <- computeMedianFactors(example_sce)
example_sce2 <- logNormCounts(example_sce2)
logcounts(example_sce2)[1:5,1:5]

# Also normalizing the alternative experiments:
example_sce2 <- logNormCounts(example_sce, use.altexps="Spikes")
logcounts(altExp(example_sce2))[1:5,1:5]

}
\seealso{
\code{\link{normalizeCounts}}, which is used to compute the normalized expression values.
}
\author{
Aaron Lun, based on code by Davis McCarthy
}
