% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylation.R
\name{dmc.non.parametric.se}
\alias{dmc.non.parametric.se}
\title{Calculate pvalues}
\usage{
dmc.non.parametric.se(
  data,
  groupCol = NULL,
  group1 = NULL,
  group2 = NULL,
  paired = FALSE,
  adj.method = "BH",
  alternative = "two.sided",
  cores = 1
)
}
\arguments{
\item{data}{SummarizedExperiment obtained from the TCGAPrepare}

\item{groupCol}{Columns with the groups inside the SummarizedExperiment
object. (This will be obtained by the function colData(data))}

\item{group1}{In case our object has more than 2 groups, you should set the
groups}

\item{group2}{In case our object has more than 2 groups, you should set the
groups}

\item{paired}{Do a paired wilcoxon test? Default: True}

\item{adj.method}{P-value adjustment method. Default:"BH" Benjamini-Hochberg}

\item{alternative}{wilcoxon test alternative}

\item{cores}{Number of cores to be used}
}
\value{
Data frame with cols p values/p values adjusted

Data frame with two cols
        p-values/p-values adjusted
}
\description{
Calculate pvalues using wilcoxon test
}
\details{
Verify if the data is significant between two groups. For the methylation
   we search for probes that have a difference in the mean methylation and
   also a significant value.
   Input: A SummarizedExperiment object that will be used to
   compared two groups with wilcoxon test, a boolean value to do a
   paired or non-paired test
   Output: p-values (non-adj/adj) histograms, p-values (non-adj/adj)
}
\examples{
nrows <- 200; ncols <- 20
 counts <- matrix(runif(nrows * ncols, 1, 1e4), nrows,
           dimnames = list(paste0("cg",1:200),LETTERS[1:20]))
rowRanges <- GenomicRanges::GRanges(rep(c("chr1", "chr2"), c(50, 150)),
                   IRanges::IRanges(floor(runif(200, 1e5, 1e6)), width=100),
                    strand=sample(c("+", "-"), 200, TRUE),
                    feature_id=sprintf("ID\%03d", 1:200))
colData <- S4Vectors::DataFrame(Treatment=rep(c("ChIP", "Input"), 10),
                    row.names=LETTERS[1:20],
                    group=rep(c("group1","group2"),c(10,10)))
data <- SummarizedExperiment::SummarizedExperiment(
         assays=S4Vectors::SimpleList(counts=counts),
         rowRanges=rowRanges,
         colData=colData)
results <- TCGAbiolinks:::dmc.non.parametric.se(data,"group")
}
\keyword{internal}
