% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Schema.R
\docType{class}
\name{Schema-class}
\alias{Schema-class}
\alias{Schema}
\alias{names,Schema-method}
\alias{Schema-method}
\alias{[,Schema,character-method}
\alias{$,Schema-method}
\alias{InfoSchema}
\alias{DataFileSchema}
\alias{AlignmentSchema}
\alias{RearrangementSchema}
\alias{RepertoireSchema}
\alias{GermlineSetSchema}
\alias{GenotypeSetSchema}
\alias{AIRRSchema}
\title{S4 class defining an AIRR standard schema}
\format{
A \code{Schema} object.

An object of class \code{Schema} of length 1.

An object of class \code{Schema} of length 1.

An object of class \code{Schema} of length 1.

An object of class \code{Schema} of length 1.

An object of class \code{Schema} of length 1.

An object of class \code{Schema} of length 1.

An object of class \code{Schema} of length 1.

An object of class \code{list} of length 26.
}
\usage{
\S4method{names}{Schema}(x)

\S4method{[}{Schema,character}(x, i)

\S4method{$}{Schema}(x, name)

InfoSchema

DataFileSchema

AlignmentSchema

RearrangementSchema

RepertoireSchema

GermlineSetSchema

GenotypeSetSchema

AIRRSchema
}
\arguments{
\item{x}{\code{Schema} object.}

\item{i}{field name.}

\item{name}{field name.}
}
\description{
\code{Schema} defines a common data structure for AIRR Data Representation 
standards.
}
\details{
The following predefined Schema objects are defined:

\code{InfoSchema}: AIRR Info \code{Schema}.

\code{DataFileSchema}: AIRR DataFile \code{Schema}.

\code{AlignmentSchema}: AIRR Alignment \code{Schema}.

\code{RearrangementSchema}: AIRR Rearrangement \code{Schema}.

\code{RepertoireSchema}: AIRR Repertoire \code{Schema}.

\code{GermlineSetSchema}: AIRR GermlineSet \code{Schema}.

\code{GenotypeSetSchema}: AIRR GenotypeSet \code{Schema}.

\code{AIRRSchema}: named list containing all non-experimental 
                              AIRR \code{Schema} objects.
}
\section{Slots}{

\describe{
\item{\code{definition}}{name of the schema definition.}

\item{\code{required}}{\code{character} vector of required fields.}

\item{\code{optional}}{\code{character} vector of non-required fields.}

\item{\code{properties}}{\code{list} of field definitions.}

\item{\code{info}}{\code{list} schema information.}
}}

\seealso{
See \link{load_schema} for loading a \code{Schema} from the definition set.
}
\keyword{datasets}
