% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/week_start.R
\name{set_week_start}
\alias{set_week_start}
\alias{get_week_start}
\title{Get and set the global week_start variable}
\usage{
set_week_start(x = 1L)

get_week_start(w = NULL)
}
\arguments{
\item{x}{a character or integer specifying the day of the week for conversion
between dates and weeks.}

\item{w}{if \code{NULL}, the global option "aweek.week_start" is returned. If \code{w}
is an aweek object, then the "week_start" attribute is returned.}
}
\value{
for \code{set_week_start}, the old value of \code{week_start} is returned,
invisibly. For \code{get_week_start}, the current value of \code{week_start} is
returned.
}
\description{
This is a convenience wrapper around \code{\link[=options]{options()}} and \code{\link[=getOption]{getOption()}}, which
allows users to input both numeric and character week start values
}
\examples{

# get the current definition of the week start
get_week_start() # defaults to Monday (1)
getOption("aweek.week_start", 1L) # identical to above

# set the week start
mon <- set_week_start("Sunday") # set week start to Sunday (7)
get_week_start()
print(set_week_start(mon)) # reset the default
get_week_start()

# Get the week_start of a specific aweek object.
w <- date2week("2019-05-04", week_start = "Sunday")
get_week_start(w)
}
\seealso{
\code{\link[=change_week_start]{change_week_start()}} for changing the week_start attribute of an
aweek object, \code{\link[=date2week]{date2week()}}, \code{\link[=week2date]{week2date()}}
}
