% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R, R/posixt.R
\name{date-today}
\alias{date-today}
\alias{date_today}
\alias{date_now}
\title{Current date and date-time}
\usage{
date_today(zone)

date_now(zone)
}
\arguments{
\item{zone}{\verb{[character(1)]}

A time zone to get the current time for.}
}
\value{
\itemize{
\item \code{date_today()} a single Date.
\item \code{date_now()} a single POSIXct.
}
}
\description{
\itemize{
\item \code{date_today()} returns the current date in the specified \code{zone} as a Date.
\item \code{date_now()} returns the current date-time in the specified \code{zone} as a
POSIXct.
}
}
\details{
clock assumes that Date is a \emph{naive} type, like naive-time. This means that
\code{date_today()} first looks up the current date-time in the specified \code{zone},
then converts that to a Date, retaining the printed time while dropping any
information about that time zone.
}
\examples{
# Current date in the local time zone
date_today("")

# Current date in a specified time zone
date_today("Europe/London")

# Current date-time in that same time zone
date_now("Europe/London")
}
