% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-arrange.R
\name{arrange.tbl_lazy}
\alias{arrange.tbl_lazy}
\title{Arrange rows by column values}
\usage{
\method{arrange}{tbl_lazy}(.data, ..., .by_group = FALSE)
}
\arguments{
\item{.data}{A lazy data frame backed by a database query.}

\item{...}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Variables, or functions or
variables. Use \code{\link[dplyr:desc]{desc()}} to sort a variable in descending order.}

\item{.by_group}{If \code{TRUE}, will sort first by grouping variable. Applies to
grouped data frames only.}
}
\value{
Another \code{tbl_lazy}. Use \code{\link[=show_query]{show_query()}} to see the generated
query, and use \code{\link[=collect.tbl_sql]{collect()}} to execute the query
and return data to R.
}
\description{
This is an method for the dplyr \code{\link[=arrange]{arrange()}} generic. It generates
the \verb{ORDER BY} clause of the SQL query. It also affects the
\code{\link[=window_order]{window_order()}} of windowed expressions in \code{\link[=mutate.tbl_lazy]{mutate.tbl_lazy()}}.

Note that \verb{ORDER BY} clauses can not generally appear in subqueries, which
means that you should \code{arrange()} as late as possible in your pipelines.
}
\section{Missing values}{

Unlike R, most databases sorts \code{NA} (\code{NULL}s) at the front. You can
can override this behaviour by explicitly sorting on \code{is.na(x)}.
}

\examples{
library(dplyr, warn.conflicts = FALSE)

db <- memdb_frame(a = c(3, 4, 1, 2), b = c(5, 1, 2, NA))
db \%>\% arrange(a) \%>\% show_query()

# Note that NAs are sorted first
db \%>\% arrange(b)
# override by sorting on is.na() first
db \%>\% arrange(is.na(b), b)
}
