% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg-plots.R
\name{ggally_autopoint}
\alias{ggally_autopoint}
\alias{ggally_autopointDiag}
\title{Scatterplot for continuous and categorical variables}
\usage{
ggally_autopoint(data, mapping, ...)

ggally_autopointDiag(data, mapping, ...)
}
\arguments{
\item{data}{data set using}

\item{mapping}{aesthetics being used}

\item{...}{other arguments passed to \code{\link[ggforce]{geom_autopoint}(...)}}
}
\description{
Make scatterplots compatible with both continuous and categorical variables
using \code{\link[ggforce]{geom_autopoint}} from package \pkg{ggforce}.
}
\examples{
# Small function to display plots only if it's interactive
p_ <- GGally::print_if_interactive

data(tips)
p_(ggally_autopoint(tips, mapping = aes(x = tip, y = total_bill)))
p_(ggally_autopoint(tips, mapping = aes(x = tip, y = sex)))
p_(ggally_autopoint(tips, mapping = aes(x = smoker, y = sex)))
p_(ggally_autopoint(tips, mapping = aes(x = smoker, y = sex, color = day)))
p_(ggally_autopoint(tips, mapping = aes(x = smoker, y = sex), size = 8))
p_(ggally_autopoint(tips, mapping = aes(x = smoker, y = sex), alpha = .9))

p_(ggpairs(
  tips,
  mapping = aes(colour = sex),
  upper = list(discrete = "autopoint", combo = "autopoint", continuous = "autopoint"),
  diag = list(discrete = "autopointDiag", continuous = "autopointDiag")
))
}
\author{
Joseph Larmarange
}
\keyword{hplot}
