% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOCore.R
\name{chord_dat}
\alias{chord_dat}
\title{Creates a binary matrix.}
\usage{
chord_dat(data, genes, process)
}
\arguments{
\item{data}{A data frame with at least two coloumns: GO ID|term and genes. 
Each row contains exactly one GO ID|term and one gene. A column containing
logFC values is optional and might be used if \code{genes} is missing.}

\item{genes}{A character vector of selected genes OR data frame with coloumns
for gene ID and logFC.}

\item{process}{A character vector of selected processes}
}
\value{
A binary matrix
}
\description{
The function creates a matrix which represents the binary 
  relation (1= is related to, 0= is not related to) between selected genes 
  (row) and processes (column). The resulting matrix can be visualized with 
  the \code{\link{GOChord}} function.
}
\details{
If more than one logFC value for each gene is at disposal, only one 
  should be used to create the binary matrix. The other values have to be 
  added manually later.
}
\examples{
\dontrun{
# Load the included dataset
data(EC)

# Building the circ object
circ <- circle_dat(EC$david, EC$genelist)

# Building the binary matrix
chord <- chord_dat(circ, EC$genes, EC$process)

}
}
\seealso{
\code{\link{GOChord}}
}

