% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/games.R
\name{preference.game}
\alias{preference.game}
\title{Trait-based random generation}
\usage{
preference.game(
  nodes,
  types,
  type.dist = rep(1, types),
  fixed.sizes = FALSE,
  pref.matrix = matrix(1, types, types),
  directed = FALSE,
  loops = FALSE
)
}
\arguments{
\item{nodes}{The number of vertices in the graphs.}

\item{types}{The number of different vertex types.}

\item{type.dist}{The distribution of the vertex types, a numeric vector of
length \sQuote{types} containing non-negative numbers. The vector will be
normed to obtain probabilities.}

\item{fixed.sizes}{Fix the number of vertices with a given vertex type
label. The \code{type.dist} argument gives the group sizes (i.e. number of
vertices with the different labels) in this case.}

\item{pref.matrix}{A square matrix giving the preferences of the vertex
types. The matrix has \sQuote{types} rows and columns. When generating
an undirected graph, it must be symmetric.}

\item{directed}{Logical constant, whether to create a directed graph.}

\item{loops}{Logical constant, whether self-loops are allowed in the graph.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{preference.game()} was renamed to \code{\link[=sample_pref]{sample_pref()}} to create a more
consistent API.
}
\keyword{internal}
