% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.R
\name{select}
\alias{select}
\title{Subset columns using their names and types}
\usage{
select(.data, ...)
}
\arguments{
\item{.data}{A \code{data.frame}.}

\item{...}{<\code{\link[=select_helpers]{poor-select}}> One or more unquoted expressions separated by commas. Variable names can
be used as if they were positions in the data frame, so expressions like \code{x:y} can be used to select a range of
variables.}
}
\value{
An object of the same type as \code{.data}. The output has the following properties:
\itemize{
\item Rows are not affected.
\item Output columns are a subset of input columns, potentially with a different order. Columns will be renamed if
\code{new_name = old_name} form is used.
\item Data frame attributes are preserved.
\item Groups are maintained; you can't select off grouping variables.
}
}
\description{
Select (and optionally rename) variables in a \code{data.frame}, using a concise mini-language that makes it easy to refer
to variables based on their name (e.g. \code{a:f} selects all columns from \code{a} on the left to \code{f} on the right). You can
also use predicate functions like \code{\link[=is.numeric]{is.numeric()}} to select variables based on their properties.
}
\details{
\subsection{Overview of selection features}{

{poorman} selections implement a dialect of R where operators make it easy to select variables:
\itemize{
\item \code{:} for selecting a range of consecutive variables.
\item \code{!} for taking the complement of a set of variables.
\item \code{&} and \code{|} for selecting the intersection or the union of two sets of variables.
\item \code{c()} for combining selections.
}

In addition, you can use \strong{selection helpers}. Some helpers select specific columns:
\itemize{
\item \code{\link[=everything]{everything()}}: Matches all variables.
\item \code{\link[=last_col]{last_col()}}: Select last variable, possibly with an offset.
}

These helpers select variables by matching patterns in their names:
\itemize{
\item \code{\link[=starts_with]{starts_with()}}: Starts with a prefix.
\item \code{\link[=ends_with]{ends_with()}}: Ends with a suffix.
\item \code{\link[=contains]{contains()}}: Contains a literal string.
\item \code{\link[=matches]{matches()}}: Matches a regular expression.
\item \code{\link[=num_range]{num_range()}}: Matches a numerical range like \code{x01}, \code{x02}, \code{x03}.
}

These helpers select variables from a character vector:
\itemize{
\item \code{\link[=all_of]{all_of()}}: Matches variable names in a character vector. All names must be present, otherwise an out-of-bounds
error is thrown.
\item \code{\link[=any_of]{any_of()}}: Same as \code{all_of()}, except that no error is thrown for names that don't exist.
}

This helper selects variables with a function:
\itemize{
\item \code{\link[=where]{where()}}: Applies a function to all variables and selects those for which the function returns \code{TRUE}.
}
}
}
\examples{
# Here we show the usage for the basic selection operators. See the
# specific help pages to learn about helpers like [starts_with()].

# Select variables by name:
mtcars \%>\% select(mpg)

# Select multiple variables by separating them with commas. Note
# how the order of columns is determined by the order of inputs:
mtcars \%>\% select(disp, gear, am)

# Rename variables:
mtcars \%>\% select(MilesPerGallon = mpg, everything())

# The `:` operator selects a range of consecutive variables:
select(mtcars, mpg:cyl)

# The `!` operator negates a selection:
mtcars \%>\% select(!(mpg:qsec))
mtcars \%>\% select(!ends_with("p"))

# `&` and `|` take the intersection or the union of two selections:
iris \%>\% select(starts_with("Petal") & ends_with("Width"))
iris \%>\% select(starts_with("Petal") | ends_with("Width"))

# To take the difference between two selections, combine the `&` and
# `!` operators:
iris \%>\% select(starts_with("Petal") & !ends_with("Width"))

}
