module MathML::LaTeX::Builtin
  module Symbol
    MAP = {
      '{' => [%i[s o], ''],
      '}' => [%i[s o], ''],
      '#' => [%i[s o], ''],
      '$' => [%i[s o], ''],
      '&' => [%i[s o], :amp],
      '_' => [%i[s o], ''],
      '%' => [%i[s o], ''],
      ',' => nil,
      'varepsilon' => [%i[s I]],
      'mathdollar' => [%i[s o], '$'],
      'lbrace' => [[:s]],
      'rbrace' => [[:s]],
      'P' => [%i[s o], :para],
      'mathparagraph' => [%i[s o], :para],
      'S' => [%i[s o], :sect],
      'mathsection' => [%i[s o], :sect],
      'dag' => [%i[s o], :dagger],
      'dagger' => [[:s]],
      'ddag' => [%i[s o], :ddagger],
      'ddagger' => [[:s]],
      'copyright' => [%i[s o], :copy],
      'pounds' => [%i[s o], :pound],
      'mathsterling' => [%i[s o], :pound],
      'dots' => [%i[s o], :mldr],
      'mathellipsis' => [%i[s o], :mldr],
      'ldots' => [%i[s o], :mldr],
      'ensuremath' => nil,
      '|' => [%i[s o], :DoubleVerticalBar],
      'mho' => [[:s]],
      'Join' => [%i[s o], :bowtie],
      'Box' => [%i[s o], :square],
      'Diamond' => [[:s]],
      'leadsto' => [%i[s o], :zigrarr],
      'sqsubset' => [[:s]],
      'sqsupset' => [[:s]],
      'lhd' => [%i[s o], :vltri],
      'unlhd' => [%i[s o], :ltrie],
      'rhd' => [%i[s o], :vrtri],
      'unrhd' => [%i[s o], :rtrie],
      'log' => [%i[s i], ''],
      'lg' => [%i[s i], ''],
      'ln' => [%i[s i], ''],
      'lim' => [%i[u i], ''],
      'limsup' => [%i[u i], 'lim sup'],
      'liminf' => [%i[u i], 'lim inf'],
      'sin' => [%i[s i], ''],
      'arcsin' => [%i[s i], ''],
      'sinh' => [%i[s i], ''],
      'cos' => [%i[s i], ''],
      'arccos' => [%i[s i], ''],
      'cosh' => [%i[s i], ''],
      'tan' => [%i[s i], ''],
      'arctan' => [%i[s i], ''],
      'tanh' => [%i[s i], ''],
      'cot' => [%i[s i], ''],
      'coth' => [%i[s i], ''],
      'sec' => [%i[s i], ''],
      'csc' => [%i[s i], ''],
      'max' => [%i[u i], ''],
      'min' => [%i[u i], ''],
      'sup' => [%i[u i], ''],
      'inf' => [%i[u i], ''],
      'arg' => [%i[s i], ''],
      'ker' => [%i[s i], ''],
      'dim' => [%i[s i], ''],
      'hom' => [%i[s i], ''],
      'det' => [%i[u i], ''],
      'exp' => [%i[s i], ''],
      'Pr' => [%i[u i], ''],
      'gcd' => [%i[u i], ''],
      'deg' => [%i[s i], ''],
      'prime' => [[:s]],
      'alpha' => [%i[s I]],
      'beta' => [%i[s I]],
      'gamma' => [%i[s I]],
      'delta' => [%i[s I]],
      'epsilon' => [%i[s I]],
      'zeta' => [%i[s I]],
      'eta' => [%i[s I]],
      'theta' => [%i[s I]],
      'iota' => [%i[s I]],
      'kappa' => [%i[s I]],
      'lambda' => [%i[s I]],
      'mu' => [%i[s I]],
      'nu' => [%i[s I]],
      'xi' => [%i[s I]],
      'pi' => [%i[s I]],
      'rho' => [%i[s I]],
      'sigma' => [%i[s I]],
      'tau' => [%i[s I]],
      'upsilon' => [%i[s I]],
      'phi' => [%i[s I]],
      'chi' => [%i[s I]],
      'psi' => [%i[s I]],
      'omega' => [%i[s I]],
      'vartheta' => [%i[s I]],
      'varpi' => [%i[s I]],
      'varrho' => [%i[s I]],
      'varsigma' => [%i[s I]],
      'varphi' => [%i[s I]],
      'Gamma' => [%i[s i]],
      'Delta' => [%i[s i]],
      'Theta' => [%i[s i]],
      'Lambda' => [%i[s i]],
      'Xi' => [%i[s i]],
      'Pi' => [%i[s i]],
      'Sigma' => [%i[s i]],
      'Upsilon' => [%i[s i], :Upsi],
      'Phi' => [%i[s i]],
      'Psi' => [%i[s i]],
      'Omega' => [%i[s i]],
      'aleph' => [%i[s i]],
      'hbar' => [%i[s i], :hslash],
      'imath' => [%i[s i]],
      'jmath' => [%i[s i]],
      'ell' => [[:s]],
      'wp' => [[:s]],
      'Re' => [%i[s i]],
      'Im' => [%i[s i]],
      'partial' => [%i[s o], :part],
      'infty' => [%i[s n], :infin],
      'emptyset' => [%i[s i], :empty],
      'nabla' => [%i[s i]],
      'surd' => [%i[s o], :Sqrt],
      'top' => [[:s]],
      'bot' => [[:s]],
      'angle' => [[:s]],
      'not' => [[:s]],
      'triangle' => [[:s]],
      'forall' => [[:s]],
      'exists' => [%i[s o], :exist],
      'neg' => [%i[s o], :not],
      'lnot' => [%i[s o], :not],
      'flat' => [[:s]],
      'natural' => [[:s]],
      'sharp' => [[:s]],
      'clubsuit' => [[:s]],
      'diamondsuit' => [[:s]],
      'heartsuit' => [[:s]],
      'spadesuit' => [[:s]],
      'coprod' => [[:u]],
      'bigvee' => [[:u]],
      'bigwedge' => [[:u]],
      'biguplus' => [[:u]],
      'bigcap' => [[:u]],
      'bigcup' => [[:u]],
      'intop' => [%i[u o], :int],
      'int' => [%i[s o]],
      'prod' => [[:u]],
      'sum' => [[:u]],
      'bigotimes' => [[:u]],
      'bigoplus' => [[:u]],
      'bigodot' => [[:u]],
      'ointop' => [%i[u o], :oint],
      'oint' => [[:s]],
      'bigsqcup' => [[:u]],
      'smallint' => [%i[u o], :int],
      'triangleleft' => [[:s]],
      'triangleright' => [[:s]],
      'bigtriangleup' => [[:s]],
      'bigtriangledown' => [[:s]],
      'wedge' => [[:s]],
      'land' => [%i[s o], :wedge],
      'vee' => [[:s]],
      'lor' => [%i[s o], :vee],
      'cap' => [[:s]],
      'cup' => [[:s]],
      'sqcap' => [[:s]],
      'sqcup' => [[:s]],
      'uplus' => [[:s]],
      'amalg' => [[:s]],
      'diamond' => [[:s]],
      'bullet' => [[:s]],
      'wr' => [[:s]],
      'div' => [[:s]],
      'odot' => [[:s]],
      'oslash' => [[:s]],
      'otimes' => [[:s]],
      'ominus' => [[:s]],
      'oplus' => [[:s]],
      'mp' => [[:s]],
      'pm' => [[:s]],
      'circ' => [%i[s o], :cir],
      'bigcirc' => [[:s]],
      'setminus' => [[:s]],
      'cdot' => [%i[s o], :sdot],
      'ast' => [[:s]],
      'times' => [[:s]],
      'star' => [[:s]],
      'propto' => [[:s]],
      'sqsubseteq' => [[:s]],
      'sqsupseteq' => [[:s]],
      'parallel' => [[:s]],
      'mid' => [[:s]],
      'dashv' => [[:s]],
      'vdash' => [[:s]],
      'nearrow' => [[:s]],
      'searrow' => [[:s]],
      'nwarrow' => [[:s]],
      'swarrow' => [[:s]],
      'Leftrightarrow' => [[:s]],
      'Leftarrow' => [[:s]],
      'Rightarrow' => [[:s]],
      'neq' => [%i[s o], :ne],
      'ne' => [[:s]],
      'leq' => [[:s]],
      'le' => [[:s]],
      'geq' => [[:s]],
      'ge' => [[:s]],
      'succ' => [[:s]],
      'prec' => [[:s]],
      'approx' => [[:s]],
      'succeq' => [%i[s o], :sccue],
      'preceq' => [%i[s o], :prcue],
      'supset' => [[:s]],
      'subset' => [[:s]],
      'supseteq' => [[:s]],
      'subseteq' => [[:s]],
      'in' => [[:s]],
      'ni' => [[:s]],
      'owns' => [%i[s o], :ni],
      'gg' => [[:s]],
      'll' => [[:s]],
      'leftrightarrow' => [[:s]],
      'leftarrow' => [[:s]],
      'gets' => [%i[s o], :leftarrow],
      'rightarrow' => [[:s]],
      'to' => [%i[s o], :rightarrow],
      'mapstochar' => [%i[s o], :vdash],
      'mapsto' => [[:s]],
      'sim' => [[:s]],
      'simeq' => [[:s]],
      'perp' => [[:s]],
      'equiv' => [[:s]],
      'asymp' => [[:s]],
      'smile' => [[:s]],
      'frown' => [[:s]],
      'leftharpoonup' => [[:s]],
      'leftharpoondown' => [[:s]],
      'rightharpoonup' => [[:s]],
      'rightharpoondown' => [[:s]],
      'cong' => [[:s]],
      'notin' => [[:s]],
      'rightleftharpoons' => [[:s]],
      'doteq' => [[:s]],
      'joinrel' => nil,
      'relbar' => [%i[s o], '-'],
      'Relbar' => [%i[s o], '='],
      'lhook' => [%i[s o], :sub],
      'hookrightarrow' => [[:s]],
      'rhook' => [%i[s o], :sup],
      'hookleftarrow' => [[:s]],
      'bowtie' => [[:s]],
      'models' => [[:s]],
      'Longrightarrow' => [[:s]],
      'longrightarrow' => [[:s]],
      'longleftarrow' => [[:s]],
      'Longleftarrow' => [[:s]],
      'longmapsto' => [%i[s o], :mapsto],
      'longleftrightarrow' => [[:s]],
      'Longleftrightarrow' => [[:s]],
      'iff' => [[:s]],
      'ldotp' => [%i[s o], '.'],
      'cdotp' => [%i[s o], :cdot],
      'colon' => [[:s]],
      'cdots' => [%i[s o], :ctdot],
      'vdots' => [%i[s o], :vellip],
      'ddots' => [%i[s o], :dtdot],
      'braceld' => [%i[s o], 0x25dc],
      'bracerd' => [%i[s o], 0x25dd],
      'bracelu' => [%i[s o], 0x25df],
      'braceru' => [%i[s o], 0x25de],
      'lmoustache' => [[:s]],
      'rmoustache' => [[:s]],
      'arrowvert' => [%i[s o], :vert],
      'Arrowvert' => [%i[s o], :DoubleVerticalBar],
      'Vert' => [%i[s o], :DoubleVerticalBar],
      'vert' => [[:s]],
      'uparrow' => [[:s]],
      'downarrow' => [[:s]],
      'updownarrow' => [[:s]],
      'Uparrow' => [[:s]],
      'Downarrow' => [[:s]],
      'Updownarrow' => [[:s]],
      'backslash' => [%i[s o], '\\'],
      'rangle' => [[:s]],
      'langle' => [[:s]],
      'rceil' => [[:s]],
      'lceil' => [[:s]],
      'rfloor' => [[:s]],
      'lfloor' => [[:s]],
      'lgroup' => [%i[s o], 0x2570],
      'rgroup' => [%i[s o], 0x256f],
      'bracevert' => [%i[s o], :vert],
      'mathunderscore' => [%i[s o], '_'],
      'square' => [[:s]],
      'rightsquigarrow' => [[:s]],
      'lozenge' => [[:s]],
      'vartriangleright' => [[:s]],
      'vartriangleleft' => [[:s]],
      'trianglerighteq' => [[:s]],
      'trianglelefteq' => [[:s]],
      'boxdot' => [%i[s o], :dotsquare],
      'boxplus' => [[:s]],
      'boxtimes' => [[:s]],
      'blacksquare' => [[:s]],
      'centerdot' => [[:s]],
      'blacklozenge' => [[:s]],
      'circlearrowright' => [[:s]],
      'circlearrowleft' => [[:s]],
      'leftrightharpoons' => [[:s]],
      'boxminus' => [[:s]],
      'Vdash' => [[:s]],
      'Vvdash' => [[:s]],
      'vDash' => [[:s]],
      'twoheadrightarrow' => [[:s]],
      'twoheadleftarrow' => [[:s]],
      'leftleftarrows' => [[:s]],
      'rightrightarrows' => [[:s]],
      'upuparrows' => [[:s]],
      'downdownarrows' => [[:s]],
      'upharpoonright' => [[:s]],
      'restriction' => [%i[s o], :upharpoonright],
      'downharpoonright' => [[:s]],
      'upharpoonleft' => [[:s]],
      'downharpoonleft' => [[:s]],
      'rightarrowtail' => [[:s]],
      'leftarrowtail' => [[:s]],
      'leftrightarrows' => [[:s]],
      'rightleftarrows' => [[:s]],
      'Lsh' => [[:s]],
      'Rsh' => [[:s]],
      'leftrightsquigarrow' => [[:s]],
      'looparrowleft' => [[:s]],
      'looparrowright' => [[:s]],
      'circeq' => [[:s]],
      'succsim' => [[:s]],
      'gtrsim' => [[:s]],
      'gtrapprox' => [[:s]],
      'multimap' => [[:s]],
      'therefore' => [[:s]],
      'because' => [[:s]],
      'doteqdot' => [[:s]],
      'Doteq' => [%i[s o], :doteqdot],
      'triangleq' => [[:s]],
      'precsim' => [[:s]],
      'lesssim' => [[:s]],
      'lessapprox' => [[:s]],
      'eqslantless' => [[:s]],
      'eqslantgtr' => [[:s]],
      'curlyeqprec' => [[:s]],
      'curlyeqsucc' => [[:s]],
      'preccurlyeq' => [[:s]],
      'leqq' => [[:s]],
      'leqslant' => [%i[s o], :leq],
      'lessgtr' => [[:s]],
      'backprime' => [[:s]],
      'risingdotseq' => [[:s]],
      'fallingdotseq' => [[:s]],
      'succcurlyeq' => [[:s]],
      'geqq' => [[:s]],
      'geqslant' => [%i[s o], :geq],
      'gtrless' => [[:s]],
      'bigstar' => [[:s]],
      'between' => [[:s]],
      'blacktriangledown' => [[:s]],
      'blacktriangleright' => [[:s]],
      'blacktriangleleft' => [[:s]],
      'vartriangle' => [%i[s o], :triangle],
      'blacktriangle' => [[:s]],
      'triangledown' => [[:s]],
      'eqcirc' => [[:s]],
      'lesseqgtr' => [[:s]],
      'gtreqless' => [[:s]],
      'lesseqqgtr' => [[:s]],
      'gtreqqless' => [[:s]],
      'Rrightarrow' => [[:s]],
      'Lleftarrow' => [[:s]],
      'veebar' => [[:s]],
      'barwedge' => [[:s]],
      'doublebarwedge' => [[:s]],
      'measuredangle' => [[:s]],
      'sphericalangle' => [%i[s o], :angsph],
      'varpropto' => [[:s]],
      'smallsmile' => [%i[s o], :smile],
      'smallfrown' => [%i[s o], :frown],
      'Subset' => [[:s]],
      'Supset' => [[:s]],
      'Cup' => [[:s]],
      'doublecup' => [%i[s o], :Cup],
      'Cap' => [[:s]],
      'doublecap' => [%i[s o], :Cap],
      'curlywedge' => [[:s]],
      'curlyvee' => [[:s]],
      'leftthreetimes' => [[:s]],
      'rightthreetimes' => [[:s]],
      'subseteqq' => [[:s]],
      'supseteqq' => [[:s]],
      'bumpeq' => [[:s]],
      'Bumpeq' => [[:s]],
      'lll' => [%i[s o], :Ll],
      'llless' => [%i[s o], :Ll],
      'ggg' => [[:s]],
      'gggtr' => [%i[s o], :ggg],
      'circledS' => [[:s]],
      'pitchfork' => [[:s]],
      'dotplus' => [[:s]],
      'backsim' => [[:s]],
      'backsimeq' => [[:s]],
      'complement' => [[:s]],
      'intercal' => [[:s]],
      'circledcirc' => [[:s]],
      'circledast' => [[:s]],
      'circleddash' => [[:s]],
      'lvertneqq' => [%i[s o], :lneqq],
      'gvertneqq' => [%i[s o], :gneqq],
      'nleq' => [%i[s o], 0x2270],
      'ngeq' => [%i[s o], 0x2271],
      'nless' => [[:s]],
      'ngtr' => [[:s]],
      'nprec' => [[:s]],
      'nsucc' => [[:s]],
      'lneqq' => [[:s]],
      'gneqq' => [[:s]],
      'nleqslant' => [[:s]],
      'ngeqslant' => [[:s]],
      'lneq' => [[:s]],
      'gneq' => [[:s]],
      'npreceq' => [%i[s o], :nprcue],
      'nsucceq' => [%i[s o], :nsccue],
      'precnsim' => [[:s]],
      'succnsim' => [[:s]],
      'lnsim' => [[:s]],
      'gnsim' => [[:s]],
      'nleqq' => [[:s]],
      'ngeqq' => [[:s]],
      'precneqq' => [%i[s o], 0x2ab5],
      'succneqq' => [%i[s o], 0x2ab6],
      'precnapprox' => [[:s]],
      'succnapprox' => [[:s]],
      'lnapprox' => [%i[s o], 0x2a89],
      'gnapprox' => [%i[s o], 0x2a8a],
      'nsim' => [[:s]],
      'ncong' => [[:s]],
      'diagup' => [%i[s o], 0x2571],
      'diagdown' => [%i[s o], 0x2572],
      'varsubsetneq' => [%i[s o], :subsetneq],
      'varsupsetneq' => [%i[s o], :supsetneq],
      'nsubseteqq' => [[:s]],
      'nsupseteqq' => [[:s]],
      'subsetneqq' => [[:s]],
      'supsetneqq' => [[:s]],
      'varsubsetneqq' => [%i[s o], :subsetneqq],
      'varsupsetneqq' => [%i[s o], :supsetneqq],
      'subsetneq' => [[:s]],
      'supsetneq' => [[:s]],
      'nsubseteq' => [[:s]],
      'nsupseteq' => [[:s]],
      'nparallel' => [[:s]],
      'nmid' => [[:s]],
      'nshortmid' => [%i[s o], :nmid],
      'nshortparallel' => [%i[s o], :nparallel],
      'nvdash' => [[:s]],
      'nVdash' => [[:s]],
      'nvDash' => [[:s]],
      'nVDash' => [[:s]],
      'ntrianglerighteq' => [[:s]],
      'ntrianglelefteq' => [[:s]],
      'ntriangleleft' => [[:s]],
      'ntriangleright' => [[:s]],
      'nleftarrow' => [[:s]],
      'nrightarrow' => [[:s]],
      'nLeftarrow' => [[:s]],
      'nRightarrow' => [[:s]],
      'nLeftrightarrow' => [[:s]],
      'nleftrightarrow' => [[:s]],
      'divideontimes' => [[:s]],
      'varnothing' => [[:s]],
      'nexists' => [[:s]],
      'Finv' => [%i[s o], 0x2132],
      'Game' => [%i[s o], 'G'],
      'eth' => [[:s]],
      'eqsim' => [[:s]],
      'beth' => [[:s]],
      'gimel' => [[:s]],
      'daleth' => [[:s]],
      'lessdot' => [[:s]],
      'gtrdot' => [[:s]],
      'ltimes' => [[:s]],
      'rtimes' => [[:s]],
      'shortmid' => [%i[s o], :mid],
      'shortparallel' => [[:s]],
      'smallsetminus' => [%i[s o], :setminus],
      'thicksim' => [%i[s o], :sim],
      'thickapprox' => [%i[s o], :approx],
      'approxeq' => [[:s]],
      'succapprox' => [[:s]],
      'precapprox' => [[:s]],
      'curvearrowleft' => [[:s]],
      'curvearrowright' => [[:s]],
      'digamma' => [[:s]],
      'varkappa' => [[:s]],
      'Bbbk' => [%i[s i], :kopf],
      'hslash' => [[:s]],
      'backepsilon' => [[:s]],
      'ulcorner' => [%i[s o], :boxdr],
      'urcorner' => [%i[s o], :boxdl],
      'llcorner' => [%i[s o], :boxur],
      'lrcorner' => [%i[s o], :boxul]
    }

    DELIMITERS = [
      'lmoustache',
      'rmoustache',
      'arrowvert',
      'Arrowvert',
      'Vert',
      'vert',
      'uparrow',
      'downarrow',
      'updownarrow',
      'Uparrow',
      'Downarrow',
      'Updownarrow',
      'backslash',
      'rangle',
      'langle',
      'rbrace',
      'lbrace',
      'rceil',
      'lceil',
      'rfloor',
      'lfloor',
      'lgroup',
      'rgroup',
      'bracevert',
      'ulcorner',
      'urcorner',
      'llcorner',
      'lrcorner',
      '{',
      '|',
      '}'
    ]
  end
end
