# 2022-07-05 Triage Log

Overall the week is a small improvement on average, with some benchmarks
(particularly in the primary category) showing significant improvements due to
the enablement of MIR inlining in
[#91743](https://github.com/rust-lang/rust/pull/91743). Inlining promises to
improve the quality of our generated LLVM IR and make other optimizations more
worthwhile, so it's great to see these early results already being quite
impactful.

Triage done by **@simulacrum**.
Revision range: [baf382e63c023259fa1f9042f8f479f183ca6ed3..880646ca9c6dc21e04efe2f1940369a45b71ff2d](https://perf.rust-lang.org/?start=baf382e63c023259fa1f9042f8f479f183ca6ed3&end=880646ca9c6dc21e04efe2f1940369a45b71ff2d&absolute=false&stat=instructions%3Au)

**Summary**:

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 1.9% | 11.9% | 111   |
| Regressions 😿 <br /> (secondary) | 3.4% | 11.9% | 106   |
| Improvements 🎉 <br /> (primary) | -2.8% | -9.7% | 105   |
| Improvements 🎉 <br /> (secondary) | -4.4% | -16.8% | 97    |
| All 😿🎉 (primary) | -0.4% | 11.9% | 216   |


3 Regressions, 6 Improvements, 6 Mixed; 4 of them in rollups
46 artifact comparisons made in total

#### Regressions

Fix FFI-unwind unsoundness with mixed panic mode [#97235](https://github.com/rust-lang/rust/pull/97235)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0075bb4fad68e64b6d1be06bf2db366c30bc75e1&end=6a1092056441652fe5fe5c5b422644951e6b99ce&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.5% | 1.2% | 86    |
| Regressions 😿 <br /> (secondary) | 0.9% | 2.5% | 36    |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | 0.5% | 1.2% | 86    |

PR author notes this added a new query for each MIR body, so this is an
expected regression, and given the soundness fix is not too large to need
further investigation.

Rollup of 5 pull requests [#98874](https://github.com/rust-lang/rust/pull/98874)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a5c6a48aee84215a9200dfa1c4c6ad88f5721f56&end=9c9ae85a4773be3c1e33717e4fa9759b4ce020ef&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.6% | 0.9% | 13    |
| Regressions 😿 <br /> (secondary) | 1.4% | 2.4% | 12    |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | 0.6% | 0.9% | 13    |

Some possibly real, though small, regressions. Unclear cause; rollup doesn't
obviously contain any sensitive PRs.

Rollup of 8 pull requests [#98904](https://github.com/rust-lang/rust/pull/98904)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=27eb6d7018e397cf98d51c205e3576951d766323&end=e1d1848cc60a407d06f90fd16877a19bed6edd9b&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.7% | 0.9% | 8     |
| Regressions 😿 <br /> (secondary) | 1.1% | 2.3% | 16    |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | 0.7% | 0.9% | 8     |

Interestingly, regressions here are remarkably similar to those in #98874
(previous rollup in this list). Not seeing an obvious connection between the PRs
in the two rollups, though.

#### Improvements

proc_macro/bridge: stop using a remote object handle for proc_macro Punct and Group [#98188](https://github.com/rust-lang/rust/pull/98188)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=00ebeb87ac87a492bd59ace6bd43d6ad1629ca4e&end=94e93749ab00539a11e90426ea87382c433530a8&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -0.5% | -1.4% | 15    |
| Improvements 🎉 <br /> (secondary) | -1.6% | -5.0% | 16    |
| All 😿🎉 (primary) | -0.5% | -1.4% | 15    |


Update `smallvec` to 1.8.1. [#98558](https://github.com/rust-lang/rust/pull/98558)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=493c960a3e6cdd2e2fbe8b6ea130fadea05f1ab0&end=66c83ffca1512ed76f9445ec7f7280f768ef71c4&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | -1.7% | -2.4% | 9     |
| All 😿🎉 (primary) | N/A  | N/A | 0     |


CTFE interning: don't walk allocations that don't need it [#97585](https://github.com/rust-lang/rust/pull/97585)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6a1092056441652fe5fe5c5b422644951e6b99ce&end=750d6f85459356db4838dc06db8b19406e1ed31a&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -1.0% | -1.0% | 2     |
| Improvements 🎉 <br /> (secondary) | -2.5% | -9.3% | 32    |
| All 😿🎉 (primary) | -1.0% | -1.0% | 2     |


Optimize `Vec::insert` for the case where `index == len`. [#98755](https://github.com/rust-lang/rust/pull/98755)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ada8c80bedb713b320af00aacab97d01d9cb5933&end=f99f9e48ed77a99747c6d07b42fdfe500f1a7de0&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -0.4% | -1.0% | 8     |
| Improvements 🎉 <br /> (secondary) | -1.2% | -2.4% | 13    |
| All 😿🎉 (primary) | -0.4% | -1.0% | 8     |


fully move dropck to mir [#98641](https://github.com/rust-lang/rust/pull/98641)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9c9ae85a4773be3c1e33717e4fa9759b4ce020ef&end=a3beeaa84da241f35888338ded6659938206ff13&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.5% | 0.7% | 2     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -0.7% | -2.4% | 34    |
| Improvements 🎉 <br /> (secondary) | -0.8% | -2.1% | 22    |
| All 😿🎉 (primary) | -0.7% | -2.4% | 36    |


interpret: track place alignment together with the type, not the value [#98846](https://github.com/rust-lang/rust/pull/98846)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e1d1848cc60a407d06f90fd16877a19bed6edd9b&end=4008dd8c6d92a0b81528fd138c6130d784e5958e&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -0.7% | -0.9% | 8     |
| Improvements 🎉 <br /> (secondary) | -1.2% | -2.3% | 13    |
| All 😿🎉 (primary) | -0.7% | -0.9% | 8     |


#### Mixed

Rollup of 9 pull requests [#98612](https://github.com/rust-lang/rust/pull/98612)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=baf382e63c023259fa1f9042f8f479f183ca6ed3&end=00ebeb87ac87a492bd59ace6bd43d6ad1629ca4e&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.7% | 1.0% | 5     |
| Regressions 😿 <br /> (secondary) | 5.2% | 9.9% | 6     |
| Improvements 🎉 <br /> (primary) | -1.0% | -1.1% | 2     |
| Improvements 🎉 <br /> (secondary) | -0.8% | -2.4% | 22    |
| All 😿🎉 (primary) | 0.2% | -1.1% | 7     |


Rollup of 7 pull requests [#98656](https://github.com/rust-lang/rust/pull/98656)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=116edb6800ea1d6615578e7f65366ae65364b3d8&end=493c960a3e6cdd2e2fbe8b6ea130fadea05f1ab0&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 1.4% | 11.3% | 131   |
| Regressions 😿 <br /> (secondary) | 3.5% | 11.2% | 73    |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | -2.2% | -3.1% | 8     |
| All 😿🎉 (primary) | 1.4% | 11.3% | 131   |

Asked for further investigation on the PR, noting
[#98277](https://github.com/rust-lang/rust/pull/98277) as a possible cause.

move MIR syntax into a dedicated file and ping some people whenever it changes [#98649](https://github.com/rust-lang/rust/pull/98649)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5d3c6d6c83edc4ef245e77397c8e32d3ee453b67&end=a9eb9c52f3e8d8b6402e6acc69b9bcfc4f371d58&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.5% | 0.5% | 1     |
| Regressions 😿 <br /> (secondary) | 1.6% | 4.3% | 20    |
| Improvements 🎉 <br /> (primary) | -0.3% | -0.4% | 5     |
| Improvements 🎉 <br /> (secondary) | -0.3% | -0.3% | 3     |
| All 😿🎉 (primary) | -0.2% | 0.5% | 6     |

This is *probably* noise, but it's not very clear. Regressions are minor enough
that further investigation does not seem warranted.

Enable MIR inlining [#91743](https://github.com/rust-lang/rust/pull/91743)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=aedf78e56b2279cc869962feac5153b6ba7001ed&end=0075bb4fad68e64b6d1be06bf2db366c30bc75e1&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 1.3% | 7.2% | 54    |
| Regressions 😿 <br /> (secondary) | 1.7% | 6.1% | 68    |
| Improvements 🎉 <br /> (primary) | -2.6% | -10.0% | 118   |
| Improvements 🎉 <br /> (secondary) | -3.4% | -17.3% | 76    |
| All 😿🎉 (primary) | -1.4% | -10.0% | 172   |

A fairly large improvement for some benchmarks, and particularly large for
bootstrap times (nearly 9% win). There are some fairly large regressions to a
few select benchmarks which stress the inlining more than helping LLVM (e.g.,
stm32f4), but overall this is a great improvement in many cases.

Avoid unnecessary work in `finalize_resolutions_in`. [#98569](https://github.com/rust-lang/rust/pull/98569)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f2d93935ffba3ab9d7ccb5300771a2d29b4c8bf3&end=5f98537eb7b5f42c246a52c550813c3cff336069&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.3% | 0.5% | 7     |
| Regressions 😿 <br /> (secondary) | 0.5% | 0.7% | 7     |
| Improvements 🎉 <br /> (primary) | -1.0% | -1.0% | 2     |
| Improvements 🎉 <br /> (secondary) | -2.1% | -2.4% | 6     |
| All 😿🎉 (primary) | 0.0% | -1.0% | 9     |

Wins/losses balance out; already labeled as triaged.

Don't use match-destructuring for derived ops on structs. [#98446](https://github.com/rust-lang/rust/pull/98446)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2557603f320593be9d1c29a453c648e61e74d343&end=d46c728bcda687b1cf5f3bedca3d501e797b2a0f&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | 1.3% | 1.9% | 19    |
| Improvements 🎉 <br /> (primary) | -0.6% | -1.5% | 66    |
| Improvements 🎉 <br /> (secondary) | -5.4% | -12.3% | 33    |
| All 😿🎉 (primary) | -0.6% | -1.5% | 66    |

Overall an excellent, though somewhat small, improvement. Regressions are small
and limited to a couple very artificial stress tests rather than real-world
benchmarks.
