#include <iostream>

#include "CommandlineOptions.hh"

#include "Chirotope.hh"
#include "PlacingTriang.hh"
#include "Cocircuits.hh"
#include "Facets.hh"

int main (const int argc, const char** argv) {
  using namespace topcom;

  CommandlineOptions::init(argc, argv);
  MessageStreams::forced() << std::endl;
  MessageStreams::forced() << "------------------------------------------------------------------\n";
  MessageStreams::forced() << " computing the facets of a point configuration \n";
  MessageStreams::forced() << " TOPCOM client: " << CommandlineOptions::client() << '\n';
  MessageStreams::forced() << "------------------------------------------------------------------\n";
  MessageStreams::forced() << std::endl;
  PointConfiguration points;
  if (points.read(std::cin)) {
    Chirotope chiro(points, false);
    //    Cocircuits cocircuits(chiro, true);

    // PlacingTriang method:
    PlacingTriang triang(chiro);
    MessageStreams::result() << Facets(chiro, triang.boundary_triang()) << std::endl;
    return 0;
  }
  else {
    return 1;
  }
}

// eof points2facets.cc
