
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bseeditablesample.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bseeditablesample.h>
#include        <bse/gsldatahandle.h>


#line 25 "bseeditablesample.proc"


/* --- open --- */
static void
open_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 27 "bseeditablesample.proc"
 {
#line 29 "bseeditablesample.proc"
  *(in_pspecs++) = bse_param_spec_object ("esample", "Editable Sample", NULL,
				 BSE_TYPE_EDITABLE_SAMPLE, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
#line 34 "bseeditablesample.proc"
}  }
static BseErrorType
#line 34 "bseeditablesample.proc"
open_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 37 "bseeditablesample.proc"
{
#line 38 "bseeditablesample.proc"
  
  BseEditableSample *esample = bse_value_get_object (in_values++);
  BseErrorType error;
  
#line 42 "bseeditablesample.proc"
  
  if (!BSE_IS_EDITABLE_SAMPLE (esample))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 46 "bseeditablesample.proc"
  
  if (!esample->wchunk)
    error = BSE_ERROR_WAVE_NOT_FOUND;
  else if (esample->open_count)
    {
      esample->open_count++;
      error = BSE_ERROR_NONE;
    }
  else
    {
      error = gsl_wave_chunk_open (esample->wchunk);
      if (!error)
	esample->open_count++;
    }
  
#line 61 "bseeditablesample.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- close --- */
static void
close_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 67 "bseeditablesample.proc"
 {
#line 69 "bseeditablesample.proc"
  *(in_pspecs++) = bse_param_spec_object ("esample", "Editable Sample", NULL,
				 BSE_TYPE_EDITABLE_SAMPLE, SFI_PARAM_STANDARD);
#line 71 "bseeditablesample.proc"
}  }
static BseErrorType
#line 71 "bseeditablesample.proc"
close_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 74 "bseeditablesample.proc"
{
#line 75 "bseeditablesample.proc"
  
  BseEditableSample *esample = bse_value_get_object (in_values++);
  
#line 78 "bseeditablesample.proc"
  
  if (!BSE_IS_EDITABLE_SAMPLE (esample) || !esample->wchunk || !esample->open_count)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 82 "bseeditablesample.proc"
  
  esample->open_count--;
  if (!esample->open_count)
    gsl_wave_chunk_close (esample->wchunk);
  
  return BSE_ERROR_NONE;
}

/* --- get-length --- */
static void
get_length_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 90 "bseeditablesample.proc"
 {
#line 92 "bseeditablesample.proc"
  *(in_pspecs++) = bse_param_spec_object ("esample", "Editable Sample", NULL,
				 BSE_TYPE_EDITABLE_SAMPLE, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_int ("length", NULL, "Number of values",
			 1, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
#line 96 "bseeditablesample.proc"
}  }
static BseErrorType
#line 96 "bseeditablesample.proc"
get_length_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 99 "bseeditablesample.proc"
{
#line 100 "bseeditablesample.proc"
  
  BseEditableSample *esample = bse_value_get_object (in_values++);
  GslDataCache *dcache = NULL;
  
#line 104 "bseeditablesample.proc"
  
  if (!BSE_IS_EDITABLE_SAMPLE (esample))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 108 "bseeditablesample.proc"
  
  if (BSE_EDITABLE_SAMPLE_OPENED (esample) && esample->wchunk)
    dcache = esample->wchunk->dcache;
  sfi_value_set_int (out_values++, dcache ? gsl_data_handle_length (dcache->dhandle) : 0);
  
  return BSE_ERROR_NONE;
}

/* --- get-n-channels --- */
static void
get_n_channels_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 116 "bseeditablesample.proc"
 {
#line 118 "bseeditablesample.proc"
  *(in_pspecs++) = bse_param_spec_object ("esample", "Editable Sample", NULL,
				 BSE_TYPE_EDITABLE_SAMPLE, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_int ("n-channels", NULL, "Number of channels",
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
#line 122 "bseeditablesample.proc"
}  }
static BseErrorType
#line 122 "bseeditablesample.proc"
get_n_channels_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 125 "bseeditablesample.proc"
{
#line 126 "bseeditablesample.proc"
  
  BseEditableSample *esample = bse_value_get_object (in_values++);
  
#line 129 "bseeditablesample.proc"
  
  if (!BSE_IS_EDITABLE_SAMPLE (esample))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 133 "bseeditablesample.proc"
  
  sfi_value_set_int (out_values++, esample->wchunk ? esample->wchunk->n_channels : 1);
  
  return BSE_ERROR_NONE;
}

/* --- get-osc-freq --- */
static void
get_osc_freq_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 139 "bseeditablesample.proc"
 {
#line 141 "bseeditablesample.proc"
  *(in_pspecs++) = bse_param_spec_object ("esample", "Editable Sample", NULL,
				 BSE_TYPE_EDITABLE_SAMPLE, SFI_PARAM_STANDARD);
  *(out_pspecs++) = bse_param_spec_freq_simple ("osc-freq", NULL, "Oscillator Frequency",
				      SFI_PARAM_STANDARD);
#line 145 "bseeditablesample.proc"
}  }
static BseErrorType
#line 145 "bseeditablesample.proc"
get_osc_freq_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 148 "bseeditablesample.proc"
{
#line 149 "bseeditablesample.proc"
  
  BseEditableSample *esample = bse_value_get_object (in_values++);
  
#line 152 "bseeditablesample.proc"
  
  if (!BSE_IS_EDITABLE_SAMPLE (esample))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 156 "bseeditablesample.proc"
  
  sfi_value_set_real (out_values++, esample->wchunk ? esample->wchunk->osc_freq : BSE_KAMMER_FREQUENCY);
  
  return BSE_ERROR_NONE;
}

/* --- read-samples --- */
static void
read_samples_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 162 "bseeditablesample.proc"
 {
#line 164 "bseeditablesample.proc"
  *(in_pspecs++) = bse_param_spec_object ("esample", "Editable Sample", NULL,
				 BSE_TYPE_EDITABLE_SAMPLE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("voffset", NULL, "Value offset",
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_fblock ("sample_block", NULL, "Block of samples", SFI_PARAM_STANDARD);
#line 169 "bseeditablesample.proc"
}  }
static BseErrorType
#line 169 "bseeditablesample.proc"
read_samples_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 172 "bseeditablesample.proc"
{
#line 173 "bseeditablesample.proc"
  
  BseEditableSample *esample = bse_value_get_object (in_values++);
  guint              voffset = sfi_value_get_int (in_values++);
  GslDataCache *dcache = NULL;
  SfiFBlock *fblock;
  
#line 179 "bseeditablesample.proc"
  
  if (!BSE_IS_EDITABLE_SAMPLE (esample))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  if (BSE_EDITABLE_SAMPLE_OPENED (esample) && esample->wchunk)
    dcache = esample->wchunk->dcache;
  if (!dcache || voffset >= gsl_data_handle_length (dcache->dhandle))
    fblock = sfi_fblock_new_sized (1024);
  else
    {
      GslDataCacheNode *dnode = gsl_data_cache_ref_node (dcache, voffset, TRUE);
      guint i, l, dnode_length = dcache->node_size;
      
      l = dnode_length - (voffset - dnode->offset) + dcache->padding;
      l = MIN (l, gsl_data_handle_length (dcache->dhandle) - voffset);
      fblock = sfi_fblock_new_sized (l);
      for (i = 0; i < l; i++)
	fblock->values[i] = dnode->data[voffset - dnode->offset + i];
      gsl_data_cache_unref_node (dcache, dnode);
    }
  
#line 200 "bseeditablesample.proc"
  
  sfi_value_take_fblock (out_values++, fblock);
  
  return BSE_ERROR_NONE;
}

/* --- collect-stats --- */
static void
collect_stats_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 206 "bseeditablesample.proc"
 {
#line 208 "bseeditablesample.proc"
  *(in_pspecs++) = bse_param_spec_object ("esample", "Editable Sample", NULL,
				 BSE_TYPE_EDITABLE_SAMPLE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("voffset", NULL, "Offset of first stat block",
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_real ("offset_scale", NULL, "Factor to scale voffset increments with",
			  0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("block_size", NULL, "Block size to compute stat pairs from",
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("stepping", NULL, "Stepping within a stat block",
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("max_pairs", NULL, "Maximum number of (min, max) pairs to collect",
			 1, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_fblock ("sample_block", NULL, "Block of samples", SFI_PARAM_STANDARD);
#line 221 "bseeditablesample.proc"
}  }
static BseErrorType
#line 221 "bseeditablesample.proc"
collect_stats_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 224 "bseeditablesample.proc"
{
#line 225 "bseeditablesample.proc"
  
  BseEditableSample *esample    = bse_value_get_object (in_values++);
  guint              voffset    = sfi_value_get_int (in_values++);
  double             offs_scale = g_value_get_double (in_values++);
  guint              block_size = sfi_value_get_int (in_values++);
  guint              stepping   = sfi_value_get_int (in_values++);
  guint              max_pairs  = sfi_value_get_int (in_values++);
  GslDataCache *dcache = NULL;
  SfiFBlock *fblock;
  
#line 235 "bseeditablesample.proc"
  
  if (!BSE_IS_EDITABLE_SAMPLE (esample) || stepping < 1)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  if (BSE_EDITABLE_SAMPLE_OPENED (esample) && esample->wchunk)
    dcache = esample->wchunk->dcache;
  if (!dcache || voffset + block_size > gsl_data_handle_length (dcache->dhandle))
    fblock = sfi_fblock_new_sized (max_pairs * 2);
  else
    {
      GslDataCacheNode *dnode = gsl_data_cache_ref_node (dcache, voffset, GSL_DATA_CACHE_DEMAND_LOAD);
      guint j, dnode_length = dcache->node_size;
      
      fblock = sfi_fblock_new_sized (max_pairs * 2);
      for (j = 0; j < max_pairs; j++)
	{
	  guint i, cur_offset = j * offs_scale;
	  gfloat min = +1, max = -1;
	  
#line 254 "bseeditablesample.proc"
	  
	  cur_offset /= stepping;
	  cur_offset = voffset + cur_offset * stepping;
	  
#line 258 "bseeditablesample.proc"
	  
	  for (i = cur_offset; i < cur_offset + block_size; i += stepping)
	    {
	      guint pos;
	      
	      if (i < dnode->offset || i >= dnode->offset + dnode_length)
		{
		  gsl_data_cache_unref_node (dcache, dnode);
#line 266 "bseeditablesample.proc"
		  
		  dnode = gsl_data_cache_ref_node (dcache, i, j == 0 ? GSL_DATA_CACHE_DEMAND_LOAD : GSL_DATA_CACHE_PEEK);
		  if (!dnode)
		    goto break_loops;
		}
	      pos = i - dnode->offset;
	      min = MIN (min, dnode->data[pos]);
	      max = MAX (max, dnode->data[pos]);
	    }
	  fblock->values[j * 2] = min;
	  fblock->values[j * 2 + 1] = max;
	}
      gsl_data_cache_unref_node (dcache, dnode);
    break_loops:
      sfi_fblock_resize (fblock, j * 2);
    }
  
#line 283 "bseeditablesample.proc"
  
  sfi_value_take_fblock (out_values++, fblock);
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_open__fill_strings (BseExportStrings *es)
{
  es->blurb = ("Open the sample for reading.");
  es->file = "/opt/src/beast/bse/bseeditablesample.proc";
  es->line = 28;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_open = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseEditableSample+open", 
    NULL,
    "/Methods/BseEditableSample/General/Open",
    NULL,
    __enode_open__fill_strings,
  },
  0, open_setup, open_exec, 
};
static void
__enode_close__fill_strings (BseExportStrings *es)
{
  es->blurb = ("Close an opened sample.");
  es->file = "/opt/src/beast/bse/bseeditablesample.proc";
  es->line = 68;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_close = {
  { (BseExportNode*) &__enode_open, BSE_EXPORT_NODE_PROC,
    "BseEditableSample+close", 
    NULL,
    "/Methods/BseEditableSample/General/Close",
    NULL,
    __enode_close__fill_strings,
  },
  0, close_setup, close_exec, 
};
static void
__enode_get_length__fill_strings (BseExportStrings *es)
{
  es->blurb = ("Return the number of values in the sample.");
  es->file = "/opt/src/beast/bse/bseeditablesample.proc";
  es->line = 91;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_length = {
  { (BseExportNode*) &__enode_close, BSE_EXPORT_NODE_PROC,
    "BseEditableSample+get-length", 
    NULL,
    "/Methods/BseEditableSample/General/Get Length",
    NULL,
    __enode_get_length__fill_strings,
  },
  0, get_length_setup, get_length_exec, 
};
static void
__enode_get_n_channels__fill_strings (BseExportStrings *es)
{
  es->blurb = ("Return the number of channels in the sample.");
  es->file = "/opt/src/beast/bse/bseeditablesample.proc";
  es->line = 117;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_n_channels = {
  { (BseExportNode*) &__enode_get_length, BSE_EXPORT_NODE_PROC,
    "BseEditableSample+get-n-channels", 
    NULL,
    "/Methods/BseEditableSample/General/Get N Channels",
    NULL,
    __enode_get_n_channels__fill_strings,
  },
  0, get_n_channels_setup, get_n_channels_exec, 
};
static void
__enode_get_osc_freq__fill_strings (BseExportStrings *es)
{
  es->blurb = ("Return the oscillator frequency for the sample.");
  es->file = "/opt/src/beast/bse/bseeditablesample.proc";
  es->line = 140;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_osc_freq = {
  { (BseExportNode*) &__enode_get_n_channels, BSE_EXPORT_NODE_PROC,
    "BseEditableSample+get-osc-freq", 
    NULL,
    "/Methods/BseEditableSample/General/Get Osc Freq",
    NULL,
    __enode_get_osc_freq__fill_strings,
  },
  0, get_osc_freq_setup, get_osc_freq_exec, 
};
static void
__enode_read_samples__fill_strings (BseExportStrings *es)
{
  es->blurb = ("Read a set of samples from a specific offset.");
  es->file = "/opt/src/beast/bse/bseeditablesample.proc";
  es->line = 163;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_read_samples = {
  { (BseExportNode*) &__enode_get_osc_freq, BSE_EXPORT_NODE_PROC,
    "BseEditableSample+read-samples", 
    NULL,
    "/Methods/BseEditableSample/General/Read Samples",
    NULL,
    __enode_read_samples__fill_strings,
  },
  0, read_samples_setup, read_samples_exec, 
};
static void
__enode_collect_stats__fill_strings (BseExportStrings *es)
{
  es->blurb = ("Collect statistics from sample blocks as (minimum, maximum) pairs.");
  es->file = "/opt/src/beast/bse/bseeditablesample.proc";
  es->line = 207;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_collect_stats = {
  { (BseExportNode*) &__enode_read_samples, BSE_EXPORT_NODE_PROC,
    "BseEditableSample+collect-stats", 
    NULL,
    "/Methods/BseEditableSample/General/Collect Stats",
    NULL,
    __enode_collect_stats__fill_strings,
  },
  0, collect_stats_setup, collect_stats_exec, 
};
BseExportNode* bse__builtin_init_bseeditablesample_genprc_c (void);
BseExportNode* bse__builtin_init_bseeditablesample_genprc_c (void)
{
  return (BseExportNode*) &__enode_collect_stats;
}

/*
 * Generated data ends here
 */
