;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: GILT; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;         The Garnet User Interface Development Environment.      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; This code was written as part of the Garnet project at          ;;;
;;; Carnegie Mellon University, and has been placed in the public   ;;;
;;; domain.  If you are using this code or any part of Garnet,      ;;;
;;; please contact garnet@cs.cmu.edu to be put on the mailing list. ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; This file created by GILT V0.2: The Garnet Interface Builder
;;; on Dec 5, 1990, 10:49 AM
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

#|
============================================================
Change log:
    3/25/92 Brad Myers - fixed constant definitions
    2/19/92 Brad Myers - added constant definitions
    02/28/90 Andrew Mickish - Changed Export-p to single X-Button
    12/05/90 Brad Myers - hacked from created file
    12/05/90 Gilt - created
============================================================
|#

(in-package "GILT" :use '("LISP" "KR"))

(create-instance 'SAVE-FILE OPAL:AGGREGADGET
  (:WINDOW-TITLE "Save File")
  (:WINDOW-LEFT 100)
  (:WINDOW-TOP 200)
  (:WINDOW-WIDTH 316)
  (:WINDOW-HEIGHT 228)
  (:PACKAGE-NAME "GILT")
  (:FUNCTION-FOR-OK `GILT::DO-SAVE-FILE)
  (:LEFT 0)
  (:TOP 0)
  (:WIDTH (o-formula (GVL :WINDOW :WIDTH) 316))
  (:HEIGHT (o-formula (GVL :WINDOW :HEIGHT) 228))
  (:parts `(
    (NIL ,OPAL:TEXT
      (:CONSTANT (T))
      (:GILT-REF "TYPE-TEXT")
      (:FONT ,(create-instance nil OPAL:FONT
            (:CONSTANT '(T))
            (:SIZE :LARGE)
            (:FACE :BOLD-ITALIC)))
      (:BOX (9 8 35 14 ))
      (:STRING "Saving...")
      (:LEFT ,(o-formula (FIRST (GVL :BOX)) 9))
      (:TOP ,(o-formula (SECOND (GVL :BOX)) 8)))
    (:FILENAME ,GARNET-GADGETS:SCROLLING-LABELED-BOX
      (:CONSTANT (T))
      (:GILT-REF "TYPE-SCROLLING-LABELED-BOX")
      (:MIN-FRAME-WIDTH NIL)
      (:SELECT-FUNCTION NIL)
      (:FIELD-FONT ,OPAL:DEFAULT-FONT)
      (:FIELD-OFFSET 2)
      (:LABEL-OFFSET 5)
      (:LABEL-FONT ,(create-instance nil OPAL:FONT
            (:CONSTANT '(T))
            (:FACE :BOLD)))
      (:BOX (20 40 285 19 ))
      (:LABEL-STRING "Filename:")
      (:LEFT ,(o-formula (FIRST (GVL :BOX)) 20))
      (:TOP ,(o-formula (SECOND (GVL :BOX)) 40))
      (:WIDTH ,(o-formula (THIRD (GVL :BOX)) 285)))
    (:GADGET-NAME ,GARNET-GADGETS:SCROLLING-LABELED-BOX
      (:CONSTANT (T))
      (:GILT-REF "TYPE-SCROLLING-LABELED-BOX")
      (:MIN-FRAME-WIDTH NIL)
      (:SELECT-FUNCTION NIL)
      (:FIELD-FONT ,OPAL:DEFAULT-FONT)
      (:FIELD-OFFSET 2)
      (:LABEL-OFFSET 5)
      (:LABEL-FONT ,(create-instance nil OPAL:FONT
            (:CONSTANT '(T))
            (:FACE :BOLD)))
      (:LABEL-STRING "Top-level Gadget name:")
      (:BOX (20 70 285 18 ))
      (:LEFT ,(o-formula (FIRST (GVL :BOX)) 20))
      (:TOP ,(o-formula (SECOND (GVL :BOX)) 70))
      (:WIDTH ,(o-formula (THIRD (GVL :BOX)) 285)))
    (:WIN-TITLE ,GARNET-GADGETS:SCROLLING-LABELED-BOX
      (:CONSTANT (T))
      (:GILT-REF "TYPE-SCROLLING-LABELED-BOX")
      (:MIN-FRAME-WIDTH NIL)
      (:SELECT-FUNCTION NIL)
      (:FIELD-FONT ,OPAL:DEFAULT-FONT)
      (:FIELD-OFFSET 2)
      (:LABEL-OFFSET 5)
      (:LABEL-FONT ,(create-instance nil OPAL:FONT
            (:CONSTANT '(T))
            (:FACE :BOLD)))
      (:LABEL-STRING "Window Title:")
      (:BOX (20 130 285 18 ))
      (:LEFT ,(o-formula (FIRST (GVL :BOX)) 20))
      (:TOP ,(o-formula (SECOND (GVL :BOX)) 130))
      (:WIDTH ,(o-formula (THIRD (GVL :BOX)) 285)))
    (:PACKAGE-NAME ,GARNET-GADGETS:SCROLLING-LABELED-BOX
      (:CONSTANT (T))
      (:GILT-REF "TYPE-SCROLLING-LABELED-BOX")
      (:MIN-FRAME-WIDTH NIL)
      (:SELECT-FUNCTION NIL)
      (:FIELD-FONT ,OPAL:DEFAULT-FONT)
      (:FIELD-OFFSET 2)
      (:LABEL-OFFSET 5)
      (:LABEL-FONT ,(create-instance nil OPAL:FONT
            (:CONSTANT '(T))
            (:FACE :BOLD)))
      (:LABEL-STRING "Package name:")
      (:BOX (20 160 285 18 ))
      (:LEFT ,(o-formula (FIRST (GVL :BOX)) 20))
      (:TOP ,(o-formula (SECOND (GVL :BOX)) 160))
      (:WIDTH ,(o-formula (THIRD (GVL :BOX)) 285)))
    (:FUNCTION-FOR-OK-NAME ,GARNET-GADGETS:SCROLLING-LABELED-BOX
      (:CONSTANT (T :EXCEPT :ACTIVE))
      (:GILT-REF  "TYPE-SCROLLING-LABELED-BOX")
      (:MIN-FRAME-WIDTH NIL)
      (:SELECT-FUNCTION NIL)
      (:FIELD-FONT ,OPAL:DEFAULT-FONT)
      (:FIELD-OFFSET 2)
      (:LABEL-OFFSET 5)
      (:LABEL-FONT ,(create-instance nil OPAL:FONT
            (:CONSTANT '(T))
            (:FACE :BOLD)))
      (:BOX (20 190 285 18 ))
      (:LABEL-STRING "Function-for-OK name:")
      (:LEFT ,(o-formula (FIRST (GVL :BOX)) 20))
      (:TOP ,(o-formula (SECOND (GVL :BOX)) 190))
      (:WIDTH ,(o-formula (THIRD (GVL :BOX)) 285)))
    (NIL ,GARNET-GADGETS:TEXT-BUTTON-PANEL
      (:CONSTANT (T))
      (:SELECTION-FUNCTION GILT:OKCANCEL-FUNCTION)
      (:GILT-REF "TYPE-OKCANCEL")
      (:SELECT-FUNCTION GILT:OKCANCEL-FUNCTION)
      (:ITEMS ("OK" "Cancel" ))
      (:GRAY-WIDTH 3)
      (:FINAL-FEEDBACK-P NIL)
      (:TEXT-OFFSET 2)
      (:SHADOW-OFFSET 5)
      (:DIRECTION :HORIZONTAL)
      (:BOX (188 6 117 29 ))
      (:LEFT ,(o-formula (FIRST (GVL :BOX)) 188))
      (:TOP ,(o-formula (SECOND (GVL :BOX)) 6)))
    (:EXPORT-P ,GARNET-GADGETS:X-BUTTON
      (:CONSTANT (T))
      (:GRAY-WIDTH 3)
      (:TEXT-ON-LEFT-P T)
      (:BUTTON-HEIGHT 20)
      (:TEXT-OFFSET 5)
      (:SHADOW-OFFSET 5)
      (:BUTTON-WIDTH 20)
      (:FONT ,(create-instance nil OPAL:FONT
			       (:CONSTANT '(T))
			       (:FACE :BOLD)))
      (:BOX (20 100 197 25 ))
      (:string "Export Top-level Gadget?")
      (:LEFT ,(o-formula (FIRST (GVL :BOX)) 20))
      (:TOP ,(o-formula (SECOND (GVL :BOX)) 100)))
    (:FUNCTION-FOR-OK-VALIDP ,OPAL:RECTANGLE
      (:CONSTANT (T :EXCEPT :VISIBLE))
      (:GILT-REF "TYPE-RECTANGLE")
      (:DRAW-FUNCTION :AND)
      (:FILLING-STYLE ,OPAL:GRAY-FILL)
      (:LINE-STYLE NIL)
      (:BOX (14 186 297 28 ))
      (:LEFT ,(o-formula (FIRST (GVL :BOX)) 14))
      (:TOP ,(o-formula (SECOND (GVL :BOX)) 186))
      (:WIDTH ,(o-formula (THIRD (GVL :BOX)) 297))
      (:HEIGHT ,(o-formula (FOURTH (GVL :BOX)) 28))))))

