/* Copyright 2020 The Chromium OS Authors. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

#ifndef __CROS_EC_ATOMIC_H
#define __CROS_EC_ATOMIC_H

#include <sys/atomic.h>

static inline void atomic_clear_bits(atomic_t *addr, atomic_val_t bits)
{
	atomic_and(addr, ~bits);
}

#endif  /* __CROS_EC_ATOMIC_H */
