/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.term;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.FloatTerm;
import gnu.prolog.term.IntegerTerm;
import gnu.prolog.term.Term;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermComparator
implements Comparator<Term> {
    protected int currentIdx;
    protected Map<Term, Integer> orderMap = new HashMap<Term, Integer>();

    @Override
    public int compare(Term o1, Term o2) {
        int ty2;
        Term t2;
        Term t1 = o1.dereference();
        if (t1 == (t2 = o2.dereference())) {
            return 0;
        }
        int ty1 = t1.getTermType();
        if (ty1 != (ty2 = t2.getTermType())) {
            return ty1 - ty2;
        }
        switch (ty1) {
            case 1: 
            case 2: {
                Integer i2;
                Integer i1 = this.orderMap.get(t1);
                if (i1 == null) {
                    i1 = this.currentIdx++;
                    this.orderMap.put(t1, i1);
                }
                if ((i2 = this.orderMap.get(t2)) == null) {
                    i2 = this.currentIdx++;
                    this.orderMap.put(t2, i2);
                }
                return i1 - i2;
            }
            case 3: {
                FloatTerm ft1 = (FloatTerm)t1;
                FloatTerm ft2 = (FloatTerm)t2;
                double fr = ft1.value - ft2.value;
                if (fr < 0.0) {
                    return -1;
                }
                if (fr > 0.0) {
                    return 1;
                }
                return 0;
            }
            case 4: {
                IntegerTerm it1 = (IntegerTerm)t1;
                IntegerTerm it2 = (IntegerTerm)t2;
                return it1.value - it2.value;
            }
            case 5: {
                AtomTerm at1 = (AtomTerm)t1;
                AtomTerm at2 = (AtomTerm)t2;
                return at1.value.compareTo(at2.value);
            }
            case 6: {
                CompoundTerm ct1 = (CompoundTerm)t1;
                CompoundTerm ct2 = (CompoundTerm)t2;
                CompoundTermTag tag1 = ct1.tag;
                CompoundTermTag tag2 = ct2.tag;
                int ar1 = tag1.arity;
                int ar2 = tag2.arity;
                if (ar1 != ar2) {
                    return ar1 - ar2;
                }
                AtomTerm fu1 = tag1.functor;
                AtomTerm fu2 = tag2.functor;
                if (fu1 != fu2) {
                    return fu1.value.compareTo(fu2.value);
                }
                Term[] args1 = ct1.args;
                Term[] args2 = ct2.args;
                int i = 0;
                while (i < ar1) {
                    int rc = this.compare(args1[i], args2[i]);
                    if (rc != 0) {
                        return rc;
                    }
                    ++i;
                }
                break;
            }
        }
        return 0;
    }
}

