/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.bytecode.ArrayClassLoader;
import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.bytecode.ZipLoader;
import gnu.expr.AccessExp;
import gnu.expr.ApplyExp;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ErrorExp;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.Keyword;
import gnu.expr.LambdaExp;
import gnu.expr.LangExp;
import gnu.expr.Language;
import gnu.expr.LetExp;
import gnu.expr.ModuleExp;
import gnu.expr.ModuleInfo;
import gnu.expr.NameLookup;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.Special;
import gnu.expr.ThisExp;
import gnu.kawa.functions.AppendValues;
import gnu.kawa.functions.GetNamedPart;
import gnu.kawa.lispexpr.LispLanguage;
import gnu.kawa.reflect.ClassMethods;
import gnu.kawa.reflect.FieldLocation;
import gnu.kawa.reflect.SlotGet;
import gnu.kawa.reflect.StaticFieldLocation;
import gnu.kawa.xml.MakeAttribute;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.PairWithPosition;
import gnu.mapping.Environment;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.Location;
import gnu.mapping.Namespace;
import gnu.mapping.SimpleSymbol;
import gnu.mapping.Symbol;
import gnu.mapping.Values;
import gnu.text.SourceLocator;
import gnu.text.SourceMessages;
import java.io.Externalizable;
import java.util.Stack;
import java.util.Vector;
import kawa.lang.AutoloadProcedure;
import kawa.lang.Macro;
import kawa.lang.PatternScope;
import kawa.lang.Quote;
import kawa.lang.Syntax;
import kawa.lang.SyntaxForm;
import kawa.lang.TemplateScope;
import kawa.standard.begin;
import kawa.standard.require;

public class Translator
extends Compilation {
    private Environment env;
    public Macro currentMacroDefinition;
    public PatternScope patternScope;
    public Declaration templateScopeDecl;
    public Declaration matchArray;
    Stack renamedAliasStack;
    public Stack formStack = new Stack();
    public int firstForm;
    public Object pendingForm;
    public LambdaExp curMethodLambda;
    public static final Declaration getNamedPartDecl;
    public static final StaticFieldLocation getNamedPartLocation;
    private static Expression errorExp;
    Syntax currentSyntax;
    Declaration macroContext;
    PairWithPosition positionPair;
    Vector notedAccess;

    public boolean isLexical(Declaration declaration) {
        if (declaration == null) {
            return false;
        }
        if (!declaration.isFluid()) {
            return true;
        }
        ScopeExp scopeExp = this.currentScope();
        ScopeExp scopeExp2 = declaration.getContext();
        while (scopeExp != null) {
            if (scopeExp == scopeExp2) {
                return true;
            }
            if (scopeExp instanceof LambdaExp && !((LambdaExp)scopeExp).getInlineOnly()) {
                return false;
            }
            scopeExp = scopeExp.outer;
        }
        return false;
    }

    public Translator(Language language, SourceMessages sourceMessages, NameLookup nameLookup) {
        super(language, sourceMessages, nameLookup);
        this.env = Environment.getCurrent();
    }

    public final Environment getGlobalEnvironment() {
        return this.env;
    }

    public Expression parse(Object object2) {
        return this.rewrite(object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression rewrite_car(Pair pair, SyntaxForm syntaxForm) {
        if (syntaxForm == null || syntaxForm.scope == this.current_scope || pair.getCar() instanceof SyntaxForm) {
            return this.rewrite_car(pair, false);
        }
        ScopeExp scopeExp = this.current_scope;
        try {
            this.setCurrentScope(syntaxForm.scope);
            Expression expression = this.rewrite_car(pair, false);
            return expression;
        }
        finally {
            this.setCurrentScope(scopeExp);
        }
    }

    public final Expression rewrite_car(Pair pair, boolean bl) {
        Object object2 = pair.getCar();
        if (pair instanceof PairWithPosition) {
            return this.rewrite_with_position(object2, bl, (PairWithPosition)pair);
        }
        return this.rewrite(object2, bl);
    }

    public Syntax getCurrentSyntax() {
        return this.currentSyntax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Expression apply_rewrite(Syntax syntax2, Pair pair) {
        Expression expression = errorExp;
        Syntax syntax3 = this.currentSyntax;
        this.currentSyntax = syntax2;
        try {
            expression = syntax2.rewriteForm(pair, this);
        }
        finally {
            this.currentSyntax = syntax3;
        }
        return expression;
    }

    static ReferenceExp getOriginalRef(Declaration declaration) {
        Expression expression;
        if (declaration != null && declaration.isAlias() && !declaration.isIndirectBinding() && (expression = declaration.getValue()) instanceof ReferenceExp) {
            return (ReferenceExp)expression;
        }
        return null;
    }

    public final boolean selfEvaluatingSymbol(Object object2) {
        return ((LispLanguage)this.getLanguage()).selfEvaluatingSymbol(object2);
    }

    public final boolean matches(Object object2, String string) {
        return this.matches(object2, null, string);
    }

    public boolean matches(Object object2, SyntaxForm syntaxForm, String string) {
        ReferenceExp referenceExp;
        if (syntaxForm != null) {
            // empty if block
        }
        if (object2 instanceof SyntaxForm) {
            object2 = ((SyntaxForm)object2).form;
        }
        if (object2 instanceof SimpleSymbol && !this.selfEvaluatingSymbol(object2) && (referenceExp = Translator.getOriginalRef(this.lexical.lookup(object2, -1))) != null) {
            object2 = referenceExp.getSymbol();
        }
        return object2 instanceof SimpleSymbol && ((Symbol)object2).getLocalPart() == string;
    }

    public boolean matches(Object object2, SyntaxForm syntaxForm, Symbol symbol) {
        ReferenceExp referenceExp;
        if (syntaxForm != null) {
            // empty if block
        }
        if (object2 instanceof SyntaxForm) {
            object2 = ((SyntaxForm)object2).form;
        }
        if (object2 instanceof SimpleSymbol && !this.selfEvaluatingSymbol(object2) && (referenceExp = Translator.getOriginalRef(this.lexical.lookup(object2, -1))) != null) {
            object2 = referenceExp.getSymbol();
        }
        return object2 == symbol;
    }

    public Declaration lookup(Object object2, int n) {
        Declaration declaration = this.lexical.lookup(object2, n);
        if (declaration != null && this.getLanguage().hasNamespace(declaration, n)) {
            return declaration;
        }
        return this.currentModule().lookup(object2, this.getLanguage(), n);
    }

    public Declaration lookupGlobal(Object object2) {
        return this.lookupGlobal(object2, -1);
    }

    public Declaration lookupGlobal(Object object2, int n) {
        ModuleExp moduleExp = this.currentModule();
        Declaration declaration = moduleExp.lookup(object2, this.getLanguage(), n);
        if (declaration == null) {
            declaration = moduleExp.getNoDefine(object2);
            declaration.setIndirectBinding(true);
        }
        return declaration;
    }

    Syntax check_if_Syntax(Declaration declaration) {
        Declaration declaration2 = Declaration.followAliases(declaration);
        Object object2 = null;
        Expression expression = declaration2.getValue();
        if (expression != null && declaration2.getFlag(32768)) {
            try {
                if (declaration.getValue() instanceof ReferenceExp) {
                    Declaration declaration3 = ((ReferenceExp)declaration.getValue()).contextDecl();
                    if (declaration3 != null) {
                        this.macroContext = declaration3;
                    } else if (this.current_scope instanceof TemplateScope) {
                        this.macroContext = ((TemplateScope)this.current_scope).macroContext;
                    }
                } else if (this.current_scope instanceof TemplateScope) {
                    this.macroContext = ((TemplateScope)this.current_scope).macroContext;
                }
                object2 = expression.eval(this.env);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.error('e', "unable to evaluate macro for " + declaration.getSymbol());
            }
        } else if (declaration.getFlag(32768) && !declaration.needsContext()) {
            StaticFieldLocation staticFieldLocation = StaticFieldLocation.make(declaration);
            object2 = staticFieldLocation.get(null);
        }
        return object2 instanceof Syntax ? (Syntax)object2 : null;
    }

    public Expression rewrite_pair(Pair pair, boolean bl) {
        Object object2;
        Object object3;
        Object object4;
        int n;
        Object object5;
        Object object6;
        if (pair.getCar() instanceof Syntax) {
            return this.apply_rewrite((Syntax)pair.getCar(), pair);
        }
        Object object7 = pair.getCdr();
        Expression expression = this.rewrite_car(pair, true);
        Object object8 = null;
        ReferenceExp referenceExp = null;
        if (expression instanceof ReferenceExp) {
            Object object9;
            referenceExp = (ReferenceExp)expression;
            Declaration declaration = referenceExp.getBinding();
            if (declaration == null) {
                object9 = referenceExp.getSymbol();
                if (object9 instanceof Symbol && !this.selfEvaluatingSymbol(object9)) {
                    object6 = (Symbol)object9;
                    object5 = ((Symbol)object6).getName();
                } else {
                    object5 = object9.toString();
                    object6 = this.env.getSymbol((String)object5);
                }
                object8 = this.env.get((Symbol)object6, this.getLanguage().hasSeparateFunctionNamespace() ? EnvironmentKey.FUNCTION : null, null);
                if (object8 instanceof Syntax) {
                    return this.apply_rewrite((Syntax)object8, pair);
                }
                if (object8 instanceof AutoloadProcedure) {
                    try {
                        object8 = ((AutoloadProcedure)object8).getLoaded();
                    }
                    catch (RuntimeException runtimeException) {
                        object8 = null;
                    }
                }
            } else {
                object9 = this.macroContext;
                object6 = this.check_if_Syntax(declaration);
                if (object6 != null) {
                    Expression expression2 = this.apply_rewrite((Syntax)object6, pair);
                    this.macroContext = object9;
                    return expression2;
                }
            }
            referenceExp.setProcedureName(true);
            if (this.getLanguage().hasSeparateFunctionNamespace()) {
                expression.setFlag(4);
            }
        }
        if ((n = Translator.listLength(object7)) == -1) {
            return this.syntaxError("circular list is not allowed after " + pair.getCar());
        }
        if (n < 0) {
            return this.syntaxError("dotted list [" + object7 + "] is not allowed after " + pair.getCar());
        }
        boolean bl2 = false;
        object6 = new Stack();
        object5 = this.current_scope;
        int n2 = 0;
        while (n2 < n) {
            if (object7 instanceof SyntaxForm) {
                object4 = (SyntaxForm)object7;
                object7 = ((SyntaxForm)object4).form;
                this.setCurrentScope(((SyntaxForm)object4).scope);
            }
            object4 = (Pair)object7;
            object3 = this.rewrite_car((Pair)object4, false);
            ++n2;
            if (bl2) {
                if ((n2 & 1) == 0) {
                    object2 = new Expression[]{(Expression)((Stack)object6).pop(), object3};
                    object3 = new ApplyExp(MakeAttribute.makeAttribute, (Expression[])object2);
                } else if (object3 instanceof QuoteExp && (object2 = ((QuoteExp)object3).getValue()) instanceof Keyword && n2 < n) {
                    object3 = new QuoteExp(((Keyword)object2).asSymbol());
                } else {
                    bl2 = false;
                }
            }
            ((Vector)object6).addElement(object3);
            object7 = ((Pair)object4).getCdr();
        }
        Object[] objectArray = new Expression[((Vector)object6).size()];
        ((Vector)object6).copyInto(objectArray);
        if (object5 != this.current_scope) {
            this.setCurrentScope((ScopeExp)object5);
        }
        if (expression instanceof ReferenceExp && ((ReferenceExp)expression).getBinding() == getNamedPartDecl) {
            object4 = objectArray[0];
            object3 = objectArray[1];
            object2 = this.namespaceResolve((Expression)object4, (Expression)object3);
            if (object2 != null) {
                return this.rewrite(object2, bl);
            }
            return GetNamedPart.makeExp((Expression)object4, (Expression)object3);
        }
        return ((LispLanguage)this.getLanguage()).makeApply(expression, (Expression[])objectArray);
    }

    public Namespace namespaceResolvePrefix(Expression expression) {
        if (expression instanceof ReferenceExp) {
            Object object2;
            Object object3;
            Object object4;
            ReferenceExp referenceExp = (ReferenceExp)expression;
            Declaration declaration = referenceExp.getBinding();
            if (declaration == null || declaration.getFlag(65536)) {
                object4 = referenceExp.getSymbol();
                object3 = object4 instanceof Symbol ? (Symbol)object4 : this.env.getSymbol(object4.toString());
                object2 = this.env.get((EnvironmentKey)object3, null);
            } else {
                object2 = declaration.isNamespaceDecl() ? declaration.getConstantValue() : null;
            }
            if (object2 instanceof Namespace) {
                object4 = (Namespace)object2;
                object3 = ((Namespace)object4).getName();
                if (object3 != null && ((String)object3).startsWith("class:")) {
                    return null;
                }
                return object4;
            }
        }
        return null;
    }

    public Symbol namespaceResolve(Namespace namespace, Expression expression) {
        if (namespace != null && expression instanceof QuoteExp) {
            String string = ((QuoteExp)expression).getValue().toString().intern();
            return namespace.getSymbol(string);
        }
        return null;
    }

    public Symbol namespaceResolve(Expression expression, Expression expression2) {
        return this.namespaceResolve(this.namespaceResolvePrefix(expression), expression2);
    }

    public static Object stripSyntax(Object object2) {
        while (object2 instanceof SyntaxForm) {
            object2 = ((SyntaxForm)object2).form;
        }
        return object2;
    }

    public static Object safeCar(Object object2) {
        while (object2 instanceof SyntaxForm) {
            object2 = ((SyntaxForm)object2).form;
        }
        if (!(object2 instanceof Pair)) {
            return null;
        }
        return Translator.stripSyntax(((Pair)object2).getCar());
    }

    public static Object safeCdr(Object object2) {
        while (object2 instanceof SyntaxForm) {
            object2 = ((SyntaxForm)object2).form;
        }
        if (!(object2 instanceof Pair)) {
            return null;
        }
        return Translator.stripSyntax(((Pair)object2).getCdr());
    }

    public static int listLength(Object object2) {
        int n = 0;
        Object object3 = object2;
        Object object4 = object2;
        while (true) {
            if (object4 instanceof SyntaxForm) {
                object4 = ((SyntaxForm)object4).form;
                continue;
            }
            while (object3 instanceof SyntaxForm) {
                object3 = ((SyntaxForm)object3).form;
            }
            if (object4 == LList.Empty) {
                return n;
            }
            if (!(object4 instanceof Pair)) {
                return -1 - n;
            }
            ++n;
            Object object5 = ((Pair)object4).getCdr();
            while (object5 instanceof SyntaxForm) {
                object5 = ((SyntaxForm)object5).form;
            }
            if (object5 == LList.Empty) {
                return n;
            }
            if (!(object5 instanceof Pair)) {
                return -1 - n;
            }
            object3 = ((Pair)object3).getCdr();
            object4 = ((Pair)object5).getCdr();
            ++n;
            if (object4 == object3) break;
        }
        return Integer.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewriteInBody(Object object2) {
        if (object2 instanceof SyntaxForm) {
            SyntaxForm syntaxForm = (SyntaxForm)object2;
            ScopeExp scopeExp = this.current_scope;
            try {
                this.setCurrentScope(syntaxForm.scope);
                this.rewriteInBody(syntaxForm.form);
            }
            finally {
                this.setCurrentScope(scopeExp);
            }
        } else if (object2 instanceof Values) {
            Object[] objectArray = ((Values)object2).getValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.rewriteInBody(objectArray[i]);
            }
        } else {
            this.formStack.add(this.rewrite(object2, false));
        }
    }

    public Expression rewrite(Object object2) {
        return this.rewrite(object2, false);
    }

    public Object namespaceResolve(Object object2) {
        Pair pair;
        if (!(object2 instanceof SimpleSymbol) && object2 instanceof Pair && Translator.safeCar(pair = (Pair)object2) == LispLanguage.lookup_sym && pair.getCdr() instanceof Pair && (pair = (Pair)pair.getCdr()).getCdr() instanceof Pair) {
            Expression expression;
            Expression expression2 = this.rewrite(pair.getCar());
            Symbol symbol = this.namespaceResolve(expression2, expression = this.rewrite(((Pair)pair.getCdr()).getCar()));
            if (symbol != null) {
                return symbol;
            }
            String string = GetNamedPart.combineName(expression2, expression);
            if (string != null) {
                return Namespace.EmptyNamespace.getSymbol(string);
            }
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression rewrite(Object object2, boolean bl) {
        if (object2 instanceof SyntaxForm) {
            SyntaxForm syntaxForm = (SyntaxForm)object2;
            ScopeExp scopeExp = this.current_scope;
            try {
                Expression expression;
                this.setCurrentScope(syntaxForm.scope);
                Expression expression2 = expression = this.rewrite(syntaxForm.form, bl);
                return expression2;
            }
            finally {
                this.setCurrentScope(scopeExp);
            }
        }
        if (object2 instanceof PairWithPosition) {
            return this.rewrite_with_position(object2, bl, (PairWithPosition)object2);
        }
        if (object2 instanceof Pair) {
            return this.rewrite_pair((Pair)object2, bl);
        }
        if (object2 instanceof Symbol && !this.selfEvaluatingSymbol(object2)) {
            boolean bl2;
            Object object3;
            Object object4;
            Declaration declaration;
            Declaration declaration2;
            block41: {
                PrimProcedure[] primProcedureArray;
                Object object5;
                String string;
                int n;
                declaration2 = this.lexical.lookup(object2, bl);
                declaration = null;
                ScopeExp scopeExp = this.current_scope;
                int n2 = n = declaration2 == null ? -1 : ScopeExp.nesting(declaration2.context);
                if (object2 instanceof Symbol && ((Symbol)object2).hasEmptyNamespace()) {
                    string = object2.toString();
                } else {
                    string = null;
                    scopeExp = null;
                }
                while (scopeExp != null) {
                    if (scopeExp instanceof LambdaExp && scopeExp.outer instanceof ClassExp && ((LambdaExp)scopeExp).isClassMethod()) {
                        char c;
                        boolean bl3;
                        if (n >= ScopeExp.nesting(scopeExp.outer)) break;
                        object4 = (LambdaExp)scopeExp;
                        object5 = (ClassExp)scopeExp.outer;
                        ClassType classType = (ClassType)((LambdaExp)object5).getType();
                        object3 = SlotGet.lookupMember(classType, string, classType);
                        boolean bl4 = bl3 = object4 == ((ClassExp)object5).clinitMethod || object4 != ((ClassExp)object5).initMethod && ((LambdaExp)object4).nameDecl.isStatic();
                        if (object3 != null || (primProcedureArray = ClassMethods.getMethods(classType, string, c = bl3 ? (char)'S' : 'V', classType, this.language)).length != 0) {
                            ReferenceExp referenceExp = bl3 ? new ReferenceExp(((ClassExp)((LambdaExp)object4).outer).nameDecl) : new ThisExp(((ScopeExp)object4).firstDecl());
                            return GetNamedPart.makeExp((Expression)referenceExp, QuoteExp.getInstance(string));
                        }
                    }
                    scopeExp = scopeExp.outer;
                }
                if (declaration2 != null) {
                    object4 = declaration2.getSymbol();
                    object2 = null;
                    object5 = Translator.getOriginalRef(declaration2);
                    if (object5 != null && (declaration2 = ((AccessExp)object5).getBinding()) == null) {
                        object4 = object2 = ((AccessExp)object5).getSymbol();
                    }
                } else {
                    object4 = object2;
                }
                object5 = (Symbol)object2;
                bl2 = this.getLanguage().hasSeparateFunctionNamespace();
                if (declaration2 != null) {
                    if (!this.isLexical(declaration2) || bl2 && declaration2.isProcedureDecl()) {
                        declaration2 = null;
                    } else if (this.current_scope instanceof TemplateScope && declaration2.needsContext()) {
                        declaration = ((TemplateScope)this.current_scope).macroContext;
                    } else if (declaration2.getFlag(0x100000) && !declaration2.isStatic()) {
                        scopeExp = this.currentScope();
                        while (true) {
                            if (scopeExp == null) {
                                throw new Error("internal error: missing " + declaration2);
                            }
                            if (scopeExp.outer == declaration2.context) break;
                            scopeExp = scopeExp.outer;
                        }
                        declaration = scopeExp.firstDecl();
                    }
                } else {
                    Expression expression;
                    object3 = this.env.lookup((Symbol)object5, bl && bl2 ? EnvironmentKey.FUNCTION : null);
                    if (object3 != null) {
                        object3 = ((Location)object3).getBase();
                    }
                    if (object3 instanceof FieldLocation) {
                        FieldLocation fieldLocation = (FieldLocation)object3;
                        try {
                            declaration2 = fieldLocation.getDeclaration();
                            if (!this.inlineOk(null) && declaration2 != getNamedPartDecl) {
                                declaration2 = null;
                                break block41;
                            }
                            if (this.immediate) {
                                if (!declaration2.isStatic()) {
                                    declaration = new Declaration("(module-instance)");
                                    declaration.setValue(new QuoteExp(fieldLocation.getInstance()));
                                }
                                break block41;
                            }
                            if (declaration2.isStatic()) {
                                Class clazz = fieldLocation.getRClass();
                                if (clazz == null || (primProcedureArray = clazz.getClassLoader()) instanceof ZipLoader || primProcedureArray instanceof ArrayClassLoader) {
                                    declaration2 = null;
                                }
                                break block41;
                            }
                            declaration2 = null;
                        }
                        catch (Throwable throwable) {
                            this.error('e', "exception loading '" + object2 + "' - " + throwable.getMessage());
                            declaration2 = null;
                        }
                    } else if (!(object3 != null && ((Location)object3).isBound() || (expression = ((LispLanguage)this.getLanguage()).checkDefaultBinding((Symbol)object5, this)) == null)) {
                        return expression;
                    }
                }
            }
            if (declaration2 != null) {
                declaration2.setFlag(262144);
                if (declaration2.getContext() instanceof PatternScope) {
                    return this.syntaxError("reference to pattern variable " + declaration2.getName() + " outside syntax template");
                }
            }
            object3 = new ReferenceExp(object4, declaration2);
            ((AccessExp)object3).setContextDecl(declaration);
            ((Expression)object3).setLine(this);
            if (bl && bl2) {
                ((Expression)object3).setFlag(4);
            }
            return object3;
        }
        if (object2 instanceof LangExp) {
            return this.rewrite(((LangExp)object2).getLangValue(), bl);
        }
        if (object2 instanceof Expression) {
            return (Expression)object2;
        }
        if (object2 == Special.abstractSpecial) {
            return QuoteExp.abstractExp;
        }
        return QuoteExp.getInstance(Quote.quote(object2, this));
    }

    public static void setLine(Expression expression, Object object2) {
        if (object2 instanceof SourceLocator) {
            expression.setLocation((SourceLocator)object2);
        }
    }

    public static void setLine(Declaration declaration, Object object2) {
        if (object2 instanceof SourceLocator) {
            declaration.setLocation((SourceLocator)object2);
        }
    }

    public Object pushPositionOf(Object object2) {
        if (object2 instanceof SyntaxForm) {
            object2 = ((SyntaxForm)object2).form;
        }
        if (!(object2 instanceof PairWithPosition)) {
            return null;
        }
        PairWithPosition pairWithPosition = (PairWithPosition)object2;
        PairWithPosition pairWithPosition2 = this.positionPair == null || this.positionPair.getFileName() != this.getFileName() || this.positionPair.getLineNumber() != this.getLineNumber() || this.positionPair.getColumnNumber() != this.getColumnNumber() ? new PairWithPosition(this, Special.eof, this.positionPair) : this.positionPair;
        this.setLine(object2);
        this.positionPair = pairWithPosition;
        return pairWithPosition2;
    }

    public void popPositionOf(Object object2) {
        if (object2 == null) {
            return;
        }
        this.setLine(object2);
        this.positionPair = (PairWithPosition)object2;
        if (this.positionPair.getCar() == Special.eof) {
            this.positionPair = (PairWithPosition)this.positionPair.getCdr();
        }
    }

    public void setLineOf(Expression expression) {
        if (expression instanceof QuoteExp) {
            return;
        }
        expression.setLocation(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type exp2Type(Pair pair) {
        Object object2 = this.pushPositionOf(pair);
        try {
            Expression expression = this.rewrite_car(pair, false);
            expression = new InlineCalls(this).walk(expression);
            if (expression instanceof ErrorExp) {
                Type type = null;
                return type;
            }
            Type type = this.getLanguage().getTypeFor(expression);
            if (type == null) {
                if (expression instanceof ReferenceExp) {
                    this.error('e', "unknown type name '" + ((ReferenceExp)expression).getName() + '\'');
                } else {
                    this.error('e', "invalid type spec (must be \"type\" or 'type or <type>)");
                }
                ClassType classType = Type.pointer_type;
                return classType;
            }
            Type type2 = type;
            return type2;
        }
        finally {
            this.popPositionOf(object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression rewrite_with_position(Object object2, boolean bl, PairWithPosition pairWithPosition) {
        Expression expression;
        Object object3 = this.pushPositionOf(pairWithPosition);
        try {
            expression = object2 == pairWithPosition ? this.rewrite_pair(pairWithPosition, bl) : this.rewrite(object2, bl);
            this.setLineOf(expression);
        }
        finally {
            this.popPositionOf(object3);
        }
        return expression;
    }

    public static Object wrapSyntax(Object object2, SyntaxForm syntaxForm) {
        if (syntaxForm == null || object2 instanceof Expression) {
            return object2;
        }
        return syntaxForm.fromDatumIfNeeded(object2);
    }

    public Object popForms(int n) {
        Object object2;
        int n2 = this.formStack.size();
        if (n2 == n) {
            return Values.empty;
        }
        if (n2 == n + 1) {
            object2 = this.formStack.elementAt(n);
        } else {
            Values values = new Values();
            for (int i = n; i < n2; ++i) {
                values.writeObject(this.formStack.elementAt(i));
            }
            object2 = values;
        }
        this.formStack.setSize(n);
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanForm(Object object2, ScopeExp scopeExp) {
        if (object2 instanceof SyntaxForm) {
            SyntaxForm syntaxForm = (SyntaxForm)object2;
            ScopeExp scopeExp2 = this.currentScope();
            try {
                this.setCurrentScope(syntaxForm.scope);
                int n = this.formStack.size();
                this.scanForm(syntaxForm.form, scopeExp);
                this.formStack.add(Translator.wrapSyntax(this.popForms(n), syntaxForm));
                return;
            }
            finally {
                this.setCurrentScope(scopeExp2);
            }
        }
        if (object2 instanceof Values) {
            if (object2 == Values.empty) {
                object2 = QuoteExp.voidExp;
            } else {
                Object[] objectArray = ((Values)object2).getValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    this.scanForm(objectArray[i], scopeExp);
                }
                return;
            }
        }
        if (object2 instanceof Pair) {
            Object object3;
            Pair pair = (Pair)object2;
            Declaration declaration = this.macroContext;
            Syntax syntax2 = null;
            ScopeExp scopeExp3 = this.current_scope;
            Object object4 = this.pushPositionOf(object2);
            try {
                SourceLocator sourceLocator;
                Expression expression;
                Externalizable externalizable;
                object3 = pair.getCar();
                if (object3 instanceof SyntaxForm) {
                    externalizable = (SyntaxForm)pair.getCar();
                    this.setCurrentScope(((SyntaxForm)externalizable).scope);
                    object3 = ((SyntaxForm)externalizable).form;
                }
                if (object3 instanceof Pair && ((Pair)(externalizable = (Pair)object3)).getCar() == LispLanguage.lookup_sym && ((Pair)externalizable).getCdr() instanceof Pair && ((Pair)(externalizable = (Pair)((Pair)externalizable).getCdr())).getCdr() instanceof Pair) {
                    expression = this.rewrite(((Pair)externalizable).getCar());
                    sourceLocator = this.rewrite(((Pair)((Pair)externalizable).getCdr()).getCar());
                    Object object5 = expression.valueIfConstant();
                    Object object6 = ((Expression)sourceLocator).valueIfConstant();
                    if (object5 instanceof Class && object6 instanceof Symbol) {
                        try {
                            object3 = GetNamedPart.getNamedPart(object5, (Symbol)object6);
                            if (object3 instanceof Syntax) {
                                syntax2 = (Syntax)object3;
                            }
                        }
                        catch (Throwable throwable) {
                            object3 = null;
                        }
                    } else {
                        object3 = this.namespaceResolve(expression, (Expression)sourceLocator);
                    }
                }
                if (object3 instanceof Symbol && !this.selfEvaluatingSymbol(object3)) {
                    expression = this.rewrite(object3, true);
                    if (expression instanceof ReferenceExp) {
                        sourceLocator = ((ReferenceExp)expression).getBinding();
                        if (sourceLocator != null) {
                            syntax2 = this.check_if_Syntax((Declaration)sourceLocator);
                        } else if ((object3 = this.resolve(object3, true)) instanceof Syntax) {
                            syntax2 = (Syntax)object3;
                        }
                    }
                } else if (object3 == begin.begin) {
                    syntax2 = (Syntax)object3;
                }
            }
            finally {
                if (scopeExp3 != this.current_scope) {
                    this.setCurrentScope(scopeExp3);
                }
                this.popPositionOf(object4);
            }
            if (syntax2 != null) {
                object3 = this.getFileName();
                int n = this.getLineNumber();
                int n2 = this.getColumnNumber();
                try {
                    this.setLine(pair);
                    syntax2.scanForm(pair, scopeExp, this);
                    return;
                }
                finally {
                    this.macroContext = declaration;
                    this.setLine((String)object3, n, n2);
                }
            }
        }
        this.formStack.add(object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object scanBody(Object object2, ScopeExp scopeExp, boolean bl) {
        Object object3 = bl ? LList.Empty : null;
        Object object4 = null;
        while (object2 != LList.Empty) {
            Object object5;
            int n;
            Externalizable externalizable;
            if (object2 instanceof SyntaxForm) {
                externalizable = (SyntaxForm)object2;
                ScopeExp scopeExp2 = this.current_scope;
                try {
                    this.setCurrentScope(((SyntaxForm)externalizable).scope);
                    n = this.formStack.size();
                    Object object6 = this.scanBody(((SyntaxForm)externalizable).form, scopeExp, bl);
                    if (bl) {
                        object6 = Translator.wrapSyntax(object6, (SyntaxForm)externalizable);
                        if (object4 == null) {
                            object5 = object6;
                            return object5;
                        }
                        ((Pair)object4).setCdrBackdoor(object6);
                        object5 = object3;
                        return object5;
                    }
                    this.formStack.add(Translator.wrapSyntax(this.popForms(n), (SyntaxForm)externalizable));
                    object5 = null;
                    return object5;
                }
                finally {
                    this.setCurrentScope(scopeExp2);
                }
            }
            if (object2 instanceof Pair) {
                externalizable = (Pair)object2;
                int n2 = this.formStack.size();
                this.scanForm(((Pair)externalizable).getCar(), scopeExp);
                if (this.getState() == 2) {
                    if (((Pair)externalizable).getCar() != this.pendingForm) {
                        externalizable = Translator.makePair((Pair)externalizable, this.pendingForm, ((Pair)externalizable).getCdr());
                    }
                    this.pendingForm = new Pair(begin.begin, externalizable);
                    return LList.Empty;
                }
                n = this.formStack.size();
                if (bl) {
                    for (int i = n2; i < n; ++i) {
                        object5 = Translator.makePair((Pair)externalizable, this.formStack.elementAt(i), LList.Empty);
                        if (object4 == null) {
                            object3 = object5;
                        } else {
                            ((Pair)object4).setCdrBackdoor(object5);
                        }
                        object4 = object5;
                    }
                    this.formStack.setSize(n2);
                }
                object2 = ((Pair)externalizable).getCdr();
                continue;
            }
            this.formStack.add(this.syntaxError("body is not a proper list"));
            break;
        }
        return object3;
    }

    public static Pair makePair(Pair pair, Object object2, Object object3) {
        if (pair instanceof PairWithPosition) {
            return new PairWithPosition((PairWithPosition)pair, object2, object3);
        }
        return new Pair(object2, object3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression rewrite_body(Object object2) {
        Object object3 = this.pushPositionOf(object2);
        LetExp letExp = new LetExp(null);
        int n = this.formStack.size();
        letExp.outer = this.current_scope;
        this.current_scope = letExp;
        try {
            Object object4;
            int n2;
            this.scanBody(object2, letExp, false);
            if (this.formStack.size() == n) {
                this.formStack.add(this.syntaxError("body with no expressions"));
            }
            if ((n2 = letExp.countNonDynamicDecls()) != 0) {
                object4 = new Expression[n2];
                int n3 = n2;
                while (--n3 >= 0) {
                    object4[n3] = QuoteExp.undefined_exp;
                }
                letExp.inits = object4;
            }
            object4 = this.makeBody(n, null);
            this.setLineOf((Expression)object4);
            if (n2 == 0) {
                Object object5 = object4;
                return object5;
            }
            letExp.body = object4;
            this.setLineOf(letExp);
            LetExp letExp2 = letExp;
            return letExp2;
        }
        finally {
            this.pop(letExp);
            this.popPositionOf(object3);
        }
    }

    public void rewriteBody(int n) {
        int n2 = this.formStack.size() - n;
        if (n2 == 0) {
            return;
        }
        if (n2 == 1) {
            Object e = this.formStack.pop();
            this.rewriteInBody(e);
        } else {
            int n3;
            Object[] objectArray = new Object[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                objectArray[n3] = this.formStack.elementAt(n + n3);
            }
            this.formStack.setSize(n);
            for (n3 = 0; n3 < n2; ++n3) {
                this.rewriteInBody(objectArray[n3]);
            }
        }
    }

    public Expression makeBody(int n, ScopeExp scopeExp) {
        this.rewriteBody(n);
        int n2 = this.formStack.size() - n;
        if (n2 == 0) {
            return QuoteExp.voidExp;
        }
        if (n2 == 1) {
            return (Expression)this.formStack.pop();
        }
        Expression[] expressionArray = new Expression[n2];
        for (int i = 0; i < n2; ++i) {
            expressionArray[i] = (Expression)this.formStack.elementAt(n + i);
        }
        this.formStack.setSize(n);
        if (scopeExp instanceof ModuleExp) {
            return new ApplyExp(AppendValues.appendValues, expressionArray);
        }
        return ((LispLanguage)this.getLanguage()).makeBody(expressionArray);
    }

    public void noteAccess(Object object2, ScopeExp scopeExp) {
        if (this.notedAccess == null) {
            this.notedAccess = new Vector();
        }
        this.notedAccess.addElement(object2);
        this.notedAccess.addElement(scopeExp);
    }

    public void processAccesses() {
        if (this.notedAccess == null) {
            return;
        }
        int n = this.notedAccess.size();
        ScopeExp scopeExp = this.current_scope;
        for (int i = 0; i < n; i += 2) {
            Declaration declaration;
            Object e = this.notedAccess.elementAt(i);
            ScopeExp scopeExp2 = (ScopeExp)this.notedAccess.elementAt(i + 1);
            if (this.current_scope != scopeExp2) {
                this.setCurrentScope(scopeExp2);
            }
            if ((declaration = this.lexical.lookup(e, -1)) == null || declaration.getFlag(65536)) continue;
            declaration.getContext().currentLambda().capture(declaration);
            declaration.setCanRead(true);
            declaration.setSimple(false);
            declaration.setFlag(524288);
        }
        if (this.current_scope != scopeExp) {
            this.setCurrentScope(scopeExp);
        }
    }

    public void finishModule(ModuleExp moduleExp) {
        boolean bl = moduleExp.isStatic();
        for (Declaration declaration = moduleExp.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            if (declaration.getFlag(512)) {
                String string = "'";
                String string2 = declaration.getFlag(1024) ? "' exported but never defined" : (declaration.getFlag(2048) ? "' declared static but never defined" : "' declared but never defined");
                this.error('e', declaration, string, string2);
            }
            if (moduleExp.getFlag(8192)) {
                if (declaration.getFlag(1024)) {
                    if (declaration.isPrivate()) {
                        if (declaration.getFlag(0x1000000)) {
                            this.error('e', declaration, "'", "' is declared both private and exported");
                        }
                        declaration.setPrivate(false);
                    }
                } else {
                    declaration.setPrivate(true);
                }
            }
            if (bl) {
                declaration.setFlag(2048);
                continue;
            }
            if ((!moduleExp.getFlag(32768) || declaration.getFlag(2048)) && Compilation.moduleStatic >= 0 && !moduleExp.getFlag(65536)) continue;
            declaration.setFlag(4096);
        }
    }

    static void vectorReverse(Vector vector, int n, int n2) {
        int n3 = n2 / 2;
        int n4 = n + n2 - 1;
        for (int i = 0; i < n3; ++i) {
            Object e = vector.elementAt(n + i);
            vector.setElementAt(vector.elementAt(n4 - i), n + i);
            vector.setElementAt(e, n4 - i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveModule(ModuleExp moduleExp) {
        int n = this.pendingImports == null ? 0 : this.pendingImports.size();
        int n2 = 0;
        while (n2 < n) {
            ModuleInfo moduleInfo = (ModuleInfo)this.pendingImports.elementAt(n2++);
            ScopeExp scopeExp = (ScopeExp)this.pendingImports.elementAt(n2++);
            Expression expression = (Expression)this.pendingImports.elementAt(n2++);
            Integer n3 = (Integer)this.pendingImports.elementAt(n2++);
            if (moduleExp != scopeExp) continue;
            ReferenceExp referenceExp = new ReferenceExp((Object)null);
            referenceExp.setLine(this);
            this.setLine(expression);
            int n4 = this.formStack.size();
            require.importDefinitions(null, moduleInfo, null, this.formStack, scopeExp, this);
            int n5 = n3;
            if (n3 != n4) {
                int n6 = this.formStack.size();
                int n7 = n6 - n5;
                Translator.vectorReverse(this.formStack, n5, n4 - n5);
                Translator.vectorReverse(this.formStack, n4, n6 - n4);
                Translator.vectorReverse(this.formStack, n5, n7);
            }
            this.setLine(referenceExp);
        }
        this.pendingImports = null;
        this.processAccesses();
        this.setModule(moduleExp);
        Compilation compilation = Compilation.getCurrent();
        try {
            Compilation.setCurrent(this);
            moduleExp.body = this.makeBody(this.firstForm, moduleExp);
            if (!this.immediate) {
                this.lexical.pop(moduleExp);
            }
        }
        finally {
            Compilation.setCurrent(compilation);
        }
    }

    public Declaration makeRenamedAlias(Declaration declaration, ScopeExp scopeExp) {
        if (scopeExp == null) {
            return declaration;
        }
        return this.makeRenamedAlias(declaration.getSymbol(), declaration, scopeExp);
    }

    public Declaration makeRenamedAlias(Object object2, Declaration declaration, ScopeExp scopeExp) {
        Declaration declaration2 = new Declaration(object2);
        declaration2.setAlias(true);
        declaration2.setPrivate(true);
        declaration2.context = scopeExp;
        ReferenceExp referenceExp = new ReferenceExp(declaration);
        referenceExp.setDontDereference(true);
        declaration2.noteValue(referenceExp);
        return declaration2;
    }

    public void pushRenamedAlias(Declaration declaration) {
        Declaration declaration2 = Translator.getOriginalRef(declaration).getBinding();
        ScopeExp scopeExp = declaration.context;
        declaration2.setSymbol(null);
        Declaration declaration3 = scopeExp.lookup(declaration2.getSymbol());
        if (declaration3 != null) {
            scopeExp.remove(declaration3);
        }
        scopeExp.addDeclaration(declaration);
        if (this.renamedAliasStack == null) {
            this.renamedAliasStack = new Stack();
        }
        this.renamedAliasStack.push(declaration3);
        this.renamedAliasStack.push(declaration);
        this.renamedAliasStack.push(scopeExp);
    }

    public void popRenamedAlias(int n) {
        while (--n >= 0) {
            ScopeExp scopeExp = (ScopeExp)this.renamedAliasStack.pop();
            Declaration declaration = (Declaration)this.renamedAliasStack.pop();
            Declaration declaration2 = Translator.getOriginalRef(declaration).getBinding();
            declaration2.setSymbol(declaration.getSymbol());
            scopeExp.remove(declaration);
            Object e = this.renamedAliasStack.pop();
            if (e == null) continue;
            scopeExp.addDeclaration((Declaration)e);
        }
    }

    public Declaration define(Object object2, SyntaxForm syntaxForm, ScopeExp scopeExp) {
        boolean bl = syntaxForm != null && syntaxForm.scope != this.currentScope();
        Object object3 = bl ? new String(object2.toString()) : object2;
        Declaration declaration = scopeExp.getDefine(object3, 'w', this);
        if (bl) {
            Declaration declaration2 = this.makeRenamedAlias(object2, declaration, syntaxForm.scope);
            syntaxForm.scope.addDeclaration(declaration2);
        }
        this.push(declaration);
        return declaration;
    }

    static {
        String string = "gnu.kawa.functions.GetNamedPart";
        String string2 = "getNamedPart";
        getNamedPartDecl = Declaration.getDeclarationFromStatic(string, string2);
        StaticFieldLocation staticFieldLocation = new StaticFieldLocation(string, string2);
        staticFieldLocation.setProcedure();
        staticFieldLocation.setDeclaration(getNamedPartDecl);
        getNamedPartLocation = staticFieldLocation;
        errorExp = new ErrorExp("unknown syntax error");
    }
}

