{ Factorial using Peano Axioms - gri 12 Aug 1994 }

(setq s
   (lambda (x)
      (cons 's (cons x nil))))
      
(setq p
   (lambda (x)
      (car (cdr x))))
      
(setq myAdd
   (lambda (x y)
      (cond
         ((atom x) y)
         (t (s (myAdd (p x) y))))))
         
(setq myMul
   (lambda (x y)
      (cond
         ((atom x) 0)
         (t (myAdd (myMul (p x) y) y)))))
         
(setq gen
   (lambda (n)
      (cond
         ((<= n 0) 0)
         (t (s (gen (- n 1)))))))
         
(setq fact
   (lambda (x)
      (cond
         ((atom x) (s 0))
         (t (myMul x (fact (p x)))))))


{ Examples:
  gen is used to create Peano Integers:

(gen 0)
(gen 2)
(gen 10)
(gen 100)

(p (gen 3))
}


{ Peano addition:

(myAdd (gen 3) (gen 4))
(myAdd (gen 0) (gen 2))
}


{ Peano multiplication:

(myMul (gen 2) (gen 3))
}


{ Peano factorial:

(fact (gen 0))
(fact (gen 2))
(fact (gen 4))
(fact (gen 5))
(fact (gen 6))
}