/* -*-C-*-
 * access to the X Window System for Sather
 * (c) 1994/11/03 - 1995/04/18 by Erik Schnetter
 */

#include <alloca.h>
#include <errno.h>
#include <malloc.h>
#include <X11/Xlib.h>
#include "header.h"


#if XLIBVERSION == 1104
typedef char *XPointer;
#endif

Display* X_OpenDisplay (char* name)
{
  return XOpenDisplay (name);
}

char* X_DisplayName (char* name)
{
  return XDisplayName (name);
}

void X_CloseDisplay (Display* display)
{
  XCloseDisplay (display);
}



INT X_AllocID (Display* display)
{
  return XAllocID (display);
}



void X_AddHost (Display* display, INT family, INT length, CHAR* address)
{
  XHostAddress host_address;
  host_address.family = family;
  host_address.length = length;
  host_address.address = address;
  XAddHost (display, &host_address);
}

XHostAddress* X_AddHosts_Init (INT num_hosts)
{
  XHostAddress* host_address_p =
    (XHostAddress*) malloc (num_hosts * sizeof(XHostAddress));
  if (!host_address_p) {
    fprintf
      (stderr, "C_X_DISPLAY::X_AddHosts_Init: Could not allocate memory\n");
  }
  return host_address_p;
}

void X_AddHosts_Next (XHostAddress* host_address_p, INT n,
		      INT family, INT length, CHAR* address)
{
  host_address_p[n].family = family;
  host_address_p[n].length = length;
  bcopy (address, &host_address_p[n], length);
}

void X_AddHosts_Finish
  (XHostAddress* host_address_p, INT num_hosts, Display* display)
{
  XAddHosts (display, host_address_p, num_hosts);
  free (host_address_p);
}

XHostAddress* X_ListHosts_Init (Display* display, INT* num_hosts, INT* state)
{
  XHostAddress* host_address_p;
  int* num_hosts_return;
  Bool* state_return;
  host_address_p = XListHosts (display, num_hosts_return, state_return);
  *num_hosts = *num_hosts_return;
  *state = *state_return;
  return host_address_p;
}

void X_ListHosts_Next (XHostAddress* host_address_p, INT n,
		       INT* family, INT* length, void** address)
{
  *family = host_address_p[n].family;
  *length = host_address_p[n].length;
  *address = host_address_p[n].address;
}

void X_ListHosts_Finish (XHostAddress* host_address_p)
{
#if XLIBVERSION == 1104
  XFree ((char *)host_address_p);
#else
  XFree (host_address_p);
#endif
}

void X_RemoveHost (Display* display, INT family, INT length, CHAR* address)
{
  XHostAddress host_address;
  host_address.family = family;
  host_address.length = length;
  host_address.address = address;
  XRemoveHost (display, &host_address);
}

XHostAddress* X_RemoveHosts_Init (INT num_hosts)
{
  XHostAddress* host_address_p =
    (XHostAddress*) malloc (num_hosts * sizeof(XHostAddress));
  if (!host_address_p) {
    fprintf
      (stderr, "C_X_DISPLAY::X_RemoveHosts_Init: Could not allocate memory\n");
  }
  return host_address_p;
}

void X_RemoveHosts_Next (XHostAddress* host_address_p, INT n,
			 INT family, INT length, CHAR* address)
{
  host_address_p[n].family = family;
  host_address_p[n].length = length;
  bcopy (address, &host_address_p[n], length);
}

void X_RemoveHosts_Finish
  (XHostAddress* host_address_p, INT num_hosts, Display* display)
{
  XRemoveHosts (display, host_address_p, num_hosts);
  free (host_address_p);
}

void X_SetAccessControl (Display* display, INT mode)
{
  XSetAccessControl (display, mode);
}

void X_EnableAccessControl (Display* display)
{
  XEnableAccessControl (display);
}

void X_DisableAccessControl (Display* display)
{
  XDisableAccessControl (display);
}



void X_AllowEvents (Display* display, INT event_mode, INT time)
{
  XAllowEvents (display, event_mode, time);
}

BOOL X_CheckIfEvent
  (Display* display, XEvent* event, Bool (*predicate)(), XPointer arg)
{
  return XCheckIfEvent (display, event, predicate, arg);
}

BOOL X_CheckMaskEvent (Display* display, INT mask, XEvent* event)
{
  return XCheckMaskEvent (display, mask, event);
}

BOOL X_CheckTypedEvent (Display* display, INT type, XEvent* event)
{
  return XCheckTypedEvent (display, type, event);
}

INT X_EventsQueued (Display* display, INT mode)
{
  return XEventsQueued (display, mode);
}

void X_IfEvent
  (Display* display, XEvent* event, Bool (*predicate)(), XPointer arg)
{
  XIfEvent (display, event, predicate, arg);
}

void X_MaskEvent (Display* display, INT mask, XEvent* event)
{
  XMaskEvent (display, mask, event);
}

void X_PeekEvent (Display* display, XEvent* event)
{
  XPeekEvent (display, event);
}

void X_PeekIfEvent
  (Display* display, XEvent* event, Bool (*predicate)(), XPointer arg)
{
  XPeekIfEvent (display, event, predicate, arg);
}

INT X_Pending (Display* display)
{
  return XPending (display);
}

void X_PutBackEvent (Display* display, XEvent* event)
{
  XPutBackEvent (display, event);
}

void X_NextEvent (Display* display, XEvent* event)
{
  XNextEvent (display, event);
}



void X_ChangeKeyboardControl (Display* display, INT mask, INT* ints)
{
  XKeyboardControl values;
  values.key_click_percent = ints[0];
  values.bell_percent = ints[1];
  values.bell_pitch = ints[2];
  values.bell_duration = ints[3];
  values.led = ints[4];
  values.led_mode = ints[5];
  values.key = ints[6];
  values.auto_repeat_mode = ints[7];
  XChangeKeyboardControl (display, mask, &values);
}

void X_GetKeyboardControl (Display* display, INT* ints, CHAR* chars)
{
  XKeyboardState values;
  int i;
  XGetKeyboardControl (display, &values);
  ints[0] = values.key_click_percent;
  ints[1] = values.bell_percent;
  ints[2] = values.bell_pitch;
  ints[3] = values.bell_duration;
  ints[4] = values.led_mask;
  ints[5] = values.global_auto_repeat;
  for (i=31; i--;) { chars[i] = values.auto_repeats[i]; }
}

void X_AutoRepeatOn (Display* display)
{
  XAutoRepeatOn (display);
}

void X_AutoRepeatOff (Display* display)
{
  XAutoRepeatOff (display);
}

void X_Bell (Display* display, INT percent)
{
  XBell (display, percent);
}

void X_QueryKeymap (Display* display, CHAR* chars)
{
  char* p;
  if (sizeof(char) != sizeof(CHAR)) {
    p = (char*) alloca (32 * sizeof(char));
  } else {
    p = (char*) chars;
  }
  XQueryKeymap(display, p);
  if (sizeof(char) != sizeof(CHAR)) {
    int i;
    for (i=32; i--;) { chars[i] = p[i]; }
  }
}



void X_ChangeKeyboardMapping
  (Display* display, INT first_keycode, INT keysyms_per_keycode, INT* keysyms,
   INT num_codes)
{
  XChangeKeyboardMapping (display, first_keycode, keysyms_per_keycode,
			  keysyms, num_codes);
}

KeySym* X_GetKeyboardMapping_first
  (Display* display, INT first_keycode, INT keycode_count, INT* ints)
{
  int keysyms_per_keycode;
  KeySym* res;
  res = XGetKeyboardMapping
    (display, first_keycode, keycode_count, &keysyms_per_keycode);
  ints[0] = keysyms_per_keycode;
  return res;
}

void X_GetKeyboardMapping_last (KeySym* token, INT* keysyms, INT keycode_count)
{
  int i;
  for (i=keycode_count; i--;) { keysyms[i] = token[i]; }
#if XLIBVERSION == 1104
  XFree ((char *)token);
#else
  XFree (token);
#endif
}



void X_ChangePointerControl
  (Display* display, BOOL do_accel, BOOL do_threshold,
   INT accel_numerator, INT accel_denominator, INT threshold)
{
  XChangePointerControl (display, do_accel, do_threshold,
			 accel_numerator, accel_denominator, threshold);
}

void X_GetPointerControl (Display* display, INT* ints)
{
  int a, b, c;
  XGetPointerControl (display, &a, &b, &c);
  ints[0]=a;
  ints[1]=b;
  ints[2]=c;
}



void X_SetScreenSaver (Display* display, INT timeout, INT interval,
		       INT prefer_blanking, INT allow_exposures)
{
  XSetScreenSaver (display, timeout, interval,
		   prefer_blanking, allow_exposures);
}

void X_ForceScreenSaver (Display* display, INT mode)
{
  XForceScreenSaver (display, mode);
}

void X_ActivateScreenSaver (Display* display)
{
  XActivateScreenSaver (display);
}

void X_ResetScreenSaver (Display* display)
{
  XResetScreenSaver (display);
}

void X_GetScreenSaver (Display* display, INT* ints)
{
  int a, b, c, d;
  XGetScreenSaver (display, &a, &b, &c, &d);
  ints[0]=a; ints[1]=b; ints[2]=c; ints[3]=d;
}



INT X_GrabPointer
  (Display* display, INT grab_window, BOOL owner_events, INT event_mask,
   INT pointer_mode, INT keyboard_mode, INT confine_to, INT cursor, INT time)
{
  return XGrabPointer
    (display, grab_window, owner_events, event_mask, pointer_mode,
     keyboard_mode, confine_to, cursor, time);
}

void X_UngrabPointer (Display* display, INT time)
{
  XUngrabPointer (display, time);
}

void X_ChangeActivePointerGrab
  (Display* display, INT event_mask, INT cursor, INT time)
{
  XChangeActivePointerGrab (display, event_mask, cursor, time);
}



EXT_OB X_FetchBytes (Display* display, INT* ints)
{
  int nbytes;
  CHAR* bytes;
  XFetchBytes (display, &nbytes);
  ints[0] = nbytes;
  return bytes;
}

EXT_OB X_FetchBuffer (Display* display, INT* ints, INT buffer)
{
  int nbytes;
  char* bytes;
  bytes = XFetchBuffer (display, &nbytes, buffer);
  ints[0] = nbytes;
  return bytes;
}

void X_RotateBuffers (Display* display, INT rotate)
{
  XRotateBuffers (display, rotate);
}

void X_StoreBuffer (Display* display, CHAR* bytes, INT nbytes, INT buffer)
{
  XStoreBuffer (display, bytes, nbytes, buffer);
}

void X_StoreBytes (Display* display, CHAR* bytes, INT nbytes)
{
  XStoreBytes (display, bytes, nbytes);
}


   
EXT_OB X_Synchronize (Display* display, BOOL onoff)
{
  return XSynchronize (display, onoff);
}

EXT_OB X_SetAfterFunction (Display* display, EXT_OB rout)
{
  XSetAfterFunction (display, rout);
}

INT C_X_DISPLAY_call_after_function(Display* display);
EXT_OB X_get_after_function (void)
{
  return C_X_DISPLAY_call_after_function;
}



void X_ConvertSelection
  (Display* display, Atom selection, Atom target, Atom property,
   Window requestor, Time time)
{
  XConvertSelection (display, selection, target, property, requestor, time);
}

Window X_GetSelectionOwner (Display* display, Atom selection)
{
  return XGetSelectionOwner (display, selection);
}

void X_SetSelectionOwner
  (Display* display, Atom selection, Window owner, Time time)
{
  XSetSelectionOwner (display, selection, owner, time);
}



XExtCodes* X_AddExtension (Display* display)
{
  return XAddExtension (display);
}

XExtCodes* X_InitExtension (Display* display, CHAR* name)
{
  return XInitExtension (display, name);
}

CHAR** X_ListExtensions_first (Display* display, INT* ints)
{
  int next;
  CHAR** ptr;
  ptr = XListExtensions (display, &next);
  ints[0] = next;
  return ptr;
}

CHAR* X_ListExtensions_loop (CHAR** ptr, INT index)
{
  return ptr[index];
}

BOOL X_QueryExtension (Display* display, CHAR* name, INT* ints)
{
  int major_opcode_return, first_event_return, first_error_return;
  BOOL bool;
  bool = XQueryExtension (display, name, &major_opcode_return,
			  &first_event_return, &first_error_return);
  ints[0] = major_opcode_return;
  ints[1] = first_event_return;
  ints[2] = first_error_return;
  return bool;
}



void X_Flush (Display* display)
{
  XFlush (display);
}

void X_Sync (Display* display, BOOL discard)
{
  XSync (display, discard);
}



INT X_DisplayMotionBufferSize (Display* display)
{
  return XDisplayMotionBufferSize (display);
}



INT X_ConnectionNumber (Display* display)
{
  return ConnectionNumber (display);
}

INT X_DefaultRootWindow (Display* display)
{
  return DefaultRootWindow (display);
}

Screen* X_DefaultScreenOfDisplay (Display* display)
{
  return DefaultScreenOfDisplay (display);
}

INT X_DefaultScreen (Display* display)
{
  return DefaultScreen (display);
}

CHAR* X_DisplayString (Display* display)
{
  return DisplayString (display);
}

INT X_MaxRequestSize (Display* display)
{
  return XMaxRequestSize (display);
}

INT X_LastKnownRequestProcessed (Display* display)
{
  return LastKnownRequestProcessed (display);
}

INT X_NextRequest (Display* display)
{
  return NextRequest (display);
}

INT X_ProtocolVersion (Display* display)
{
  return ProtocolVersion (display);
}

INT X_ProtocolRevision (Display* display)
{
  return ProtocolRevision (display);
}

INT X_QLength (Display* display)
{
  return QLength (display);
}

INT X_ScreenCount (Display* display)
{
  return ScreenCount (display);
}

CHAR* X_ServerVendor (Display* display)
{
  return ServerVendor (display);
}

INT X_VendorRelease (Display* display)
{
  return VendorRelease (display);
}



XPixmapFormatValues* X_ListPixmapFormats_first (Display* display, INT* ints)
{
  int nformats;
  XPixmapFormatValues* formats;
  formats = XListPixmapFormats (display, &nformats);
  ints[0] = nformats;
  return formats;
}

void X_ListPixmapFormats_loop
  (XPixmapFormatValues* format, XPixmapFormatValues* formats, INT index)
{
  *format = formats[index];
}



INT X_ImageByteOrder (Display* display)
{
  return ImageByteOrder (display);
}

INT X_BitmapBitOrder (Display* display)
{
  return BitmapBitOrder (display);
}

INT X_BitmapPad (Display* display)
{
  return BitmapPad (display);
}

INT X_BitmapUnit (Display* display)
{
  return BitmapUnit (display);
}
