/*
 *  Ball And Paddle
 *
 *  Copyright (C) 2007 by Eric Hutchins
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **/

#ifndef __GAME_H__
#define __GAME_H__

#include <vector>
#include <fstream>
#include <sstream>
using namespace std;

#include "SDL.h"
#include "SDL_image.h"

#include "gamestate.h"
#include "globals.h"
#include "ball.h"
#include "block.h"
#include "paddle.h"
#include "powerup.h"
#include "laser.h"
#include "highscoremenu.h"
#include "mainmenu.h"
#include "gameover.h"

class Game:public GameState
{

private:
  SDL_Surface * imgBlocks;
  SDL_Surface *imgBall;
  SDL_Surface *imgPowerUps;
  SDL_Surface *imgBackground;
  SDL_Surface *imgLaser;
  SDL_Surface *imgPaddle;
    vector < Ball * >balls;
    vector < vector < Block * > >blocks;
  Paddle *paddle;
    vector < PowerUp * >powerUps;
    vector < Laser * >lasers;
  int timeTilReady;
  bool powerBalls;
  int level;
  int oldScore;
  int bonusScore;
  int score;
  bool reverse;
  bool m_paused;
  bool m_gameover;
  bool m_transitioning;
  bool tickingBonusTime;
  int bonusTime;
  int extraBallCount;
  string levelsetName;
  string levelsetFilename;
    vector < int >scores;
    vector < string > names;
  void handlePowerUp (int type);
  void loadHighScores ();
  void saveHighScores ();
  void endGame (bool won, GameStateManager * gameStateManager);
  void drawBox (SDL_Surface * dest, int x, int y, int width, int height,
		Uint32 inside, Uint32 outside);

  bool m_started;

  static Game m_instance;

public:
  static Game *instance ()
  {
    return &m_instance;
  }
  void init ();
  void cleanup ();
  void pause ();
  void resume ();
  void handleEvents (GameStateManager * gameStateManager);
  void update (GameStateManager * gameStateManager);
  void draw (GameStateManager * gameStateManager);
  bool loadLevel (int level);
  void loadImages (GameStateManager * gameStateManager);
  bool getTransitioning ()
  {
    return m_transitioning;
  }
};

#endif
