// Copyright (C) 2005 David Sugar, Tycho Softworks.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.
//
// This exception applies only to the code released under the name GNU
// ccAudio.  If you copy code from other releases into a copy of GNU
// ccAudio, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own for GNU ccAudio, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.
//
#include "private.h"
#include <cstdio>
#include <cstring>
#include <cstdlib>
#include <cctype>

#ifdef	HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "audio2.h"

using namespace ost;

#define	MAP_HASH_SIZE	197
#define	MAP_PAGE_COUNT	255
#define	MAP_PAGE_SIZE (sizeof(void *[MAP_PAGE_COUNT]))
#define	MAP_PAGE_FIX (MAP_PAGE_SIZE / MAP_PAGE_COUNT)

static unsigned char *page = NULL;
static unsigned used = MAP_PAGE_SIZE;
static TelTone::tonekey_t *hash[MAP_HASH_SIZE];

static unsigned key(const char *id)
{
	unsigned val = 0;
	while(*id)
		val = (val << 1) ^ (*(id++) & 0x1f);

	return val % MAP_HASH_SIZE;
}

static void *map(unsigned len)
{
	unsigned char *pos;
	unsigned fix = len % MAP_PAGE_FIX;
	

	if(fix)
		len += MAP_PAGE_FIX - fix;

	if(used + len > MAP_PAGE_SIZE)
	{
		page = (unsigned char *)(new void *[MAP_PAGE_COUNT]);
		used = 0;
	}

	pos = page + used;
	used += len;
	return pos;
}

TelTone::tonekey_t *TelTone::find(const char *id, const char *locale)
{
	unsigned k;
	tonekey_t *tk;
	char namebuf[65];
	char env[32];
	char *cp, *ep;

	if(locale == NULL)
	{
		locale = getenv("LANG");
		if(!locale)
			locale="us";

		snprintf(env, sizeof(env), "%s", locale);
		ep = strchr(env, '.');
		if(ep)
			*ep = 0;
		cp = strchr(env, '_');
		if(cp)
			locale = ++cp;
		else
			locale = env;
	}

	snprintf(namebuf, sizeof(namebuf), "%s.%s", locale, id);
	k = key(namebuf);	
	tk = hash[k];

	while(tk)
	{
		if(!stricmp(namebuf, tk->id))
			break;
		tk = tk->next;
	}
	return tk;
}
	

bool TelTone::load(const char *path, const char *l)
{
	char buffer[256];
	char locale[256];
	char *loclist[128], *cp, *ep, *name;
	char *lists[64];
	char **field, *freq, *fdur, *fcount;
	tonedef_t *def, *first, *again, *last, *final;
	tonekey_t *tk;
	unsigned count, i, k;
	unsigned lcount = 0;
	FILE *fp;
	char namebuf[65];
	bool loaded = false;

	fp = fopen(path, "r");
	if(!fp)
		return false;

	memset(&hash, 0, sizeof(hash));

	for(;;)
	{
		fgets(buffer, sizeof(buffer) - 1, fp);
		if(feof(fp))
			break;
		cp = buffer;
		while(isspace(*cp))
			++cp;

		if(*cp == '[')
		{
			if(loaded)
				break;
			strcpy(locale, buffer);
			cp = locale;
			lcount = 0;
			cp = strtok(cp, "[]|\r\n");
			while(cp)
			{
				if(*cp && !l)
					loclist[lcount++] = cp;
				else if(*cp && !stricmp(cp, l))
				{
					loclist[lcount++] = cp;
					loaded = true;
				}
				cp = strtok(NULL, "[]|\r\n");
			}
			continue;
		}

		if(!isalpha(*cp) || !lcount)
			continue;

		ep = strchr(cp, '=');
		if(!ep)
			continue;
		*(ep++) = 0;
		name = strtok(cp, " \t");
		cp = strchr(ep, ';');
		if(cp)
			*cp = 0;
		cp = strchr(ep, '#');
		if(cp)
			*cp = 0;
		cp = strtok(ep, ",");
		count = 0;
		while(cp)
		{
			while(isspace(*cp))
				++cp;
						
			lists[count++] = cp;
			cp = strtok(NULL, ",");
		}	
		if(!count)
			continue;

		field = &lists[0];
		first = last = again = NULL;
		while(count--)
		{
			freq = strtok(*field, " \t\r\n");
			fdur = strtok(NULL, " \t\r\n");
			fcount = strtok(NULL, " \t\r\n");

			if(!freq)
				goto skip;

			freq = strtok(freq, " \r\r\n");

			if(isalpha(*freq))
			{
				tk = find(freq, loclist[0]);
				if(tk)
				{
					if(!first)
						first = tk->first;
					else
					{
						final = tk->last;
						again = tk->first;
					}
				}
				break;
			}

			def = (tonedef_t *)map(sizeof(tonedef_t));
			memset(def, 0, sizeof(tonedef_t));
			if(!first)
				first = def;
			else
				last->next = def;

			last = final = def;

			def->next = NULL;

			if(!fdur || !atol(fdur))
			{
				again = def;
				count = 0;
			}
			else if((!fcount || !atoi(fcount)) && !count)
				again = first;	

			cp = strtok(freq, " \t\r\n");
			ep = cp;
			while(isdigit(*ep))
				++ep;
			def->f1 = atoi(cp);
			if(*ep)
				def->f2 = atoi(++ep);
			else
				def->f2 = 0;

			if(!fcount)
				fcount = "1";

			def->count = atoi(fcount);
			if(!def->count)
				++def->count;

			if(!fdur)
				goto skip;

			cp = strtok(fdur, " \t\r\n");
			ep = cp;
			while(isdigit(*ep))
				++ep;
			def->duration = atol(cp);
			if(*ep)
				def->silence = atol(++ep);
			else
				def->silence = 0;
			
skip:
			++field;
		}
		if(last)
			last->next = again;
		field = &loclist[0];
		i = lcount;
		while(i--)
		{
			snprintf(namebuf, sizeof(namebuf), "%s.%s",
				*(field++), name);
			tk = (tonekey_t *)map((unsigned)sizeof(tonekey_t) + strlen(namebuf));
			strcpy(tk->id, namebuf);
			tk->first = first;
			tk->last = final;
			k = key(namebuf);
			tk->next = hash[k];
			hash[k] = tk;
		}
	}

	fclose(fp);
	if(page)
		return true;
	return false;
}

