-- C45265A.ADA

--                             Grant of Unlimited Rights
--
--     Under contracts F33600-87-D-0337, F33600-84-D-0280, MDA903-79-C-0687,
--     F08630-91-C-0015, and DCA100-97-D-0025, the U.S. Government obtained 
--     unlimited rights in the software and documentation contained herein.
--     Unlimited rights are defined in DFAR 252.227-7013(a)(19).  By making 
--     this public release, the Government intends to confer upon all 
--     recipients unlimited rights  equal to those held by the Government.  
--     These rights include rights to use, duplicate, release or disclose the 
--     released technical data and computer software in whole or in part, in 
--     any manner and for any purpose whatsoever, and to have or permit others 
--     to do so.
--
--                                    DISCLAIMER
--
--     ALL MATERIALS OR INFORMATION HEREIN RELEASED, MADE AVAILABLE OR
--     DISCLOSED ARE AS IS.  THE GOVERNMENT MAKES NO EXPRESS OR IMPLIED 
--     WARRANTY AS TO ANY MATTER WHATSOEVER, INCLUDING THE CONDITIONS OF THE
--     SOFTWARE, DOCUMENTATION OR OTHER INFORMATION RELEASED, MADE AVAILABLE 
--     OR DISCLOSED, OR THE OWNERSHIP, MERCHANTABILITY, OR FITNESS FOR A
--     PARTICULAR PURPOSE OF SAID MATERIAL.
--*
-- CHECK THAT MEMBERSHIP TESTS YIELD THE CORRECT RESULTS FOR ONE
-- DIMENSIONAL AND MULTI-DIMENSIONAL ARRAY TYPES WHEN:
--     A) THE SUBTYPE INDICATION DENOTES AN UNCONSTRAINED ARRAY.
--     B) THE SUBTYPE INDICATION DENOTES A CONSTRAINED ARRAY.

-- TBN  7/22/86

WITH REPORT; USE REPORT;
PROCEDURE C45265A IS

     PACKAGE P IS
          TYPE KEY IS LIMITED PRIVATE;
     PRIVATE
          TYPE KEY IS NEW NATURAL;
     END P;

     SUBTYPE INT IS INTEGER RANGE 1 .. 20;
     TYPE ARRAY_TYPE_1 IS ARRAY (INT RANGE <>) OF INTEGER;
     TYPE ARRAY_TYPE_2 IS ARRAY (INT RANGE <>, INT RANGE <>) OF INTEGER;
     TYPE ARRAY_TYPE_3 IS ARRAY (INT RANGE <>, INT RANGE <>,
                                               INT RANGE <>) OF INTEGER;
     TYPE ARRAY_TYPE_4 IS ARRAY (INT RANGE <>) OF P.KEY;
     TYPE ARRAY_TYPE_5 IS ARRAY (INT RANGE <>, INT RANGE <>) OF P.KEY;

     SUBTYPE ARRAY_SUB1 IS ARRAY_TYPE_1;
     SUBTYPE ARRAY_SUB2 IS ARRAY_TYPE_2;
     SUBTYPE ARRAY_SUB3 IS ARRAY_TYPE_3;
     SUBTYPE ARRAY_SUB4 IS ARRAY_TYPE_4;
     SUBTYPE ARRAY_SUB5 IS ARRAY_TYPE_5;
     SUBTYPE CON_ARRAY1 IS ARRAY_TYPE_1 (1..5);
     SUBTYPE CON_ARRAY2 IS ARRAY_TYPE_2 (1..2, 1..2);
     SUBTYPE CON_ARRAY3 IS ARRAY_TYPE_3 (1..2, 1..3, 1..4);
     SUBTYPE CON_ARRAY4 IS ARRAY_TYPE_4 (1..4);
     SUBTYPE CON_ARRAY5 IS ARRAY_TYPE_5 (1..2, 1..3);
     SUBTYPE NULL_ARRAY1 IS ARRAY_TYPE_1 (2 .. 1);

     ARRAY1 : ARRAY_TYPE_1 (1..10);
     ARRAY2 : ARRAY_SUB1 (11..20);
     ARRAY3 : ARRAY_TYPE_2 (1..4, 1..3);
     ARRAY4 : ARRAY_SUB2 (5..7, 5..8);
     ARRAY5 : ARRAY_TYPE_3 (1..2, 1..3, 1..4);
     ARRAY6 : ARRAY_SUB3 (1..3, 1..2, 1..4);
     NULL_ARRAY_1 : ARRAY_TYPE_1 (3..2);
     NULL_ARRAY_2 : ARRAY_SUB1 (2..1);
     ARRAY7 : ARRAY_TYPE_1 (1..10) := (1..10 => 7);
     ARRAY8 : CON_ARRAY1 := (1..5 => 8);
     ARRAY9 : ARRAY_TYPE_2 (1..10, 1..10) := (1..10 => (1..10 => 9));
     ARRAY10 : CON_ARRAY2 := (1..2 => (1..2 => 10));
     ARRAY11 : ARRAY_TYPE_3 (1..10, 1..10, 1..10) := (1..10 =>
                                              (1..10 => (1..10 => 11)));
     ARRAY12 : CON_ARRAY3 := (1..2 => (1..3 => (1..4 => 12)));
     ARRAY13 : ARRAY_TYPE_4 (1..2);
     ARRAY14 : ARRAY_SUB4 (1..5);
     ARRAY15 : ARRAY_TYPE_4 (1..6);
     ARRAY16 : CON_ARRAY4;
     ARRAY17 : ARRAY_TYPE_5 (1..3, 1..2);
     ARRAY18 : ARRAY_SUB5 (1..2, 1..3);
     ARRAY19 : ARRAY_TYPE_5 (1..4, 1..3);
     ARRAY20 : CON_ARRAY5;

BEGIN
     TEST ("C45265A", "CHECK THAT MEMBERSHIP TESTS YIELD THE CORRECT " &
                      "RESULTS FOR ONE DIMENSIONAL AND MULTI-" &
                      "DIMENSIONAL ARRAY TYPES");

     ARRAY1 := (ARRAY1'RANGE => 1);
     ARRAY2 := (ARRAY2'RANGE => 2);
     ARRAY3 := (ARRAY3'RANGE(1) => (ARRAY3'RANGE(2) => 3));
     ARRAY4 := (ARRAY4'RANGE(1) => (ARRAY4'RANGE(2) => 4));
     ARRAY5 := (ARRAY5'RANGE(1) => (ARRAY5'RANGE(2) =>
                                   (ARRAY5'RANGE(3) => 5)));
     ARRAY6 := (ARRAY6'RANGE(1) => (ARRAY6'RANGE(2) =>
                                   (ARRAY6'RANGE(3) => 6)));

     IF ARRAY1 IN ARRAY_SUB1 THEN
          NULL;
     ELSE
          FAILED ("INCORRECT RESULTS FOR UNCONSTRAINED ARRAYS - 1");
     END IF;
     IF ARRAY2 NOT IN ARRAY_SUB1 THEN
          FAILED ("INCORRECT RESULTS FOR UNCONSTRAINED ARRAYS - 2");
     END IF;

     IF ARRAY3 IN ARRAY_SUB2 THEN
          NULL;
     ELSE
          FAILED ("INCORRECT RESULTS FOR UNCONSTRAINED ARRAYS - 3");
     END IF;
     IF ARRAY4 NOT IN ARRAY_SUB2 THEN
          FAILED ("INCORRECT RESULTS FOR UNCONSTRAINED ARRAYS - 4");
     END IF;

     IF ARRAY5 IN ARRAY_SUB3 THEN
          NULL;
     ELSE
          FAILED ("INCORRECT RESULTS FOR UNCONSTRAINED ARRAYS - 5");
     END IF;
     IF ARRAY6 NOT IN ARRAY_SUB3 THEN
          FAILED ("INCORRECT RESULTS FOR UNCONSTRAINED ARRAYS - 6");
     END IF;

     IF NULL_ARRAY_1 IN ARRAY_SUB1 THEN
          NULL;
     ELSE
          FAILED ("INCORRECT RESULTS FOR UNCONSTRAINED ARRAYS - 7");
     END IF;
     IF NULL_ARRAY_2 NOT IN ARRAY_SUB1 THEN
          FAILED ("INCORRECT RESULTS FOR UNCONSTRAINED ARRAYS - 8");
     END IF;

     IF ARRAY7 IN CON_ARRAY1 THEN
          FAILED ("INCORRECT RESULTS FOR CONSTRAINED ARRAYS - 9");
     END IF;
     IF ARRAY8 NOT IN CON_ARRAY1 THEN
          FAILED ("INCORRECT RESULTS FOR CONSTRAINED ARRAYS - 10");
     END IF;

     IF ARRAY9 IN CON_ARRAY2 THEN
          FAILED ("INCORRECT RESULTS FOR CONSTRAINED ARRAYS - 11");
     END IF;
     IF ARRAY10 NOT IN CON_ARRAY2 THEN
          FAILED ("INCORRECT RESULTS FOR CONSTRAINED ARRAYS - 12");
     END IF;

     IF ARRAY11 IN CON_ARRAY3 THEN
          FAILED ("INCORRECT RESULTS FOR CONSTRAINED ARRAYS - 13");
     END IF;
     IF ARRAY12 NOT IN CON_ARRAY3 THEN
          FAILED ("INCORRECT RESULTS FOR CONSTRAINED ARRAYS - 14");
     END IF;

     IF ARRAY13 IN ARRAY_SUB4 THEN
          NULL;
     ELSE
          FAILED ("INCORRECT RESULTS FOR UNCONSTRAINED ARRAYS - 15");
     END IF;
     IF ARRAY14 NOT IN ARRAY_SUB4 THEN
          FAILED ("INCORRECT RESULTS FOR UNCONSTRAINED ARRAYS - 16");
     END IF;

     IF ARRAY15 IN CON_ARRAY4 THEN
          FAILED ("INCORRECT RESULTS FOR CONSTRAINED ARRAYS - 17");
     END IF;
     IF ARRAY16 NOT IN CON_ARRAY4 THEN
          FAILED ("INCORRECT RESULTS FOR CONSTRAINED ARRAYS - 18");
     END IF;

     IF ARRAY17 IN ARRAY_SUB5 THEN
          NULL;
     ELSE
          FAILED ("INCORRECT RESULTS FOR UNCONSTRAINED ARRAYS - 19");
     END IF;
     IF ARRAY18 NOT IN ARRAY_SUB5 THEN
          FAILED ("INCORRECT RESULTS FOR UNCONSTRAINED ARRAYS - 20");
     END IF;

     IF ARRAY19 IN CON_ARRAY5 THEN
          FAILED ("INCORRECT RESULTS FOR CONSTRAINED ARRAYS - 21");
     END IF;
     IF ARRAY20 NOT IN CON_ARRAY5 THEN
          FAILED ("INCORRECT RESULTS FOR CONSTRAINED ARRAYS - 22");
     END IF;

     IF NULL_ARRAY_1 IN NULL_ARRAY1 THEN
          FAILED ("INCORRECT RESULTS FOR NULL ARRAYS - 23");
     END IF;
     IF NULL_ARRAY_2 NOT IN NULL_ARRAY1 THEN
          FAILED ("INCORRECT RESULTS FOR NULL ARRAYS - 24");
     END IF;

     RESULT;
END C45265A;
