/*
This file is licensed to you under the license specified in the included file
`LICENSE'. Look there for further details.
*/


%{
#include "argsdef.h"
#include "parser.h"
extern int gengetopt_count_line;
%}

%%

[Pp][Aa][Cc][Kk][Aa][Gg][Ee]		   return TOK_PACKAGE;
[Vv][Ee][Rr][Ss][Ii][Oo][Nn]		   return TOK_VERSION;
[Oo][Pp][Tt][Ii][Oo][Nn]		   return TOK_OPTION;
[Ss][Tt][Rr][Ii][Nn][Gg]	yylval.argtype = ARG_STRING; return TOK_ARGTYPE;
[Ii][Nn][Tt]			yylval.argtype = ARG_INT; return TOK_ARGTYPE;
[Ss][Hh][Oo][Rr][Tt]		yylval.argtype = ARG_SHORT; return TOK_ARGTYPE;
[Ll][Oo][Nn][Gg]		yylval.argtype = ARG_LONG; return TOK_ARGTYPE;
[Ff][Ll][Oo][Aa][Tt]		yylval.argtype = ARG_FLOAT; return TOK_ARGTYPE;
[Dd][Oo][Uu][Bb][Ll][Ee]	yylval.argtype = ARG_DOUBLE; return TOK_ARGTYPE;
[Ll][Oo][Nn][Gg][Dd][Oo][Uu][Bb][Ll][Ee]   yylval.argtype = ARG_LONGDOUBLE; return TOK_ARGTYPE;
[Ll][Oo][Nn][Gg][Ll][Oo][Nn][Gg]   yylval.argtype = ARG_LONGLONG; return TOK_ARGTYPE;
[Yy][Ee][Ss]				   return TOK_YES;
[Nn][Oo]				   return TOK_NO;
[Ff][Ll][Aa][Gg]			   return TOK_FLAG;
[Oo][Nn]				   yylval.bool = 1; return TOK_ONOFF;
[Oo][Ff][Ff]				   yylval.bool = 0; return TOK_ONOFF;

[[:alnum:]-]			yylval.chr = yytext[0]; return TOK_CHAR;
\"[^\"\n]*\"	{
				/* if you add or remove symbols, change canonize_vars
				   function */
				yytext [strlen(yytext) - 1] = 0;
				yylval.str = yytext + 1;
				return TOK_STRING;
				}

[ \t]+				/* eat spaces */
#.*				/* comments begin with # in any place */
\n				gengetopt_count_line++; return '\n';

.		{ return 1000; /* little hack to produce a parse error too. */ }

%%

