/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.construct.parsers;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.List;
import org.gnunet.construct.Message;
import org.gnunet.construct.ProtocolViolationException;
import org.gnunet.construct.ReflectUtil;
import org.gnunet.construct.parsers.Parser;

public class StringParser
implements Parser {
    private final String cset;
    private final boolean optional;
    private final Field targetField;

    public StringParser(String charset, boolean optional, Field f) {
        this.targetField = f;
        this.optional = optional;
        this.cset = charset;
    }

    @Override
    public int getSize(Message srcObj) {
        String s = (String)ReflectUtil.justGet(srcObj, this.targetField);
        if (s == null) {
            if (this.optional) {
                return 0;
            }
            throw new AssertionError((Object)("non-optional string in field '" + this.targetField + "' cannot be null"));
        }
        try {
            byte[] b = s.getBytes(this.cset);
            return b.length + 1;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException();
        }
    }

    @Override
    public int parse(ByteBuffer srcBuf, int frameOffset, Message frameObj, Message dstObj, List<Field> frameSizePath) {
        String str;
        if (this.optional) {
            if (frameSizePath == null) {
                throw new AssertionError((Object)"optional string with no length field in the message!");
            }
            int frameSize = ReflectUtil.justGetInt(frameObj, frameSizePath);
            int remaining = frameOffset + frameSize - srcBuf.position();
            if (remaining == 0) {
                if (!this.optional) {
                    throw new ProtocolViolationException("no data received for non-optional string");
                }
                ReflectUtil.justSet(dstObj, this.targetField, null);
                return 0;
            }
        }
        if (!srcBuf.hasRemaining()) {
            throw new ProtocolViolationException("no data for non-optional string field " + this.targetField);
        }
        int length = 0;
        while (srcBuf.get(srcBuf.position() + length) != 0) {
            ++length;
        }
        byte[] stringData = new byte[length];
        srcBuf.get(stringData);
        if (srcBuf.get() != 0) {
            throw new AssertionError((Object)"programming error");
        }
        try {
            str = new String(stringData, this.cset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException();
        }
        ReflectUtil.justSet(dstObj, this.targetField, str);
        return length + 1;
    }

    @Override
    public int write(ByteBuffer dstBuf, Message srcObj) {
        byte[] b;
        String s = (String)ReflectUtil.justGet(srcObj, this.targetField);
        if (s == null) {
            if (!this.optional) {
                throw new AssertionError((Object)"non-optional string cannot be null");
            }
            return 0;
        }
        try {
            b = s.getBytes(this.cset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException();
        }
        dstBuf.put(b);
        dstBuf.put((byte)0);
        return b.length + 1;
    }

    @Override
    public void patch(Message m, int frameSize, List<Field> frameSizePath, Message frameObj) {
        if (frameSizePath != null) {
            ReflectUtil.justSetInt(frameObj, frameSizePath, frameSize);
        }
    }

    @Override
    public int getStaticSize() {
        return this.optional ? 0 : 1;
    }
}

