/* const/gsl_const_cgs.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GSL_CONST_CGS__
#define __GSL_CONST_CGS__

#define GSL_CONST_CGS_SPEED_OF_LIGHT (2.99792458e10) /* cm / s */
#define GSL_CONST_CGS_GRAVITATIONAL_CONSTANT (6.67259e-8) /* cm^3 / g s^2 */
#define GSL_CONST_CGS_PLANCKS_CONSTANT_H (6.6260755e-27) /* g cm^2 / s */
#define GSL_CONST_CGS_PLANCKS_CONSTANT_HBAR (1.05457266913e-27) /* g cm^2 / s */
#define GSL_CONST_CGS_VACUUM_PERMEABILITY (1.25663706144e-1) /* cm g / A^2 s^2 */
#define GSL_CONST_CGS_ASTRONOMICAL_UNIT (1.495979e13) /* cm */
#define GSL_CONST_CGS_LIGHT_YEAR (9.46053620707e17) /* cm */
#define GSL_CONST_CGS_PARSEC (3.08567818589e18) /* cm */
#define GSL_CONST_CGS_GRAV_ACCEL (9.80665e2) /* cm / s^2 */
#define GSL_CONST_CGS_ELECTRON_VOLT (1.60217733e-12) /* g cm^2 / s^2 */
#define GSL_CONST_CGS_MASS_ELECTRON (9.10938961969e-28) /* g */
#define GSL_CONST_CGS_MASS_MUON (1.88353269879e-25) /* g */
#define GSL_CONST_CGS_MASS_PROTON (1.67262307095e-24) /* g */
#define GSL_CONST_CGS_MASS_NEUTRON (1.67492862142e-24) /* g */
#define GSL_CONST_CGS_RYDBERG (2.17987412173e-11) /* g cm^2 / s^2 */
#define GSL_CONST_CGS_BOLTZMANN (1.3806513e-16) /* g cm^2 / K s^2 */
#define GSL_CONST_CGS_BOHR_MAGNETON (9.27401542715e-20) /* A cm^2 */
#define GSL_CONST_CGS_NUCLEAR_MAGNETON (5.05078658357e-23) /* A cm^2 */
#define GSL_CONST_CGS_ELECTRON_MAGNETIC_MOMENT (9.28477005945e-20) /* A cm^2 */
#define GSL_CONST_CGS_PROTON_MAGNETIC_MOMENT (1.41060761072e-22) /* A cm^2 */
#define GSL_CONST_CGS_MOLAR_GAS (8.31447086363e7) /* g cm^2 / K mol s^2 */
#define GSL_CONST_CGS_STANDARD_GAS_VOLUME (2.2413992e4) /* cm^3 / mol */
#define GSL_CONST_CGS_MINUTE (6e1) /* s */
#define GSL_CONST_CGS_HOUR (3.6e3) /* s */
#define GSL_CONST_CGS_DAY (8.64e4) /* s */
#define GSL_CONST_CGS_WEEK (6.048e5) /* s */
#define GSL_CONST_CGS_INCH (2.54e0) /* cm */
#define GSL_CONST_CGS_FOOT (3.048e1) /* cm */
#define GSL_CONST_CGS_YARD (9.144e1) /* cm */
#define GSL_CONST_CGS_MILE (1.609344e5) /* cm */
#define GSL_CONST_CGS_NAUTICAL_MILE (1.852e5) /* cm */
#define GSL_CONST_CGS_FATHOM (1.8288e2) /* cm */
#define GSL_CONST_CGS_MIL (2.54e-3) /* cm */
#define GSL_CONST_CGS_POINT (3.52777777778e-2) /* cm */
#define GSL_CONST_CGS_TEXPOINT (3.51459803515e-2) /* cm */
#define GSL_CONST_CGS_MICRON (1e-4) /* cm */
#define GSL_CONST_CGS_ANGSTROM (1e-8) /* cm */
#define GSL_CONST_CGS_HECTARE (1e8) /* cm^2 */
#define GSL_CONST_CGS_ACRE (4.04685642241e7) /* cm^2 */
#define GSL_CONST_CGS_BARN (1e-24) /* cm^2 */
#define GSL_CONST_CGS_LITER (1e3) /* cm^3 */
#define GSL_CONST_CGS_US_GALLON (3.78541178402e3) /* cm^3 */
#define GSL_CONST_CGS_QUART (9.46352946004e2) /* cm^3 */
#define GSL_CONST_CGS_PINT (4.73176473002e2) /* cm^3 */
#define GSL_CONST_CGS_CUP (2.36588236501e2) /* cm^3 */
#define GSL_CONST_CGS_FLUID_OUNCE (2.95735295626e1) /* cm^3 */
#define GSL_CONST_CGS_TABLESPOON (1.47867647813e1) /* cm^3 */
#define GSL_CONST_CGS_TEASPOON (4.92892159375e0) /* cm^3 */
#define GSL_CONST_CGS_CANADIAN_GALLON (4.54609e3) /* cm^3 */
#define GSL_CONST_CGS_UK_GALLON (4.546092e3) /* cm^3 */
#define GSL_CONST_CGS_MILES_PER_HOUR (4.4704e1) /* cm / s */
#define GSL_CONST_CGS_KILOMETERS_PER_HOUR (2.77777777778e1) /* cm / s */
#define GSL_CONST_CGS_KNOT (5.14444444444e1) /* cm / s */
#define GSL_CONST_CGS_POUND_MASS (4.5359237e2) /* g */
#define GSL_CONST_CGS_OUNCE_MASS (2.8349523125e1) /* g */
#define GSL_CONST_CGS_TON (9.0718474e5) /* g */
#define GSL_CONST_CGS_METRIC_TON (1e6) /* g */
#define GSL_CONST_CGS_UK_TON (1.0160469088e6) /* g */
#define GSL_CONST_CGS_TROY_OUNCE (3.1103475e1) /* g */
#define GSL_CONST_CGS_CARAT (2e-1) /* g */
#define GSL_CONST_CGS_UNIFIED_ATOMIC_MASS (1.6605402e-24) /* g */
#define GSL_CONST_CGS_GRAM_FORCE (9.80665e2) /* cm g / s^2 */
#define GSL_CONST_CGS_POUND_FORCE (4.44822161526e5) /* cm g / s^2 */
#define GSL_CONST_CGS_KILOPOUND_FORCE (4.44822161526e8) /* cm g / s^2 */
#define GSL_CONST_CGS_POUNDAL (1.38255e4) /* cm g / s^2 */
#define GSL_CONST_CGS_CALORIE (4.1868e7) /* g cm^2 / s^2 */
#define GSL_CONST_CGS_BTU (1.05505585262e10) /* g cm^2 / s^2 */
#define GSL_CONST_CGS_THERM (1.05506e15) /* g cm^2 / s^2 */
#define GSL_CONST_CGS_HORSEPOWER (7.457e9) /* g cm^2 / s^3 */
#define GSL_CONST_CGS_BAR (1e6) /* g / cm s^2 */
#define GSL_CONST_CGS_STD_ATMOSPHERE (1.01325e6) /* g / cm s^2 */
#define GSL_CONST_CGS_TORR (1.33322368421e3) /* g / cm s^2 */
#define GSL_CONST_CGS_METER_OF_MERCURY (1.33322368421e6) /* g / cm s^2 */
#define GSL_CONST_CGS_INCH_OF_MERCURY (3.38638815789e4) /* g / cm s^2 */
#define GSL_CONST_CGS_INCH_OF_WATER (2.4884e3) /* g / cm s^2 */
#define GSL_CONST_CGS_PSI (6.89475729317e4) /* g / cm s^2 */
#define GSL_CONST_CGS_POISE (1e0) /* g / cm s */
#define GSL_CONST_CGS_STOKES (1e0) /* cm^2 / s */
#define GSL_CONST_CGS_FARADAY (9.6485308989e4) /* A s / mol */
#define GSL_CONST_CGS_ELECTRON_CHARGE (1.60217733e-19) /* A s */
#define GSL_CONST_CGS_GAUSS (1e-1) /* g / A s^2 */
#define GSL_CONST_CGS_STILB (1e0) /* cd / cm^2 */
#define GSL_CONST_CGS_LUMEN (1e0) /* cd sr */
#define GSL_CONST_CGS_LUX (1e-4) /* cd sr / cm^2 */
#define GSL_CONST_CGS_PHOT (1e0) /* cd sr / cm^2 */
#define GSL_CONST_CGS_FOOTCANDLE (1.076e-3) /* cd sr / cm^2 */
#define GSL_CONST_CGS_LAMBERT (1e0) /* cd sr / cm^2 */
#define GSL_CONST_CGS_FOOTLAMBERT (1.07639104e-3) /* cd sr / cm^2 */
#define GSL_CONST_CGS_CURIE (3.7e10) /* 1 / s */
#define GSL_CONST_CGS_ROENTGEN (2.58e-7) /* A s / g */
#define GSL_CONST_CGS_RAD (1e2) /* cm^2 / s^2 */
#define GSL_CONST_CGS_SOLAR_MASS (1.98892e33) /* g */

#endif /* __GSL_CONST_CGS__ */
