

;;; jtw-java.el --- A program for receiving the output of the program: java

;; Copyright (C) 2006-2016 Davin Pearson

;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: java backend
;; Version: 2.0

;; This file is part of GNU Java Training Wheels.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Commentary:

;; A program for receiving the output of the program: java in the form
;; of a pipe.

;;; Known Bugs:

;; none so far!

;;; Code:

(require 'cl)
(assert *prefix*)

(setq load-path (cons (concat *prefix* "/share/emacs/site-lisp/dlisp")
                      load-path))

(require 'jtw-build-jtw)

(defun d-current-line-as-string ()
  (buffer-substring-no-properties (point-at-bol) (point-at-eol)))

(defun doit ()
  (interactive)
  (let (red-line said-message numb file-less-suffix old-suffix
                 new-suffix line-left line-right file-plus-suffix)
    (condition-case err
        (while (setq red-line (read-from-minibuffer ""))
          ;;(while (setq red-line (d-read-line))
          ;;(message "input0: red-line=%s" red-line)
          ;;(message "1")
          (assert red-line)
          ;;(message "2")
          (assert (stringp red-line))
          ;;(message "3")
          (assert (sequencep red-line))
          ;;(message "4")
          (setq said-message nil)
          ;;(message "5")
          (when (string-match "\\([A-Z][a-zA-Z0-9_]*\\)\\(\\.java\\):\\([0-9]+\\)" red-line)
            ;;(message "6")
            (setq said-message t)
            ;;(message "7")
            (setq numb (substring red-line (match-beginning 3) (match-end 3)))
            ;;(message "8")
            (assert (read-ready numb))
            ;;(message "9")
            ;;(assert (sequencep (count-locations)))
            ;;(setq numb (- (read-str numb) (count-locations)))
            ;;(message "10")
            (assert (sequencep numb))
            ;;(message "11")
            (assert (stringp numb))
            (setq numb (read-str numb))
            ;;(message "12")
            (assert (integerp numb))
            ;;(assert (sequencep numb))
            ;;(message "13")
            (assert (stringp red-line))
            (assert (sequencep red-line))
            (assert (and 1 (match-beginning 1)))
            (assert (and 2 (match-end 1)))
            (assert (and 3 (match-beginning 2)))
            (assert (and 4 (match-end 2)))
            (assert (and 5 (match-beginning 3)))
            (assert (and 6 (match-end 3)))
            ;;(message "14")
            (setq file-less-suffix (substring red-line (match-beginning 1) (match-end 1)))
            ;;(message "15")
            (assert file-less-suffix)
            (assert (stringp file-less-suffix))
            ;;(message "16")
            (setq old-suffix ".java")
            ;;(message "17")
            (assert old-suffix)
            (assert (stringp old-suffix))
            ;;(message "18")
            (setq new-suffix ".jtw")
            ;;(message "19")
            (assert new-suffix)
            (assert (stringp new-suffix))
            ;;(message "20")
            (setq line-left        (substring red-line 0 (match-beginning 1)))
            (setq line-right       (substring red-line (match-end 3)))
            (setq file-plus-suffix (concat file-less-suffix new-suffix))
            (setq file             (concat file-less-suffix old-suffix))
            ;;(message "21")
            (assert (stringp line-left))
            (assert (stringp line-right))
            (assert (stringp file-plus-suffix))
            (assert (stringp file))
            ;;(message "22")
            (find-file file)
            ;;(message "23")
            (assert (integerp numb))
            (goto-line numb)
            ;;(message "(warn--get-location)=%s" (warn--get-location))
            ;;(message "24")
            ;;(debug "Tiger Woods")
            (setq location (warn--get-location))
            ;;(setq location (cons file numb))
            ;;(message "24b")
            ;;(message "location=%s" location)
            (assert (not (eq location t)))
            (assert (not (eq location nil)))
            (assert (sequencep location))
            (assert (consp location))
            (assert (stringp (car location)))
            (assert (numberp (cdr location)))
            ;;(message "25")
            (when location
              ;;(message "26")
              (setq red-line (concat line-left (car location) ":" (prin1-to-string (cdr location)) line-right))
              ;;(message "27")
              )
            ;;(message "28")
            (assert (sequencep red-line))
            (message "input1: %s" red-line)
            )
          (when (not said-message)
            (message "input2: %s" red-line)
            ;;(message "Jean Jarre's Equinoxe")
            ))
      (error
       ;;(message "input4: My Fair Lady")
       (if (and (not (string-match "Error reading from stdin" (prin1-to-string (cdr err))))
                (not (string-match "Eobp" (prin1-to-string (cdr err)))))
           (message "input4: Error=%s" (cdr err))
       )))))

(provide 'jtw-java)
;; (round (/ (d-what-line) 50.0)) 3 pages
;;; end of jtw-java.el
