/* Data for function powf.
   Copyright (C) 2014-2016 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <http://www.gnu.org/licenses/>.  */

#include "svml_s_powf_data.h"

	.section .rodata, "a"
	.align 64

/* Data table for vector implementations of function powf.
   The table may contain polynomial, reduction, lookup coefficients and
   other coefficients obtained through different methods of research
   and experimental work.  */

	.globl __svml_spow_data
__svml_spow_data:

/* General purpose constants for H+L multiplication:
 * NMINNORM */
float_vector _NMINNORM 0x80800000

/* NMAXVAL */
float_vector _NMAXVAL 0xfeffffff

/* INF */
float_vector _INF 0x7f800000

/* ABSMASK */
float_vector _ABSMASK 0x7fffffff

/* DOMAINRANGE */
float_vector _DOMAINRANGE 0x42ae9a00

/* Log(2) lookup High+Low table for logarithmic part */
.if .-__svml_spow_data != _Log_HA_table
.err
.endif
	.quad	0xc086232bdd7a8300
	.quad	0xbe1ce91eef3fb100
	.quad	0xc086232fdc7ad828
	.quad	0xbe1cefcffda73b6a
	.quad	0xc0862333d97d2ba0
	.quad	0xbe1cef406748f1ff
	.quad	0xc0862337d48378e0
	.quad	0xbe1cef2a9429925a
	.quad	0xc086233bcd8fb878
	.quad	0xbe1cf138d17ebecb
	.quad	0xc086233fc4a3e018
	.quad	0xbe1ceff2dbbbb29e
	.quad	0xc0862343b9c1e270
	.quad	0xbe1cf1a42aae437b
	.quad	0xc0862347acebaf68
	.quad	0xbe1cef3b152048af
	.quad	0xc086234b9e2333f0
	.quad	0xbe1cef20e127805e
	.quad	0xc086234f8d6a5a30
	.quad	0xbe1cf00ad6052cf4
	.quad	0xc08623537ac30980
	.quad	0xbe1cefc4642ee597
	.quad	0xc0862357662f2660
	.quad	0xbe1cf1f277d36e16
	.quad	0xc086235b4fb092a0
	.quad	0xbe1ceed009e8d8e6
	.quad	0xc086235f37492d28
	.quad	0xbe1cf1e4038cb362
	.quad	0xc08623631cfad250
	.quad	0xbe1cf0b0873b8557
	.quad	0xc086236700c75b98
	.quad	0xbe1cf15bb3227c0b
	.quad	0xc086236ae2b09fe0
	.quad	0xbe1cf151ef8ca9ed
	.quad	0xc086236ec2b87358
	.quad	0xbe1cefe1dc2cd2ed
	.quad	0xc0862372a0e0a780
	.quad	0xbe1cf0d1eec5454f
	.quad	0xc08623767d2b0b48
	.quad	0xbe1ceeefd570bbce
	.quad	0xc086237a57996af0
	.quad	0xbe1cee99ae91b3a7
	.quad	0xc086237e302d9028
	.quad	0xbe1cf0412830fbd1
	.quad	0xc086238206e94218
	.quad	0xbe1ceee898588610
	.quad	0xc0862385dbce4548
	.quad	0xbe1cee9a1fbcaaea
	.quad	0xc0862389aede5bc0
	.quad	0xbe1ceed8e7cc1ad6
	.quad	0xc086238d801b4500
	.quad	0xbe1cf10c8d059da6
	.quad	0xc08623914f86be18
	.quad	0xbe1ceee6c63a8165
	.quad	0xc08623951d228180
	.quad	0xbe1cf0c3592d2ff1
	.quad	0xc0862398e8f04758
	.quad	0xbe1cf0026cc4cb1b
	.quad	0xc086239cb2f1c538
	.quad	0xbe1cf15d48d8e670
	.quad	0xc08623a07b28ae60
	.quad	0xbe1cef359363787c
	.quad	0xc08623a44196b390
	.quad	0xbe1cefdf1ab2e82c
	.quad	0xc08623a8063d8338
	.quad	0xbe1cefe43c02aa84
	.quad	0xc08623abc91ec960
	.quad	0xbe1cf044f5ae35b7
	.quad	0xc08623af8a3c2fb8
	.quad	0xbe1cf0b0b4001e1b
	.quad	0xc08623b349975d98
	.quad	0xbe1cf1bae76dfbcf
	.quad	0xc08623b70731f810
	.quad	0xbe1cef0a72e13a62
	.quad	0xc08623bac30da1c8
	.quad	0xbe1cf184007d2b6b
	.quad	0xc08623be7d2bfb40
	.quad	0xbe1cf16f4b239e98
	.quad	0xc08623c2358ea2a0
	.quad	0xbe1cf0976acada87
	.quad	0xc08623c5ec3733d0
	.quad	0xbe1cf066318a16ff
	.quad	0xc08623c9a1274880
	.quad	0xbe1ceffaa7148798
	.quad	0xc08623cd54607820
	.quad	0xbe1cf23ab02e9b6e
	.quad	0xc08623d105e45800
	.quad	0xbe1cefdfef7d4fde
	.quad	0xc08623d4b5b47b20
	.quad	0xbe1cf17fece44f2b
	.quad	0xc08623d863d27270
	.quad	0xbe1cf18f907d0d7c
	.quad	0xc08623dc103fccb0
	.quad	0xbe1cee61fe072c98
	.quad	0xc08623dfbafe1668
	.quad	0xbe1cf022dd891e2f
	.quad	0xc08623e3640eda20
	.quad	0xbe1ceecc1daf4358
	.quad	0xc08623e70b73a028
	.quad	0xbe1cf0173c4fa380
	.quad	0xc08623eab12deec8
	.quad	0xbe1cf16a2150c2f4
	.quad	0xc08623ee553f4a30
	.quad	0xbe1cf1bf980b1f4b
	.quad	0xc08623f1f7a93480
	.quad	0xbe1cef8b731663c2
	.quad	0xc08623f5986d2dc0
	.quad	0xbe1cee9a664d7ef4
	.quad	0xc08623f9378cb3f0
	.quad	0xbe1cf1eda2af6400
	.quad	0xc08623fcd5094320
	.quad	0xbe1cf1923f9d68d7
	.quad	0xc086240070e45548
	.quad	0xbe1cf0747cd3e03a
	.quad	0xc08624040b1f6260
	.quad	0xbe1cf22ee855bd6d
	.quad	0xc0862407a3bbe078
	.quad	0xbe1cf0d57360c00b
	.quad	0xc086240b3abb4398
	.quad	0xbe1ceebc815cd575
	.quad	0xc086240ed01efdd0
	.quad	0xbe1cf03bfb970951
	.quad	0xc086241263e87f50
	.quad	0xbe1cf16e74768529
	.quad	0xc0862415f6193658
	.quad	0xbe1cefec64b8becb
	.quad	0xc086241986b28f30
	.quad	0xbe1cf0838d210baa
	.quad	0xc086241d15b5f448
	.quad	0xbe1cf0ea86e75b11
	.quad	0xc0862420a324ce28
	.quad	0xbe1cf1708d11d805
	.quad	0xc08624242f008380
	.quad	0xbe1ceea988c5a417
	.quad	0xc0862427b94a7910
	.quad	0xbe1cef166a7bbca5
	.quad	0xc086242b420411d0
	.quad	0xbe1cf0c9d9e86a38
	.quad	0xc086242ec92eaee8
	.quad	0xbe1cef0946455411
	.quad	0xc08624324ecbaf98
	.quad	0xbe1cefea60907739
	.quad	0xc0862435d2dc7160
	.quad	0xbe1cf1ed0934ce42
	.quad	0xc086243955624ff8
	.quad	0xbe1cf191ba746c7d
	.quad	0xc086243cd65ea548
	.quad	0xbe1ceeec78cf2a7e
	.quad	0xc086244055d2c968
	.quad	0xbe1cef345284c119
	.quad	0xc0862443d3c012b8
	.quad	0xbe1cf24f77355219
	.quad	0xc08624475027d5e8
	.quad	0xbe1cf05bf087e114
	.quad	0xc086244acb0b65d0
	.quad	0xbe1cef3504a32189
	.quad	0xc086244e446c1398
	.quad	0xbe1ceff54b2a406f
	.quad	0xc0862451bc4b2eb8
	.quad	0xbe1cf0757d54ed4f
	.quad	0xc086245532aa04f0
	.quad	0xbe1cf0c8099fdfd5
	.quad	0xc0862458a789e250
	.quad	0xbe1cf0b173796a31
	.quad	0xc086245c1aec1138
	.quad	0xbe1cf11d8734540d
	.quad	0xc086245f8cd1da60
	.quad	0xbe1cf1916a723ceb
	.quad	0xc0862462fd3c84d8
	.quad	0xbe1cf19a911e1da7
	.quad	0xc08624666c2d5608
	.quad	0xbe1cf23a9ef72e4f
	.quad	0xc0862469d9a591c0
	.quad	0xbe1cef503d947663
	.quad	0xc086246d45a67a18
	.quad	0xbe1cf0fceeb1a0b2
	.quad	0xc0862470b0314fa8
	.quad	0xbe1cf107e27e4fbc
	.quad	0xc086247419475160
	.quad	0xbe1cf03dd9922331
	.quad	0xc086247780e9bc98
	.quad	0xbe1cefce1a10e129
	.quad	0xc086247ae719cd18
	.quad	0xbe1ceea47f73c4f6
	.quad	0xc086247e4bd8bd10
	.quad	0xbe1ceec0ac56d100
	.quad	0xc0862481af27c528
	.quad	0xbe1cee8a6593278a
	.quad	0xc086248511081c70
	.quad	0xbe1cf2231dd9dec7
	.quad	0xc0862488717af888
	.quad	0xbe1cf0b4b8ed7da8
	.quad	0xc086248bd0818d68
	.quad	0xbe1cf1bd8d835002
	.quad	0xc086248f2e1d0d98
	.quad	0xbe1cf259acc107f4
	.quad	0xc08624928a4eaa20
	.quad	0xbe1cee897636b00c
	.quad	0xc0862495e5179270
	.quad	0xbe1cee757f20c326
	.quad	0xc08624993e78f490
	.quad	0xbe1cefafd3aa54a4
	.quad	0xc086249c9673fd10
	.quad	0xbe1cee7298d38b97
	.quad	0xc086249fed09d6f8
	.quad	0xbe1ceedc158d4ceb
	.quad	0xc08624a3423babe0
	.quad	0xbe1cf2282987cb2e
	.quad	0xc08624a6960aa400
	.quad	0xbe1cefe7381ecc4b
	.quad	0xc08624a9e877e600
	.quad	0xbe1cef328dbbce80
	.quad	0xc08624ad39849728
	.quad	0xbe1cefde45f3cc71
	.quad	0xc08624b08931db58
	.quad	0xbe1cefa8b89433b9
	.quad	0xc08624b3d780d500
	.quad	0xbe1cef6773c0b139
	.quad	0xc08624b72472a528
	.quad	0xbe1cf031c931c11f
	.quad	0xc08624ba70086b78
	.quad	0xbe1cf088f49275e7
	.quad	0xc08624bdba434630
	.quad	0xbe1cf17de0eaa86d
	.quad	0xc08624c103245238
	.quad	0xbe1cefd492f1ba75
	.quad	0xc08624c44aacab08
	.quad	0xbe1cf1253e154466
	.quad	0xc08624c790dd6ad0
	.quad	0xbe1cf0fb09ee6d55
	.quad	0xc08624cad5b7aa58
	.quad	0xbe1cf1f08dd048fe
	.quad	0xc08624ce193c8120
	.quad	0xbe1ceeca0809697f
	.quad	0xc08624d15b6d0538
	.quad	0xbe1cef8d5662d968
	.quad	0xc08624d49c4a4b78
	.quad	0xbe1cee97b556ed78
	.quad	0xc08624d7dbd56750
	.quad	0xbe1cf1b14b6acb75
	.quad	0xc08624db1a0f6b00
	.quad	0xbe1cef1e860623f2
	.quad	0xc08624de56f96758
	.quad	0xbe1ceeaf4d156f3d
	.quad	0xc08624e192946bf0
	.quad	0xbe1ceecc12b400ed
	.quad	0xc08624e4cce18710
	.quad	0xbe1cf180c40c794f
	.quad	0xc08624e805e1c5c8
	.quad	0xbe1cf185a08f7f65
	.quad	0xc08624eb3d9633d8
	.quad	0xbe1cef45fc924078
	.quad	0xc08624ee73ffdbb0
	.quad	0xbe1cf1e4f457f32a
	.quad	0xc08624f1a91fc6a0
	.quad	0xbe1cf040147b8a5a
	.quad	0xc08624f4dcf6fc98
	.quad	0xbe1cf1effca0dfb2
	.quad	0xc08624f80f868468
	.quad	0xbe1cf0470146e5bc
	.quad	0xc08624fb40cf6390
	.quad	0xbe1cef4dd186e501
	.quad	0xc08624fe70d29e60
	.quad	0xbe1ceebe257f66c7
	.quad	0xc08625019f9137f0
	.quad	0xbe1ceefb7a1c395c
	.quad	0xc0862504cd0c3220
	.quad	0xbe1cf209dedfed8c
	.quad	0xc0862507f9448db0
	.quad	0xbe1cf082da464994
	.quad	0xc086250b243b4a18
	.quad	0xbe1cee88694a73cf
	.quad	0xc086250e4df165a0
	.quad	0xbe1cf0b61e8f0531
	.quad	0xc08625117667dd78
	.quad	0xbe1cf1106599c962
	.quad	0xc08625149d9fad98
	.quad	0xbe1ceff1ee88af1f
	.quad	0xc0862517c399d0c8
	.quad	0xbe1cf0f746994ef6
	.quad	0xc086251ae85740b8
	.quad	0xbe1cefe8a1d077e4
	.quad	0xc086251e0bd8f5e0
	.quad	0xbe1cf1a1da036092
	.quad	0xc08625212e1fe7a8
	.quad	0xbe1cf0f8a7786fcd
	.quad	0xc08625244f2d0c48
	.quad	0xbe1cefa1174a07a7
	.quad	0xc08625276f0158d8
	.quad	0xbe1cef1043aa5b25
	.quad	0xc086252a8d9dc150
	.quad	0xbe1cf15d521c169d
	.quad	0xc086252dab033898
	.quad	0xbe1cf220bba8861f
	.quad	0xc0862530c732b078
	.quad	0xbe1cef51e310eae2
	.quad	0xc0862533e22d1988
	.quad	0xbe1cf222fcedd8ae
	.quad	0xc0862536fbf36370
	.quad	0xbe1cefdb4da4bda8
	.quad	0xc086253a14867ca0
	.quad	0xbe1ceeafc1112171
	.quad	0xc086253d2be75280
	.quad	0xbe1cee99dfb4b408
	.quad	0xc08625404216d160
	.quad	0xbe1cf22d2536f06b
	.quad	0xc08625435715e498
	.quad	0xbe1cef6abbf2e268
	.quad	0xc08625466ae57648
	.quad	0xbe1cf093a14789f5
	.quad	0xc08625497d866fa0
	.quad	0xbe1cf0f93655603c
	.quad	0xc086254c8ef9b8b8
	.quad	0xbe1cf1cc40c9aafc
	.quad	0xc086254f9f4038a8
	.quad	0xbe1ceeea5f4e9157
	.quad	0xc0862552ae5ad568
	.quad	0xbe1cefa9f52d4997
	.quad	0xc0862555bc4a7400
	.quad	0xbe1cefa490a638ff
	.quad	0xc0862558c90ff868
	.quad	0xbe1cef7fcf797d6f
	.quad	0xc086255bd4ac4590
	.quad	0xbe1cf1b4c51113c9
	.quad	0xc086255edf203d78
	.quad	0xbe1cef55e5b4a55d
	.quad	0xc0862561e86cc100
	.quad	0xbe1cf0d37a25f9dc
	.quad	0xc0862564f092b028
	.quad	0xbe1ceebe9efc19d9
	.quad	0xc0862567f792e9d8
	.quad	0xbe1cee8ad30a57b5
	.quad	0xc086256afd6e4c08
	.quad	0xbe1cef4e1817b90b
	.quad	0xc086256e0225b3b8
	.quad	0xbe1cee7fa9229996
	.quad	0xc086257105b9fce0
	.quad	0xbe1cf0b54963d945
	.quad	0xc0862574082c0298
	.quad	0xbe1cee5f2f3c7995
	.quad	0xc0862577097c9ee0
	.quad	0xbe1cf0828e303a2c
	.quad	0xc086257a09acaae0
	.quad	0xbe1cf172c3078947
	.quad	0xc086257d08bcfec0
	.quad	0xbe1cf189252afa22
	.quad	0xc086258006ae71b8
	.quad	0xbe1cefdb80426923
	.quad	0xc08625830381da08
	.quad	0xbe1ceef1391a0372
	.quad	0xc0862585ff380d00
	.quad	0xbe1cf17720c78d13
	.quad	0xc0862588f9d1df18
	.quad	0xbe1ceef1f9027d83
	.quad	0xc086258bf35023b8
	.quad	0xbe1cf06fac99dec9
	.quad	0xc086258eebb3ad78
	.quad	0xbe1cf1373eeb45c0
	.quad	0xc0862591e2fd4e00
	.quad	0xbe1cef777536bb81
	.quad	0xc0862594d92dd600
	.quad	0xbe1cf0f43ca40766
	.quad	0xc0862597ce461558
	.quad	0xbe1cefb2cfc6766b
	.quad	0xc086259ac246daf0
	.quad	0xbe1ceea49e64ffa2
	.quad	0xc086259db530f4c8
	.quad	0xbe1cf250fa457dec
	.quad	0xc08625a0a7053018
	.quad	0xbe1cf17d8bb2a44e
	.quad	0xc08625a397c45918
	.quad	0xbe1cf1d5906d54b7
	.quad	0xc08625a6876f3b30
	.quad	0xbe1cf08fe7b31780
	.quad	0xc08625a97606a0e0
	.quad	0xbe1cef13edfc9d11
	.quad	0xc08625ac638b53c8
	.quad	0xbe1cef9d2b107219
	.quad	0xc08625af4ffe1cb0
	.quad	0xbe1cf1ddd4ff6160
	.quad	0xc08625b23b5fc390
	.quad	0xbe1cefa02a996495
	.quad	0xc08625b525b10f68
	.quad	0xbe1cf166a7e37ee5
	.quad	0xc08625b80ef2c680
	.quad	0xbe1cef0b171068a5
	.quad	0xc08625baf725ae28
	.quad	0xbe1cf05c80779283
	.quad	0xc08625bdde4a8af0
	.quad	0xbe1cf1bbfbffb889
	.quad	0xc08625c0c4622090
	.quad	0xbe1cf0b8666c0124
	.quad	0xc08625c3a96d31e0
	.quad	0xbe1cf0a8fcf47a86
	.quad	0xc08625c68d6c80f0
	.quad	0xbe1cef46e18cb092
	.quad	0xc08625c97060cef0
	.quad	0xbe1cf1458a350efb
	.quad	0xc08625cc524adc58
	.quad	0xbe1ceeea1dadce12
	.quad	0xc08625cf332b68b0
	.quad	0xbe1cf0a1bfdc44c7
	.quad	0xc08625d2130332d0
	.quad	0xbe1cef96d02da73e
	.quad	0xc08625d4f1d2f8a8
	.quad	0xbe1cf2451c3c7701
	.quad	0xc08625d7cf9b7778
	.quad	0xbe1cf10d08f83812
	.quad	0xc08625daac5d6ba0
	.quad	0xbe1ceec5b4895c5e
	.quad	0xc08625dd881990b0
	.quad	0xbe1cf14e1325c5e4
	.quad	0xc08625e062d0a188
	.quad	0xbe1cf21d0904be12
	.quad	0xc08625e33c835838
	.quad	0xbe1ceed0839bcf21
	.quad	0xc08625e615326df0
	.quad	0xbe1cf1bb944889d2
	.quad	0xc08625e8ecde9b48
	.quad	0xbe1cee738e85eece
	.quad	0xc08625ebc38897e0
	.quad	0xbe1cf25c2bc6ef12
	.quad	0xc08625ee99311ac8
	.quad	0xbe1cf132b70a41ad
	.quad	0xc08625f16dd8da28
	.quad	0xbe1cf1984236a6e3
	.quad	0xc08625f441808b78
	.quad	0xbe1cf19ae74998f9
	.quad	0xc08625f71428e370
	.quad	0xbe1cef3e175d61a1
	.quad	0xc08625f9e5d295f8
	.quad	0xbe1cf101f9868fd9
	.quad	0xc08625fcb67e5658
	.quad	0xbe1cee69db83dcd2
	.quad	0xc08625ff862cd6f8
	.quad	0xbe1cf081b636af51
	.quad	0xc086260254dec9a8
	.quad	0xbe1cee62c7d59b3e
	.quad	0xc08626052294df58
	.quad	0xbe1cf1b745c57716
	.quad	0xc0862607ef4fc868
	.quad	0xbe1cef3d2800ea23
	.quad	0xc086260abb103458
	.quad	0xbe1cef480ff1acd2
	.quad	0xc086260d85d6d200
	.quad	0xbe1cf2424c9a17ef
	.quad	0xc08626104fa44f90
	.quad	0xbe1cf12cfde90fd5
	.quad	0xc086261318795a68
	.quad	0xbe1cf21f590dd5b6
	.quad	0xc0862615e0569f48
	.quad	0xbe1cf0c50f9cd28a
	.quad	0xc0862618a73cca30
	.quad	0xbe1ceedbdb520545
	.quad	0xc086261b6d2c8668
	.quad	0xbe1cf0b030396011
	.quad	0xc086261e32267e98
	.quad	0xbe1cf19917010e96
	.quad	0xc0862620f62b5cb0
	.quad	0xbe1cf07331355985
	.quad	0xc0862623b93bc9e8
	.quad	0xbe1cf01ae921a1c3
	.quad	0xc08626267b586ed0
	.quad	0xbe1cefe5cf0dbf0c
	.quad	0xc08626293c81f348
	.quad	0xbe1cf01b258aeb50
	.quad	0xc086262bfcb8fe88
	.quad	0xbe1cee6b9e7f4c68
	.quad	0xc086262ebbfe3710
	.quad	0xbe1cee684a9b21c9
	.quad	0xc08626317a5242b8
	.quad	0xbe1cf1f8bcde9a8b
	.quad	0xc086263437b5c6c0
	.quad	0xbe1cf1d063d36238
	.quad	0xc0862636f42967a8
	.quad	0xbe1cf1e31a19075e
	.quad	0xc0862639afadc950
	.quad	0xbe1cf1d8efdf7e7d
	.quad	0xc086263c6a438ef0
	.quad	0xbe1cf1812ee72dba
	.quad	0xc086263f23eb5b18
	.quad	0xbe1cf1449a9a2279
	.quad	0xc0862641dca5cfb8
	.quad	0xbe1cee96edce5085
	.quad	0xc086264494738e08
	.quad	0xbe1cf06797bd03b2
	.quad	0xc08626474b5536b8
	.quad	0xbe1cef91b9b7ffc1
	.quad	0xc086264a014b69c0
	.quad	0xbe1cef4b6721278f
	.quad	0xc086264cb656c678
	.quad	0xbe1cf1942925eb4a
	.quad	0xc086264f6a77eba8
	.quad	0xbe1cefa2c7bc2e39
	.quad	0xc08626521daf7758
	.quad	0xbe1cf252595aceb3
	.quad	0xc0862654cffe0718
	.quad	0xbe1cee8e9ae47ec2
	.quad	0xc0862657816437a8
	.quad	0xbe1cf1bf913828fa
	.quad	0xc086265a31e2a558
	.quad	0xbe1cf23475d6b366
	.quad	0xc086265ce179ebc8
	.quad	0xbe1cef8df00a922b
	.quad	0xc086265f902aa5f0
	.quad	0xbe1cef279bfa43e0
	.quad	0xc08626623df56e38
	.quad	0xbe1cf080e10b8365
	.quad	0xc0862664eadade70
	.quad	0xbe1cf1a518f9b544
	.quad	0xc086266796db8fd0
	.quad	0xbe1cef9308fed9e9
	.quad	0xc086266a41f81ae8
	.quad	0xbe1ceea3ae6b19c9
	.quad	0xc086266cec3117b8
	.quad	0xbe1ceef06003d4c2
	.quad	0xc086266f95871da8
	.quad	0xbe1cf0b8457ffb0c
	.quad	0xc08626723dfac390
	.quad	0xbe1cf0c526745ad6
	.quad	0xc0862674e58c9fa8
	.quad	0xbe1cf0cf91ff7b5d
	.quad	0xc08626778c3d4798
	.quad	0xbe1cefe260819380
	.quad	0xc086267a320d5070
	.quad	0xbe1ceebd90aa27a3
	.quad	0xc086267cd6fd4ea8
	.quad	0xbe1cf0388121dffa
	.quad	0xc086267f7b0dd630
	.quad	0xbe1cf1a3881435f1
	.quad	0xc08626821e3f7a68
	.quad	0xbe1cef28e9d9ac52
	.quad	0xc0862684c092ce08
	.quad	0xbe1cf02d300062dd
	.quad	0xc086268762086350
	.quad	0xbe1cefaee1edfa35
	.quad	0xc086268a02a0cbe0
	.quad	0xbe1cf0a5a052e936
	.quad	0xc086268ca25c98d8
	.quad	0xbe1cee60a4a497ed
	.quad	0xc086268f413c5ab0
	.quad	0xbe1cf0e4a5d0cf49
	.quad	0xc0862691df40a170
	.quad	0xbe1cf149235a4e6e
	.quad	0xc08626947c69fc80
	.quad	0xbe1cf215180b9fcc
	.quad	0xc086269718b8fac8
	.quad	0xbe1cef9b156a9840
	.quad	0xc0862699b42e2a90
	.quad	0xbe1cf054c91441be
	.quad	0xc086269c4eca19a8
	.quad	0xbe1cf13ded26512c
	.quad	0xc086269ee88d5550
	.quad	0xbe1cf22ea4d8ac06
	.quad	0xc08626a181786a40
	.quad	0xbe1cf2354666ee2e
	.quad	0xc08626a4198be4a8
	.quad	0xbe1cefef936752b3
	.quad	0xc08626a6b0c85020
	.quad	0xbe1cf1e360a9db68
	.quad	0xc08626a9472e37d8
	.quad	0xbe1ceed6aeb812c5
	.quad	0xc08626abdcbe2650
	.quad	0xbe1cf227340b4986
	.quad	0xc08626ae7178a5b0
	.quad	0xbe1cf0215a0cbe0d
	.quad	0xc08626b1055e3f70
	.quad	0xbe1cf256adf0ae26
	.quad	0xc08626b3986f7ca8
	.quad	0xbe1ceff3c67aed06
	.quad	0xc08626b62aace5c8
	.quad	0xbe1cf2159fb93652
	.quad	0xc08626b8bc1702e0
	.quad	0xbe1cf01e6dbd1c7f
	.quad	0xc08626bb4cae5b60
	.quad	0xbe1cf009e75d1c0c
	.quad	0xc08626bddc737648
	.quad	0xbe1ceec10a020e73
	.quad	0xc08626c06b66da08
	.quad	0xbe1cf06d5783eee7
	.quad	0xc08626c2f9890ca0
	.quad	0xbe1cf0cb8f169ffe
	.quad	0xc08626c586da9388
	.quad	0xbe1cef7de2452430
	.quad	0xc08626c8135bf3b0
	.quad	0xbe1cf05da6f783ae
	.quad	0xc08626ca9f0db198
	.quad	0xbe1cefcc877d681d
	.quad	0xc08626cd29f05138
	.quad	0xbe1cef0531954ab3
	.quad	0xc08626cfb4045608
	.quad	0xbe1cf06b8565ea3d
	.quad	0xc08626d23d4a4310
	.quad	0xbe1cefdc455d9d7e
	.quad	0xc08626d4c5c29ad0
	.quad	0xbe1ceefc47e8fa64
	.quad	0xc08626d74d6ddf48
	.quad	0xbe1cf1872bf033f2
	.quad	0xc08626d9d44c9210
	.quad	0xbe1cf19d91087f9d
	.quad	0xc08626dc5a5f3438
	.quad	0xbe1cf012d444c6ab
	.quad	0xc08626dedfa64650
	.quad	0xbe1cf0ba528ee153
	.quad	0xc08626e164224880
	.quad	0xbe1ceeb431709788
	.quad	0xc08626e3e7d3ba60
	.quad	0xbe1cf0b9af31a6a5
	.quad	0xc08626e66abb1b28
	.quad	0xbe1cf168fb2e135b
	.quad	0xc08626e8ecd8e990
	.quad	0xbe1cef9097461c93
	.quad	0xc08626eb6e2da3d0
	.quad	0xbe1cee7a434735d8
	.quad	0xc08626edeeb9c7a8
	.quad	0xbe1cf235732b86f2
	.quad	0xc08626f06e7dd280
	.quad	0xbe1cefe1510b89e6
	.quad	0xc08626f2ed7a4120
	.quad	0xbe1cf1f64b9b80ef
	.quad	0xc08626f56baf9000
	.quad	0xbe1cf08f320ca339
	.quad	0xc08626f7e91e3b08
	.quad	0xbe1cf1b1de2808a1
	.quad	0xc08626fa65c6bdc0
	.quad	0xbe1cf1976d778b28
	.quad	0xc08626fce1a99338
	.quad	0xbe1ceef40a4f076f
	.quad	0xc08626ff5cc73600
	.quad	0xbe1cef3e45869ce3
	.quad	0xc0862701d7202048
	.quad	0xbe1ceef601b4c9d6
	.quad	0xc086270450b4cbc0
	.quad	0xbe1cf1eaf0b57fd6
	.quad	0xc0862706c985b1c0
	.quad	0xbe1cef82a44990f3
	.quad	0xc086270941934b10
	.quad	0xbe1ceefe32981f2c
	.quad	0xc086270bb8de1018
	.quad	0xbe1cefbf6f5a0445
	.quad	0xc086270e2f6678d0
	.quad	0xbe1cf18dba75792c
	.quad	0xc0862710a52cfcc8
	.quad	0xbe1cf0da64ce995f
	.quad	0xc08627131a321318
	.quad	0xbe1cef04ac0fb802
	.quad	0xc08627158e763268
	.quad	0xbe1cee9d4e2ad9bd
	.quad	0xc086271801f9d0f8
	.quad	0xbe1cefa9b55407b5
	.quad	0xc086271a74bd64a0
	.quad	0xbe1cefe6bd329570
	.quad	0xc086271ce6c162c8
	.quad	0xbe1cef0b1205dc85
	.quad	0xc086271f58064068
	.quad	0xbe1cef092a785e3f
	.quad	0xc0862721c88c7210
	.quad	0xbe1cf050dcdaac30
	.quad	0xc086272438546be8
	.quad	0xbe1cf210907ded8b
	.quad	0xc0862726a75ea1b8
	.quad	0xbe1cee760be44f99
	.quad	0xc086272915ab86c0
	.quad	0xbe1ceeeee07c2bcc
	.quad	0xc086272b833b8df0
	.quad	0xbe1cf06874992df5
	.quad	0xc086272df00f29d0
	.quad	0xbe1cef8fac5d4899
	.quad	0xc08627305c26cc70
	.quad	0xbe1cf1103241cc99
	.quad	0xc0862732c782e788
	.quad	0xbe1cf1d35fef83fe
	.quad	0xc08627353223ec68
	.quad	0xbe1cef3ec8133e1d
	.quad	0xc08627379c0a4be8
	.quad	0xbe1cef7261daccd8
	.quad	0xc086273a05367688
	.quad	0xbe1cf18656c50806
	.quad	0xc086273c6da8dc68
	.quad	0xbe1cf1c8736e049a
	.quad	0xc086273ed561ed38
	.quad	0xbe1cf1f93bff4911
	.quad	0xc08627413c621848
	.quad	0xbe1cf188a4ea680c
	.quad	0xc0862743a2a9cc80
	.quad	0xbe1cf1d270930c80
	.quad	0xc086274608397868
	.quad	0xbe1cf25a328c28e2
	.quad	0xc08627486d118a28
	.quad	0xbe1cf106f90aa3b8
	.quad	0xc086274ad1326f80
	.quad	0xbe1cee5e9d2e885a
	.quad	0xc086274d349c95c0
	.quad	0xbe1cf1c0bac27228
	.quad	0xc086274f975069f8
	.quad	0xbe1cf1a1500f9b1c
	.quad	0xc0862751f94e58c0
	.quad	0xbe1cefc30663ac44
	.quad	0xc08627545a96ce48
	.quad	0xbe1cf17123e427a2
	.quad	0xc0862756bb2a3678
	.quad	0xbe1cefb92749fea4
	.quad	0xc08627591b08fcc0
	.quad	0xbe1cefa40e1ea74a
	.quad	0xc086275b7a338c40
	.quad	0xbe1cee6f4612c3e9
	.quad	0xc086275dd8aa4fa8
	.quad	0xbe1cf1c54a053627
	.quad	0xc0862760366db168
	.quad	0xbe1ceff5eb503d9e
	.quad	0xc0862762937e1b70
	.quad	0xbe1cf02e47f10cee
	.quad	0xc0862764efdbf768
	.quad	0xbe1ceeb06e1d0dad
	.quad	0xc08627674b87ae88
	.quad	0xbe1cf10aadd6dba5
	.quad	0xc0862769a681a9c0
	.quad	0xbe1cf24e9913d30f
	.quad	0xc086276c00ca51a0
	.quad	0xbe1cef47b301e312
	.quad	0xc086276e5a620e48
	.quad	0xbe1ceeb1cefc2e85
	.quad	0xc0862770b3494788
	.quad	0xbe1cf16f1fbbe011
	.quad	0xc08627730b8064e8
	.quad	0xbe1ceebdf75174c7
	.quad	0xc08627756307cd70
	.quad	0xbe1cf06e3871a0da
	.quad	0xc0862777b9dfe7f0
	.quad	0xbe1cef16799fd554
	.quad	0xc086277a10091ac0
	.quad	0xbe1cf248dabf5377
	.quad	0xc086277c6583cc00
	.quad	0xbe1cf0c78d92a2cd
	.quad	0xc086277eba506158
	.quad	0xbe1cf0b911b029f0
	.quad	0xc08627810e6f4028
	.quad	0xbe1cefdc24719766
	.quad	0xc086278361e0cd70
	.quad	0xbe1cefbb6562b7e7
	.quad	0xc0862785b4a56dd8
	.quad	0xbe1cf1e0afb349ec
	.quad	0xc086278806bd85c0
	.quad	0xbe1cf008292e52fc
	.quad	0xc086278a58297918
	.quad	0xbe1cf053073872bf
	.quad	0xc086278ca8e9ab88
	.quad	0xbe1cf17a0a55a947
	.quad	0xc086278ef8fe8068
	.quad	0xbe1ceeffb0b60234
	.quad	0xc086279148685aa0
	.quad	0xbe1cf162204794a8
	.quad	0xc086279397279ce0
	.quad	0xbe1cf24cc8cb48ac
	.quad	0xc0862795e53ca978
	.quad	0xbe1cf0c9be68d5c3
	.quad	0xc086279832a7e258
	.quad	0xbe1cf172cd3d7388
	.quad	0xc086279a7f69a930
	.quad	0xbe1ceea2465fbce5
	.quad	0xc086279ccb825f40
	.quad	0xbe1cf0a386d2500f
	.quad	0xc086279f16f26590
	.quad	0xbe1cf1e338ddc18a
	.quad	0xc08627a161ba1cd0
	.quad	0xbe1cef1f5049867f
	.quad	0xc08627a3abd9e548
	.quad	0xbe1cef96c1ea8b1f
	.quad	0xc08627a5f5521f00
	.quad	0xbe1cf138f6fd3c26
	.quad	0xc08627a83e2329b0
	.quad	0xbe1cf0d4fcbfdf3a
	.quad	0xc08627aa864d64b0
	.quad	0xbe1cf24870c12c81
	.quad	0xc08627accdd12f18
	.quad	0xbe1cf0ae2a56348d
	.quad	0xc08627af14aee7a0
	.quad	0xbe1cee8ca1a9b893
	.quad	0xc08627b15ae6eca8
	.quad	0xbe1cf20414d637b0
	.quad	0xc08627b3a0799c60
	.quad	0xbe1cf0fc6b7b12d8
	.quad	0xc08627b5e5675488
	.quad	0xbe1cf152d93c4a00
	.quad	0xc08627b829b072a0
	.quad	0xbe1cf1073f9b77c2
	.quad	0xc08627ba6d5553d8
	.quad	0xbe1cee694f97d5a4
	.quad	0xc08627bcb0565500
	.quad	0xbe1cf0456b8239d7
	.quad	0xc08627bef2b3d2b0
	.quad	0xbe1cf211497127e3
	.quad	0xc08627c1346e2930
	.quad	0xbe1cf01856c0384d
	.quad	0xc08627c37585b468
	.quad	0xbe1cefa7dd05479e
	.quad	0xc08627c5b5fad000
	.quad	0xbe1cef3ae8e50b93
	.quad	0xc08627c7f5cdd750
	.quad	0xbe1ceea5f32fdd3a
	.quad	0xc08627ca34ff2560
	.quad	0xbe1cef424caeb8d9
	.quad	0xc08627cc738f14f0
	.quad	0xbe1cf0194d07a81f
	.quad	0xc08627ceb17e0070
	.quad	0xbe1cf20f452000c1
	.quad	0xc08627d0eecc4210
	.quad	0xbe1cf00e356218e4
	.quad	0xc08627d32b7a33a0
	.quad	0xbe1cef30484b4bcb
	.quad	0xc08627d567882eb0
	.quad	0xbe1ceeea11a6641b
	.quad	0xc08627d7a2f68c80
	.quad	0xbe1cf13492d5bd7b
	.quad	0xc08627d9ddc5a618
	.quad	0xbe1ceeb7048fad96
	.quad	0xc08627dc17f5d418
	.quad	0xbe1ceef0666f0477
	.quad	0xc08627de51876ee8
	.quad	0xbe1cf060d4b8b5c2
	.quad	0xc08627e08a7acea8
	.quad	0xbe1cf0b2a4b6ff8c
	.quad	0xc08627e2c2d04b28
	.quad	0xbe1cf0e34809a875
	.quad	0xc08627e4fa883bf0
	.quad	0xbe1cf16bf74a3522
	.quad	0xc08627e731a2f848
	.quad	0xbe1cee6a24623d57
	.quad	0xc08627e96820d718
	.quad	0xbe1cefc7b4f1528e
	.quad	0xc08627eb9e022f18
	.quad	0xbe1cf163051f3548
	.quad	0xc08627edd34756b8
	.quad	0xbe1cef36b3366305
	.quad	0xc08627f007f0a408
	.quad	0xbe1cf18134625550
	.quad	0xc08627f23bfe6cf0
	.quad	0xbe1cf0ec32ec1a11
	.quad	0xc08627f46f710700
	.quad	0xbe1ceeb3b64f3edc
	.quad	0xc08627f6a248c778
	.quad	0xbe1cf0cd15805bc8
	.quad	0xc08627f8d4860368
	.quad	0xbe1cf20db3bddebe
	.quad	0xc08627fb06290f90
	.quad	0xbe1cf25188430e25
	.quad	0xc08627fd37324070
	.quad	0xbe1ceea1713490f9
	.quad	0xc08627ff67a1ea28
	.quad	0xbe1cf159521d234c
	.quad	0xc0862801977860b8
	.quad	0xbe1cf24dfe50783b
	.quad	0xc0862803c6b5f7d0
	.quad	0xbe1ceef2ef89a60b
	.quad	0xc0862805f55b02c8
	.quad	0xbe1cee7fc919d62c
	.quad	0xc08628082367d4c0
	.quad	0xbe1cf215a7fb513a
	.quad	0xc086280a50dcc0a8
	.quad	0xbe1cf0e4401c5ed4
	.quad	0xc086280c7dba1910
	.quad	0xbe1cf04ec734d256
	.quad	0xc086280eaa003050
	.quad	0xbe1cf010ad787fea
	.quad	0xc0862810d5af5880
	.quad	0xbe1cee622478393d
	.quad	0xc086281300c7e368
	.quad	0xbe1cf01c7482564f
	.quad	0xc08628152b4a22a0
	.quad	0xbe1cf0de20d33536
	.quad	0xc086281755366778
	.quad	0xbe1cef2edae5837d
	.quad	0xc08628197e8d02f0
	.quad	0xbe1cf0a345318cc9
	.quad	0xc086281ba74e45d8
	.quad	0xbe1cf20085aa34b8
	.quad	0xc086281dcf7a80c0
	.quad	0xbe1cef5fa845ad83
	.quad	0xc086281ff71203e0
	.quad	0xbe1cf050d1df69c4
	.quad	0xc08628221e151f48
	.quad	0xbe1ceffe43c035b9
	.quad	0xc0862824448422b8
	.quad	0xbe1cf14f3018d3c2
	.quad	0xc08628266a5f5dc0
	.quad	0xbe1cef0a5fbae83d
	.quad	0xc08628288fa71f98
	.quad	0xbe1ceff8a95b72a1
	.quad	0xc086282ab45bb750
	.quad	0xbe1cef073aa9849b
	.quad	0xc086282cd87d73a8
	.quad	0xbe1cef69b3835c02
	.quad	0xc086282efc0ca328
	.quad	0xbe1cf0bc139379a9
	.quad	0xc08628311f099420
	.quad	0xbe1cef247a9ec596
	.quad	0xc086283341749490
	.quad	0xbe1cef74bbcc488a
	.quad	0xc0862835634df248
	.quad	0xbe1cef4bc42e7b8e
	.quad	0xc08628378495fad0
	.quad	0xbe1cf136d4d5a810
	.quad	0xc0862839a54cfb80
	.quad	0xbe1cf0d290b24dd8
	.quad	0xc086283bc5734168
	.quad	0xbe1ceeebde8e0065
	.quad	0xc086283de5091950
	.quad	0xbe1cf1a09f60aa1e
	.quad	0xc0862840040ecfe0
	.quad	0xbe1cf0803947a234
	.quad	0xc08628422284b168
	.quad	0xbe1cf0abf7638127
	.quad	0xc0862844406b0a08
	.quad	0xbe1cf0f73ee12058
	.quad	0xc08628465dc225a0
	.quad	0xbe1cf2079971b26c
	.quad	0xc08628487a8a4fe0
	.quad	0xbe1cee74957564b1
	.quad	0xc086284a96c3d420
	.quad	0xbe1ceee77c1b7d43
	.quad	0xc086284cb26efd90
	.quad	0xbe1cf23addba6e09
	.quad	0xc086284ecd8c1730
	.quad	0xbe1cf199f4a1da60
	.quad	0xc0862850e81b6bb0
	.quad	0xbe1cf09fdea81393
	.quad	0xc0862853021d4588
	.quad	0xbe1cf176adb417f7
	.quad	0xc08628551b91ef00
	.quad	0xbe1cf0f64f84a8da
	.quad	0xc08628573479b220
	.quad	0xbe1ceec34cf49523
	.quad	0xc08628594cd4d8a8
	.quad	0xbe1cf16d60fbe0bb
	.quad	0xc086285b64a3ac40
	.quad	0xbe1cee8de7acfc7b
	.quad	0xc086285d7be67630
	.quad	0xbe1ceee6256cce8d
	.quad	0xc086285f929d7fa0
	.quad	0xbe1cee7d66a3d8a5
	.quad	0xc0862861a8c91170
	.quad	0xbe1cf0bef8265792
	.quad	0xc0862863be697458
	.quad	0xbe1cf097f890c6f8
	.quad	0xc0862865d37ef0c8
	.quad	0xbe1cf09502d5c3fc
	.quad	0xc0862867e809cf00
	.quad	0xbe1ceeffb239dac7
	.quad	0xc0862869fc0a56f8
	.quad	0xbe1cf1fbfff95c98
	.quad	0xc086286c0f80d090
	.quad	0xbe1cefa57ad3eef7
	.quad	0xc086286e226d8348
	.quad	0xbe1cf22c58b9183d
	.quad	0xc086287034d0b690
	.quad	0xbe1ceff262d0a248
	.quad	0xc086287246aab180
	.quad	0xbe1cefa7bc194186
	.quad	0xc086287457fbbb08
	.quad	0xbe1cf06782d784d9
	.quad	0xc086287668c419e0
	.quad	0xbe1cf1d44d0eaa07
	.quad	0xc086287879041490
	.quad	0xbe1cf034803c8a48
	.quad	0xc086287a88bbf158
	.quad	0xbe1cf08e84916b6f
	.quad	0xc086287c97ebf650
	.quad	0xbe1cf0c4d3dc1bc7
	.quad	0xc086287ea6946958
	.quad	0xbe1cefb1e4625943
	.quad	0xc0862880b4b59010
	.quad	0xbe1cf143efdd1fd0
	.quad	0xc0862882c24faff8
	.quad	0xbe1cee9896d016da
	.quad	0xc0862884cf630e38
	.quad	0xbe1cf2186072f2cc
	.quad	0xc0862886dbefeff0
	.quad	0xbe1cef9217633d34
	.quad	0xc0862888e7f699e0
	.quad	0xbe1cf05603549486
	.quad	0xc086288af37750b0
	.quad	0xbe1cef50fff513d3
	.quad	0xc086288cfe7258c0
	.quad	0xbe1cf127713b32d0
	.quad	0xc086288f08e7f650
	.quad	0xbe1cf05015520f3d
	.quad	0xc086289112d86d58
	.quad	0xbe1cf12eb458b26f
	.quad	0xc08628931c4401a8
	.quad	0xbe1cf22eae2887ed
	.quad	0xc0862895252af6e0
	.quad	0xbe1cefdd6656dd2d
	.quad	0xc08628972d8d9058
	.quad	0xbe1cf1048ea4e646
	.quad	0xc0862899356c1150
	.quad	0xbe1ceec4501167e9
	.quad	0xc086289b3cc6bcb8
	.quad	0xbe1cf0ad52becc3f
	.quad	0xc086289d439dd568
	.quad	0xbe1cf0daa4e00e35
	.quad	0xc086289f49f19df8
	.quad	0xbe1cf00b80de8d6a
	.quad	0xc08628a14fc258c8
	.quad	0xbe1cf1bcf2ea8464
	.quad	0xc08628a355104818
	.quad	0xbe1cf0435e2782b0
	.quad	0xc08628a559dbade0
	.quad	0xbe1cf0e3e1a5f56c
	.quad	0xc08628a75e24cbf8
	.quad	0xbe1cefed9d5a721d
	.quad	0xc08628a961ebe3f8
	.quad	0xbe1cf0d2d74321e2
	.quad	0xc08628ab65313750
	.quad	0xbe1cf24200eb55e9
	.quad	0xc08628ad67f50740
	.quad	0xbe1cf23e9d7cf979
	.quad	0xc08628af6a3794d0
	.quad	0xbe1cf23a088f421c
	.quad	0xc08628b16bf920e0
	.quad	0xbe1cef2c1de1ab32
	.quad	0xc08628b36d39ec08
	.quad	0xbe1cf1abc231f7b2
	.quad	0xc08628b56dfa36d0
	.quad	0xbe1cf2074d5ba303
	.quad	0xc08628b76e3a4180
	.quad	0xbe1cf05cd5eed880
	.rept	48
	.byte	0
	.endr

/* Log(2) lookup table for logarithmic part */
.if .-__svml_spow_data != _Log_LA_table
.err
.endif
	.quad	0x8000000000000000
	.quad	0xbf5ff802a9ab10e6
	.quad	0xbf6ff00aa2b10bc0
	.quad	0xbf77ee11ebd82e94
	.quad	0xbf7fe02a6b106789
	.quad	0xbf83e7295d25a7d9
	.quad	0xbf87dc475f810a77
	.quad	0xbf8bcf712c74384c
	.quad	0xbf8fc0a8b0fc03e4
	.quad	0xbf91d7f7eb9eebe7
	.quad	0xbf93cea44346a575
	.quad	0xbf95c45a51b8d389
	.quad	0xbf97b91b07d5b11b
	.quad	0xbf99ace7551cc514
	.quad	0xbf9b9fc027af9198
	.quad	0xbf9d91a66c543cc4
	.quad	0xbf9f829b0e783300
	.quad	0xbfa0b94f7c196176
	.quad	0xbfa1b0d98923d980
	.quad	0xbfa2a7ec2214e873
	.quad	0xbfa39e87b9febd60
	.quad	0xbfa494acc34d911c
	.quad	0xbfa58a5bafc8e4d5
	.quad	0xbfa67f94f094bd98
	.quad	0xbfa77458f632dcfc
	.quad	0xbfa868a83083f6cf
	.quad	0xbfa95c830ec8e3eb
	.quad	0xbfaa4fe9ffa3d235
	.quad	0xbfab42dd711971bf
	.quad	0xbfac355dd0921f2d
	.quad	0xbfad276b8adb0b52
	.quad	0xbfae19070c276016
	.quad	0xbfaf0a30c01162a6
	.quad	0xbfaffae9119b9303
	.quad	0xbfb075983598e471
	.quad	0xbfb0ed839b5526fe
	.quad	0xbfb16536eea37ae1
	.quad	0xbfb1dcb263db1944
	.quad	0xbfb253f62f0a1417
	.quad	0xbfb2cb0283f5de1f
	.quad	0xbfb341d7961bd1d1
	.quad	0xbfb3b87598b1b6ee
	.quad	0xbfb42edcbea646f0
	.quad	0xbfb4a50d3aa1b040
	.quad	0xbfb51b073f06183f
	.quad	0xbfb590cafdf01c28
	.quad	0xbfb60658a93750c4
	.quad	0xbfb67bb0726ec0fc
	.quad	0xbfb6f0d28ae56b4c
	.quad	0xbfb765bf23a6be13
	.quad	0xbfb7da766d7b12cd
	.quad	0xbfb84ef898e8282a
	.quad	0xbfb8c345d6319b21
	.quad	0xbfb9375e55595ede
	.quad	0xbfb9ab42462033ad
	.quad	0xbfba1ef1d8061cd4
	.quad	0xbfba926d3a4ad563
	.quad	0xbfbb05b49bee43fe
	.quad	0xbfbb78c82bb0eda1
	.quad	0xbfbbeba818146765
	.quad	0xbfbc5e548f5bc743
	.quad	0xbfbcd0cdbf8c13e1
	.quad	0xbfbd4313d66cb35d
	.quad	0xbfbdb5270187d927
	.quad	0xbfbe27076e2af2e6
	.quad	0xbfbe98b549671467
	.quad	0xbfbf0a30c01162a6
	.quad	0xbfbf7b79fec37ddf
	.quad	0xbfbfec9131dbeabb
	.quad	0xbfc02ebb42bf3d4b
	.quad	0xbfc0671512ca596e
	.quad	0xbfc09f561ee719c3
	.quad	0xbfc0d77e7cd08e59
	.quad	0xbfc10f8e422539b1
	.quad	0xbfc14785846742ac
	.quad	0xbfc17f6458fca611
	.quad	0xbfc1b72ad52f67a0
	.quad	0xbfc1eed90e2dc2c3
	.quad	0xbfc2266f190a5acb
	.quad	0xbfc25ded0abc6ad2
	.quad	0xbfc29552f81ff523
	.quad	0xbfc2cca0f5f5f251
	.quad	0xbfc303d718e47fd3
	.quad	0xbfc33af575770e4f
	.quad	0xbfc371fc201e8f74
	.quad	0xbfc3a8eb2d31a376
	.quad	0xbfc3dfc2b0ecc62a
	.quad	0xbfc41682bf727bc0
	.quad	0xbfc44d2b6ccb7d1e
	.quad	0xbfc483bccce6e3dd
	.quad	0xbfc4ba36f39a55e5
	.quad	0xbfc4f099f4a230b2
	.quad	0xbfc526e5e3a1b438
	.quad	0xbfc55d1ad4232d6f
	.quad	0xbfc59338d9982086
	.quad	0xbfc5c940075972b9
	.quad	0xbfc5ff3070a793d4
	.quad	0xbfc6350a28aaa758
	.quad	0xbfc66acd4272ad51
	.quad	0xbfc6a079d0f7aad2
	.quad	0xbfc6d60fe719d21d
	.quad	0xbfc70b8f97a1aa75
	.quad	0xbfc740f8f54037a5
	.quad	0xbfc7764c128f2127
	.quad	0xbfc7ab890210d909
	.quad	0xbfc7e0afd630c274
	.quad	0xbfc815c0a14357eb
	.quad	0xbfc84abb75865139
	.quad	0xbfc87fa06520c911
	.quad	0xbfc8b46f8223625b
	.quad	0xbfc8e928de886d41
	.quad	0xbfc91dcc8c340bde
	.quad	0xbfc9525a9cf456b4
	.quad	0xbfc986d3228180ca
	.quad	0xbfc9bb362e7dfb83
	.quad	0xbfc9ef83d2769a34
	.quad	0xbfca23bc1fe2b563
	.quad	0xbfca57df28244dcd
	.quad	0xbfca8becfc882f19
	.quad	0xbfcabfe5ae46124c
	.quad	0xbfcaf3c94e80bff3
	.quad	0xbfcb2797ee46320c
	.quad	0xbfcb5b519e8fb5a4
	.quad	0xbfcb8ef670420c3b
	.quad	0xbfcbc286742d8cd6
	.quad	0xbfcbf601bb0e44e2
	.quad	0xbfcc2968558c18c1
	.quad	0xbfcc5cba543ae425
	.quad	0xbfcc8ff7c79a9a22
	.quad	0xbfccc320c0176502
	.quad	0xbfccf6354e09c5dc
	.quad	0xbfcd293581b6b3e7
	.quad	0xbfcd5c216b4fbb91
	.quad	0xbfcd8ef91af31d5e
	.quad	0xbfcdc1bca0abec7d
	.quad	0xbfcdf46c0c722d2f
	.quad	0xbfce27076e2af2e6
	.quad	0xbfce598ed5a87e2f
	.quad	0xbfce8c0252aa5a60
	.quad	0xbfcebe61f4dd7b0b
	.quad	0xbfcef0adcbdc5936
	.quad	0xbfcf22e5e72f105d
	.quad	0xbfcf550a564b7b37
	.quad	0xbfcf871b28955045
	.quad	0xbfcfb9186d5e3e2b
	.quad	0xbfcfeb0233e607cc
	.quad	0xbfd00e6c45ad501d
	.quad	0xbfd0274dc16c232f
	.quad	0xbfd0402594b4d041
	.quad	0xbfd058f3c703ebc6
	.quad	0xbfd071b85fcd590d
	.quad	0xbfd08a73667c57af
	.quad	0xbfd0a324e27390e3
	.quad	0xbfd0bbccdb0d24bd
	.quad	0xbfd0d46b579ab74b
	.quad	0xbfd0ed005f657da4
	.quad	0xbfd1058bf9ae4ad5
	.quad	0xbfd11e0e2dad9cb7
	.quad	0xbfd136870293a8b0
	.quad	0xbfd14ef67f88685a
	.quad	0xbfd1675cababa60e
	.quad	0xbfd17fb98e15095d
	.quad	0xbfd1980d2dd4236f
	.quad	0xbfd1b05791f07b49
	.quad	0xbfd1c898c16999fb
	.quad	0xbfd1e0d0c33716be
	.quad	0xbfd1f8ff9e48a2f3
	.quad	0xbfd211255986160c
	.quad	0xbfd22941fbcf7966
	.quad	0xbfd241558bfd1404
	.quad	0xbfd2596010df763a
	.quad	0xbfd27161913f853d
	.quad	0xbfd2895a13de86a3
	.quad	0xbfd2a1499f762bc9
	.quad	0xbfd2b9303ab89d25
	.quad	0xbfd2d10dec508583
	.quad	0xbfd2e8e2bae11d31
	.quad	0xbfd300aead06350c
	.quad	0xbfd31871c9544185
	.quad	0xbfd3302c16586588
	.quad	0xbfd347dd9a987d55
	.quad	0xbfd35f865c93293e
	.quad	0xbfd3772662bfd85b
	.quad	0xbfd38ebdb38ed321
	.quad	0xbfd3a64c556945ea
	.quad	0xbfd3bdd24eb14b6a
	.quad	0xbfd3d54fa5c1f710
	.quad	0xbfd3ecc460ef5f50
	.quad	0xbfd404308686a7e4
	.quad	0xbfd41b941cce0bee
	.quad	0xbfd432ef2a04e814
	.quad	0xbfd44a41b463c47c
	.quad	0xbfd4618bc21c5ec2
	.quad	0xbfd478cd5959b3d9
	.quad	0xbfd49006804009d1
	.quad	0xbfd4a7373cecf997
	.quad	0xbfd4be5f957778a1
	.quad	0xbfd4d57f8fefe27f
	.quad	0xbfd4ec973260026a
	.quad	0xbfd503a682cb1cb3
	.quad	0xbfd51aad872df82d
	.quad	0xbfd531ac457ee77e
	.quad	0xbfd548a2c3add263
	.quad	0xbfd55f9107a43ee2
	.quad	0xbfd5767717455a6c
	.quad	0xbfd58d54f86e02f2
	.quad	0xbfd5a42ab0f4cfe2
	.quad	0xbfd5baf846aa1b19
	.quad	0xbfd5d1bdbf5809ca
	.quad	0xbfd5e87b20c2954a
	.quad	0xbfd5ff3070a793d4
	.quad	0xbfd615ddb4bec13c
	.quad	0xbfd62c82f2b9c795
	.quad	0x3fd61965cdb02c1f
	.quad	0x3fd602d08af091ec
	.quad	0x3fd5ec433d5c35ae
	.quad	0x3fd5d5bddf595f30
	.quad	0x3fd5bf406b543db2
	.quad	0x3fd5a8cadbbedfa1
	.quad	0x3fd5925d2b112a59
	.quad	0x3fd57bf753c8d1fb
	.quad	0x3fd565995069514c
	.quad	0x3fd54f431b7be1a9
	.quad	0x3fd538f4af8f72fe
	.quad	0x3fd522ae0738a3d8
	.quad	0x3fd50c6f1d11b97c
	.quad	0x3fd4f637ebba9810
	.quad	0x3fd4e0086dd8baca
	.quad	0x3fd4c9e09e172c3c
	.quad	0x3fd4b3c077267e9a
	.quad	0x3fd49da7f3bcc41f
	.quad	0x3fd487970e958770
	.quad	0x3fd4718dc271c41b
	.quad	0x3fd45b8c0a17df13
	.quad	0x3fd44591e0539f49
	.quad	0x3fd42f9f3ff62642
	.quad	0x3fd419b423d5e8c7
	.quad	0x3fd403d086cea79c
	.quad	0x3fd3edf463c1683e
	.quad	0x3fd3d81fb5946dba
	.quad	0x3fd3c25277333184
	.quad	0x3fd3ac8ca38e5c5f
	.quad	0x3fd396ce359bbf54
	.quad	0x3fd3811728564cb2
	.quad	0x3fd36b6776be1117
	.quad	0x3fd355bf1bd82c8b
	.quad	0x3fd3401e12aecba1
	.quad	0x3fd32a84565120a8
	.quad	0x3fd314f1e1d35ce4
	.quad	0x3fd2ff66b04ea9d4
	.quad	0x3fd2e9e2bce12286
	.quad	0x3fd2d46602adccee
	.quad	0x3fd2bef07cdc9354
	.quad	0x3fd2a982269a3dbf
	.quad	0x3fd2941afb186b7c
	.quad	0x3fd27ebaf58d8c9d
	.quad	0x3fd269621134db92
	.quad	0x3fd25410494e56c7
	.quad	0x3fd23ec5991eba49
	.quad	0x3fd22981fbef797b
	.quad	0x3fd214456d0eb8d4
	.quad	0x3fd1ff0fe7cf47a7
	.quad	0x3fd1e9e1678899f4
	.quad	0x3fd1d4b9e796c245
	.quad	0x3fd1bf99635a6b95
	.quad	0x3fd1aa7fd638d33f
	.quad	0x3fd1956d3b9bc2fa
	.quad	0x3fd180618ef18adf
	.quad	0x3fd16b5ccbacfb73
	.quad	0x3fd1565eed455fc3
	.quad	0x3fd14167ef367783
	.quad	0x3fd12c77cd00713b
	.quad	0x3fd1178e8227e47c
	.quad	0x3fd102ac0a35cc1c
	.quad	0x3fd0edd060b78081
	.quad	0x3fd0d8fb813eb1ef
	.quad	0x3fd0c42d676162e3
	.quad	0x3fd0af660eb9e279
	.quad	0x3fd09aa572e6c6d4
	.quad	0x3fd085eb8f8ae797
	.quad	0x3fd07138604d5862
	.quad	0x3fd05c8be0d9635a
	.quad	0x3fd047e60cde83b8
	.quad	0x3fd03346e0106062
	.quad	0x3fd01eae5626c691
	.quad	0x3fd00a1c6adda473
	.quad	0x3fcfeb2233ea07cd
	.quad	0x3fcfc218be620a5e
	.quad	0x3fcf991c6cb3b379
	.quad	0x3fcf702d36777df0
	.quad	0x3fcf474b134df229
	.quad	0x3fcf1e75fadf9bde
	.quad	0x3fcef5ade4dcffe6
	.quad	0x3fceccf2c8fe920a
	.quad	0x3fcea4449f04aaf5
	.quad	0x3fce7ba35eb77e2a
	.quad	0x3fce530effe71012
	.quad	0x3fce2a877a6b2c12
	.quad	0x3fce020cc6235ab5
	.quad	0x3fcdd99edaf6d7e9
	.quad	0x3fcdb13db0d48940
	.quad	0x3fcd88e93fb2f450
	.quad	0x3fcd60a17f903515
	.quad	0x3fcd38666871f465
	.quad	0x3fcd1037f2655e7b
	.quad	0x3fcce816157f1988
	.quad	0x3fccc000c9db3c52
	.quad	0x3fcc97f8079d44ec
	.quad	0x3fcc6ffbc6f00f71
	.quad	0x3fcc480c0005ccd1
	.quad	0x3fcc2028ab17f9b4
	.quad	0x3fcbf851c067555f
	.quad	0x3fcbd087383bd8ad
	.quad	0x3fcba8c90ae4ad19
	.quad	0x3fcb811730b823d2
	.quad	0x3fcb5971a213acdb
	.quad	0x3fcb31d8575bce3d
	.quad	0x3fcb0a4b48fc1b46
	.quad	0x3fcae2ca6f672bd4
	.quad	0x3fcabb55c31693ad
	.quad	0x3fca93ed3c8ad9e3
	.quad	0x3fca6c90d44b704e
	.quad	0x3fca454082e6ab05
	.quad	0x3fca1dfc40f1b7f1
	.quad	0x3fc9f6c407089664
	.quad	0x3fc9cf97cdce0ec3
	.quad	0x3fc9a8778debaa38
	.quad	0x3fc981634011aa75
	.quad	0x3fc95a5adcf7017f
	.quad	0x3fc9335e5d594989
	.quad	0x3fc90c6db9fcbcd9
	.quad	0x3fc8e588ebac2dbf
	.quad	0x3fc8beafeb38fe8c
	.quad	0x3fc897e2b17b19a5
	.quad	0x3fc871213750e994
	.quad	0x3fc84a6b759f512f
	.quad	0x3fc823c16551a3c2
	.quad	0x3fc7fd22ff599d4f
	.quad	0x3fc7d6903caf5ad0
	.quad	0x3fc7b0091651528c
	.quad	0x3fc7898d85444c73
	.quad	0x3fc7631d82935a86
	.quad	0x3fc73cb9074fd14d
	.quad	0x3fc716600c914054
	.quad	0x3fc6f0128b756abc
	.quad	0x3fc6c9d07d203fc7
	.quad	0x3fc6a399dabbd383
	.quad	0x3fc67d6e9d785771
	.quad	0x3fc6574ebe8c133a
	.quad	0x3fc6313a37335d76
	.quad	0x3fc60b3100b09476
	.quad	0x3fc5e533144c1719
	.quad	0x3fc5bf406b543db2
	.quad	0x3fc59958ff1d52f1
	.quad	0x3fc5737cc9018cdd
	.quad	0x3fc54dabc26105d2
	.quad	0x3fc527e5e4a1b58d
	.quad	0x3fc5022b292f6a45
	.quad	0x3fc4dc7b897bc1c8
	.quad	0x3fc4b6d6fefe22a4
	.quad	0x3fc4913d8333b561
	.quad	0x3fc46baf0f9f5db7
	.quad	0x3fc4462b9dc9b3dc
	.quad	0x3fc420b32740fdd4
	.quad	0x3fc3fb45a59928cc
	.quad	0x3fc3d5e3126bc27f
	.quad	0x3fc3b08b6757f2a9
	.quad	0x3fc38b3e9e027479
	.quad	0x3fc365fcb0159016
	.quad	0x3fc340c59741142e
	.quad	0x3fc31b994d3a4f85
	.quad	0x3fc2f677cbbc0a96
	.quad	0x3fc2d1610c86813a
	.quad	0x3fc2ac55095f5c59
	.quad	0x3fc28753bc11aba5
	.quad	0x3fc2625d1e6ddf57
	.quad	0x3fc23d712a49c202
	.quad	0x3fc2188fd9807263
	.quad	0x3fc1f3b925f25d41
	.quad	0x3fc1ceed09853752
	.quad	0x3fc1aa2b7e23f72a
	.quad	0x3fc185747dbecf34
	.quad	0x3fc160c8024b27b1
	.quad	0x3fc13c2605c398c3
	.quad	0x3fc1178e8227e47c
	.quad	0x3fc0f301717cf0fb
	.quad	0x3fc0ce7ecdccc28d
	.quad	0x3fc0aa06912675d5
	.quad	0x3fc08598b59e3a07
	.quad	0x3fc06135354d4b18
	.quad	0x3fc03cdc0a51ec0d
	.quad	0x3fc0188d2ecf6140
	.quad	0x3fbfe89139dbd566
	.quad	0x3fbfa01c9db57ce2
	.quad	0x3fbf57bc7d9005db
	.quad	0x3fbf0f70cdd992e3
	.quad	0x3fbec739830a1120
	.quad	0x3fbe7f1691a32d3e
	.quad	0x3fbe3707ee30487b
	.quad	0x3fbdef0d8d466db9
	.quad	0x3fbda727638446a2
	.quad	0x3fbd5f55659210e2
	.quad	0x3fbd179788219364
	.quad	0x3fbccfedbfee13a8
	.quad	0x3fbc885801bc4b23
	.quad	0x3fbc40d6425a5cb1
	.quad	0x3fbbf968769fca11
	.quad	0x3fbbb20e936d6974
	.quad	0x3fbb6ac88dad5b1c
	.quad	0x3fbb23965a52ff00
	.quad	0x3fbadc77ee5aea8c
	.quad	0x3fba956d3ecade63
	.quad	0x3fba4e7640b1bc38
	.quad	0x3fba0792e9277cac
	.quad	0x3fb9c0c32d4d2548
	.quad	0x3fb97a07024cbe74
	.quad	0x3fb9335e5d594989
	.quad	0x3fb8ecc933aeb6e8
	.quad	0x3fb8a6477a91dc29
	.quad	0x3fb85fd927506a48
	.quad	0x3fb8197e2f40e3f0
	.quad	0x3fb7d33687c293c9
	.quad	0x3fb78d02263d82d3
	.quad	0x3fb746e100226ed9
	.quad	0x3fb700d30aeac0e1
	.quad	0x3fb6bad83c1883b6
	.quad	0x3fb674f089365a7a
	.quad	0x3fb62f1be7d77743
	.quad	0x3fb5e95a4d9791cb
	.quad	0x3fb5a3abb01ade25
	.quad	0x3fb55e10050e0384
	.quad	0x3fb518874226130a
	.quad	0x3fb4d3115d207eac
	.quad	0x3fb48dae4bc31018
	.quad	0x3fb4485e03dbdfad
	.quad	0x3fb403207b414b7f
	.quad	0x3fb3bdf5a7d1ee64
	.quad	0x3fb378dd7f749714
	.quad	0x3fb333d7f8183f4b
	.quad	0x3fb2eee507b40301
	.quad	0x3fb2aa04a44717a5
	.quad	0x3fb26536c3d8c369
	.quad	0x3fb2207b5c78549e
	.quad	0x3fb1dbd2643d190b
	.quad	0x3fb1973bd1465567
	.quad	0x3fb152b799bb3cc9
	.quad	0x3fb10e45b3cae831
	.quad	0x3fb0c9e615ac4e17
	.quad	0x3fb08598b59e3a07
	.quad	0x3fb0415d89e74444
	.quad	0x3faffa6911ab9301
	.quad	0x3faf723b517fc523
	.quad	0x3faeea31c006b87c
	.quad	0x3fae624c4a0b5e1b
	.quad	0x3fadda8adc67ee4e
	.quad	0x3fad52ed6405d86f
	.quad	0x3faccb73cdddb2cc
	.quad	0x3fac441e06f72a9e
	.quad	0x3fabbcebfc68f420
	.quad	0x3fab35dd9b58baad
	.quad	0x3faaaef2d0fb10fc
	.quad	0x3faa282b8a936171
	.quad	0x3fa9a187b573de7c
	.quad	0x3fa91b073efd7314
	.quad	0x3fa894aa149fb343
	.quad	0x3fa80e7023d8ccc4
	.quad	0x3fa788595a3577ba
	.quad	0x3fa70265a550e777
	.quad	0x3fa67c94f2d4bb58
	.quad	0x3fa5f6e73078efb8
	.quad	0x3fa5715c4c03ceef
	.quad	0x3fa4ebf43349e26f
	.quad	0x3fa466aed42de3ea
	.quad	0x3fa3e18c1ca0ae92
	.quad	0x3fa35c8bfaa1306b
	.quad	0x3fa2d7ae5c3c5bae
	.quad	0x3fa252f32f8d183f
	.quad	0x3fa1ce5a62bc353a
	.quad	0x3fa149e3e4005a8d
	.quad	0x3fa0c58fa19dfaaa
	.quad	0x3fa0415d89e74444
	.quad	0x3f9f7a9b16782856
	.quad	0x3f9e72bf2813ce51
	.quad	0x3f9d6b2725979802
	.quad	0x3f9c63d2ec14aaf2
	.quad	0x3f9b5cc258b718e6
	.quad	0x3f9a55f548c5c43f
	.quad	0x3f994f6b99a24475
	.quad	0x3f98492528c8cabf
	.quad	0x3f974321d3d006d3
	.quad	0x3f963d6178690bd6
	.quad	0x3f9537e3f45f3565
	.quad	0x3f9432a925980cc1
	.quad	0x3f932db0ea132e22
	.quad	0x3f9228fb1fea2e28
	.quad	0x3f912487a5507f70
	.quad	0x3f90205658935847
	.quad	0x3f8e38ce3033310c
	.quad	0x3f8c317384c75f06
	.quad	0x3f8a2a9c6c170462
	.quad	0x3f882448a388a2aa
	.quad	0x3f861e77e8b53fc6
	.quad	0x3f841929f96832f0
	.quad	0x3f82145e939ef1e9
	.quad	0x3f8010157588de71
	.quad	0x3f7c189cbb0e27fb
	.quad	0x3f78121214586b54
	.quad	0x3f740c8a747878e2
	.quad	0x3f70080559588b35
	.quad	0x3f680904828985c0
	.quad	0x3f60040155d5889e
	.quad	0x3f50020055655889
	.quad	0x0000000000000000
	.rept	56
	.byte	0
	.endr

/* Polynomial coefficients for log part:
 * coeff4 */
double_vector _poly_coeff_1 0x3fc9999cacdb4d0a

/* coeff3 */
double_vector _poly_coeff_2 0xbfd0000148058ee1

/* coeff2 */
double_vector _poly_coeff_3 0x3fd55555555543c5

/* coeff1 */
double_vector _poly_coeff_4 0xbfdffffffffff81f

/* General purpose constants for log part: ExpMask */
double_vector _ExpMask 0x000fffffffffffff

/* Two10 */
double_vector _Two10 0x3f50000000000000

/* MinNorm */
double_vector _MinNorm 0x0010000000000000

/* MaxNorm */
double_vector _MaxNorm 0x7fefffffffffffff

/* HalfMask */
double_vector _HalfMask 0xfffffffffc000000

/* One */
double_vector _One 0x3ff0000000000000

/* L2H */
double_vector _L2H 0x3fe62e42fefa0000

/* L2L */
double_vector _L2L 0x3d7cf79abc9e0000

/* Threshold */
double_vector _Threshold 0x4086a00000000000

/* Bias */
double_vector _Bias 0x408ff80000000000

/* Bias1 */
double_vector _Bias1 0x408ff00000000000

/* L2L */
double_vector _L2 0x3fe62e42fefa39ef

/* dInfs = DP infinity, +/- == */
.if .-__svml_spow_data != _dInfs
.err
.endif
	.quad	0x7ff0000000000000
	.quad	0xfff0000000000000
	.rept	48
	.byte	0
	.endr

/* dOnes = DP one, +/- == */
.if .-__svml_spow_data != _dOnes
.err
.endif
	.quad	0x3ff0000000000000
	.quad	0xbff0000000000000
	.rept	48
	.byte	0
	.endr

/* dZeros = DP zero +/- == */
.if .-__svml_spow_data != _dZeros
.err
.endif
	.quad	0x0000000000000000
	.quad	0x8000000000000000
	.rept	48
	.byte	0
	.endr
.if .-__svml_spow_data != __dbT
.err
.endif
	.quad	0x3feffffffc27dd9e
	.quad	0x3ff00162f1a4047d
	.quad	0x3ff002c603f68252
	.quad	0x3ff00429350e12af
	.quad	0x3ff0058c84ed6032
	.quad	0x3ff006eff39715b2
	.quad	0x3ff00853810dde41
	.quad	0x3ff009b72d54652f
	.quad	0x3ff00b1af86d5604
	.quad	0x3ff00c7ee25b5c86
	.quad	0x3ff00de2eb2124b3
	.quad	0x3ff00f4712c15ac8
	.quad	0x3ff010ab593eab39
	.quad	0x3ff0120fbe9bc2ba
	.quad	0x3ff0137442db4e38
	.quad	0x3ff014d8e5fffada
	.quad	0x3ff0163da80c7604
	.quad	0x3ff017a289036d56
	.quad	0x3ff0190788e78eab
	.quad	0x3ff01a6ca7bb8818
	.quad	0x3ff01bd1e58207ef
	.quad	0x3ff01d37423dbcbc
	.quad	0x3ff01e9cbdf15549
	.quad	0x3ff02002589f8099
	.quad	0x3ff02168124aedec
	.quad	0x3ff022cdeaf64cbc
	.quad	0x3ff02433e2a44cc1
	.quad	0x3ff02599f9579ded
	.quad	0x3ff027002f12f06d
	.quad	0x3ff0286683d8f4ac
	.quad	0x3ff029ccf7ac5b4d
	.quad	0x3ff02b338a8fd532
	.quad	0x3ff02c9a3c861379
	.quad	0x3ff02e010d91c778
	.quad	0x3ff02f67fdb5a2c4
	.quad	0x3ff030cf0cf4572d
	.quad	0x3ff032363b5096bc
	.quad	0x3ff0339d88cd13bc
	.quad	0x3ff03504f56c80ae
	.quad	0x3ff0366c81319053
	.quad	0x3ff037d42c1ef5a2
	.quad	0x3ff0393bf63763d5
	.quad	0x3ff03aa3df7d8e5f
	.quad	0x3ff03c0be7f428eb
	.quad	0x3ff03d740f9de766
	.quad	0x3ff03edc567d7df7
	.quad	0x3ff04044bc95a0fe
	.quad	0x3ff041ad41e9051d
	.quad	0x3ff04315e67a5f2a
	.quad	0x3ff0447eaa4c643e
	.quad	0x3ff045e78d61c9ac
	.quad	0x3ff047508fbd4502
	.quad	0x3ff048b9b1618c0b
	.quad	0x3ff04a22f25154cd
	.quad	0x3ff04b8c528f558b
	.quad	0x3ff04cf5d21e44c4
	.quad	0x3ff04e5f7100d935
	.quad	0x3ff04fc92f39c9d4
	.quad	0x3ff051330ccbcdd5
	.quad	0x3ff0529d09b99ca8
	.quad	0x3ff054072605edfb
	.quad	0x3ff0557161b379b3
	.quad	0x3ff056dbbcc4f7f8
	.quad	0x3ff05846373d212a
	.quad	0x3ff059b0d11eade5
	.quad	0x3ff05b1b8a6c5706
	.quad	0x3ff05c866328d5a2
	.quad	0x3ff05df15b56e30a
	.quad	0x3ff05f5c72f938cf
	.quad	0x3ff060c7aa1290bd
	.quad	0x3ff0623300a5a4db
	.quad	0x3ff0639e76b52f6e
	.quad	0x3ff0650a0c43eaf6
	.quad	0x3ff06675c1549232
	.quad	0x3ff067e195e9e01a
	.quad	0x3ff0694d8a068fe7
	.quad	0x3ff06ab99dad5d0c
	.quad	0x3ff06c25d0e10338
	.quad	0x3ff06d9223a43e58
	.quad	0x3ff06efe95f9ca95
	.quad	0x3ff0706b27e46455
	.quad	0x3ff071d7d966c83a
	.quad	0x3ff07344aa83b324
	.quad	0x3ff074b19b3de22f
	.quad	0x3ff0761eab9812b4
	.quad	0x3ff0778bdb950247
	.quad	0x3ff078f92b376ebc
	.quad	0x3ff07a669a821621
	.quad	0x3ff07bd42977b6c4
	.quad	0x3ff07d41d81b0f2b
	.quad	0x3ff07eafa66ede1e
	.quad	0x3ff0801d9475e2a0
	.quad	0x3ff0818ba232dbee
	.quad	0x3ff082f9cfa88985
	.quad	0x3ff084681cd9ab21
	.quad	0x3ff085d689c900b6
	.quad	0x3ff0874516794a79
	.quad	0x3ff088b3c2ed48d9
	.quad	0x3ff08a228f27bc86
	.quad	0x3ff08b917b2b6667
	.quad	0x3ff08d0086fb07a6
	.quad	0x3ff08e6fb29961a8
	.quad	0x3ff08fdefe09360d
	.quad	0x3ff0914e694d46b6
	.quad	0x3ff092bdf46855c0
	.quad	0x3ff0942d9f5d2582
	.quad	0x3ff0959d6a2e7893
	.quad	0x3ff0970d54df11c8
	.quad	0x3ff0987d5f71b432
	.quad	0x3ff099ed89e9231e
	.quad	0x3ff09b5dd448221a
	.quad	0x3ff09cce3e9174ec
	.quad	0x3ff09e3ec8c7df9d
	.quad	0x3ff09faf72ee2670
	.quad	0x3ff0a1203d070de5
	.quad	0x3ff0a29127155abd
	.quad	0x3ff0a402311bd1f0
	.quad	0x3ff0a5735b1d38bb
	.quad	0x3ff0a6e4a51c5493
	.quad	0x3ff0a8560f1beb2c
	.quad	0x3ff0a9c7991ec278
	.quad	0x3ff0ab394327a0a7
	.quad	0x3ff0acab0d394c25
	.quad	0x3ff0ae1cf7568b9d
	.quad	0x3ff0af8f018225f7
	.quad	0x3ff0b1012bbee259
	.quad	0x3ff0b273760f8825
	.quad	0x3ff0b3e5e076defc
	.quad	0x3ff0b5586af7aebc
	.quad	0x3ff0b6cb1594bf84
	.quad	0x3ff0b83de050d9ab
	.quad	0x3ff0b9b0cb2ec5ca
	.quad	0x3ff0bb23d6314cb7
	.quad	0x3ff0bc97015b3783
	.quad	0x3ff0be0a4caf4f81
	.quad	0x3ff0bf7db8305e3f
	.quad	0x3ff0c0f143e12d8a
	.quad	0x3ff0c264efc4876c
	.quad	0x3ff0c3d8bbdd362e
	.quad	0x3ff0c54ca82e0455
	.quad	0x3ff0c6c0b4b9bca6
	.quad	0x3ff0c834e1832a24
	.quad	0x3ff0c9a92e8d180e
	.quad	0x3ff0cb1d9bda51e1
	.quad	0x3ff0cc92296da35b
	.quad	0x3ff0ce06d749d876
	.quad	0x3ff0cf7ba571bd6a
	.quad	0x3ff0d0f093e81eab
	.quad	0x3ff0d265a2afc8f1
	.quad	0x3ff0d3dad1cb892b
	.quad	0x3ff0d550213e2c8c
	.quad	0x3ff0d6c5910a8081
	.quad	0x3ff0d83b213352b8
	.quad	0x3ff0d9b0d1bb711b
	.quad	0x3ff0db26a2a5a9d4
	.quad	0x3ff0dc9c93f4cb4a
	.quad	0x3ff0de12a5aba423
	.quad	0x3ff0df88d7cd0344
	.quad	0x3ff0e0ff2a5bb7cd
	.quad	0x3ff0e2759d5a9121
	.quad	0x3ff0e3ec30cc5edd
	.quad	0x3ff0e562e4b3f0df
	.quad	0x3ff0e6d9b9141745
	.quad	0x3ff0e850adefa265
	.quad	0x3ff0e9c7c34962db
	.quad	0x3ff0eb3ef924297d
	.quad	0x3ff0ecb64f82c75e
	.quad	0x3ff0ee2dc6680dd6
	.quad	0x3ff0efa55dd6ce75
	.quad	0x3ff0f11d15d1db0c
	.quad	0x3ff0f294ee5c05ab
	.quad	0x3ff0f40ce77820a2
	.quad	0x3ff0f5850128fe7a
	.quad	0x3ff0f6fd3b717200
	.quad	0x3ff0f87596544e3f
	.quad	0x3ff0f9ee11d4667f
	.quad	0x3ff0fb66adf48e46
	.quad	0x3ff0fcdf6ab7995c
	.quad	0x3ff0fe5848205bc4
	.quad	0x3ff0ffd14631a9c2
	.quad	0x3ff1014a64ee57d9
	.quad	0x3ff102c3a4593ac9
	.quad	0x3ff1043d04752792
	.quad	0x3ff105b68544f373
	.quad	0x3ff1073026cb73e9
	.quad	0x3ff108a9e90b7eb2
	.quad	0x3ff10a23cc07e9c6
	.quad	0x3ff10b9dcfc38b63
	.quad	0x3ff10d17f44139fe
	.quad	0x3ff10e923983cc53
	.quad	0x3ff1100c9f8e1955
	.quad	0x3ff111872662f83e
	.quad	0x3ff11301ce054081
	.quad	0x3ff1147c9677c9d2
	.quad	0x3ff115f77fbd6c23
	.quad	0x3ff1177289d8ffa9
	.quad	0x3ff118edb4cd5cd4
	.quad	0x3ff11a69009d5c54
	.quad	0x3ff11be46d4bd71a
	.quad	0x3ff11d5ffadba653
	.quad	0x3ff11edba94fa36e
	.quad	0x3ff1205778aaa817
	.quad	0x3ff121d368ef8e3b
	.quad	0x3ff1234f7a213008
	.quad	0x3ff124cbac4267e5
	.quad	0x3ff12647ff56107f
	.quad	0x3ff127c4735f04bd
	.quad	0x3ff1294108601fcb
	.quad	0x3ff12abdbe5c3d0f
	.quad	0x3ff12c3a95563832
	.quad	0x3ff12db78d50ed19
	.quad	0x3ff12f34a64f37ed
	.quad	0x3ff130b1e053f513
	.quad	0x3ff1322f3b62012e
	.quad	0x3ff133acb77c3927
	.quad	0x3ff1352a54a57a1f
	.quad	0x3ff136a812e0a17c
	.quad	0x3ff13825f2308ce0
	.quad	0x3ff139a3f2981a2e
	.quad	0x3ff13b22141a278a
	.quad	0x3ff13ca056b99356
	.quad	0x3ff13e1eba793c33
	.quad	0x3ff13f9d3f5c0103
	.quad	0x3ff1411be564c0e7
	.quad	0x3ff1429aac965b40
	.quad	0x3ff1441994f3afae
	.quad	0x3ff145989e7f9e13
	.quad	0x3ff14717c93d068e
	.quad	0x3ff14897152ec980
	.quad	0x3ff14a168257c787
	.quad	0x3ff14b9610bae185
	.quad	0x3ff14d15c05af897
	.quad	0x3ff14e95913aee1e
	.quad	0x3ff15015835da3b8
	.quad	0x3ff1519596c5fb46
	.quad	0x3ff15315cb76d6e5
	.quad	0x3ff15496217318f6
	.quad	0x3ff1561698bda417
	.quad	0x3ff1579731595b27
	.quad	0x3ff15917eb492145
	.quad	0x3ff15a98c68fd9d1
	.quad	0x3ff15c19c330686b
	.quad	0x3ff15d9ae12db0ef
	.quad	0x3ff15f1c208a977f
	.quad	0x3ff1609d814a007b
	.quad	0x3ff1621f036ed081
	.quad	0x3ff163a0a6fbec71
	.quad	0x3ff165226bf4396d
	.quad	0x3ff166a4525a9cd3
	.quad	0x3ff168265a31fc44
	.quad	0x3ff169a8837d3da3
	.quad	0x3ff16b2ace3f4710
	.quad	0x3ff16cad3a7afeeb
	.quad	0x3ff16e2fc8334bd8
	.quad	0x3ff16fb2776b14b8
	.quad	0x3ff17135482540ad
	.quad	0x3ff172b83a64b71a
	.quad	0x3ff1743b4e2c5fa4
	.quad	0x3ff175be837f222d
	.quad	0x3ff17741da5fe6da
	.quad	0x3ff178c552d1960f
	.quad	0x3ff17a48ecd71873
	.quad	0x3ff17bcca87356e9
	.quad	0x3ff17d5085a93a9b
	.quad	0x3ff17ed4847bacec
	.quad	0x3ff18058a4ed9787
	.quad	0x3ff181dce701e451
	.quad	0x3ff183614abb7d75
	.quad	0x3ff184e5d01d4d5b
	.quad	0x3ff1866a772a3ead
	.quad	0x3ff187ef3fe53c58
	.quad	0x3ff189742a513185
	.quad	0x3ff18af9367109a1
	.quad	0x3ff18c7e6447b059
	.quad	0x3ff18e03b3d8119c
	.quad	0x3ff18f8925251997
	.quad	0x3ff1910eb831b4ba
	.quad	0x3ff192946d00cfb6
	.quad	0x3ff1941a4395577c
	.quad	0x3ff195a03bf2393e
	.quad	0x3ff19726561a626d
	.quad	0x3ff198ac9210c0c1
	.quad	0x3ff19a32efd8422c
	.quad	0x3ff19bb96f73d4e5
	.quad	0x3ff19d4010e66763
	.quad	0x3ff19ec6d432e85c
	.quad	0x3ff1a04db95c46cc
	.quad	0x3ff1a1d4c06571ed
	.quad	0x3ff1a35be9515937
	.quad	0x3ff1a4e33422ec69
	.quad	0x3ff1a66aa0dd1b81
	.quad	0x3ff1a7f22f82d6bc
	.quad	0x3ff1a979e0170e9a
	.quad	0x3ff1ab01b29cb3dd
	.quad	0x3ff1ac89a716b786
	.quad	0x3ff1ae11bd880ada
	.quad	0x3ff1af99f5f39f5d
	.quad	0x3ff1b122505c66d5
	.quad	0x3ff1b2aaccc5534b
	.quad	0x3ff1b4336b315705
	.quad	0x3ff1b5bc2ba3648e
	.quad	0x3ff1b7450e1e6eb3
	.quad	0x3ff1b8ce12a56880
	.quad	0x3ff1ba57393b4544
	.quad	0x3ff1bbe081e2f88e
	.quad	0x3ff1bd69ec9f762f
	.quad	0x3ff1bef37973b23b
	.quad	0x3ff1c07d2862a105
	.quad	0x3ff1c206f96f3724
	.quad	0x3ff1c390ec9c696f
	.quad	0x3ff1c51b01ed2cfe
	.quad	0x3ff1c6a53964772e
	.quad	0x3ff1c82f93053d99
	.quad	0x3ff1c9ba0ed2761e
	.quad	0x3ff1cb44accf16dc
	.quad	0x3ff1cccf6cfe1634
	.quad	0x3ff1ce5a4f626acb
	.quad	0x3ff1cfe553ff0b83
	.quad	0x3ff1d1707ad6ef85
	.quad	0x3ff1d2fbc3ed0e37
	.quad	0x3ff1d4872f445f44
	.quad	0x3ff1d612bcdfda99
	.quad	0x3ff1d79e6cc27863
	.quad	0x3ff1d92a3eef3111
	.quad	0x3ff1dab63368fd56
	.quad	0x3ff1dc424a32d624
	.quad	0x3ff1ddce834fb4b0
	.quad	0x3ff1df5adec29273
	.quad	0x3ff1e0e75c8e6927
	.quad	0x3ff1e273fcb632c5
	.quad	0x3ff1e400bf3ce98b
	.quad	0x3ff1e58da42587fa
	.quad	0x3ff1e71aab7308d1
	.quad	0x3ff1e8a7d5286717
	.quad	0x3ff1ea3521489e0e
	.quad	0x3ff1ebc28fd6a942
	.quad	0x3ff1ed5020d5847a
	.quad	0x3ff1eeddd4482bc3
	.quad	0x3ff1f06baa319b6b
	.quad	0x3ff1f1f9a294d004
	.quad	0x3ff1f387bd74c660
	.quad	0x3ff1f515fad47b95
	.quad	0x3ff1f6a45ab6ecfa
	.quad	0x3ff1f832dd1f1829
	.quad	0x3ff1f9c1820ffafe
	.quad	0x3ff1fb50498c9397
	.quad	0x3ff1fcdf3397e057
	.quad	0x3ff1fe6e4034dfdf
	.quad	0x3ff1fffd6f669115
	.quad	0x3ff2018cc12ff324
	.quad	0x3ff2031c35940574
	.quad	0x3ff204abcc95c7b4
	.quad	0x3ff2063b863839d2
	.quad	0x3ff207cb627e5c01
	.quad	0x3ff2095b616b2eb7
	.quad	0x3ff20aeb8301b2aa
	.quad	0x3ff20c7bc744e8d5
	.quad	0x3ff20e0c2e37d274
	.quad	0x3ff20f9cb7dd7108
	.quad	0x3ff2112d6438c651
	.quad	0x3ff212be334cd455
	.quad	0x3ff2144f251c9d5b
	.quad	0x3ff215e039ab23ee
	.quad	0x3ff2177170fb6adb
	.quad	0x3ff21902cb107531
	.quad	0x3ff21a9447ed4643
	.quad	0x3ff21c25e794e1a7
	.quad	0x3ff21db7aa0a4b34
	.quad	0x3ff21f498f508707
	.quad	0x3ff220db976a997e
	.quad	0x3ff2226dc25b8739
	.quad	0x3ff224001026551c
	.quad	0x3ff2259280ce084e
	.quad	0x3ff227251455a63b
	.quad	0x3ff228b7cac0348e
	.quad	0x3ff22a4aa410b938
	.quad	0x3ff22bdda04a3a6b
	.quad	0x3ff22d70bf6fbea0
	.quad	0x3ff22f0401844c8d
	.quad	0x3ff23097668aeb31
	.quad	0x3ff2322aee86a1ca
	.quad	0x3ff233be997a77db
	.quad	0x3ff235526769752b
	.quad	0x3ff236e65856a1c4
	.quad	0x3ff2387a6c4505ef
	.quad	0x3ff23a0ea337aa40
	.quad	0x3ff23ba2fd319789
	.quad	0x3ff23d377a35d6de
	.quad	0x3ff23ecc1a47719b
	.quad	0x3ff24060dd69715c
	.quad	0x3ff241f5c39ee002
	.quad	0x3ff2438acceac7b2
	.quad	0x3ff2451ff95032d1
	.quad	0x3ff246b548d22c0c
	.quad	0x3ff2484abb73be50
	.quad	0x3ff249e05137f4cf
	.quad	0x3ff24b760a21daff
	.quad	0x3ff24d0be6347c98
	.quad	0x3ff24ea1e572e597
	.quad	0x3ff2503807e0223a
	.quad	0x3ff251ce4d7f3f08
	.quad	0x3ff25364b65348c6
	.quad	0x3ff254fb425f4c80
	.quad	0x3ff25691f1a65784
	.quad	0x3ff25828c42b7763
	.quad	0x3ff259bfb9f1b9f7
	.quad	0x3ff25b56d2fc2d55
	.quad	0x3ff25cee0f4ddfdd
	.quad	0x3ff25e856ee9e031
	.quad	0x3ff2601cf1d33d35
	.quad	0x3ff261b4980d0613
	.quad	0x3ff2634c619a4a36
	.quad	0x3ff264e44e7e1952
	.quad	0x3ff2667c5ebb8358
	.quad	0x3ff2681492559883
	.quad	0x3ff269ace94f694f
	.quad	0x3ff26b4563ac067d
	.quad	0x3ff26cde016e8111
	.quad	0x3ff26e76c299ea53
	.quad	0x3ff2700fa73153d1
	.quad	0x3ff271a8af37cf5b
	.quad	0x3ff27341dab06f07
	.quad	0x3ff274db299e452c
	.quad	0x3ff276749c046468
	.quad	0x3ff2780e31e5df9c
	.quad	0x3ff279a7eb45c9ef
	.quad	0x3ff27b41c82736c8
	.quad	0x3ff27cdbc88d39d8
	.quad	0x3ff27e75ec7ae70f
	.quad	0x3ff2801033f352a4
	.quad	0x3ff281aa9ef99111
	.quad	0x3ff283452d90b716
	.quad	0x3ff284dfdfbbd9b7
	.quad	0x3ff2867ab57e0e3a
	.quad	0x3ff28815aeda6a2d
	.quad	0x3ff289b0cbd4035f
	.quad	0x3ff28b4c0c6defe6
	.quad	0x3ff28ce770ab461b
	.quad	0x3ff28e82f88f1c9e
	.quad	0x3ff2901ea41c8a50
	.quad	0x3ff291ba7356a657
	.quad	0x3ff2935666408820
	.quad	0x3ff294f27cdd475a
	.quad	0x3ff2968eb72ffbfc
	.quad	0x3ff2982b153bbe3d
	.quad	0x3ff299c79703a69e
	.quad	0x3ff29b643c8acdde
	.quad	0x3ff29d0105d44d08
	.quad	0x3ff29e9df2e33d66
	.quad	0x3ff2a03b03bab88b
	.quad	0x3ff2a1d8385dd84a
	.quad	0x3ff2a37590cfb6bf
	.quad	0x3ff2a5130d136e49
	.quad	0x3ff2a6b0ad2c198d
	.quad	0x3ff2a84e711cd374
	.quad	0x3ff2a9ec58e8b729
	.quad	0x3ff2ab8a6492e024
	.quad	0x3ff2ad28941e6a18
	.quad	0x3ff2aec6e78e7104
	.quad	0x3ff2b0655ee61129
	.quad	0x3ff2b203fa28670e
	.quad	0x3ff2b3a2b9588f7f
	.quad	0x3ff2b5419c79a78c
	.quad	0x3ff2b6e0a38ecc8b
	.quad	0x3ff2b87fce9b1c18
	.quad	0x3ff2ba1f1da1b412
	.quad	0x3ff2bbbe90a5b29e
	.quad	0x3ff2bd5e27aa3627
	.quad	0x3ff2befde2b25d5c
	.quad	0x3ff2c09dc1c14733
	.quad	0x3ff2c23dc4da12e4
	.quad	0x3ff2c3ddebffdff0
	.quad	0x3ff2c57e3735ce1a
	.quad	0x3ff2c71ea67efd6d
	.quad	0x3ff2c8bf39de8e38
	.quad	0x3ff2ca5ff157a10f
	.quad	0x3ff2cc00cced56cd
	.quad	0x3ff2cda1cca2d08f
	.quad	0x3ff2cf42f07b2fbd
	.quad	0x3ff2d0e4387995fe
	.quad	0x3ff2d285a4a12544
	.quad	0x3ff2d42734f4ffc3
	.quad	0x3ff2d5c8e97847f6
	.quad	0x3ff2d76ac22e209d
	.quad	0x3ff2d90cbf19acbd
	.quad	0x3ff2daaee03e0fa3
	.quad	0x3ff2dc51259e6ce0
	.quad	0x3ff2ddf38f3de848
	.quad	0x3ff2df961d1fa5f9
	.quad	0x3ff2e138cf46ca57
	.quad	0x3ff2e2dba5b67a06
	.quad	0x3ff2e47ea071d9f4
	.quad	0x3ff2e621bf7c0f57
	.quad	0x3ff2e7c502d83fa4
	.quad	0x3ff2e9686a89909e
	.quad	0x3ff2eb0bf6932845
	.quad	0x3ff2ecafa6f82ce7
	.quad	0x3ff2ee537bbbc512
	.quad	0x3ff2eff774e1179d
	.quad	0x3ff2f19b926b4ba5
	.quad	0x3ff2f33fd45d888a
	.quad	0x3ff2f4e43abaf5f5
	.quad	0x3ff2f688c586bbd5
	.quad	0x3ff2f82d74c4025c
	.quad	0x3ff2f9d24875f205
	.quad	0x3ff2fb77409fb390
	.quad	0x3ff2fd1c5d447003
	.quad	0x3ff2fec19e6750ab
	.quad	0x3ff30067040b7f19
	.quad	0x3ff3020c8e342527
	.quad	0x3ff303b23ce46cf4
	.quad	0x3ff30558101f80e3
	.quad	0x3ff306fe07e88ba0
	.quad	0x3ff308a42442b81d
	.quad	0x3ff30a4a65313191
	.quad	0x3ff30bf0cab7237a
	.quad	0x3ff30d9754d7b99d
	.quad	0x3ff30f3e03962005
	.quad	0x3ff310e4d6f58302
	.quad	0x3ff3128bcef90f2b
	.quad	0x3ff31432eba3f15f
	.quad	0x3ff315da2cf956c2
	.quad	0x3ff3178192fc6cbf
	.quad	0x3ff319291db06106
	.quad	0x3ff31ad0cd186190
	.quad	0x3ff31c78a1379c9b
	.quad	0x3ff31e209a1140ab
	.quad	0x3ff31fc8b7a87c8c
	.quad	0x3ff32170fa007f51
	.quad	0x3ff32319611c7851
	.quad	0x3ff324c1ecff972d
	.quad	0x3ff3266a9dad0bca
	.quad	0x3ff3281373280654
	.quad	0x3ff329bc6d73b741
	.quad	0x3ff32b658c934f48
	.quad	0x3ff32d0ed089ff6c
	.quad	0x3ff32eb8395af8f4
	.quad	0x3ff33061c7096d6f
	.quad	0x3ff3320b79988eb2
	.quad	0x3ff333b5510b8eda
	.quad	0x3ff3355f4d65a04a
	.quad	0x3ff337096ea9f5ab
	.quad	0x3ff338b3b4dbc1f0
	.quad	0x3ff33a5e1ffe384f
	.quad	0x3ff33c08b0148c49
	.quad	0x3ff33db36521f1a3
	.quad	0x3ff33f5e3f299c69
	.quad	0x3ff341093e2ec0f2
	.quad	0x3ff342b4623493d7
	.quad	0x3ff3445fab3e49fa
	.quad	0x3ff3460b194f1887
	.quad	0x3ff347b6ac6a34ec
	.quad	0x3ff349626492d4e2
	.quad	0x3ff34b0e41cc2e67
	.quad	0x3ff34cba441977c4
	.quad	0x3ff34e666b7de784
	.quad	0x3ff35012b7fcb47d
	.quad	0x3ff351bf299915c9
	.quad	0x3ff3536bc05642cf
	.quad	0x3ff355187c377337
	.quad	0x3ff356c55d3fdef4
	.quad	0x3ff358726372be40
	.quad	0x3ff35a1f8ed3499b
	.quad	0x3ff35bccdf64b9cf
	.quad	0x3ff35d7a552a47ea
	.quad	0x3ff35f27f0272d45
	.quad	0x3ff360d5b05ea37f
	.quad	0x3ff3628395d3e47d
	.quad	0x3ff36431a08a2a6f
	.quad	0x3ff365dfd084afc9
	.quad	0x3ff3678e25c6af48
	.quad	0x3ff3693ca05363f3
	.quad	0x3ff36aeb402e0915
	.quad	0x3ff36c9a0559da43
	.quad	0x3ff36e48efda1358
	.quad	0x3ff36ff7ffb1f078
	.quad	0x3ff371a734e4ae11
	.quad	0x3ff373568f7588d3
	.quad	0x3ff375060f67bdb9
	.quad	0x3ff376b5b4be8a0a
	.quad	0x3ff378657f7d2b4c
	.quad	0x3ff37a156fa6df54
	.quad	0x3ff37bc5853ee43d
	.quad	0x3ff37d75c0487869
	.quad	0x3ff37f2620c6da82
	.quad	0x3ff380d6a6bd497c
	.quad	0x3ff38287522f048e
	.quad	0x3ff38438231f4b3f
	.quad	0x3ff385e919915d57
	.quad	0x3ff3879a35887ae9
	.quad	0x3ff3894b7707e450
	.quad	0x3ff38afcde12da2f
	.quad	0x3ff38cae6aac9d71
	.quad	0x3ff38e601cd86f48
	.quad	0x3ff39011f4999132
	.quad	0x3ff391c3f1f344f1
	.quad	0x3ff3937614e8cc90
	.quad	0x3ff395285d7d6a65
	.quad	0x3ff396dacbb4610c
	.quad	0x3ff3988d5f90f36a
	.quad	0x3ff39a40191664ac
	.quad	0x3ff39bf2f847f847
	.quad	0x3ff39da5fd28f1f8
	.quad	0x3ff39f5927bc95c8
	.quad	0x3ff3a10c78062804
	.quad	0x3ff3a2bfee08ed45
	.quad	0x3ff3a47389c82a68
	.quad	0x3ff3a6274b472498
	.quad	0x3ff3a7db32892144
	.quad	0x3ff3a98f3f916626
	.quad	0x3ff3ab4372633941
	.quad	0x3ff3acf7cb01e0de
	.quad	0x3ff3aeac4970a392
	.quad	0x3ff3b060edb2c837
	.quad	0x3ff3b215b7cb95f3
	.quad	0x3ff3b3caa7be5434
	.quad	0x3ff3b57fbd8e4aae
	.quad	0x3ff3b734f93ec163
	.quad	0x3ff3b8ea5ad30097
	.quad	0x3ff3ba9fe24e50dd
	.quad	0x3ff3bc558fb3fb0d
	.quad	0x3ff3be0b6307484a
	.quad	0x3ff3bfc15c4b81ff
	.quad	0x3ff3c1777b83f1e0
	.quad	0x3ff3c32dc0b3e1ea
	.quad	0x3ff3c4e42bde9c62
	.quad	0x3ff3c69abd076bd8
	.quad	0x3ff3c85174319b24
	.quad	0x3ff3ca0851607565
	.quad	0x3ff3cbbf54974607
	.quad	0x3ff3cd767dd958bd
	.quad	0x3ff3cf2dcd29f984
	.quad	0x3ff3d0e5428c749e
	.quad	0x3ff3d29cde04169e
	.quad	0x3ff3d4549f942c57
	.quad	0x3ff3d60c874002ee
	.quad	0x3ff3d7c4950ae7cb
	.quad	0x3ff3d97cc8f828a2
	.quad	0x3ff3db35230b136f
	.quad	0x3ff3dceda346f679
	.quad	0x3ff3dea649af204f
	.quad	0x3ff3e05f1646dfca
	.quad	0x3ff3e2180911840c
	.quad	0x3ff3e3d122125c7f
	.quad	0x3ff3e58a614cb8db
	.quad	0x3ff3e743c6c3e91b
	.quad	0x3ff3e8fd527b3d8a
	.quad	0x3ff3eab7047606b7
	.quad	0x3ff3ec70dcb7957e
	.quad	0x3ff3ee2adb433b04
	.quad	0x3ff3efe5001c48b5
	.quad	0x3ff3f19f4b46104c
	.quad	0x3ff3f359bcc3e3c8
	.quad	0x3ff3f51454991573
	.quad	0x3ff3f6cf12c8f7e5
	.quad	0x3ff3f889f756ddfa
	.quad	0x3ff3fa4502461adb
	.quad	0x3ff3fc00339a01f9
	.quad	0x3ff3fdbb8b55e710
	.quad	0x3ff3ff77097d1e26
	.quad	0x3ff40132ae12fb8a
	.quad	0x3ff402ee791ad3d5
	.quad	0x3ff404aa6a97fbea
	.quad	0x3ff40666828dc8f6
	.quad	0x3ff40822c0ff9071
	.quad	0x3ff409df25f0a81b
	.quad	0x3ff40b9bb16465fe
	.quad	0x3ff40d58635e2070
	.quad	0x3ff40f153be12e0f
	.quad	0x3ff410d23af0e5c5
	.quad	0x3ff4128f60909ec4
	.quad	0x3ff4144cacc3b08a
	.quad	0x3ff4160a1f8d72dd
	.quad	0x3ff417c7b8f13dd0
	.quad	0x3ff4198578f269be
	.quad	0x3ff41b435f944f4c
	.quad	0x3ff41d016cda476c
	.quad	0x3ff41ebfa0c7ab57
	.quad	0x3ff4207dfb5fd491
	.quad	0x3ff4223c7ca61cea
	.quad	0x3ff423fb249dde7b
	.quad	0x3ff425b9f34a73a7
	.quad	0x3ff42778e8af371d
	.quad	0x3ff4293804cf83d5
	.quad	0x3ff42af747aeb511
	.quad	0x3ff42cb6b1502661
	.quad	0x3ff42e7641b73399
	.quad	0x3ff43035f8e738de
	.quad	0x3ff431f5d6e3929c
	.quad	0x3ff433b5dbaf9d8b
	.quad	0x3ff43576074eb6ac
	.quad	0x3ff4373659c43b4c
	.quad	0x3ff438f6d3138902
	.quad	0x3ff43ab7733ffdb1
	.quad	0x3ff43c783a4cf784
	.quad	0x3ff43e39283dd4f5
	.quad	0x3ff43ffa3d15f4c3
	.quad	0x3ff441bb78d8b5fc
	.quad	0x3ff4437cdb8977f9
	.quad	0x3ff4453e652b9a59
	.quad	0x3ff4470015c27d0e
	.quad	0x3ff448c1ed51804b
	.quad	0x3ff44a83ebdc0497
	.quad	0x3ff44c4611656abf
	.quad	0x3ff44e085df113da
	.quad	0x3ff44fcad182614e
	.quad	0x3ff4518d6c1cb4c9
	.quad	0x3ff453502dc37045
	.quad	0x3ff455131679f608
	.quad	0x3ff456d62643a8a0
	.quad	0x3ff458995d23eae9
	.quad	0x3ff45a5cbb1e2009
	.quad	0x3ff45c204035ab72
	.quad	0x3ff45de3ec6df0df
	.quad	0x3ff45fa7bfca5459
	.quad	0x3ff4616bba4e3a34
	.quad	0x3ff4632fdbfd070c
	.quad	0x3ff464f424da1fcc
	.quad	0x3ff466b894e8e9a6
	.quad	0x3ff4687d2c2cca1e
	.quad	0x3ff46a41eaa926fc
	.quad	0x3ff46c06d061665a
	.quad	0x3ff46dcbdd58ee98
	.quad	0x3ff46f9111932664
	.quad	0x3ff471566d1374b7
	.quad	0x3ff4731befdd40d6
	.quad	0x3ff474e199f3f251
	.quad	0x3ff476a76b5af103
	.quad	0x3ff4786d6415a514
	.quad	0x3ff47a33842776f6
	.quad	0x3ff47bf9cb93cf67
	.quad	0x3ff47dc03a5e1772
	.quad	0x3ff47f86d089b86d
	.quad	0x3ff4814d8e1a1bf8
	.quad	0x3ff483147312ac00
	.quad	0x3ff484db7f76d2be
	.quad	0x3ff486a2b349fab7
	.quad	0x3ff4886a0e8f8ebb
	.quad	0x3ff48a31914af9e6
	.quad	0x3ff48bf93b7fa79f
	.quad	0x3ff48dc10d31039b
	.quad	0x3ff48f89066279da
	.quad	0x3ff49151271776a6
	.quad	0x3ff493196f536698
	.quad	0x3ff494e1df19b693
	.quad	0x3ff496aa766dd3c6
	.quad	0x3ff4987335532bad
	.quad	0x3ff49a3c1bcd2c0f
	.quad	0x3ff49c0529df4300
	.quad	0x3ff49dce5f8cdee0
	.quad	0x3ff49f97bcd96e5a
	.quad	0x3ff4a16141c86066
	.quad	0x3ff4a32aee5d2449
	.quad	0x3ff4a4f4c29b2993
	.quad	0x3ff4a6bebe85e020
	.quad	0x3ff4a888e220b819
	.quad	0x3ff4aa532d6f21f4
	.quad	0x3ff4ac1da0748e6f
	.quad	0x3ff4ade83b346e9c
	.quad	0x3ff4afb2fdb233d4
	.quad	0x3ff4b17de7f14fbb
	.quad	0x3ff4b348f9f53446
	.quad	0x3ff4b51433c153b3
	.quad	0x3ff4b6df9559208f
	.quad	0x3ff4b8ab1ec00db1
	.quad	0x3ff4ba76cff98e3e
	.quad	0x3ff4bc42a90915a7
	.quad	0x3ff4be0ea9f217aa
	.quad	0x3ff4bfdad2b80852
	.quad	0x3ff4c1a7235e5bf6
	.quad	0x3ff4c3739be88737
	.quad	0x3ff4c5403c59ff09
	.quad	0x3ff4c70d04b638a6
	.quad	0x3ff4c8d9f500a999
	.quad	0x3ff4caa70d3cc7b9
	.quad	0x3ff4cc744d6e0926
	.quad	0x3ff4ce41b597e454
	.quad	0x3ff4d00f45bdcffe
	.quad	0x3ff4d1dcfde3432d
	.quad	0x3ff4d3aade0bb539
	.quad	0x3ff4d578e63a9dc2
	.quad	0x3ff4d747167374bd
	.quad	0x3ff4d9156eb9b264
	.quad	0x3ff4dae3ef10cf42
	.quad	0x3ff4dcb2977c442f
	.quad	0x3ff4de8167ff8a4e
	.quad	0x3ff4e050609e1b11
	.quad	0x3ff4e21f815b7036
	.quad	0x3ff4e3eeca3b03c9
	.quad	0x3ff4e5be3b405022
	.quad	0x3ff4e78dd46ecfe6
	.quad	0x3ff4e95d95c9fe0b
	.quad	0x3ff4eb2d7f5555ce
	.quad	0x3ff4ecfd911452bd
	.quad	0x3ff4eecdcb0a70b3
	.quad	0x3ff4f09e2d3b2bd8
	.quad	0x3ff4f26eb7aa00a1
	.quad	0x3ff4f43f6a5a6bd2
	.quad	0x3ff4f610454fea79
	.quad	0x3ff4f7e1488df9f4
	.quad	0x3ff4f9b2741817ee
	.quad	0x3ff4fb83c7f1c25e
	.quad	0x3ff4fd55441e778b
	.quad	0x3ff4ff26e8a1b608
	.quad	0x3ff500f8b57efcb6
	.quad	0x3ff502caaab9cac1
	.quad	0x3ff5049cc8559fa7
	.quad	0x3ff5066f0e55fb31
	.quad	0x3ff508417cbe5d77
	.quad	0x3ff50a14139246db
	.quad	0x3ff50be6d2d53812
	.quad	0x3ff50db9ba8ab21a
	.quad	0x3ff50f8ccab63642
	.quad	0x3ff51160035b4625
	.quad	0x3ff51333647d63ad
	.quad	0x3ff51506ee201112
	.quad	0x3ff516daa046d0d6
	.quad	0x3ff518ae7af525ce
	.quad	0x3ff51a827e2e931a
	.quad	0x3ff51c56a9f69c2a
	.quad	0x3ff51e2afe50c4b9
	.quad	0x3ff51fff7b4090d2
	.quad	0x3ff521d420c984ce
	.quad	0x3ff523a8eeef2553
	.quad	0x3ff5257de5b4f757
	.quad	0x3ff52753051e801a
	.quad	0x3ff529284d2f4530
	.quad	0x3ff52afdbdeacc76
	.quad	0x3ff52cd357549c19
	.quad	0x3ff52ea919703a95
	.quad	0x3ff5307f04412eb4
	.quad	0x3ff5325517caff8d
	.quad	0x3ff5342b54113485
	.quad	0x3ff53601b9175551
	.quad	0x3ff537d846e0e9f5
	.quad	0x3ff539aefd717ac0
	.quad	0x3ff53b85dccc9053
	.quad	0x3ff53d5ce4f5b39a
	.quad	0x3ff53f3415f06dd2
	.quad	0x3ff5410b6fc04885
	.quad	0x3ff542e2f268cd8c
	.quad	0x3ff544ba9ded870f
	.quad	0x3ff546927251ff84
	.quad	0x3ff5486a6f99c1b1
	.quad	0x3ff54a4295c858a6
	.quad	0x3ff54c1ae4e14fc7
	.quad	0x3ff54df35ce832c3
	.quad	0x3ff54fcbfde08d9b
	.quad	0x3ff551a4c7cdec9c
	.quad	0x3ff5537dbab3dc60
	.quad	0x3ff55556d695e9d6
	.quad	0x3ff557301b77a236
	.quad	0x3ff55909895c9309
	.quad	0x3ff55ae320484a28
	.quad	0x3ff55cbce03e55b7
	.quad	0x3ff55e96c942442b
	.quad	0x3ff56070db57a44b
	.quad	0x3ff5624b16820529
	.quad	0x3ff564257ac4f625
	.quad	0x3ff56600082406f4
	.quad	0x3ff567dabea2c792
	.quad	0x3ff569b59e44c851
	.quad	0x3ff56b90a70d99ce
	.quad	0x3ff56d6bd900ccf5
	.quad	0x3ff56f473421f304
	.quad	0x3ff57122b8749d87
	.quad	0x3ff572fe65fc5e58
	.quad	0x3ff574da3cbcc7a0
	.quad	0x3ff576b63cb96bd8
	.quad	0x3ff5789265f5ddca
	.quad	0x3ff57a6eb875b08c
	.quad	0x3ff57c4b343c7786
	.quad	0x3ff57e27d94dc66d
	.quad	0x3ff58004a7ad3148
	.quad	0x3ff581e19f5e4c6a
	.quad	0x3ff583bec064ac79
	.quad	0x3ff5859c0ac3e669
	.quad	0x3ff587797e7f8f7c
	.quad	0x3ff589571b9b3d44
	.quad	0x3ff58b34e21a85a7
	.quad	0x3ff58d12d200fed2
	.quad	0x3ff58ef0eb523f4a
	.quad	0x3ff590cf2e11ddde
	.quad	0x3ff592ad9a4371af
	.quad	0x3ff5948c2fea922e
	.quad	0x3ff5966aef0ad71b
	.quad	0x3ff59849d7a7d883
	.quad	0x3ff59a28e9c52ec9
	.quad	0x3ff59c0825667299
	.quad	0x3ff59de78a8f3cf4
	.quad	0x3ff59fc719432727
	.quad	0x3ff5a1a6d185cad3
	.quad	0x3ff5a386b35ac1e4
	.quad	0x3ff5a566bec5a699
	.quad	0x3ff5a746f3ca1381
	.quad	0x3ff5a927526ba378
	.quad	0x3ff5ab07daadf1af
	.quad	0x3ff5ace88c9499a3
	.quad	0x3ff5aec968233721
	.quad	0x3ff5b0aa6d5d6649
	.quad	0x3ff5b28b9c46c389
	.quad	0x3ff5b46cf4e2eb9d
	.quad	0x3ff5b64e77357b97
	.quad	0x3ff5b830234210d3
	.quad	0x3ff5ba11f90c4902
	.quad	0x3ff5bbf3f897c221
	.quad	0x3ff5bdd621e81a81
	.quad	0x3ff5bfb87500f0c1
	.quad	0x3ff5c19af1e5e3d2
	.quad	0x3ff5c37d989a92f2
	.quad	0x3ff5c56069229db4
	.quad	0x3ff5c7436381a3f7
	.quad	0x3ff5c92687bb45ed
	.quad	0x3ff5cb09d5d3241a
	.quad	0x3ff5cced4dccdf4c
	.quad	0x3ff5ced0efac18aa
	.quad	0x3ff5d0b4bb7471a6
	.quad	0x3ff5d298b1298c02
	.quad	0x3ff5d47cd0cf09d4
	.quad	0x3ff5d6611a688d81
	.quad	0x3ff5d8458df9b9bf
	.quad	0x3ff5da2a2b863193
	.quad	0x3ff5dc0ef3119855
	.quad	0x3ff5ddf3e49f91ad
	.quad	0x3ff5dfd90033c193
	.quad	0x3ff5e1be45d1cc4f
	.quad	0x3ff5e3a3b57d567d
	.quad	0x3ff5e5894f3a0506
	.quad	0x3ff5e76f130b7d27
	.quad	0x3ff5e95500f5646d
	.quad	0x3ff5eb3b18fb60b3
	.quad	0x3ff5ed215b21182a
	.quad	0x3ff5ef07c76a314e
	.quad	0x3ff5f0ee5dda52f4
	.quad	0x3ff5f2d51e752439
	.quad	0x3ff5f4bc093e4c90
	.quad	0x3ff5f6a31e3973bf
	.quad	0x3ff5f88a5d6a41d9
	.quad	0x3ff5fa71c6d45f43
	.quad	0x3ff5fc595a7b74b4
	.quad	0x3ff5fe4118632b33
	.quad	0x3ff60029008f2c1b
	.quad	0x3ff6021113032116
	.quad	0x3ff603f94fc2b41f
	.quad	0x3ff605e1b6d18f82
	.quad	0x3ff607ca48335ddf
	.quad	0x3ff609b303ebca24
	.quad	0x3ff60b9be9fe7f93
	.quad	0x3ff60d84fa6f29bf
	.quad	0x3ff60f6e3541748a
	.quad	0x3ff611579a790c29
	.quad	0x3ff613412a199d25
	.quad	0x3ff6152ae426d453
	.quad	0x3ff61714c8a45edf
	.quad	0x3ff618fed795ea44
	.quad	0x3ff61ae910ff244e
	.quad	0x3ff61cd374e3bb1b
	.quad	0x3ff61ebe03475d1c
	.quad	0x3ff620a8bc2db914
	.quad	0x3ff622939f9a7e14
	.quad	0x3ff6247ead915b83
	.quad	0x3ff62669e6160116
	.quad	0x3ff62855492c1ed7
	.quad	0x3ff62a40d6d76521
	.quad	0x3ff62c2c8f1b84a0
	.quad	0x3ff62e1871fc2e52
	.quad	0x3ff630047f7d1386
	.quad	0x3ff631f0b7a1e5e1
	.quad	0x3ff633dd1a6e5753
	.quad	0x3ff635c9a7e61a25
	.quad	0x3ff637b6600ce0ed
	.quad	0x3ff639a342e65e97
	.quad	0x3ff63b905076465f
	.quad	0x3ff63d7d88c04bd0
	.quad	0x3ff63f6aebc822cd
	.quad	0x3ff6415879917f88
	.quad	0x3ff6434632201685
	.quad	0x3ff6453415779c9b
	.quad	0x3ff64722239bc6f3
	.quad	0x3ff649105c904b09
	.quad	0x3ff64afec058dea9
	.quad	0x3ff64ced4ef937f3
	.quad	0x3ff64edc08750d5b
	.quad	0x3ff650caecd015a3
	.quad	0x3ff652b9fc0e07e3
	.quad	0x3ff654a936329b85
	.quad	0x3ff656989b418844
	.quad	0x3ff658882b3e862e
	.quad	0x3ff65a77e62d4da4
	.quad	0x3ff65c67cc119759
	.quad	0x3ff65e57dcef1c54
	.quad	0x3ff6604818c995ed
	.quad	0x3ff662387fa4bdce
	.quad	0x3ff6642911844df6
	.quad	0x3ff66619ce6c00b4
	.quad	0x3ff6680ab65f90ac
	.quad	0x3ff669fbc962b8d3
	.quad	0x3ff66bed07793473
	.quad	0x3ff66dde70a6bf26
	.quad	0x3ff66fd004ef14db
	.quad	0x3ff671c1c455f1d2
	.quad	0x3ff673b3aedf129f
	.quad	0x3ff675a5c48e342a
	.quad	0x3ff67798056713aa
	.quad	0x3ff6798a716d6eaf
	.quad	0x3ff67b7d08a50316
	.quad	0x3ff67d6fcb118f12
	.quad	0x3ff67f62b8b6d12a
	.quad	0x3ff68155d1988835
	.quad	0x3ff6834915ba7361
	.quad	0x3ff6853c8520522a
	.quad	0x3ff687301fcde464
	.quad	0x3ff68923e5c6ea33
	.quad	0x3ff68b17d70f2412
	.quad	0x3ff68d0bf3aa52c9
	.quad	0x3ff68f003b9c3779
	.quad	0x3ff690f4aee89395
	.quad	0x3ff692e94d9328e0
	.quad	0x3ff694de179fb976
	.quad	0x3ff696d30d1207c0
	.quad	0x3ff698c82dedd681
	.quad	0x3ff69abd7a36e8c9
	.quad	0x3ff69cb2f1f101ff
	.quad	0x3ff69ea8951fe5e0
	.quad	0x3ff6a09e63c75876
	.quad	0x3ff6a2945deb1e23
	.quad	0x3ff6a48a838efb9d
	.quad	0x3ff6a680d4b6b5ec
	.quad	0x3ff6a8775166126a
	.quad	0x3ff6aa6df9a0d6c8
	.quad	0x3ff6ac64cd6ac90a
	.quad	0x3ff6ae5bccc7af86
	.quad	0x3ff6b052f7bb50e6
	.quad	0x3ff6b24a4e497429
	.quad	0x3ff6b441d075e0a1
	.quad	0x3ff6b6397e445df5
	.quad	0x3ff6b83157b8b41e
	.quad	0x3ff6ba295cd6ab6a
	.quad	0x3ff6bc218da20c7a
	.quad	0x3ff6be19ea1ea046
	.quad	0x3ff6c01272503016
	.quad	0x3ff6c20b263a8587
	.quad	0x3ff6c40405e16a8b
	.quad	0x3ff6c5fd1148a969
	.quad	0x3ff6c7f648740cb9
	.quad	0x3ff6c9efab675f6a
	.quad	0x3ff6cbe93a266cbe
	.quad	0x3ff6cde2f4b5004b
	.quad	0x3ff6cfdcdb16e5fb
	.quad	0x3ff6d1d6ed4fea0d
	.quad	0x3ff6d3d12b63d914
	.quad	0x3ff6d5cb95567ff7
	.quad	0x3ff6d7c62b2babf1
	.quad	0x3ff6d9c0ece72a93
	.quad	0x3ff6dbbbda8cc9c0
	.quad	0x3ff6ddb6f42057b0
	.quad	0x3ff6dfb239a5a2f3
	.quad	0x3ff6e1adab207a67
	.quad	0x3ff6e3a94894ad43
	.quad	0x3ff6e5a512060b13
	.quad	0x3ff6e7a1077863b4
	.quad	0x3ff6e99d28ef875a
	.quad	0x3ff6eb99766f468d
	.quad	0x3ff6ed95effb722a
	.quad	0x3ff6ef929597db64
	.quad	0x3ff6f18f674853bf
	.quad	0x3ff6f38c6510ad16
	.quad	0x3ff6f5898ef4b99a
	.quad	0x3ff6f786e4f84bcd
	.quad	0x3ff6f984671f368a
	.quad	0x3ff6fb82156d4cfe
	.quad	0x3ff6fd7fefe662ac
	.quad	0x3ff6ff7df68e4b6c
	.quad	0x3ff7017c2968db6b
	.quad	0x3ff7037a8879e729
	.quad	0x3ff7057913c5437d
	.quad	0x3ff70777cb4ec594
	.quad	0x3ff70976af1a42ec
	.quad	0x3ff70b75bf2b915c
	.quad	0x3ff70d74fb868710
	.quad	0x3ff70f74642efa85
	.quad	0x3ff71173f928c291
	.quad	0x3ff71373ba77b65f
	.quad	0x3ff71573a81fad6d
	.quad	0x3ff71773c2247f90
	.quad	0x3ff71974088a04f2
	.quad	0x3ff71b747b541612
	.quad	0x3ff71d751a868bc4
	.quad	0x3ff71f75e6253f32
	.quad	0x3ff72176de3409db
	.quad	0x3ff7237802b6c593
	.quad	0x3ff7257953b14c84
	.quad	0x3ff7277ad127792f
	.quad	0x3ff7297c7b1d2667
	.quad	0x3ff72b7e51962f56
	.quad	0x3ff72d8054966f7e
	.quad	0x3ff72f828421c2b3
	.quad	0x3ff73184e03c0520
	.quad	0x3ff7338768e91346
	.quad	0x3ff7358a1e2cc9fc
	.quad	0x3ff7378d000b066d
	.quad	0x3ff739900e87a61c
	.quad	0x3ff73b9349a686df
	.quad	0x3ff73d96b16b86e5
	.quad	0x3ff73f9a45da84b1
	.quad	0x3ff7419e06f75f1a
	.quad	0x3ff743a1f4c5f551
	.quad	0x3ff745a60f4a26da
	.quad	0x3ff747aa5687d38f
	.quad	0x3ff749aeca82dba1
	.quad	0x3ff74bb36b3f1f98
	.quad	0x3ff74db838c0804e
	.quad	0x3ff74fbd330adef7
	.quad	0x3ff751c25a221d1c
	.quad	0x3ff753c7ae0a1c9b
	.quad	0x3ff755cd2ec6bfaa
	.quad	0x3ff757d2dc5be8d3
	.quad	0x3ff759d8b6cd7af8
	.quad	0x3ff75bdebe1f5950
	.quad	0x3ff75de4f2556769
	.quad	0x3ff75feb53738927
	.quad	0x3ff761f1e17da2c4
	.quad	0x3ff763f89c7798d0
	.quad	0x3ff765ff84655034
	.quad	0x3ff76806994aae2c
	.quad	0x3ff76a0ddb2b984c
	.quad	0x3ff76c154a0bf47d
	.quad	0x3ff76e1ce5efa903
	.quad	0x3ff77024aeda9c72
	.quad	0x3ff7722ca4d0b5ba
	.quad	0x3ff77434c7d5dc1c
	.quad	0x3ff7763d17edf738
	.quad	0x3ff77845951ceefb
	.quad	0x3ff77a4e3f66abb0
	.quad	0x3ff77c5716cf15f4
	.quad	0x3ff77e601b5a16bd
	.quad	0x3ff780694d0b9758
	.quad	0x3ff78272abe78169
	.quad	0x3ff7847c37f1bee8
	.quad	0x3ff78685f12e3a27
	.quad	0x3ff7888fd7a0ddcc
	.quad	0x3ff78a99eb4d94d8
	.quad	0x3ff78ca42c384a9f
	.quad	0x3ff78eae9a64eacc
	.quad	0x3ff790b935d76165
	.quad	0x3ff792c3fe939ac3
	.quad	0x3ff794cef49d8396
	.quad	0x3ff796da17f908e9
	.quad	0x3ff798e568aa181a
	.quad	0x3ff79af0e6b49ee0
	.quad	0x3ff79cfc921c8b49
	.quad	0x3ff79f086ae5cbba
	.quad	0x3ff7a11471144eef
	.quad	0x3ff7a320a4ac03fa
	.quad	0x3ff7a52d05b0da48
	.quad	0x3ff7a7399426c19b
	.quad	0x3ff7a9465011aa0b
	.quad	0x3ff7ab5339758409
	.quad	0x3ff7ad605056405d
	.quad	0x3ff7af6d94b7d027
	.quad	0x3ff7b17b069e24de
	.quad	0x3ff7b388a60d3050
	.quad	0x3ff7b5967308e4a3
	.quad	0x3ff7b7a46d953455
	.quad	0x3ff7b9b295b6123a
	.quad	0x3ff7bbc0eb6f7180
	.quad	0x3ff7bdcf6ec545aa
	.quad	0x3ff7bfde1fbb8295
	.quad	0x3ff7c1ecfe561c73
	.quad	0x3ff7c3fc0a9907d2
	.quad	0x3ff7c60b44883993
	.quad	0x3ff7c81aac27a6f1
	.quad	0x3ff7ca2a417b4580
	.quad	0x3ff7cc3a04870b28
	.quad	0x3ff7ce49f54eee2d
	.quad	0x3ff7d05a13d6e52a
	.quad	0x3ff7d26a6022e710
	.quad	0x3ff7d47ada36eb2a
	.quad	0x3ff7d68b8216e919
	.quad	0x3ff7d89c57c6d8d7
	.quad	0x3ff7daad5b4ab2b8
	.quad	0x3ff7dcbe8ca66f64
	.quad	0x3ff7decfebde07de
	.quad	0x3ff7e0e178f57582
	.quad	0x3ff7e2f333f0b201
	.quad	0x3ff7e5051cd3b766
	.quad	0x3ff7e71733a28014
	.quad	0x3ff7e929786106c7
	.quad	0x3ff7eb3beb134693
	.quad	0x3ff7ed4e8bbd3ae3
	.quad	0x3ff7ef615a62df7a
	.quad	0x3ff7f17457083077
	.quad	0x3ff7f38781b12a4e
	.quad	0x3ff7f59ada61c9cc
	.quad	0x3ff7f7ae611e0c17
	.quad	0x3ff7f9c215e9eeae
	.quad	0x3ff7fbd5f8c96f66
	.quad	0x3ff7fdea09c08c72
	.quad	0x3ff7fffe48d34457
	.quad	0x3ff80212b60595f7
	.quad	0x3ff80427515b808b
	.quad	0x3ff8063c1ad903a4
	.quad	0x3ff8085112821f2e
	.quad	0x3ff80a66385ad36d
	.quad	0x3ff80c7b8c6720fb
	.quad	0x3ff80e910eab08ce
	.quad	0x3ff810a6bf2a8c34
	.quad	0x3ff812bc9de9acd3
	.quad	0x3ff814d2aaec6cab
	.quad	0x3ff816e8e636ce15
	.quad	0x3ff818ff4fccd3c0
	.quad	0x3ff81b15e7b280b9
	.quad	0x3ff81d2cadebd863
	.quad	0x3ff81f43a27cde79
	.quad	0x3ff8215ac5699711
	.quad	0x3ff8237216b60699
	.quad	0x3ff82589966631da
	.quad	0x3ff827a1447e1df3
	.quad	0x3ff829b92101d060
	.quad	0x3ff82bd12bf54ef1
	.quad	0x3ff82de9655c9fd6
	.quad	0x3ff83001cd3bc993
	.quad	0x3ff8321a6396d307
	.quad	0x3ff834332871c36a
	.quad	0x3ff8364c1bd0a24e
	.quad	0x3ff838653db7779f
	.quad	0x3ff83a7e8e2a4ba1
	.quad	0x3ff83c980d2d26f1
	.quad	0x3ff83eb1bac41287
	.quad	0x3ff840cb96f317b4
	.quad	0x3ff842e5a1be4023
	.quad	0x3ff844ffdb2995d7
	.quad	0x3ff8471a4339232f
	.quad	0x3ff84934d9f0f2e1
	.quad	0x3ff84b4f9f550fff
	.quad	0x3ff84d6a936985f4
	.quad	0x3ff84f85b6326082
	.quad	0x3ff851a107b3abca
	.quad	0x3ff853bc87f17443
	.quad	0x3ff855d836efc6bd
	.quad	0x3ff857f414b2b067
	.quad	0x3ff85a10213e3ec4
	.quad	0x3ff85c2c5c967fb5
	.quad	0x3ff85e48c6bf8171
	.quad	0x3ff860655fbd528d
	.quad	0x3ff86282279401f7
	.quad	0x3ff8649f1e479ef5
	.quad	0x3ff866bc43dc392a
	.quad	0x3ff868d99855e08f
	.quad	0x3ff86af71bb8a57c
	.quad	0x3ff86d14ce08989e
	.quad	0x3ff86f32af49cb03
	.quad	0x3ff87150bf804e0b
	.quad	0x3ff8736efeb03378
	.quad	0x3ff8758d6cdd8d61
	.quad	0x3ff877ac0a0c6e38
	.quad	0x3ff879cad640e8cc
	.quad	0x3ff87be9d17f1044
	.quad	0x3ff87e08fbcaf822
	.quad	0x3ff880285528b444
	.quad	0x3ff88247dd9c58df
	.quad	0x3ff884679529fa86
	.quad	0x3ff886877bd5ae23
	.quad	0x3ff888a791a388ff
	.quad	0x3ff88ac7d697a0b9
	.quad	0x3ff88ce84ab60b4f
	.quad	0x3ff88f08ee02df15
	.quad	0x3ff89129c08232be
	.quad	0x3ff8934ac2381d54
	.quad	0x3ff8956bf328b63f
	.quad	0x3ff8978d53581541
	.quad	0x3ff899aee2ca5273
	.quad	0x3ff89bd0a183864e
	.quad	0x3ff89df28f87c9a5
	.quad	0x3ff8a014acdb35a2
	.quad	0x3ff8a236f981e3cd
	.quad	0x3ff8a459757fee0b
	.quad	0x3ff8a67c20d96e96
	.quad	0x3ff8a89efb928009
	.quad	0x3ff8aac205af3d57
	.quad	0x3ff8ace53f33c1ce
	.quad	0x3ff8af08a8242919
	.quad	0x3ff8b12c40848f3b
	.quad	0x3ff8b35008591095
	.quad	0x3ff8b573ffa5c9e2
	.quad	0x3ff8b798266ed839
	.quad	0x3ff8b9bc7cb8590d
	.quad	0x3ff8bbe102866a27
	.quad	0x3ff8be05b7dd29b2
	.quad	0x3ff8c02a9cc0b632
	.quad	0x3ff8c24fb1352e86
	.quad	0x3ff8c474f53eb1e8
	.quad	0x3ff8c69a68e15fed
	.quad	0x3ff8c8c00c215887
	.quad	0x3ff8cae5df02bc04
	.quad	0x3ff8cd0be189ab0a
	.quad	0x3ff8cf3213ba46a0
	.quad	0x3ff8d1587598b023
	.quad	0x3ff8d37f07290950
	.quad	0x3ff8d5a5c86f743d
	.quad	0x3ff8d7ccb970135d
	.quad	0x3ff8d9f3da2f097f
	.quad	0x3ff8dc1b2ab079ca
	.quad	0x3ff8de42aaf887c7
	.quad	0x3ff8e06a5b0b5758
	.quad	0x3ff8e2923aed0cb7
	.quad	0x3ff8e4ba4aa1cc81
	.quad	0x3ff8e6e28a2dbba9
	.quad	0x3ff8e90af994ff81
	.quad	0x3ff8eb3398dbbdb7
	.quad	0x3ff8ed5c68061c54
	.quad	0x3ff8ef85671841bc
	.quad	0x3ff8f1ae961654b0
	.quad	0x3ff8f3d7f5047c4f
	.quad	0x3ff8f60183e6e012
	.quad	0x3ff8f82b42c1a7cf
	.quad	0x3ff8fa553198fbb8
	.quad	0x3ff8fc7f5071045a
	.quad	0x3ff8fea99f4deaa1
	.quad	0x3ff900d41e33d7d1
	.quad	0x3ff902fecd26f58f
	.quad	0x3ff90529ac2b6dda
	.quad	0x3ff90754bb456b0e
	.quad	0x3ff9097ffa7917e2
	.quad	0x3ff90bab69ca9f6c
	.quad	0x3ff90dd7093e2d1b
	.quad	0x3ff91002d8d7ecbd
	.quad	0x3ff9122ed89c0a7e
	.quad	0x3ff9145b088eb2e4
	.quad	0x3ff9168768b412d0
	.quad	0x3ff918b3f9105783
	.quad	0x3ff91ae0b9a7ae9b
	.quad	0x3ff91d0daa7e4610
	.quad	0x3ff91f3acb984c37
	.quad	0x3ff921681cf9efc3
	.quad	0x3ff923959ea75fc4
	.quad	0x3ff925c350a4cba7
	.quad	0x3ff927f132f66333
	.quad	0x3ff92a1f45a05690
	.quad	0x3ff92c4d88a6d63f
	.quad	0x3ff92e7bfc0e1323
	.quad	0x3ff930aa9fda3e74
	.quad	0x3ff932d9740f89d1
	.quad	0x3ff9350878b2272d
	.quad	0x3ff93737adc648dd
	.quad	0x3ff9396713502192
	.quad	0x3ff93b96a953e45b
	.quad	0x3ff93dc66fd5c4a2
	.quad	0x3ff93ff666d9f630
	.quad	0x3ff942268e64ad2b
	.quad	0x3ff94456e67a1e16
	.quad	0x3ff946876f1e7dd2
	.quad	0x3ff948b82856019b
	.quad	0x3ff94ae91224df0d
	.quad	0x3ff94d1a2c8f4c1e
	.quad	0x3ff94f4b77997f27
	.quad	0x3ff9517cf347aeda
	.quad	0x3ff953ae9f9e1246
	.quad	0x3ff955e07ca0e0dd
	.quad	0x3ff958128a545266
	.quad	0x3ff95a44c8bc9f0e
	.quad	0x3ff95c7737ddff5a
	.quad	0x3ff95ea9d7bcac2f
	.quad	0x3ff960dca85cdecf
	.quad	0x3ff9630fa9c2d0da
	.quad	0x3ff96542dbf2bc4e
	.quad	0x3ff967763ef0db86
	.quad	0x3ff969a9d2c1693a
	.quad	0x3ff96bdd9768a084
	.quad	0x3ff96e118ceabcd7
	.quad	0x3ff97045b34bfa05
	.quad	0x3ff9727a0a90943f
	.quad	0x3ff974ae92bcc816
	.quad	0x3ff976e34bd4d273
	.quad	0x3ff9791835dcf0a3
	.quad	0x3ff97b4d50d9604e
	.quad	0x3ff97d829cce5f7c
	.quad	0x3ff97fb819c02c8f
	.quad	0x3ff981edc7b3064d
	.quad	0x3ff98423a6ab2bd5
	.quad	0x3ff98659b6acdca7
	.quad	0x3ff9888ff7bc58a2
	.quad	0x3ff98ac669dde001
	.quad	0x3ff98cfd0d15b35d
	.quad	0x3ff98f33e16813b0
	.quad	0x3ff9916ae6d94251
	.quad	0x3ff993a21d6d80f4
	.quad	0x3ff995d9852911ae
	.quad	0x3ff998111e1036f2
	.quad	0x3ff99a48e827338e
	.quad	0x3ff99c80e3724ab5
	.quad	0x3ff99eb90ff5bff1
	.quad	0x3ff9a0f16db5d730
	.quad	0x3ff9a329fcb6d4be
	.quad	0x3ff9a562bcfcfd42
	.quad	0x3ff9a79bae8c95c8
	.quad	0x3ff9a9d4d169e3b4
	.quad	0x3ff9ac0e25992ccd
	.quad	0x3ff9ae47ab1eb739
	.quad	0x3ff9b08161fec979
	.quad	0x3ff9b2bb4a3daa71
	.quad	0x3ff9b4f563dfa161
	.quad	0x3ff9b72faee8f5e9
	.quad	0x3ff9b96a2b5df009
	.quad	0x3ff9bba4d942d81f
	.quad	0x3ff9bddfb89bf6e9
	.quad	0x3ff9c01ac96d9580
	.quad	0x3ff9c2560bbbfd60
	.quad	0x3ff9c4917f8b7866
	.quad	0x3ff9c6cd24e050c8
	.quad	0x3ff9c908fbbed121
	.quad	0x3ff9cb45042b4467
	.quad	0x3ff9cd813e29f5f2
	.quad	0x3ff9cfbda9bf3179
	.quad	0x3ff9d1fa46ef430e
	.quad	0x3ff9d43715be772a
	.quad	0x3ff9d67416311aa0
	.quad	0x3ff9d8b1484b7aa2
	.quad	0x3ff9daeeac11e4c5
	.quad	0x3ff9dd2c4188a6fb
	.quad	0x3ff9df6a08b40f94
	.quad	0x3ff9e1a801986d45
	.quad	0x3ff9e3e62c3a0f1d
	.quad	0x3ff9e624889d448d
	.quad	0x3ff9e86316c65d65
	.quad	0x3ff9eaa1d6b9a9d6
	.quad	0x3ff9ece0c87b7a6f
	.quad	0x3ff9ef1fec102020
	.quad	0x3ff9f15f417bec36
	.quad	0x3ff9f39ec8c33062
	.quad	0x3ff9f5de81ea3eb2
	.quad	0x3ff9f81e6cf56995
	.quad	0x3ff9fa5e89e903d9
	.quad	0x3ff9fc9ed8c960ac
	.quad	0x3ff9fedf599ad39d
	.quad	0x3ffa01200c61b09a
	.quad	0x3ffa0360f1224bf2
	.quad	0x3ffa05a207e0fa53
	.quad	0x3ffa07e350a210ca
	.quad	0x3ffa0a24cb69e4c7
	.quad	0x3ffa0c66783ccc19
	.quad	0x3ffa0ea8571f1ced
	.quad	0x3ffa10ea68152dd4
	.quad	0x3ffa132cab2355bc
	.quad	0x3ffa156f204debf5
	.quad	0x3ffa17b1c7994830
	.quad	0x3ffa19f4a109c27b
	.quad	0x3ffa1c37aca3b348
	.quad	0x3ffa1e7aea6b7367
	.quad	0x3ffa20be5a655c0a
	.quad	0x3ffa2301fc95c6c4
	.quad	0x3ffa2545d1010d86
	.quad	0x3ffa2789d7ab8aa3
	.quad	0x3ffa29ce109998cf
	.quad	0x3ffa2c127bcf931c
	.quad	0x3ffa2e571951d502
	.quad	0x3ffa309be924ba55
	.quad	0x3ffa32e0eb4c9f4a
	.quad	0x3ffa35261fcde079
	.quad	0x3ffa376b86acdad9
	.quad	0x3ffa39b11fedebc2
	.quad	0x3ffa3bf6eb9570ef
	.quad	0x3ffa3e3ce9a7c878
	.quad	0x3ffa40831a2950d8
	.quad	0x3ffa42c97d1e68ec
	.quad	0x3ffa4510128b6ff1
	.quad	0x3ffa4756da74c583
	.quad	0x3ffa499dd4dec9a2
	.quad	0x3ffa4be501cddcad
	.quad	0x3ffa4e2c61465f66
	.quad	0x3ffa5073f34cb2f0
	.quad	0x3ffa52bbb7e538cc
	.quad	0x3ffa5503af1452e0
	.quad	0x3ffa574bd8de6371
	.quad	0x3ffa59943547cd25
	.quad	0x3ffa5bdcc454f307
	.quad	0x3ffa5e25860a387d
	.quad	0x3ffa606e7a6c0154
	.quad	0x3ffa62b7a17eb1b8
	.quad	0x3ffa6500fb46ae37
	.quad	0x3ffa674a87c85bbf
	.quad	0x3ffa699447081fa2
	.quad	0x3ffa6bde390a5f91
	.quad	0x3ffa6e285dd3819f
	.quad	0x3ffa7072b567ec43
	.quad	0x3ffa72bd3fcc0653
	.quad	0x3ffa7507fd043708
	.quad	0x3ffa7752ed14e5fb
	.quad	0x3ffa799e10027b29
	.quad	0x3ffa7be965d15ef0
	.quad	0x3ffa7e34ee85fa0f
	.quad	0x3ffa8080aa24b5a6
	.quad	0x3ffa82cc98b1fb3a
	.quad	0x3ffa8518ba3234b0
	.quad	0x3ffa87650ea9cc4d
	.quad	0x3ffa89b1961d2cbb
	.quad	0x3ffa8bfe5090c106
	.quad	0x3ffa8e4b3e08f499
	.quad	0x3ffa90985e8a3344
	.quad	0x3ffa92e5b218e937
	.quad	0x3ffa953338b98307
	.quad	0x3ffa9780f2706da6
	.quad	0x3ffa99cedf42166e
	.quad	0x3ffa9c1cff32eb19
	.quad	0x3ffa9e6b524759c1
	.quad	0x3ffaa0b9d883d0e6
	.quad	0x3ffaa30891ecbf66
	.quad	0x3ffaa5577e869486
	.quad	0x3ffaa7a69e55bfea
	.quad	0x3ffaa9f5f15eb19b
	.quad	0x3ffaac4577a5da02
	.quad	0x3ffaae95312fa9ec
	.quad	0x3ffab0e51e009287
	.quad	0x3ffab3353e1d0565
	.quad	0x3ffab5859189747c
	.quad	0x3ffab7d6184a5220
	.quad	0x3ffaba26d264110c
	.quad	0x3ffabc77bfdb245d
	.quad	0x3ffabec8e0b3ff90
	.quad	0x3ffac11a34f31687
	.quad	0x3ffac36bbc9cdd87
	.quad	0x3ffac5bd77b5c936
	.quad	0x3ffac80f66424e9f
	.quad	0x3ffaca618846e330
	.quad	0x3ffaccb3ddc7fcb7
	.quad	0x3ffacf0666ca1167
	.quad	0x3ffad159235197d6
	.quad	0x3ffad3ac136306fc
	.quad	0x3ffad5ff3702d636
	.quad	0x3ffad8528e357d43
	.quad	0x3ffadaa618ff7445
	.quad	0x3ffadcf9d76533bf
	.quad	0x3ffadf4dc96b349b
	.quad	0x3ffae1a1ef15f025
	.quad	0x3ffae3f64869e00c
	.quad	0x3ffae64ad56b7e60
	.quad	0x3ffae89f961f4598
	.quad	0x3ffaeaf48a89b08d
	.quad	0x3ffaed49b2af3a7a
	.quad	0x3ffaef9f0e945eff
	.quad	0x3ffaf1f49e3d9a1f
	.quad	0x3ffaf44a61af6840
	.quad	0x3ffaf6a058ee462d
	.quad	0x3ffaf8f683feb114
	.quad	0x3ffafb4ce2e52685
	.quad	0x3ffafda375a62474
	.quad	0x3ffafffa3c46293a
	.quad	0x3ffb025136c9b394
	.quad	0x3ffb04a8653542a2
	.quad	0x3ffb06ffc78d55e6
	.quad	0x3ffb09575dd66d48
	.quad	0x3ffb0baf28150913
	.quad	0x3ffb0e07264da9f8
	.quad	0x3ffb105f5884d106
	.quad	0x3ffb12b7bebeffb8
	.quad	0x3ffb15105900b7e6
	.quad	0x3ffb1769274e7bcf
	.quad	0x3ffb19c229acce18
	.quad	0x3ffb1c1b602031c6
	.quad	0x3ffb1e74caad2a44
	.quad	0x3ffb20ce69583b61
	.quad	0x3ffb23283c25e951
	.quad	0x3ffb2582431ab8ab
	.quad	0x3ffb27dc7e3b2e6b
	.quad	0x3ffb2a36ed8bcff1
	.quad	0x3ffb2c9191112300
	.quad	0x3ffb2eec68cfadc2
	.quad	0x3ffb314774cbf6c3
	.quad	0x3ffb33a2b50a84f5
	.quad	0x3ffb35fe298fdfad
	.quad	0x3ffb3859d2608ea7
	.quad	0x3ffb3ab5af811a00
	.quad	0x3ffb3d11c0f60a3b
	.quad	0x3ffb3f6e06c3e840
	.quad	0x3ffb41ca80ef3d5d
	.quad	0x3ffb44272f7c9343
	.quad	0x3ffb468412707405
	.quad	0x3ffb48e129cf6a20
	.quad	0x3ffb4b3e759e0071
	.quad	0x3ffb4d9bf5e0c23e
	.quad	0x3ffb4ff9aa9c3b30
	.quad	0x3ffb525793d4f751
	.quad	0x3ffb54b5b18f8319
	.quad	0x3ffb571403d06b5b
	.quad	0x3ffb59728a9c3d55
	.quad	0x3ffb5bd145f786a7
	.quad	0x3ffb5e3035e6d559
	.quad	0x3ffb608f5a6eb7d6
	.quad	0x3ffb62eeb393bcee
	.quad	0x3ffb654e415a73d6
	.quad	0x3ffb67ae03c76c2a
	.quad	0x3ffb6a0dfadf35e8
	.quad	0x3ffb6c6e26a66177
	.quad	0x3ffb6ece87217fa1
	.quad	0x3ffb712f1c552196
	.quad	0x3ffb738fe645d8e9
	.quad	0x3ffb75f0e4f83795
	.quad	0x3ffb78521870cffb
	.quad	0x3ffb7ab380b434df
	.quad	0x3ffb7d151dc6f96c
	.quad	0x3ffb7f76efadb132
	.quad	0x3ffb81d8f66cf026
	.quad	0x3ffb843b32094aa4
	.quad	0x3ffb869da287556c
	.quad	0x3ffb890047eba5a5
	.quad	0x3ffb8b63223ad0da
	.quad	0x3ffb8dc631796cfe
	.quad	0x3ffb902975ac1068
	.quad	0x3ffb928ceed751d6
	.quad	0x3ffb94f09cffc869
	.quad	0x3ffb9754802a0bab
	.quad	0x3ffb99b8985ab38a
	.quad	0x3ffb9c1ce596585d
	.quad	0x3ffb9e8167e192dc
	.quad	0x3ffba0e61f40fc29
	.quad	0x3ffba34b0bb92dca
	.quad	0x3ffba5b02d4ec1ab
	.quad	0x3ffba81584065220
	.quad	0x3ffbaa7b0fe479e1
	.quad	0x3ffbace0d0edd40c
	.quad	0x3ffbaf46c726fc27
	.quad	0x3ffbb1acf2948e1f
	.quad	0x3ffbb413533b2643
	.quad	0x3ffbb679e91f614c
	.quad	0x3ffbb8e0b445dc58
	.quad	0x3ffbbb47b4b334eb
	.quad	0x3ffbbdaeea6c08f0
	.quad	0x3ffbc0165574f6bb
	.quad	0x3ffbc27df5d29d00
	.quad	0x3ffbc4e5cb899adf
	.quad	0x3ffbc74dd69e8fdc
	.quad	0x3ffbc9b617161be5
	.quad	0x3ffbcc1e8cf4df48
	.quad	0x3ffbce87383f7ac1
	.quad	0x3ffbd0f018fa8f6d
	.quad	0x3ffbd3592f2abed3
	.quad	0x3ffbd5c27ad4aae0
	.quad	0x3ffbd82bfbfcf5e7
	.quad	0x3ffbda95b2a842a2
	.quad	0x3ffbdcff9edb3432
	.quad	0x3ffbdf69c09a6e20
	.quad	0x3ffbe1d417ea945a
	.quad	0x3ffbe43ea4d04b36
	.quad	0x3ffbe6a967503772
	.quad	0x3ffbe9145f6efe30
	.quad	0x3ffbeb7f8d3144fc
	.quad	0x3ffbedeaf09bb1c7
	.quad	0x3ffbf05689b2eaec
	.quad	0x3ffbf2c2587b9729
	.quad	0x3ffbf52e5cfa5da6
	.quad	0x3ffbf79a9733e5f3
	.quad	0x3ffbfa07072cd804
	.quad	0x3ffbfc73ace9dc39
	.quad	0x3ffbfee0886f9b53
	.quad	0x3ffc014d99c2be80
	.quad	0x3ffc03bae0e7ef53
	.quad	0x3ffc06285de3d7c7
	.quad	0x3ffc089610bb223d
	.quad	0x3ffc0b03f9727980
	.quad	0x3ffc0d72180e88c1
	.quad	0x3ffc0fe06c93fb98
	.quad	0x3ffc124ef7077e06
	.quad	0x3ffc14bdb76dbc74
	.quad	0x3ffc172cadcb63b0
	.quad	0x3ffc199bda2520f2
	.quad	0x3ffc1c0b3c7fa1d9
	.quad	0x3ffc1e7ad4df946e
	.quad	0x3ffc20eaa349a71c
	.quad	0x3ffc235aa7c288be
	.quad	0x3ffc25cae24ee890
	.quad	0x3ffc283b52f37637
	.quad	0x3ffc2aabf9b4e1c5
	.quad	0x3ffc2d1cd697dbaf
	.quad	0x3ffc2f8de9a114d2
	.quad	0x3ffc31ff32d53e76
	.quad	0x3ffc3470b2390a49
	.quad	0x3ffc36e267d12a62
	.quad	0x3ffc395453a25140
	.quad	0x3ffc3bc675b131cb
	.quad	0x3ffc3e38ce027f50
	.quad	0x3ffc40ab5c9aed89
	.quad	0x3ffc431e217f3095
	.quad	0x3ffc45911cb3fcfd
	.quad	0x3ffc48044e3e07b0
	.quad	0x3ffc4a77b6220609
	.quad	0x3ffc4ceb5464adc8
	.quad	0x3ffc4f5f290ab517
	.quad	0x3ffc51d33418d28a
	.quad	0x3ffc54477593bd1c
	.quad	0x3ffc56bbed802c30
	.quad	0x3ffc59309be2d792
	.quad	0x3ffc5ba580c07778
	.quad	0x3ffc5e1a9c1dc47f
	.quad	0x3ffc608fedff77ae
	.quad	0x3ffc6305766a4a74
	.quad	0x3ffc657b3562f6a9
	.quad	0x3ffc67f12aee368d
	.quad	0x3ffc6a675710c4cc
	.quad	0x3ffc6cddb9cf5c77
	.quad	0x3ffc6f54532eb909
	.quad	0x3ffc71cb23339668
	.quad	0x3ffc744229e2b0e1
	.quad	0x3ffc76b96740c52b
	.quad	0x3ffc7930db529065
	.quad	0x3ffc7ba8861cd01a
	.quad	0x3ffc7e2067a44239
	.quad	0x3ffc80987feda51f
	.quad	0x3ffc8310cefdb791
	.quad	0x3ffc858954d938bc
	.quad	0x3ffc88021184e837
	.quad	0x3ffc8a7b05058602
	.quad	0x3ffc8cf42f5fd289
	.quad	0x3ffc8f6d90988e9c
	.quad	0x3ffc91e728b47b79
	.quad	0x3ffc9460f7b85ac7
	.quad	0x3ffc96dafda8ee95
	.quad	0x3ffc99553a8af95b
	.quad	0x3ffc9bcfae633dfe
	.quad	0x3ffc9e4a59367fca
	.quad	0x3ffca0c53b098273
	.quad	0x3ffca34053e10a1b
	.quad	0x3ffca5bba3c1db4b
	.quad	0x3ffca8372ab0baf6
	.quad	0x3ffcaab2e8b26e78
	.quad	0x3ffcad2eddcbbb9a
	.quad	0x3ffcafab0a01688c
	.quad	0x3ffcb2276d583be7
	.quad	0x3ffcb4a407d4fcb3
	.quad	0x3ffcb720d97c725c
	.quad	0x3ffcb99de25364bb
	.quad	0x3ffcbc1b225e9c14
	.quad	0x3ffcbe9899a2e114
	.quad	0x3ffcc1164824fcd0
	.quad	0x3ffcc3942de9b8ca
	.quad	0x3ffcc6124af5deee
	.quad	0x3ffcc8909f4e3990
	.quad	0x3ffccb0f2af79372
	.quad	0x3ffccd8dedf6b7bd
	.quad	0x3ffcd00ce8507204
	.quad	0x3ffcd28c1a098e48
	.quad	0x3ffcd50b8326d8f2
	.quad	0x3ffcd78b23ad1ed5
	.quad	0x3ffcda0afba12d30
	.quad	0x3ffcdc8b0b07d1aa
	.quad	0x3ffcdf0b51e5da58
	.quad	0x3ffce18bd04015b7
	.quad	0x3ffce40c861b52b1
	.quad	0x3ffce68d737c6096
	.quad	0x3ffce90e98680f28
	.quad	0x3ffceb8ff4e32e8c
	.quad	0x3ffcee1188f28f58
	.quad	0x3ffcf093549b0289
	.quad	0x3ffcf31557e15988
	.quad	0x3ffcf59792ca6629
	.quad	0x3ffcf81a055afaab
	.quad	0x3ffcfa9caf97e9b8
	.quad	0x3ffcfd1f91860666
	.quad	0x3ffcffa2ab2a2432
	.quad	0x3ffd0225fc891709
	.quad	0x3ffd04a985a7b341
	.quad	0x3ffd072d468acd9b
	.quad	0x3ffd09b13f373b42
	.quad	0x3ffd0c356fb1d1ce
	.quad	0x3ffd0eb9d7ff6743
	.quad	0x3ffd113e7824d20f
	.quad	0x3ffd13c35026e90b
	.quad	0x3ffd1648600a837b
	.quad	0x3ffd18cda7d4790f
	.quad	0x3ffd1b532789a1e4
	.quad	0x3ffd1dd8df2ed681
	.quad	0x3ffd205ecec8efd8
	.quad	0x3ffd22e4f65cc746
	.quad	0x3ffd256b55ef3696
	.quad	0x3ffd27f1ed8517fd
	.quad	0x3ffd2a78bd23461a
	.quad	0x3ffd2cffc4ce9bfe
	.quad	0x3ffd2f87048bf51e
	.quad	0x3ffd320e7c602d5e
	.quad	0x3ffd34962c50210e
	.quad	0x3ffd371e1460aced
	.quad	0x3ffd39a63496ae1e
	.quad	0x3ffd3c2e8cf70237
	.quad	0x3ffd3eb71d868736
	.quad	0x3ffd413fe64a1b88
	.quad	0x3ffd43c8e7469e02
	.quad	0x3ffd46522080edeb
	.quad	0x3ffd48db91fdeaf0
	.quad	0x3ffd4b653bc2752c
	.quad	0x3ffd4def1dd36d29
	.quad	0x3ffd50793835b3da
	.quad	0x3ffd53038aee2a9f
	.quad	0x3ffd558e1601b344
	.quad	0x3ffd5818d9753003
	.quad	0x3ffd5aa3d54d8381
	.quad	0x3ffd5d2f098f90cf
	.quad	0x3ffd5fba76403b6b
	.quad	0x3ffd62461b64673f
	.quad	0x3ffd64d1f900f8a4
	.quad	0x3ffd675e0f1ad45a
	.quad	0x3ffd69ea5db6df94
	.quad	0x3ffd6c76e4d9ffed
	.quad	0x3ffd6f03a4891b6e
	.quad	0x3ffd71909cc9188f
	.quad	0x3ffd741dcd9ede30
	.quad	0x3ffd76ab370f53a1
	.quad	0x3ffd7938d91f609f
	.quad	0x3ffd7bc6b3d3ed53
	.quad	0x3ffd7e54c731e251
	.quad	0x3ffd80e3133e289e
	.quad	0x3ffd837197fda9a8
	.quad	0x3ffd860055754f4c
	.quad	0x3ffd888f4baa03d3
	.quad	0x3ffd8b1e7aa0b1f5
	.quad	0x3ffd8dade25e44d5
	.quad	0x3ffd903d82e7a803
	.quad	0x3ffd92cd5c41c77f
	.quad	0x3ffd955d6e718fb2
	.quad	0x3ffd97edb97bed76
	.quad	0x3ffd9a7e3d65ce10
	.quad	0x3ffd9d0efa341f33
	.quad	0x3ffd9f9fefebceff
	.quad	0x3ffda2311e91cc02
	.quad	0x3ffda4c2862b0536
	.quad	0x3ffda75426bc6a05
	.quad	0x3ffda9e6004aea45
	.quad	0x3ffdac7812db7638
	.quad	0x3ffdaf0a5e72fe91
	.quad	0x3ffdb19ce316746e
	.quad	0x3ffdb42fa0cac95a
	.quad	0x3ffdb6c29794ef50
	.quad	0x3ffdb955c779d8b8
	.quad	0x3ffdbbe9307e7867
	.quad	0x3ffdbe7cd2a7c1a1
	.quad	0x3ffdc110adfaa815
	.quad	0x3ffdc3a4c27c1fe4
	.quad	0x3ffdc63910311d9a
	.quad	0x3ffdc8cd971e9631
	.quad	0x3ffdcb6257497f13
	.quad	0x3ffdcdf750b6ce17
	.quad	0x3ffdd08c836b797f
	.quad	0x3ffdd321ef6c7800
	.quad	0x3ffdd5b794bec0bc
	.quad	0x3ffdd84d73674b3f
	.quad	0x3ffddae38b6b0f89
	.quad	0x3ffddd79dccf0603
	.quad	0x3ffde01067982789
	.quad	0x3ffde2a72bcb6d61
	.quad	0x3ffde53e296dd143
	.quad	0x3ffde7d560844d54
	.quad	0x3ffdea6cd113dc26
	.quad	0x3ffded047b2178bb
	.quad	0x3ffdef9c5eb21e83
	.quad	0x3ffdf2347bcac95e
	.quad	0x3ffdf4ccd2707596
	.quad	0x3ffdf76562a81feb
	.quad	0x3ffdf9fe2c76c585
	.quad	0x3ffdfc972fe163fd
	.quad	0x3ffdff306cecf95b
	.quad	0x3ffe01c9e39e8418
	.quad	0x3ffe046393fb0315
	.quad	0x3ffe06fd7e0775aa
	.quad	0x3ffe0997a1c8db99
	.quad	0x3ffe0c31ff443512
	.quad	0x3ffe0ecc967e82b9
	.quad	0x3ffe1167677cc59c
	.quad	0x3ffe14027243ff3b
	.quad	0x3ffe169db6d93183
	.quad	0x3ffe193935415ed1
	.quad	0x3ffe1bd4ed8189f2
	.quad	0x3ffe1e70df9eb621
	.quad	0x3ffe210d0b9de709
	.quad	0x3ffe23a9718420c3
	.quad	0x3ffe2646115667d9
	.quad	0x3ffe28e2eb19c142
	.quad	0x3ffe2b7ffed33266
	.quad	0x3ffe2e1d4c87c11e
	.quad	0x3ffe30bad43c73ae
	.quad	0x3ffe335895f650cf
	.quad	0x3ffe35f691ba5fa4
	.quad	0x3ffe3894c78da7c2
	.quad	0x3ffe3b333775312f
	.quad	0x3ffe3dd1e176045e
	.quad	0x3ffe4070c5952a35
	.quad	0x3ffe430fe3d7ac06
	.quad	0x3ffe45af3c429394
	.quad	0x3ffe484ecedaeb14
	.quad	0x3ffe4aee9ba5bd26
	.quad	0x3ffe4d8ea2a814df
	.quad	0x3ffe502ee3e6fdc2
	.quad	0x3ffe52cf5f6783c0
	.quad	0x3ffe5570152eb33c
	.quad	0x3ffe581105419909
	.quad	0x3ffe5ab22fa54269
	.quad	0x3ffe5d53945ebd0f
	.quad	0x3ffe5ff53373171e
	.quad	0x3ffe62970ce75f28
	.quad	0x3ffe653920c0a430
	.quad	0x3ffe67db6f03f5ab
	.quad	0x3ffe6a7df7b6637a
	.quad	0x3ffe6d20badcfdf3
	.quad	0x3ffe6fc3b87cd5d9
	.quad	0x3ffe7266f09afc62
	.quad	0x3ffe750a633c8332
	.quad	0x3ffe77ae10667c5d
	.quad	0x3ffe7a51f81dfa6b
	.quad	0x3ffe7cf61a681052
	.quad	0x3ffe7f9a7749d178
	.quad	0x3ffe823f0ec851b6
	.quad	0x3ffe84e3e0e8a554
	.quad	0x3ffe8788edafe10a
	.quad	0x3ffe8a2e35231a01
	.quad	0x3ffe8cd3b74765d6
	.quad	0x3ffe8f797421da93
	.quad	0x3ffe921f6bb78eb2
	.quad	0x3ffe94c59e0d9924
	.quad	0x3ffe976c0b291144
	.quad	0x3ffe9a12b30f0ee0
	.quad	0x3ffe9cb995c4aa3b
	.quad	0x3ffe9f60b34efc02
	.quad	0x3ffea2080bb31d5a
	.quad	0x3ffea4af9ef627d4
	.quad	0x3ffea7576d1d3575
	.quad	0x3ffea9ff762d60b2
	.quad	0x3ffeaca7ba2bc471
	.quad	0x3ffeaf50391d7c09
	.quad	0x3ffeb1f8f307a346
	.quad	0x3ffeb4a1e7ef5660
	.quad	0x3ffeb74b17d9b203
	.quad	0x3ffeb9f482cbd34b
	.quad	0x3ffebc9e28cad7ca
	.quad	0x3ffebf4809dbdd7c
	.quad	0x3ffec1f2260402d5
	.quad	0x3ffec49c7d4866b8
	.quad	0x3ffec7470fae2879
	.quad	0x3ffec9f1dd3a67df
	.quad	0x3ffecc9ce5f24521
	.quad	0x3ffecf4829dae0eb
	.quad	0x3ffed1f3a8f95c56
	.quad	0x3ffed49f6352d8ef
	.quad	0x3ffed74b58ec78b7
	.quad	0x3ffed9f789cb5e20
	.quad	0x3ffedca3f5f4ac0a
	.quad	0x3ffedf509d6d85cb
	.quad	0x3ffee1fd803b0f2a
	.quad	0x3ffee4aa9e626c5f
	.quad	0x3ffee757f7e8c217
	.quad	0x3ffeea058cd3356e
	.quad	0x3ffeecb35d26ebf2
	.quad	0x3ffeef6168e90ba5
	.quad	0x3ffef20fb01ebafb
	.quad	0x3ffef4be32cd20da
	.quad	0x3ffef76cf0f9649a
	.quad	0x3ffefa1beaa8ae04
	.quad	0x3ffefccb1fe02556
	.quad	0x3ffeff7a90a4f33f
	.quad	0x3fff022a3cfc40e1
	.quad	0x3fff04da24eb37d0
	.quad	0x3fff078a48770213
	.quad	0x3fff0a3aa7a4ca23
	.quad	0x3fff0ceb4279baea
	.quad	0x3fff0f9c18faffca
	.quad	0x3fff124d2b2dc491
	.quad	0x3fff14fe79173584
	.quad	0x3fff17b002bc7f5a
	.quad	0x3fff1a61c822cf3c
	.quad	0x3fff1d13c94f52c7
	.quad	0x3fff1fc606473809
	.quad	0x3fff22787f0fad85
	.quad	0x3fff252b33ade22f
	.quad	0x3fff27de24270571
	.quad	0x3fff2a9150804723
	.quad	0x3fff2d44b8bed796
	.quad	0x3fff2ff85ce7e78a
	.quad	0x3fff32ac3d00a832
	.quad	0x3fff3560590e4b38
	.quad	0x3fff3814b11602b5
	.quad	0x3fff3ac9451d0138
	.quad	0x3fff3d7e152879c2
	.quad	0x3fff4033213d9fc8
	.quad	0x3fff42e86961a731
	.quad	0x3fff459ded99c45a
	.quad	0x3fff4853adeb2c11
	.quad	0x3fff4b09aa5b1398
	.quad	0x3fff4dbfe2eeb0a6
	.quad	0x3fff507657ab3963
	.quad	0x3fff532d0895e46e
	.quad	0x3fff55e3f5b3e8d8
	.quad	0x3fff589b1f0a7e23
	.quad	0x3fff5b52849edc4a
	.quad	0x3fff5e0a26763bb8
	.quad	0x3fff60c20495d54d
	.quad	0x3fff637a1f02e25c
	.quad	0x3fff663275c29cab
	.quad	0x3fff68eb08da3e7a
	.quad	0x3fff6ba3d84f0275
	.quad	0x3fff6e5ce42623c1
	.quad	0x3fff71162c64ddf3
	.quad	0x3fff73cfb1106d1b
	.quad	0x3fff7689722e0db5
	.quad	0x3fff79436fc2fcb6
	.quad	0x3fff7bfda9d47787
	.quad	0x3fff7eb82067bc04
	.quad	0x3fff8172d382087c
	.quad	0x3fff842dc3289bb5
	.quad	0x3fff86e8ef60b4ea
	.quad	0x3fff89a4582f93c7
	.quad	0x3fff8c5ffd9a786e
	.quad	0x3fff8f1bdfa6a377
	.quad	0x3fff91d7fe5955eb
	.quad	0x3fff949459b7d14b
	.quad	0x3fff9750f1c7578c
	.quad	0x3fff9a0dc68d2b16
	.quad	0x3fff9ccad80e8ec8
	.quad	0x3fff9f882650c5f2
	.quad	0x3fffa245b159145c
	.quad	0x3fffa503792cbe42
	.quad	0x3fffa7c17dd10856
	.quad	0x3fffaa7fbf4b37bd
	.quad	0x3fffad3e3da09211
	.quad	0x3fffaffcf8d65d61
	.quad	0x3fffb2bbf0f1e031
	.quad	0x3fffb57b25f8617d
	.quad	0x3fffb83a97ef28b2
	.quad	0x3fffbafa46db7db4
	.quad	0x3fffbdba32c2a8db
	.quad	0x3fffc07a5ba9f2f6
	.quad	0x3fffc33ac196a548
	.quad	0x3fffc5fb648e098a
	.quad	0x3fffc8bc449569e9
	.quad	0x3fffcb7d61b21108
	.quad	0x3fffce3ebbe94a01
	.quad	0x3fffd10053406061
	.quad	0x3fffd3c227bca02c
	.quad	0x3fffd684396355da
	.quad	0x3fffd9468839ce5a
	.quad	0x3fffdc0914455712
	.quad	0x3fffdecbdd8b3dd8
	.quad	0x3fffe18ee410d0ff
	.quad	0x3fffe45227db5f4b
	.quad	0x3fffe715a8f037f6
	.quad	0x3fffe9d96754aab1
	.quad	0x3fffec9d630e07a4
	.quad	0x3fffef619c219f69
	.quad	0x3ffff2261294c314
	.quad	0x3ffff4eac66cc42c
	.quad	0x3ffff7afb7aef4b0
	.quad	0x3ffffa74e660a715
	.quad	0x3ffffd3a52872e44
	.quad	0x3ffffffffc27dd9e
	.rept	56
	.byte	0
	.endr

/* Other general purpose constants:
 * _dbInvLn2 */
double_vector __dbInvLn2 0x40a71547652b82fe

/* _dbShifter */
double_vector __dbShifter 0x4338000000000000

/* _dbHALF */
double_vector __dbHALF 0x3fe0000000000000

/* _dbC1 = 2^(1/2^K)-1 */
double_vector __dbC1 0x3f362f3904051fa1

/* _lbLOWKBITS = 2^K-1 */
double_vector __lbLOWKBITS 0x00000000000007ff

/* _iAbsMask */
float_vector __iAbsMask 0x7fffffff

/* _iDomainRange */
float_vector __iDomainRange 0x4059fe36
	.type	__svml_spow_data,@object
	.size __svml_spow_data,.-__svml_spow_data
