/* _string.h

   written by Don Robert Maszle
   27 January 1992
   
   Copyright (c) 1993.  Don Maszle, Frederic Bois.  All rights reserved.

   -- Revisions -----
     Logfile:  SCCS/s._string.h
    Revision:  1.1
        Date:  7/14/93
     Modtime:  19:14:57
      Author:  @a
   -- SCCS  ---------

   Alternate string routines header file.  Routines for when NULL
   pointer dereferencing is a no-no.

   These handle NULL string pointer cases in a reasonable manner and
   ultimately call the standard library routines.
*/

#define  _strcpy(szDest, szSource) \
  ((szDest) && (szSource) ? strcpy((szDest), (szSource)) : NULL)

#define  _strlen(sz) \
  ((sz) ? strlen((sz)) : (int) 0)

#define  _strchr(sz, iChar) \
  ((sz) ? strchr((sz), (iChar)) : NULL)

#define  _strtok(sz, szToken) \
  ((sz) && (szToken) ? strtok((sz), (szToken)) : NULL)

int       Strcmp(const char*, const char*);


