
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>

#ifdef GLOBAL
#include <pthread.h>
#else
#include "pthread.h"
#endif

#define die(str) do { \
            fprintf(stderr, "**die: %s: %s\n", str, strerror(errno)); \
            exit(1); \
        } while (0)

static void *child(void *_arg)
{
    char *name = (char *)_arg;
    int i;

    fprintf(stderr, "child: startup %s\n", name);
    for (i = 0; i < 100; i++) {
        if (i++ % 10 == 0)
            sleep(1);
        fprintf(stderr, "child: %s counts i=%d\n", name, i);
    }
    fprintf(stderr, "child: shutdown %s\n", name);
    return _arg;
}

int main(int argc, char *argv[]) 
{
    pthread_attr_t thread_attr;
    pthread_t thread[4];
    char *rc;

    fprintf(stderr, "main: init\n");

    fprintf(stderr, "main: initializing attribute object\n");
    if (pthread_attr_init(&thread_attr) != 0)
        die("pthread_attr_init");
    if (pthread_attr_setdetachstate(&thread_attr, PTHREAD_CREATE_JOINABLE) != 0)
        die("pthread_attr_setdetachstate");
    
    fprintf(stderr, "main: create thread 1\n");
    if (pthread_create(&thread[0], &thread_attr, child, "foo") != 0)
        die("pthread_create");
    fprintf(stderr, "main: create thread 2\n");
    if (pthread_create(&thread[1], &thread_attr, child, "bar") != 0)
        die("pthread_create");
    fprintf(stderr, "main: create thread 3\n");
    if (pthread_create(&thread[2], &thread_attr, child, "baz") != 0)
        die("pthread_create");
    fprintf(stderr, "main: create thread 4\n");
    if (pthread_create(&thread[3], &thread_attr, child, "quux") != 0)
        die("pthread_create");

    fprintf(stderr, "main: destroying attribute object\n");
    if (pthread_attr_destroy(&thread_attr) != 0)
        die("pthread_attr_destroy");

    sleep(3);

    fprintf(stderr, "main: joining...\n");
    if (pthread_join(thread[0], (void **)&rc) != 0)
        die("pthread_join");
    fprintf(stderr, "main: joined thread: %s\n", rc);
    if (pthread_join(thread[1], (void **)&rc) != 0)
        die("pthread_join");
    fprintf(stderr, "main: joined thread: %s\n", rc);
    if (pthread_join(thread[2], (void **)&rc) != 0)
        die("pthread_join");
    fprintf(stderr, "main: joined thread: %s\n", rc);
    if (pthread_join(thread[3], (void **)&rc) != 0)
        die("pthread_join");
    fprintf(stderr, "main: joined thread: %s\n", rc);

    fprintf(stderr, "main: exit\n");
    return 0;
}

