/*
 This file is part of GNU Taler
 (C) 2021-2023 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
import {
  HttpResponse,
  HttpResponseOk,
  RequestError,
} from "@gnu-taler/web-util/browser";
import { AuditorBackend } from "../declaration.js";
import { useBackendRequest } from "./backend.js";

// FIX default import https://github.com/microsoft/TypeScript/issues/49189
import _useSWR, { SWRHook } from "swr";

const useSWR = _useSWR as unknown as SWRHook;

type YesOrNo = "yes" | "no";

export interface HelperDashboardFilter {
  finance?: YesOrNo;
  security?: YesOrNo;
  operating?: YesOrNo;
  detail?: YesOrNo;
}

export function getOperationData(
  args?: HelperDashboardFilter,
  updateFilter?: (d: Date) => void,
): HttpResponse<any, AuditorBackend.ErrorDetail> {
  const { multiFetcher } = useBackendRequest();
  const endpoints = [
    "monitoring/row-inconsistency",
    "monitoring/purse-not-closed-inconsistencies",
    "monitoring/reserve-not-closed-inconsistency",
    "monitoring/denominations-without-sigs",
    "monitoring/deposit-confirmation",
    "monitoring/denomination-key-validity-withdraw-inconsistency",
    "monitoring/refreshes-hanging",
    //TODO fix endpoint
    // "monitoring/closure-lags",
    //  "monitoring/row-minor-inconsistencies",
    //  "monitoring/historic-denomination-revenue",
    //  "monitoring/denomination-pending",
    "monitoring/historic-reserve-summary",
  ];

  const { data: list, error: listError } = useSWR<
    HttpResponseOk<any>[],
    RequestError<AuditorBackend.ErrorDetail>
  >(endpoints, multiFetcher, {
    refreshInterval: 60,
    refreshWhenHidden: false,
    revalidateOnFocus: false,
    revalidateOnReconnect: false,
    refreshWhenOffline: false,
  });

  if (listError) return listError.cause;

  if (list) {
    return { ok: true, data: [list] };
  }
  return { loading: true };
}

export interface EntityAPI {
  updateEntity: (id: string) => Promise<void>;
}
