/* Copyright (c) 2025, Kristian Nielsen.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1335  USA */

#include <stdint.h>
#include <atomic>

#include "handler_binlog_reader.h"


static constexpr uint32_t BINLOG_HEADER_PAGE_SIZE= 512;
extern const char *INNODB_BINLOG_MAGIC;

extern handler_binlog_reader *get_binlog_reader_innodb();
extern bool open_engine_binlog(handler_binlog_reader *reader,
                               ulonglong start_position,
                               const char *filename, IO_CACHE *opened_cache);


/* Shared functions defined in mysqlbinlog.cc */
extern void error(const char *format, ...) ATTRIBUTE_FORMAT(printf, 1, 2);
