
#ifndef VARTYPES_H          /* include only once per compile */
#define VARTYPES_H 1

#if defined(WIN32)
	#include <dos.h>
	#ifndef RCLDLL
		#define RCLDLL 
	#endif
#else	// not Win32
	#define RCLDLL  
#endif

#if (FL_MAJOR_VERSION <= 1)
#define FL_API   FL_EXPORT
#endif

// These are for the editor, but occasionally seem useful elsewhere
#define SOFT_RETURN 0x0D
#define HARD_RETURN 0x0A
#define CARRIAGE_RETURN  0x0D
#define LINE_FEED 0x0A


#ifndef TRUE
	#define TRUE    1
#endif
#ifndef FALSE
	#define FALSE   0
#endif

#ifdef _WINDOWS
	#undef RCLDLL
	#if defined(RCL_EXPORTS)
		#define RCLDLL  __declspec(dllexport)
	#else
		#define RCLDLL  
	#endif
#endif

#ifdef WIN32
RCLDLL extern double PowersOfTen[];
#else
extern double PowersOfTen[];
#endif

enum ErrorSeverity
{
  ERROR_OKAY,
  ERROR_INFO,
  ERROR_WARN,
  ERROR_FAIL,
};


#undef NOERROR

enum rclError {
  NOERROR,        /* everything OK */	
  NOMEMORY,           /* out of memory */	
  USERCANCEL,         /* user cancelled operation */
  GOTBREAKKEY,        /* user hit a break key */
  ABORTED,            /* operation aborted */
  FILEERROR,          /* a file error occurred */
  BUFFER_OVERFLOW,    /* operation overflowed internal buffers */	
  RELOAD,             /* internally used to force data reload */
  SECURITYVIOLATION,  /* unauthorized operation attempted */
  NOCONFIG,           /* can't read config file records */
  CLIPBOARD_EMPTY,    /* nothing in clipboard to operate on */
  NO_REGION,          /* region not marked to operate on */
  RANGE_ERROR,        /* bounds check exceeded */
  LIMITS_FULL_ERROR,  /* preset limits exceeded */
  LICENSE_OK,         /* license is OK for this module */
  NOT_LICENSED,       /* no license for this module */
  LICENSE_EXPIRED,    /* past license date range */
  FORM_COMPLETE,      /* user completed input form */
  WRONG_TYPE,         /* data is not the expected type */
  VMERROR,            /* VM file error */
  INVALID_PARAMETER,  /* bad parameter given for object construction */
  UNKNOWN_USER,			/* can't identify user name */
};


/* Macro to get a random integer within a specified range */

#define getrandom( min, max ) ((rand() % (int)(((max)+1) - (min))) + (min))
#define DIVIDE(num, by)         (((by) == 0) ? 0 : ((num) / (by)))

#include <math.h>
#ifndef WIN32
	#include <cmath>
	#ifndef modf
		extern "C" double modf(double, double *);
	#endif
#endif

inline double Round(double num, short places)
{
  double intpart, fracpart;
  
  fracpart = modf(num * PowersOfTen[places], &intpart);
  if(fracpart >= 0.5)
    intpart++;
  return (intpart / PowersOfTen[places]);
}


inline bool IsZero(double num)
{	
  return((num > -0.005) && (num < 0.005));	
}

#endif

