/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.engine.impl.ByteBufferUtils;
import org.apache.qpid.proton.engine.impl.TransportImpl;
import org.apache.qpid.proton.engine.impl.TransportOutput;
import org.apache.qpid.proton.engine.impl.TransportOutputWriter;

class TransportOutputAdaptor
implements TransportOutput {
    private static final ByteBuffer _emptyHead = ByteBufferUtils.newReadableBuffer(0).asReadOnlyBuffer();
    private final TransportOutputWriter _transportOutputWriter;
    private final int _maxFrameSize;
    private ByteBuffer _outputBuffer = null;
    private ByteBuffer _head = null;
    private boolean _output_done = false;
    private boolean _head_closed = false;

    TransportOutputAdaptor(TransportOutputWriter transportOutputWriter, int maxFrameSize) {
        this._transportOutputWriter = transportOutputWriter;
        this._maxFrameSize = maxFrameSize > 0 ? maxFrameSize : 4096;
    }

    @Override
    public int pending() {
        if (this._head_closed) {
            return -1;
        }
        if (this._outputBuffer == null) {
            this.init_buffers();
        }
        this._output_done = this._transportOutputWriter.writeInto(this._outputBuffer);
        this._head.limit(this._outputBuffer.position());
        if (this._outputBuffer.position() == 0 && this._outputBuffer.capacity() > TransportImpl.BUFFER_RELEASE_THRESHOLD) {
            this.release_buffers();
        }
        if (this._output_done && (this._outputBuffer == null || this._outputBuffer.position() == 0)) {
            return -1;
        }
        return this._outputBuffer == null ? 0 : this._outputBuffer.position();
    }

    @Override
    public ByteBuffer head() {
        this.pending();
        return this._head != null ? this._head : _emptyHead;
    }

    @Override
    public void pop(int bytes) {
        if (this._outputBuffer != null) {
            this._outputBuffer.flip();
            this._outputBuffer.position(bytes);
            this._outputBuffer.compact();
            this._head.position(0);
            this._head.limit(this._outputBuffer.position());
            if (this._outputBuffer.position() == 0 && this._outputBuffer.capacity() > TransportImpl.BUFFER_RELEASE_THRESHOLD) {
                this.release_buffers();
            }
        }
    }

    @Override
    public void close_head() {
        this._head_closed = true;
        this._transportOutputWriter.closed(null);
        this.release_buffers();
    }

    private void init_buffers() {
        this._outputBuffer = ByteBufferUtils.newWriteableBuffer(this._maxFrameSize);
        this._head = this._outputBuffer.asReadOnlyBuffer();
        this._head.limit(0);
    }

    private void release_buffers() {
        this._head = null;
        this._outputBuffer = null;
    }
}

